/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.logicentity;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.util.PropUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;

public class ImportSinglePersonPropEditPlugin
extends AbstractHDTCFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject eventObject) {
        BasedataEdit logicEntity = (BasedataEdit)this.getView().getControl("logicentity");
        logicEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit prop = (BasedataEdit)this.getView().getControl("prop");
        prop.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().beginInit();
        this.init();
        this.getModel().endInit();
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyKey;
        switch (propertyKey = beforeF7SelectEvent.getProperty().getName()) {
            case "logicentity": {
                this.addLogicEntityFilter(beforeF7SelectEvent.getCustomQFilters());
                break;
            }
            case "prop": {
                if (!this.checkProp(beforeF7SelectEvent)) break;
                this.addPropFilter(beforeF7SelectEvent.getCustomQFilters());
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyKey = args.getProperty().getName();
        if ("logicentity".equals(propertyKey)) {
            this.clearPropValue();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (!StringUtils.equals((String)operateKey, (String)"btnok")) {
            return;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)4);
        resultMap.put("propList", this.getSelectIdListByKey());
        this.getView().returnDataToParent((Object)resultMap);
        this.getModel().setDataChanged(false);
    }

    private List<Long> getSelectIdListByKey() {
        DynamicObjectCollection col = this.getModel().getDataEntity().getDynamicObjectCollection("prop");
        if (ObjectUtils.isEmpty((Object)col)) {
            return null;
        }
        return col.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid_id")).collect(Collectors.toList());
    }

    private void clearPropValue() {
        this.getModel().setValue("prop", null);
    }

    private void addLogicEntityFilter(List<QFilter> filterList) {
        filterList.add(this.commonLogicQFilter());
        QFilter qFilter = new QFilter("bizobj.number", "=", (Object)"hrpi_person");
        filterList.add(qFilter);
    }

    private boolean checkProp(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject logicEntityDy = this.getModel().getDataEntity().getDynamicObject("logicentity");
        if (logicEntityDy == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u5b9e\u4f53\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ImportPersonPropEditPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
        }
        return logicEntityDy != null;
    }

    private void addPropFilter(List<QFilter> filterList) {
        filterList.add(this.commonPropQFilter());
        filterList.add(PropUtils.getNoAttAndPropFieldFilter());
        filterList.add(PropUtils.getIncludeFieldTypeFilter((IDataModel)this.getView().getParentView().getModel()));
        DynamicObject logicEntityDy = this.getModel().getDataEntity().getDynamicObject("logicentity");
        filterList.add(new QFilter("logicentity", "=", (Object)logicEntityDy.getLong("id")));
        List propIdList = (List)this.getView().getFormShowParameter().getCustomParam("propList");
        if (!CollectionUtils.isEmpty((Collection)propIdList)) {
            filterList.add(new QFilter("id", "not in", (Object)propIdList));
        }
    }

    private QFilter commonPropQFilter() {
        QFilter qFilter = new QFilter("proptype", "=", (Object)"10");
        qFilter.and("name", "!=", (Object)"ID");
        qFilter.and("cusstatus", "=", (Object)"1");
        qFilter.and("deleted", "=", (Object)Boolean.FALSE);
        return qFilter;
    }

    private QFilter commonLogicQFilter() {
        return new QFilter("cusstatus", "=", (Object)"1").and("deleted", "=", (Object)"0");
    }

    private void init() {
        String logicEntityIdStr = (String)this.getView().getFormShowParameter().getCustomParam("logicentity");
        if (logicEntityIdStr != null) {
            long logicEntityId = Long.parseLong(logicEntityIdStr);
            this.getModel().setValue("logicentity", (Object)logicEntityId);
            this.getView().setEnable(Boolean.FALSE, new String[]{"logicentity"});
        }
    }
}

