/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.logicentity;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.common.metadatafield.parse.IMetaDataFieldParser;
import kd.hdtc.hrbm.business.common.metadatafield.parse.MetaDataFieldParserFactory;
import kd.hdtc.hrbm.business.domain.model.IEntityCardDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityRelDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropRelPropDomainService;
import kd.hdtc.hrbm.business.domain.model.ITempMappingDomainService;
import kd.hdtc.hrbm.common.constant.HRBMAppConstants;
import kd.hdtc.hrbm.common.exception.HRBMBizException;
import kd.hdtc.hrbm.common.msgEnum.BizModelMsgEnum;
import kd.hdtc.hrbm.formplugin.web.common.util.CommonPageUtils;
import kd.hdtc.hrbm.formplugin.web.logicentity.LogicEntitykUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hr.hbp.common.util.HRStringUtils;

public class LogicEntityEditPlugin
extends HDTCDataBaseEdit
implements HyperLinkClickListener {
    private static final Log LOG = LogFactory.getLog(LogicEntityEditPlugin.class);
    private static final String SELECT_ITEMS = "selectitmes";
    private static final String ALIAS = "alias";
    private static final String VIEX_FLEX = "view_flex";
    private static final String view_advconap = "view_advconap";
    private final String MESSAGE = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201c%1$s\u201d\u5df2\u88ab\u7b2c%2$s\u884c\u7684\u201c%3$s\u201d\u4f7f\u7528\uff0c\u8bf7\u91ca\u653e\u6b64\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u540e\uff0c\u518d\u91cd\u65b0\u4fee\u6539", (String)"LogicEntityEditPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]);
    private final ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);
    private final IPropDomainService propDomainService = (IPropDomainService)ServiceFactory.getService(IPropDomainService.class);
    private final ILogicEntityRelDomainService logicEntityRelDomainService = (ILogicEntityRelDomainService)ServiceFactory.getService(ILogicEntityRelDomainService.class);
    private final IPropRelPropDomainService propRelDomainService = (IPropRelPropDomainService)ServiceFactory.getService(IPropRelPropDomainService.class);
    private final IEntityCardDomainService entityCardDomainService = (IEntityCardDomainService)ServiceFactory.getService(IEntityCardDomainService.class);
    private final ITempMappingDomainService tempMappingDomainService = (ITempMappingDomainService)ServiceFactory.getService(ITempMappingDomainService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit textEdit = (TextEdit)this.getView().getControl("fieldextattrname");
        textEdit.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyKey = propertyChangedArgs.getProperty().getName();
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        if ("fieldtype".equals(propertyKey)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
            String fieldType = entryRowEntity.getString("fieldtype");
            if (StringUtils.isEmpty((String)fieldType)) {
                return;
            }
            if (FieldTypeEnum.BASEDATAFIELD.getType().equals(changeData.getOldValue())) {
                this.handleBaseDataPropValue(entryRowEntity.getString("epropkey"), true, null, null);
            }
            this.setExtFieldEnable(entryCurrentRowIndex, true);
            this.updatePersonInfoAttachPropInfo(propertyChangedArgs);
            this.getView().setEnable(Boolean.valueOf(FieldTypeEnum.getExtField((String)fieldType)), entryCurrentRowIndex, new String[]{"fieldextattrname"});
        } else if ("ename".equals(propertyKey)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
            String fieldType = entryRowEntity.getString("fieldtype");
            String propKey = entryRowEntity.getString("epropkey");
            this.getModel().setValue("ecusstatus", (Object)"0", entryCurrentRowIndex);
            if (FieldTypeEnum.BASEDATAFIELD.getType().equals(fieldType)) {
                this.handleBaseDataPropValue(propKey, false, propKey, entryRowEntity.getString("ename"));
            }
        } else if ("epropkey".equals(propertyKey)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
            String fieldType = entryRowEntity.getString("fieldtype");
            String propKey = entryRowEntity.getString("epropkey");
            if (StringUtils.isNotEmpty((String)propKey)) {
                this.getModel().setValue("epropkey", (Object)propKey.toLowerCase(Locale.ROOT), entryCurrentRowIndex);
            }
            if (FieldTypeEnum.BASEDATAFIELD.getType().equals(fieldType)) {
                this.handleBaseDataPropValue(String.valueOf(changeData.getOldValue()), false, propKey, entryRowEntity.getString("ename"));
            }
        } else if ("fieldconfig".equals(propertyKey)) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
            String fieldType = entryRowEntity.getString("fieldtype");
            if (FieldTypeEnum.BASEDATAFIELD.getType().equals(fieldType)) {
                this.handleBaseDataPropValue(entryRowEntity.getString("epropkey"), true, null, null);
            }
        }
    }

    private void updatePersonInfoAttachPropInfo(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData;
        String oldFieldType;
        DynamicObject bizObj = this.getModel().getDataEntity().getDynamicObject("bizobj");
        if (bizObj != null && "hrpi_person".equals(bizObj.getString("number")) && "AttachmentPanelAp".equals(oldFieldType = (String)(changeData = propertyChangedArgs.getChangeSet()[0]).getOldValue())) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String newPropKey = (String)this.propDomainService.getPropNumberList(1, Long.valueOf(ConvertUtils.toLong((Object)this.getModel().getValue("id"))), this.getModel().getEntryEntity("entryentity")).poll();
            this.getModel().setValue("epropkey", (Object)newPropKey, entryCurrentRowIndex);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((String)"fieldextattrname", (String)control.getKey())) {
            FormShowParameter parameter = new FormShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity"));
            String item = entryRowEntity.getString("fieldconfig");
            String fieldType = entryRowEntity.getString("fieldtype");
            IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser((String)fieldType);
            if (metaDataFieldParser != null) {
                parameter.setFormId(metaDataFieldParser.getMetaDataNumber());
                if (StringUtils.isNotEmpty((String)item)) {
                    parameter.setCustomParam("value", metaDataFieldParser.parseItems(item));
                }
                if (FieldTypeEnum.BASEDATAPROPFIELD.getType().equals(fieldType)) {
                    Map<String, Map<String, String>> baseDataMap = this.parseBaseDataMap(this.getModel().getEntryEntity("entryentity"));
                    parameter.setCustomParam("baseDataMap", baseDataMap);
                }
                parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SELECT_ITEMS));
                this.getView().showForm(parameter);
            }
        }
    }

    public void afterBindData(EventObject e) {
        boolean isCopy = false;
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long id = dataEntity.getLong("id");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object openTypeObj = customParams.get("opentype");
        Object nodeIdObj = customParams.get("curnodeid");
        this.handleOnlyProp(status);
        List propList = new ArrayList();
        if (id != 0L) {
            propList = this.propDomainService.getExcludeWhitePropInfobyLogicEntityId(id);
        }
        Map<Long, Long> proRelMap = Collections.EMPTY_MAP;
        if (status.getValue() == OperationStatus.ADDNEW.getValue()) {
            long pkid;
            DynamicObject logicEntityInfo;
            BillView source = (BillView)e.getSource();
            BillShowParameter showParameter = (BillShowParameter)source.getFormShowParameter();
            Object pkId = showParameter.getPkId();
            Object copyObj = showParameter.getCustomParam("iscopy");
            if (!ObjectUtils.isEmpty((Object)pkId)) {
                id = ConvertUtils.toLong((Object)pkId);
            }
            if (!ObjectUtils.isEmpty((Object)copyObj)) {
                isCopy = (Boolean)copyObj;
            }
            long pid = id;
            DynamicObject parent = dataEntity.getDynamicObject("pid");
            if (parent != null) {
                pid = parent.getLong("id");
            }
            if (isCopy && (logicEntityInfo = this.logicEntityDomainService.getLogicEntityInfoById((Object)(pkid = showParameter.getCustomParam("pkid") == null ? id : (Long)showParameter.getCustomParam("pkid")))) != null) {
                this.getModel().setValue("number", (Object)this.logicEntityDomainService.getLogicEntityNumber(Long.valueOf(pid), ConvertUtils.toString(openTypeObj), Long.valueOf(ConvertUtils.toLong(nodeIdObj))));
                this.getModel().setValue("index", (Object)this.logicEntityDomainService.getLogicEntityIndex(Long.valueOf(ConvertUtils.toLong(nodeIdObj))));
                this.getModel().setValue("bizobj", logicEntityInfo.get("bizobj"));
                propList = this.propDomainService.getExcludeWhitePropInfobyLogicEntityId(pkid);
                Object template = customParams.get("template.id");
                if (!ObjectUtils.isEmpty(template)) {
                    this.getModel().setValue("template", (Object)ConvertUtils.toLong(template));
                    this.getView().getFormShowParameter().setCustomParam("template", (Object)ConvertUtils.toLong(template));
                }
            }
            this.getModel().setValue("isv", (Object)ISVService.getISVInfo().getId());
        } else if (status.getValue() == OperationStatus.EDIT.getValue() && dataEntity.getLong("sublogicentity.id") != 0L) {
            proRelMap = this.propRelDomainService.getProRelByEntityIdAndRelType(Long.valueOf(id), "B1").stream().collect(Collectors.toMap(dy -> dy.getLong("sourceprop"), dy -> dy.getLong("targetprop"), (v1, v2) -> v2));
        }
        this.setEntityCardEntry(id);
        if (CollectionUtils.isEmpty(propList)) {
            return;
        }
        this.loadPropEntry(id, propList, isCopy, proRelMap);
        this.handleEntityField();
        LogicEntitykUtils.controlEntry(this.getView(), this.getModel());
        this.getModel().setDataChanged(false);
        this.getView().updateView("entryentity");
    }

    private void handleOnlyProp(OperationStatus status) {
        this.getView().setVisible(Boolean.valueOf(OperationStatus.VIEW.equals((Object)status)), new String[]{"proponlylabel"});
    }

    private Map<String, Map<String, String>> parseBaseDataMap(DynamicObjectCollection entryEntity) {
        if (entryEntity == null) {
            return null;
        }
        List baseDataEntry = entryEntity.stream().filter(dy -> FieldTypeEnum.BASEDATAFIELD.getType().equals(dy.getString("fieldtype"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(baseDataEntry)) {
            return null;
        }
        HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)baseDataEntry.size());
        IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser((String)FieldTypeEnum.BASEDATAFIELD.getType());
        for (DynamicObject baseData : baseDataEntry) {
            Map itemMap;
            HashMap propMap = Maps.newHashMapWithExpectedSize((int)4);
            propMap.put("epropkey", baseData.getString("epropkey"));
            propMap.put("ename", baseData.getString("ename"));
            if (metaDataFieldParser != null && CollectionUtils.isNotEmpty((Map)(itemMap = (Map)metaDataFieldParser.parseItems(baseData.getString("fieldconfig"))))) {
                propMap.put("baseEntityId", (String)itemMap.get("value"));
            }
            baseDataMap.put(baseData.getString("epropkey"), propMap);
        }
        return baseDataMap;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object nodeIdObj = customParams.get("curnodeid");
        Object openTypeObj = customParams.get("opentype");
        if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"saveandeffect")) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntity)) {
                this.getView().showTipNotification(BizModelMsgEnum.ENTRYENTITY_NOT_EMPTY.get());
                args.setCancel(true);
                return;
            }
            if (!LogicEntitykUtils.checkEntryEntity(this)) {
                args.setCancel(true);
                return;
            }
            OperateOption option = ((DefaultEntityOperate)args.getSource()).getOption();
            option.setVariableValue("pagetype", openTypeObj.toString());
            option.setVariableValue("curnodeid", nodeIdObj.toString());
        } else if (HRStringUtils.equals((String)operateKey, (String)"deleteentry")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList nameList = Lists.newArrayListWithCapacity((int)10);
            ArrayList indexList = Lists.newArrayListWithCapacity((int)10);
            ArrayList baseDataEntityRowList = Lists.newArrayListWithCapacity((int)10);
            for (int selectRow : selectRows) {
                DynamicObject row = this.getModel().getEntryRowEntity("entryentity", selectRow);
                String fieldType = row.getString("fieldtype");
                if (FieldTypeEnum.BASEDATAFIELD.getType().equals(fieldType)) {
                    baseDataEntityRowList.add(row);
                }
                String name = row.getString("ename");
                if (!HRStringUtils.equalsIgnoreCase((String)row.getString("eisv"), (String)ISVService.getISVInfo().getId())) {
                    nameList.add(name);
                    continue;
                }
                if (row.getBoolean("extend")) {
                    nameList.add(name);
                    continue;
                }
                indexList.add(selectRow + 1);
            }
            this.handleDeleteEntryEntity(args, nameList, indexList, baseDataEntityRowList);
        }
    }

    private String checkBaseDataTypeErrorMessage(List<DynamicObject> baseDataEntityRowList) {
        StringBuilder errorMessage = new StringBuilder();
        if (CollectionUtils.isEmpty(baseDataEntityRowList)) {
            return null;
        }
        HashMap baseDataTypeAndNameMap = Maps.newHashMapWithExpectedSize((int)baseDataEntityRowList.size());
        for (DynamicObject baseDataEntityRow : baseDataEntityRowList) {
            String propKey = baseDataEntityRow.getString("epropkey");
            if (StringUtils.isEmpty((String)propKey)) continue;
            baseDataTypeAndNameMap.put(propKey, baseDataEntityRow.getString("ename"));
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            Map result;
            String baseDataNumber;
            String baseDataPropFieldConfig;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            if (!FieldTypeEnum.BASEDATAPROPFIELD.getType().equals(dynamicObject.getString("fieldtype")) || StringUtils.isEmpty((String)(baseDataPropFieldConfig = dynamicObject.getString("fieldconfig"))) || baseDataTypeAndNameMap.get(baseDataNumber = (String)(result = (Map)SerializationUtils.fromJsonString((String)baseDataPropFieldConfig, Map.class)).get("baseDataNumber")) == null) continue;
            errorMessage.append(String.format(this.MESSAGE, baseDataTypeAndNameMap.get(baseDataNumber), i + 1, dynamicObject.getString("epropkey"))).append("\n");
        }
        return errorMessage.toString();
    }

    private void handleBaseDataPropValue(String baseDataKey, boolean isClear, String newBaseDataPropKey, String newBaseDataPropName) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            Map result;
            String baseDataNumber;
            String baseDataPropFieldConfig;
            if (!FieldTypeEnum.BASEDATAPROPFIELD.getType().equals(dynamicObject.getString("fieldtype")) || StringUtils.isEmpty((String)(baseDataPropFieldConfig = dynamicObject.getString("fieldconfig"))) || !baseDataKey.equals(baseDataNumber = (String)(result = (Map)JsonUtils.castType((String)baseDataPropFieldConfig, Map.class)).get("baseDataNumber"))) continue;
            if (isClear) {
                dynamicObject.set("fieldconfig", null);
                dynamicObject.set("fieldextattrname", null);
                continue;
            }
            String baseDataPropName = (String)result.get("baseDataPropName");
            String caption = newBaseDataPropName + "." + baseDataPropName;
            result.put("caption", caption);
            result.put("baseDataNumber", newBaseDataPropKey);
            result.put("baseDataName", newBaseDataPropName);
            dynamicObject.set("fieldconfig", (Object)JsonUtils.toStr((Object)result));
            dynamicObject.set("fieldextattrname", (Object)caption);
        }
        this.getView().updateView("entryentity");
        LogicEntitykUtils.controlEntry(this.getView(), this.getModel());
    }

    private void handleDeleteEntryEntity(BeforeDoOperationEventArgs args, List<String> nameList, List<Integer> indexList, List<DynamicObject> baseDataEntityRowList) {
        if (nameList.size() > 0) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, BizModelMsgEnum.CURR_SELECT_PROP_NOT_DELETE.get(), String.join((CharSequence)",", nameList)));
            args.setCancel(true);
            return;
        }
        String baseDataTypeErrorMessage = this.checkBaseDataTypeErrorMessage(baseDataEntityRowList);
        if (StringUtils.isNotEmpty((String)baseDataTypeErrorMessage)) {
            this.getView().showErrorNotification(baseDataTypeErrorMessage);
            args.setCancel(true);
            return;
        }
        boolean hasEffective = false;
        DynamicObjectCollection propEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList hasEffectiveFieldNameList = Lists.newArrayListWithExpectedSize((int)16);
        for (int index : indexList) {
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", index - 1);
            boolean sync = row.getBoolean("sync");
            if (!sync) continue;
            hasEffective = true;
            hasEffectiveFieldNameList.add(row.getString("ename"));
        }
        if (!hasEffective) {
            propEntry.removeIf(prop -> indexList.contains(prop.getInt("seq")));
            this.getView().updateView("entryentity");
            LogicEntitykUtils.controlEntry(this.getView(), this.getModel());
        } else {
            String titleTip = String.format(Locale.ROOT, BizModelMsgEnum.DELETE_ENTRYENTITY_ENSURE_TIP.get(), String.join((CharSequence)",", hasEffectiveFieldNameList));
            this.getView().showConfirm(titleTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("deleteEntryEntityCallBackId", (IFormPlugin)this));
            this.getPageCache().put("needDeleteEntryEntityIndexList", JsonUtils.toStr(indexList));
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String needDeleteEntryEntityIndexList;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("deleteEntryEntityCallBackId".equals(callBackId) && MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult()) && StringUtils.isNotEmpty((String)(needDeleteEntryEntityIndexList = this.getPageCache().get("needDeleteEntryEntityIndexList")))) {
            List indexList = (List)JsonUtils.castType((String)needDeleteEntryEntityIndexList, List.class);
            DynamicObjectCollection propEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            propEntry.removeIf(prop -> indexList.contains(prop.getInt("seq")));
            this.getView().updateView("entryentity");
            LogicEntitykUtils.controlEntry(this.getView(), this.getModel());
        }
    }

    private String getTipsMsg(List<String> nameList) {
        StringBuilder msg = new StringBuilder();
        nameList.forEach(name -> msg.append(String.format(Locale.ROOT, BizModelMsgEnum.CURR_SELECT_PROP_NOT_DELETE.get(), name)).append("\n"));
        return msg.toString();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        super.closedCallBack(closedCallBackEvent);
        if (SELECT_ITEMS.equals(closedCallBackEvent.getActionId()) && CollectionUtils.isNotEmpty((Map)(returnData = (Map)closedCallBackEvent.getReturnData()))) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("fieldextattrname", returnData.get(ALIAS), entryCurrentRowIndex);
            this.getModel().setValue("fieldconfig", returnData.get("value"), entryCurrentRowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"newentry")) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.getModel().setValue("eisv", (Object)ISVService.getISVInfo().getId(), entryCurrentRowIndex);
            this.getModel().setValue("eindex", (Object)this.getPropEntryIndex(), entryCurrentRowIndex);
            this.getModel().setValue("proptype", (Object)"10", entryCurrentRowIndex);
        } else if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"saveandeffect")) {
            IFormView parentView;
            String fromType = (String)this.getView().getFormShowParameter().getCustomParam("fomtype");
            if ("bizList".equals(fromType) && args.getOperationResult().isSuccess()) {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().updateView();
            }
            if ((parentView = this.getView().getParentView()) == null) {
                return;
            }
            if (parentView.getFormShowParameter().getFormId().equals("hrbm_bmmanagement") || parentView.getFormShowParameter().getFormId().equals("hrbm_bdmanagement")) {
                parentView.invokeOperation("refresh");
                this.getView().sendFormAction(parentView);
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"modify")) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().updateView();
        }
    }

    private Integer getPropEntryIndex() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        long pkId = this.getModel().getDataEntity().getLong("id");
        if (entryEntity.size() == 1) {
            return (Integer)this.propDomainService.getPropIndexList(Long.valueOf(pkId), 1).poll();
        }
        Optional<Integer> maxIndex = entryEntity.stream().map(dyc -> dyc.getInt("eindex")).max(Comparator.comparingInt(a -> a));
        if (!maxIndex.isPresent()) {
            return (Integer)this.propDomainService.getPropIndexList(Long.valueOf(pkId), 1).poll();
        }
        Integer index = maxIndex.get();
        if (index == 1) {
            index = HRBMAppConstants.THREE_HUNDRED;
        }
        if (index >= HRBMAppConstants.PROP_MAX_INDEX) {
            return HRBMAppConstants.PROP_MAX_INDEX;
        }
        int incrIndex = index + 10;
        if (incrIndex >= HRBMAppConstants.PROP_MAX_INDEX) {
            return HRBMAppConstants.PROP_MAX_INDEX;
        }
        return incrIndex;
    }

    private void loadPropEntry(long id, List<DynamicObject> propList, boolean isCopy, Map<Long, Long> proRelMap) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        entryEntity.clear();
        Set<Object> metadataPropNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        if (!isCopy && id != 0L) {
            metadataPropNumberSet = this.getMetadataPropNumbers(id);
        }
        HashSet finalMetadataPropNumberSet = metadataPropNumberSet;
        ArrayList fieldNumberList = Lists.newArrayListWithExpectedSize((int)10);
        fieldNumberList.add("id");
        if (isCopy) {
            Object template = this.getView().getFormShowParameter().getCustomParam("template.id");
            Object openType = this.getView().getFormShowParameter().getCustomParam("opentype");
            String platTemplateId = this.tempMappingDomainService.getPlatTemplateIdByTempMappingId(Long.valueOf(template == null ? 0L : ConvertUtils.toLong((Object)template)));
            if ("bdmode".equals(openType)) {
                platTemplateId = this.tempMappingDomainService.getBaseDataPlatTemplateIdById(this.getModel().getDataEntity().getBoolean("controlentity"));
            }
            if (StringUtils.isNotEmpty((String)platTemplateId) && MetadataUtils.isExist((String)platTemplateId)) {
                fieldNumberList.addAll(MetadataUtils.getFieldNumberList((String)platTemplateId));
            }
        }
        propList.stream().sorted(Comparator.comparing(prop -> prop.getInt("index"))).forEach(prop -> {
            DynamicObject dyc = new DynamicObject(entryEntity.getDynamicObjectType());
            if (!isCopy) {
                dyc.set("id", (Object)prop.getLong("id"));
                Long otherImportProp = (Long)proRelMap.get(prop.getLong("id"));
                if (otherImportProp != null) {
                    dyc.set("otherImportProp", (Object)otherImportProp);
                }
                dyc.set("ecusstatus", (Object)prop.getString("cusstatus"));
            }
            dyc.set("epropkey", (Object)prop.getString("propkey"));
            dyc.set("ename", (Object)prop.getLocaleString("name"));
            dyc.set("fieldtype", (Object)prop.getString("fieldtype"));
            dyc.set("must", (Object)prop.getBoolean("must"));
            dyc.set("ebizrule", (Object)prop.getLocaleString("bizrule"));
            dyc.set("fieldconfig", (Object)prop.getString("fieldconfig"));
            dyc.set("proplabelmul", (Object)prop.getDynamicObjectCollection("proplabelmul"));
            dyc.set("eindex", (Object)prop.getInt("index"));
            dyc.set("primary", (Object)prop.getBoolean("primary"));
            dyc.set("proptype", (Object)prop.getString("proptype"));
            dyc.set("extend", (Object)prop.getBoolean("extend"));
            dyc.set("eisv", (Object)prop.getString("isv"));
            dyc.set("sync", (Object)false);
            if (isCopy) {
                dyc.set("extend", (Object)fieldNumberList.contains(prop.getString("propkey")));
                dyc.set("eisv", (Object)(dyc.getBoolean("extend") ? prop.getString("isv") : ISVService.getISVInfo().getId()));
            } else if (id != 0L && finalMetadataPropNumberSet.contains(prop.getString("propkey"))) {
                dyc.set("sync", (Object)true);
            }
            entryEntity.add((Object)dyc);
        });
        List sortEntryEntity = entryEntity.stream().sorted(Comparator.comparing(row -> !row.getBoolean("extend"))).collect(Collectors.toList());
        entryEntity.clear();
        entryEntity.addAll(sortEntryEntity);
    }

    private Set<String> getMetadataPropNumbers(Long id) {
        HashSet metadataPropNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        List logicEntityRelList = this.logicEntityRelDomainService.getLogicEntityRelInfoByLogicEntityId(id);
        logicEntityRelList.forEach(logic -> {
            String metadataNum = this.getMetadataNumber(logic.getString("metadatanum"));
            if (!MetadataDao.checkNumber((String)metadataNum)) {
                throw new HRBMBizException(String.format(Locale.ROOT, BizModelMsgEnum.METADATA_NOT_EXIST.get(), metadataNum));
            }
            MainEntityType mainEntityType = kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils.getMainEntityType((String)metadataNum);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            List formMetadata = MetadataUtils.getFormMetadata((String)mainEntityType.getName());
            List<ControlAp> fileAps = null;
            if (CollectionUtils.isNotEmpty((Collection)formMetadata)) {
                fileAps = formMetadata.stream().filter(form -> form instanceof AttachmentPanelAp).collect(Collectors.toList());
            }
            List items = entityMetadata.getItems();
            Set entryEntityIdSet = items.stream().filter(item -> item instanceof EntryEntity).map(item -> item.getId()).collect(Collectors.toSet());
            items.forEach(item -> {
                if (item instanceof MainEntity) {
                    metadataPropNumberSet.add("id");
                    return;
                }
                if (item instanceof EntryEntity || entryEntityIdSet.contains(item.getParentId())) {
                    return;
                }
                metadataPropNumberSet.add(item.getKey());
            });
            if (fileAps != null && fileAps.size() > 0) {
                fileAps.forEach(ap -> metadataPropNumberSet.add(ap.getKey()));
            }
        });
        return metadataPropNumberSet;
    }

    private String getMetadataNumber(String metadataNumber) {
        return (String)Splitter.on((String)".").splitToList((CharSequence)metadataNumber).get(0);
    }

    private void handleEntityField() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!ObjectUtils.isEmpty((Object)entryEntity)) {
            String curIsv = ISVService.getISVInfo().getId();
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entity = (DynamicObject)entryEntity.get(i);
                String item = entity.getString("fieldconfig");
                String isv = entity.getString("eisv");
                boolean extend = entity.getBoolean("extend");
                this.setFieldItemName(entity, item);
                this.setExtFieldEnable(i, false);
                if (!HRStringUtils.equalsIgnoreCase((String)curIsv, (String)isv) || extend) {
                    this.getView().setEnable(Boolean.FALSE, ConvertUtils.toInt((Object)i), new String[]{"fieldextattrname"});
                    continue;
                }
                boolean hasFieldConfig = FieldTypeEnum.getExtField((String)entity.getString("fieldtype"));
                if (hasFieldConfig) continue;
                this.getView().setEnable(Boolean.valueOf(hasFieldConfig), i, new String[]{"fieldextattrname"});
            }
        }
    }

    private void setFieldItemName(DynamicObject entity, String item) {
        if (StringUtils.isEmpty((String)item)) {
            return;
        }
        String fieldType = entity.getString("fieldtype");
        IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser((String)fieldType);
        if (metaDataFieldParser != null) {
            String alias = metaDataFieldParser.parseAlias(item);
            entity.set("fieldextattrname", (Object)alias);
        }
    }

    private void setExtFieldEnable(int entryCurrentRowIndex, boolean isDeleteAllValue) {
        if (isDeleteAllValue) {
            this.getModel().setValue("fieldextattrname", null, entryCurrentRowIndex);
            this.getModel().setValue("fieldconfig", null, entryCurrentRowIndex);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject currentEntryDy = (DynamicObject)entryEntity.get(args.getRowIndex());
        if ("0".equals(currentEntryDy.getString("ecusstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5c5e\u6027\u5c1a\u672a\u751f\u6548\uff0c\u65e0\u6cd5\u67e5\u770b\u5c5e\u6027\u4fe1\u606f\uff0c\u8bf7\u5728\u5c5e\u6027\u751f\u6548\u540e\u518d\u8fdb\u884c\u70b9\u51fb\u67e5\u770b\u3002", (String)"LogicEntityEditPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long primaryKeyValue = currentEntryDy.getLong("id");
        Long id = this.getModel().getDataEntity().getLong("id");
        if (StringUtils.equals((String)"epropkey", (String)args.getFieldName()) && id != 0L) {
            CommonPageUtils.showBillForm(this.getView(), "hrbm_prop", primaryKeyValue, null, OperationStatus.VIEW, ShowType.MainNewTabPage);
        }
    }

    private void setEntityCardEntry(long logicId) {
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{view_advconap});
            return;
        }
        DynamicObject[] entityCards = this.entityCardDomainService.queryEntityCards(logicId);
        if (entityCards.length > 0) {
            Set logicIdSet = Arrays.stream(entityCards).map(dy -> dy.getLong("logicentity")).collect(Collectors.toSet());
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("hrbm_entitycardentry");
            listShowParameter.getOpenStyle().setTargetKey(VIEX_FLEX);
            listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            listShowParameter.getListFilterParameter().setFilter(new QFilter("logicentity", "in", logicIdSet));
            listShowParameter.getListFilterParameter().setOrderBy("index");
            this.getView().showForm((FormShowParameter)listShowParameter);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{view_advconap});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{view_advconap});
        }
    }
}

