/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.logicentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.baseconfig.IBaseConfigDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrbm.business.domain.model.bean.BizObjBean;
import kd.hdtc.hrbm.business.domain.model.bean.LogicEntityExtInfoBean;
import kd.hdtc.hrbm.business.domain.model.bean.LogicEntityRelBean;
import kd.hdtc.hrbm.business.domain.model.entity.IBizObjEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityRelEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.expt.common.plugin.AfterQueryDataEventArgs;
import kd.hr.expt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;
import kd.hr.hbp.common.util.HRStringUtils;

public class LogicEntityExportPlugin
implements HRExportPlugin {
    private final IBizObjEntityService iBizObjEntityService = (IBizObjEntityService)ServiceFactory.createInstance(IBizObjEntityService.class);
    private final ILogicEntityDomainService iLogicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.createInstance(ILogicEntityDomainService.class);
    private final IPropDomainService iPropDomainService = (IPropDomainService)ServiceFactory.createInstance(IPropDomainService.class);
    private final IBaseConfigDomainService iBaseConfigDomainService = (IBaseConfigDomainService)ServiceFactory.createInstance(IBaseConfigDomainService.class);
    private final ILogicEntityRelEntityService iLogicEntityRelEntityService = (ILogicEntityRelEntityService)ServiceFactory.createInstance(ILogicEntityRelEntityService.class);
    private final Map<String, String> LOGIC_ENTITY_ADD_FIELD_AND_FIELD_NAME_MAP = ImmutableMap.of((Object)"cloud", (Object)ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"LogicEntityExportPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), (Object)"app", (Object)ResManager.loadKDString((String)"\u4e1a\u52a1\u5e94\u7528", (String)"LogicEntityExportPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
    private final Map<String, String> LOGIC_ENTITY_ADD_POST_FIELD_AND_FIELD_NAME_MAP = ImmutableMap.of((Object)"metadatanum", (Object)ResManager.loadKDString((String)"\u5143\u6570\u636e\u7f16\u7801", (String)"LogicEntityExportPlugin_3", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), (Object)"metadataname", (Object)ResManager.loadKDString((String)"\u5143\u6570\u636e\u540d\u79f0", (String)"LogicEntityExportPlugin_4", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), (Object)"table", (Object)ResManager.loadKDString((String)"\u7269\u7406\u8868\u540d", (String)"LogicEntityExportPlugin_5", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), (Object)"tablename", (Object)ResManager.loadKDString((String)"\u7269\u7406\u8868\u540d\u4e2d\u6587\u540d", (String)"LogicEntityExportPlugin_6", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
    private final Map<String, String> PROP_ADD_FIELD_AND_FIELD_NAME_MAP = ImmutableMap.of((Object)"cloud", (Object)ResManager.loadKDString((String)"\u4e1a\u52a1\u4e91", (String)"LogicEntityExportPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), (Object)"app", (Object)ResManager.loadKDString((String)"\u4e1a\u52a1\u5e94\u7528", (String)"LogicEntityExportPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), (Object)"bizobj", (Object)ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61", (String)"LogicEntityExportPlugin_2", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        super.beforeCreateHeaderColumn(args);
        List headerWriterFormatList = args.getHeaderWriterFormats();
        headerWriterFormatList.forEach(headerWriterFormat -> {
            String entityName = headerWriterFormat.getEnityName();
            if ("hrbm_logicentity".equals(entityName)) {
                this.iLogicEntityDomainService.handleCustomColumn(headerWriterFormat, this.LOGIC_ENTITY_ADD_FIELD_AND_FIELD_NAME_MAP, this.LOGIC_ENTITY_ADD_POST_FIELD_AND_FIELD_NAME_MAP);
            } else if ("hrbm_prop".equals(entityName)) {
                this.iLogicEntityDomainService.handleCustomColumn(headerWriterFormat, this.PROP_ADD_FIELD_AND_FIELD_NAME_MAP, null);
            }
        });
    }

    public void afterQueryData(AfterQueryDataEventArgs afterQueryDataEventArgs) {
        List dataList = afterQueryDataEventArgs.getDataList();
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            String name = ((DynamicObject)dataList.get(0)).getDataEntityType().getName();
            if ("hrbm_prop".equals(name)) {
                Set excludeColumns = this.iBaseConfigDomainService.getPropBlackList();
                dataList = dataList.stream().filter(dy -> "10".equals(dy.getString("proptype")) && !excludeColumns.contains(dy.getString("propkey")) && "1".equals(dy.getString("enable"))).sorted(Comparator.comparing(prop -> prop.getInt("index"))).collect(Collectors.toList());
            }
            afterQueryDataEventArgs.setDataList(dataList);
        }
    }

    private Map<String, BizObjBean> getBizObjEntryMapByProp(List<DynamicObject> dataList) {
        LinkedHashMap logicEntityNumberPropNumberAndBizObjIdMap = Maps.newLinkedHashMapWithExpectedSize((int)dataList.size());
        dataList.forEach(dy -> {
            DynamicObject logicEntity = dy.getDynamicObject("logicentity");
            if (logicEntity != null && logicEntity.getDynamicObject("bizobj") != null) {
                String logicEntityNumber = logicEntity.getString("number");
                String propNumber = dy.getString("number");
                logicEntityNumberPropNumberAndBizObjIdMap.put(logicEntityNumber + propNumber, logicEntity.getDynamicObject("bizobj").getLong("id"));
            }
        });
        Map bizObjIdAndBizObjEntryMap = this.iBizObjEntityService.queryBizObjEntryById(logicEntityNumberPropNumberAndBizObjIdMap.values());
        LinkedHashMap logicEntityNumberPropNumberAndBizObjMap = Maps.newLinkedHashMapWithExpectedSize((int)dataList.size());
        logicEntityNumberPropNumberAndBizObjIdMap.forEach((logicEntityNumberPropNumber, bizObjId) -> {
            BizObjBean bizObjBean = (BizObjBean)bizObjIdAndBizObjEntryMap.get(bizObjId);
            if (bizObjBean != null) {
                logicEntityNumberPropNumberAndBizObjMap.put(logicEntityNumberPropNumber, bizObjBean);
            }
        });
        return logicEntityNumberPropNumberAndBizObjMap;
    }

    private Map<String, BizObjBean> getBizObjEntryMapByPropByPkIds(Map<Integer, Map<String, Object>> rowDataPkIds) {
        if (CollectionUtils.isEmpty(rowDataPkIds)) {
            return new HashMap<String, BizObjBean>();
        }
        ArrayList propIdList = Lists.newArrayListWithExpectedSize((int)rowDataPkIds.size());
        rowDataPkIds.forEach((rowIndex, entityEntityMap) -> entityEntityMap.values().forEach(propId -> propIdList.add((Long)propId)));
        List propInfoList = this.iPropDomainService.getPropInfoByIds((Collection)propIdList);
        return this.getBizObjEntryMapByProp(propInfoList);
    }

    private Map<String, LogicEntityExtInfoBean> getBizObjEntryMapByLogicEntity(List<DynamicObject> dataList) {
        LinkedHashMap logicEntityNumberAndBizObjIdMap = Maps.newLinkedHashMapWithExpectedSize((int)dataList.size());
        LinkedHashMap logicEntityNumberAndLogicEntityIdMap = Maps.newLinkedHashMapWithExpectedSize((int)dataList.size());
        dataList.forEach(dy -> {
            DynamicObject bizObj = dy.getDynamicObject("bizobj");
            if (bizObj != null) {
                logicEntityNumberAndBizObjIdMap.put(dy.getString("number"), bizObj.getLong("id"));
            }
            logicEntityNumberAndLogicEntityIdMap.put(dy.getString("number"), dy.getLong("id"));
        });
        Map bizObjIdAndBizObjEntryMap = this.iBizObjEntityService.queryBizObjEntryById(logicEntityNumberAndBizObjIdMap.values());
        Map logicEntityIdAndLogicEntityRelEntryListMap = this.iLogicEntityRelEntityService.queryLogicEntityRelEntryByLogicEntityId(logicEntityNumberAndLogicEntityIdMap.values());
        LinkedHashMap logicEntityNumberAndLogicEntityExtInfoEntryMap = Maps.newLinkedHashMapWithExpectedSize((int)dataList.size());
        logicEntityNumberAndBizObjIdMap.forEach((logicEntityNumber, bizObjId) -> {
            BizObjBean bizObjBean = (BizObjBean)bizObjIdAndBizObjEntryMap.get(bizObjId);
            if (bizObjBean != null) {
                LogicEntityExtInfoBean logicEntityExtInfoBean = logicEntityNumberAndLogicEntityExtInfoEntryMap.getOrDefault(logicEntityNumber, new LogicEntityExtInfoBean());
                logicEntityExtInfoBean.setBizObjBean(bizObjBean);
                logicEntityNumberAndLogicEntityExtInfoEntryMap.put(logicEntityNumber, logicEntityExtInfoBean);
            }
        });
        logicEntityNumberAndLogicEntityIdMap.forEach((logicEntityNumber, logicEntityId) -> {
            List logicEntityRelBeanList = (List)logicEntityIdAndLogicEntityRelEntryListMap.get(logicEntityId);
            if (CollectionUtils.isNotEmpty((Collection)logicEntityRelBeanList)) {
                LogicEntityExtInfoBean logicEntityExtInfoBean = logicEntityNumberAndLogicEntityExtInfoEntryMap.getOrDefault(logicEntityNumber, new LogicEntityExtInfoBean());
                logicEntityExtInfoBean.setLogicEntityRelBeanList(logicEntityRelBeanList);
                logicEntityNumberAndLogicEntityExtInfoEntryMap.put(logicEntityNumber, logicEntityExtInfoBean);
            }
        });
        return logicEntityNumberAndLogicEntityExtInfoEntryMap;
    }

    private Map<String, LogicEntityExtInfoBean> getBizObjEntryMapByLogicEntityByPkIds(Map<Integer, Map<String, Object>> rowDataPkIds) {
        if (CollectionUtils.isEmpty(rowDataPkIds)) {
            return new HashMap<String, LogicEntityExtInfoBean>();
        }
        ArrayList logicEntityIdList = Lists.newArrayListWithExpectedSize((int)rowDataPkIds.size());
        rowDataPkIds.forEach((rowIndex, entityEntityMap) -> entityEntityMap.values().forEach(logicEntityId -> logicEntityIdList.add((Long)logicEntityId)));
        Object[] logicEntityInfos = this.iLogicEntityDomainService.getLogicEntityInfoByIdList((List)logicEntityIdList);
        if (ArrayUtils.isEmpty((Object[])logicEntityInfos)) {
            return new HashMap<String, LogicEntityExtInfoBean>();
        }
        return this.getBizObjEntryMapByLogicEntity(ConvertUtils.toList((Object[])logicEntityInfos));
    }

    public void beforeWriteData(BeforeWriteDataEventArgs beforeWriteDataEventArgs) {
        List tplDataRowList = beforeWriteDataEventArgs.getTplDataRows();
        String entityNumber = (String)new ArrayList(beforeWriteDataEventArgs.getEntityIdStartIndex().keySet()).get(0);
        if ("hrbm_logicentity".equals(entityNumber)) {
            HashSet<String> fieldKeySet = new HashSet<String>(this.LOGIC_ENTITY_ADD_FIELD_AND_FIELD_NAME_MAP.keySet());
            fieldKeySet.addAll(this.LOGIC_ENTITY_ADD_POST_FIELD_AND_FIELD_NAME_MAP.keySet());
            Map<String, LogicEntityExtInfoBean> logicEntityNumberAndLogicEntityExtInfoEntryMap = this.getBizObjEntryMapByLogicEntityByPkIds(beforeWriteDataEventArgs.getRowDataPkIds());
            this.setLogicEntityCustomFieldValue(tplDataRowList, fieldKeySet, logicEntityNumberAndLogicEntityExtInfoEntryMap);
        } else if ("hrbm_prop".equals(entityNumber)) {
            Map<String, BizObjBean> logicEntityNumberPropNumberAndBizObjIdMap = this.getBizObjEntryMapByPropByPkIds(beforeWriteDataEventArgs.getRowDataPkIds());
            this.setPropCustomFieldValue(tplDataRowList, this.PROP_ADD_FIELD_AND_FIELD_NAME_MAP.keySet(), logicEntityNumberPropNumberAndBizObjIdMap);
        }
    }

    private void setPropCustomFieldValue(List<Map<Integer, Map<String, Object>>> tplDataRowList, Set<String> fieldKeyList, Map<String, BizObjBean> logicEntityNumberPropNumberAndBizObjMap) {
        for (Map<Integer, Map<String, Object>> tplDataRow : tplDataRowList) {
            BizObjBean bizObjBean;
            LinkedHashMap fieldKeyAndFieldInfoMapMap = Maps.newLinkedHashMapWithExpectedSize((int)fieldKeyList.size());
            String logicEntityNumber = "";
            String propNumber = "";
            for (Map.Entry<Integer, Map<String, Object>> cellValueMapEntry : tplDataRow.entrySet()) {
                Map<String, Object> cellValueMap = cellValueMapEntry.getValue();
                Object key = cellValueMap.get("key");
                if (fieldKeyList.contains(key)) {
                    fieldKeyAndFieldInfoMapMap.put(key, cellValueMap);
                }
                if ("logicentity.number".equals(key)) {
                    logicEntityNumber = cellValueMap.get("val") + "";
                }
                if (!"number".equals(key)) continue;
                propNumber = cellValueMap.get("val") + "";
            }
            String logicEntityNumberPropNumber = logicEntityNumber + propNumber;
            if (!StringUtils.isNotEmpty((String)logicEntityNumberPropNumber) || (bizObjBean = logicEntityNumberPropNumberAndBizObjMap.get(logicEntityNumberPropNumber)) == null) continue;
            this.setValue((Map)fieldKeyAndFieldInfoMapMap.get("cloud"), bizObjBean.getCloudName());
            this.setValue((Map)fieldKeyAndFieldInfoMapMap.get("app"), bizObjBean.getAppName());
            this.setValue((Map)fieldKeyAndFieldInfoMapMap.get("bizobj"), bizObjBean.getName());
        }
    }

    private void setLogicEntityCustomFieldValue(List<Map<Integer, Map<String, Object>>> tplDataRowList, Set<String> fieldKeyList, Map<String, LogicEntityExtInfoBean> logicEntityNumberAndLogicEntityExtInfoEntryMap) {
        for (Map<Integer, Map<String, Object>> tplDataRow : tplDataRowList) {
            String logicEntityNumber = "";
            LinkedHashMap fieldKeyAndFieldInfoMapMap = Maps.newLinkedHashMapWithExpectedSize((int)fieldKeyList.size());
            for (Map.Entry<Integer, Map<String, Object>> cellValueMapEntry : tplDataRow.entrySet()) {
                Map<String, Object> cellValueMap = cellValueMapEntry.getValue();
                Object key = cellValueMap.get("key");
                if (fieldKeyList.contains(key)) {
                    fieldKeyAndFieldInfoMapMap.put(key, cellValueMap);
                }
                if (!"number".equals(key)) continue;
                logicEntityNumber = cellValueMap.get("val") + "";
            }
            this.setCustomValue(logicEntityNumberAndLogicEntityExtInfoEntryMap, logicEntityNumber, fieldKeyAndFieldInfoMapMap);
        }
    }

    private void setCustomValue(Map<String, LogicEntityExtInfoBean> logicEntityNumberAndLogicEntityExtInfoEntryMap, String logicEntityNumber, Map<Object, Map<String, Object>> fieldKeyAndFieldInfoMapMap) {
        LogicEntityExtInfoBean logicEntityExtInfoBean;
        if (StringUtils.isNotEmpty((String)logicEntityNumber) && (logicEntityExtInfoBean = logicEntityNumberAndLogicEntityExtInfoEntryMap.get(logicEntityNumber)) != null) {
            if (logicEntityExtInfoBean.getBizObjBean() != null) {
                this.setValue(fieldKeyAndFieldInfoMapMap.get("cloud"), logicEntityExtInfoBean.getBizObjBean().getCloudName());
                this.setValue(fieldKeyAndFieldInfoMapMap.get("app"), logicEntityExtInfoBean.getBizObjBean().getAppName());
            }
            if (CollectionUtils.isNotEmpty((Collection)logicEntityExtInfoBean.getLogicEntityRelBeanList())) {
                List logicEntityRelBeanList = logicEntityExtInfoBean.getLogicEntityRelBeanList();
                List metadataNameList = logicEntityRelBeanList.stream().map(LogicEntityRelBean::getMetadataName).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
                this.setValue(fieldKeyAndFieldInfoMapMap.get("metadataname"), String.join((CharSequence)",", metadataNameList));
                List metadataNumberList = logicEntityRelBeanList.stream().map(LogicEntityRelBean::getMetadataNum).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
                this.setValue(fieldKeyAndFieldInfoMapMap.get("metadatanum"), String.join((CharSequence)",", metadataNumberList));
                List tableList = logicEntityRelBeanList.stream().map(LogicEntityRelBean::getTable).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
                this.setValue(fieldKeyAndFieldInfoMapMap.get("table"), String.join((CharSequence)",", tableList));
                List tableNameList = logicEntityRelBeanList.stream().map(LogicEntityRelBean::getMetadataName).filter(HRStringUtils::isNotEmpty).collect(Collectors.toList());
                this.setValue(fieldKeyAndFieldInfoMapMap.get("tablename"), String.join((CharSequence)",", tableNameList));
            }
        }
    }

    private void setValue(Map<String, Object> cellValueMap, String value) {
        if (cellValueMap != null) {
            cellValueMap.put("val", value);
        }
    }
}

