/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.logicentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.common.metadatafield.parse.IMetaDataFieldParser;
import kd.hdtc.hrbm.business.common.metadatafield.parse.MetaDataFieldParserFactory;
import kd.hdtc.hrbm.business.common.util.ExtTemplateUtils;
import kd.hdtc.hrbm.business.domain.model.bean.BizModelDataBean;
import kd.hdtc.hrbm.common.constant.HRBMAppConstants;
import kd.hdtc.hrbm.common.constant.TempMappingConstants;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;
import kd.hdtc.hrbm.common.enums.ExtCaseEnum;
import kd.hdtc.hrbm.common.exception.HRBMBizException;
import kd.hdtc.hrbm.common.msgEnum.BizModelMsgEnum;
import kd.hdtc.hrbm.formplugin.web.logicentity.LogicEntityCallbackEditPlugin;
import kd.hdtc.hrbm.formplugin.web.logicentity.LogicEntitykUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.IsvUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.PatternUtil;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class LogicEntityNewEditPlugin
extends LogicEntityCallbackEditPlugin {
    private static final Log LOG = LogFactory.getLog(LogicEntityNewEditPlugin.class);

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyKey = propertyChangedArgs.getProperty().getName();
        ChangeData changeData = propertyChangedArgs.getChangeSet()[0];
        if ("fieldtype".equals(propertyKey)) {
            this.changeFieldType(propertyChangedArgs, changeData);
        } else if ("ename".equals(propertyKey)) {
            this.changeEName();
        } else if ("epropkey".equals(propertyKey)) {
            this.changeEPropKey(changeData);
        } else if ("fieldconfig".equals(propertyKey)) {
            this.changeFieldConfig();
        } else if (HRStringUtils.equals((String)propertyKey, (String)"controlentity")) {
            this.handleControlEntity((Boolean)propertyChangedArgs.getChangeSet()[0].getNewValue());
        } else if ("number".equals(propertyKey)) {
            this.changeNumber();
        }
    }

    private void changeNumber() {
        String preFix = this.logicEntityPageSourceBo.getLogicEntityNumberGenerateBo().generate();
        String number = this.getModel().getDataEntity().getString("number");
        if (!number.startsWith(preFix)) {
            this.getModel().setValue("number", (Object)preFix);
        }
        if (PatternUtil.containsUppercase((String)number)) {
            this.getModel().setValue("number", (Object)number.toLowerCase(Locale.ROOT));
        }
    }

    private void handleControlEntity(Boolean control) {
        String currPageStatus = this.getView().getPageCache().get("currpagestatus");
        if (HRStringUtils.equals((String)currPageStatus, (String)"addnew")) {
            String platTemplateId = this.tempMappingDomainService.getBaseDataPlatTemplateIdById(control.booleanValue());
            DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
            entryEntity.removeIf(row -> row.getBoolean("extend"));
            LinkedList propIndexList = this.propDomainService.getPropIndexList(null, MetadataUtils.getMainEntityType((String)platTemplateId).getProperties().size());
            Set excludeColumns = this.iBaseConfigDomainService.getPropBlackList();
            ExtTemplateUtils.handleExtTemplateField((boolean)true, (Set)excludeColumns, (String)platTemplateId, (DynamicObjectCollection)entryEntity, (LinkedList)propIndexList);
            List sortEntryEntity = entryEntity.stream().sorted(Comparator.comparing(row -> !row.getBoolean("extend"))).collect(Collectors.toList());
            entryEntity.clear();
            entryEntity.addAll(sortEntryEntity);
            this.getModel().setValue("template", (Object)(control != false ? TempMappingConstants.ORG_BASEDATA_TEMPLATE_ID : TempMappingConstants.BASEDATA_TEMPLATE_ID));
            this.getView().updateView("entryentity");
            LogicEntitykUtils.controlEntry(this.getView(), this.getModel());
        }
    }

    private void changeFieldConfig() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        String fieldType = entryRowEntity.getString("fieldtype");
        if (FieldTypeEnum.BASEDATAFIELD.getType().equals(fieldType)) {
            this.handleBaseDataPropValue(entryRowEntity.getString("epropkey"), true, null, null);
        }
    }

    private void changeEPropKey(ChangeData changeData) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        String fieldType = entryRowEntity.getString("fieldtype");
        String propKey = entryRowEntity.getString("epropkey");
        if (StringUtils.isNotEmpty((String)propKey)) {
            this.getModel().setValue("epropkey", (Object)propKey.toLowerCase(Locale.ROOT), entryCurrentRowIndex);
        }
        if (FieldTypeEnum.BASEDATAFIELD.getType().equals(fieldType)) {
            this.handleBaseDataPropValue(String.valueOf(changeData.getOldValue()), false, propKey, entryRowEntity.getString("ename"));
        }
    }

    private void changeEName() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        String fieldType = entryRowEntity.getString("fieldtype");
        String propKey = entryRowEntity.getString("epropkey");
        this.getModel().setValue("ecusstatus", (Object)"0", entryCurrentRowIndex);
        if (FieldTypeEnum.BASEDATAFIELD.getType().equals(fieldType)) {
            this.handleBaseDataPropValue(propKey, false, propKey, entryRowEntity.getString("ename"));
        }
    }

    private void changeFieldType(PropertyChangedArgs propertyChangedArgs, ChangeData changeData) {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", entryCurrentRowIndex);
        String fieldType = entryRowEntity.getString("fieldtype");
        if (StringUtils.isEmpty((String)fieldType)) {
            return;
        }
        if (FieldTypeEnum.BASEDATAFIELD.getType().equals(changeData.getOldValue())) {
            this.handleBaseDataPropValue(entryRowEntity.getString("epropkey"), true, null, null);
        }
        this.setExtFieldEnable(entryCurrentRowIndex, true);
        this.updatePersonInfoAttachPropInfo(propertyChangedArgs);
        this.getView().setEnable(Boolean.valueOf(FieldTypeEnum.getExtField((String)fieldType)), entryCurrentRowIndex, new String[]{"fieldextattrname"});
    }

    private void updatePersonInfoAttachPropInfo(PropertyChangedArgs propertyChangedArgs) {
        ChangeData changeData;
        String oldFieldType;
        DynamicObject bizObj = this.getModel().getDataEntity().getDynamicObject("bizobj");
        if (bizObj != null && "hrpi_person".equals(bizObj.getString("number")) && "AttachmentPanelAp".equals(oldFieldType = (String)(changeData = propertyChangedArgs.getChangeSet()[0]).getOldValue())) {
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String newPropKey = this.getPropEntryNumber();
            this.getModel().setValue("epropkey", (Object)newPropKey, entryCurrentRowIndex);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((String)"fieldextattrname", (String)control.getKey())) {
            this.clickFieldAttrName();
        }
    }

    private void clickFieldAttrName() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", this.getModel().getEntryCurrentRowIndex("entryentity"));
        String item = entryRowEntity.getString("fieldconfig");
        String fieldType = entryRowEntity.getString("fieldtype");
        IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser((String)fieldType);
        if (metaDataFieldParser != null) {
            parameter.setFormId(metaDataFieldParser.getMetaDataNumber());
            if (StringUtils.isNotEmpty((String)item)) {
                parameter.setCustomParam("value", metaDataFieldParser.parseItems(item));
            }
            if (FieldTypeEnum.BASEDATAPROPFIELD.getType().equals(fieldType)) {
                Map<String, Map<String, String>> baseDataMap = this.parseBaseDataMap(this.getModel().getEntryEntity("entryentity"));
                parameter.setCustomParam("baseDataMap", baseDataMap);
            }
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectitmes"));
            this.getView().showForm(parameter);
        }
    }

    private Map<String, Map<String, String>> parseBaseDataMap(DynamicObjectCollection entryEntity) {
        if (entryEntity == null) {
            return null;
        }
        List baseDataEntry = entryEntity.stream().filter(dy -> FieldTypeEnum.BASEDATAFIELD.getType().equals(dy.getString("fieldtype"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(baseDataEntry)) {
            return null;
        }
        HashMap baseDataMap = Maps.newHashMapWithExpectedSize((int)baseDataEntry.size());
        IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser((String)FieldTypeEnum.BASEDATAFIELD.getType());
        for (DynamicObject baseData : baseDataEntry) {
            Map itemMap;
            HashMap propMap = Maps.newHashMapWithExpectedSize((int)4);
            propMap.put("epropkey", baseData.getString("epropkey"));
            propMap.put("ename", baseData.getString("ename"));
            if (metaDataFieldParser != null && CollectionUtils.isNotEmpty((Map)(itemMap = (Map)metaDataFieldParser.parseItems(baseData.getString("fieldconfig"))))) {
                propMap.put("baseEntityId", (String)itemMap.get("value"));
            }
            baseDataMap.put(baseData.getString("epropkey"), propMap);
        }
        return baseDataMap;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"saveandeffect")) {
            this.doBeforeSave(args, this.nodeId, this.openTypeObj);
        } else if (HRStringUtils.equals((String)operateKey, (String)"deleteentry")) {
            this.doBeforeDeleteEntry(args);
        } else if (HRStringUtils.equals((String)operateKey, (String)"fromotherentity")) {
            this.showFromOtherEntityPage();
        }
    }

    private void showFromOtherEntityPage() {
        FormShowParameter formShowParameter = this.logicEntityPageSourceBo.getFromOtherPageOpenBo().getFormShowParameter((IFormPlugin)this);
        this.getView().showForm(formShowParameter);
    }

    private void doBeforeDeleteEntry(BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        ArrayList nameList = Lists.newArrayListWithCapacity((int)10);
        ArrayList indexList = Lists.newArrayListWithCapacity((int)10);
        ArrayList baseDataEntityRowList = Lists.newArrayListWithCapacity((int)10);
        for (int selectRow : selectRows) {
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", selectRow);
            String fieldType = row.getString("fieldtype");
            if (FieldTypeEnum.BASEDATAFIELD.getType().equals(fieldType)) {
                baseDataEntityRowList.add(row);
            }
            String name = row.getString("ename");
            if (!HRStringUtils.equalsIgnoreCase((String)row.getString("eisv"), (String)ISVService.getISVInfo().getId())) {
                nameList.add(name);
                continue;
            }
            if (row.getBoolean("extend")) {
                nameList.add(name);
                continue;
            }
            indexList.add(selectRow + 1);
        }
        this.handleDeleteEntryEntity(args, nameList, indexList, baseDataEntityRowList);
    }

    private void doBeforeSave(BeforeDoOperationEventArgs args, Object nodeIdObj, Object openTypeObj) {
        if (!LogicEntitykUtils.checkEntryEntity(this)) {
            args.setCancel(true);
            return;
        }
        OperateOption option = ((DefaultEntityOperate)args.getSource()).getOption();
        option.setVariableValue("pagetype", openTypeObj.toString());
        option.setVariableValue("curnodeid", nodeIdObj.toString());
        this.addExtCase(option);
    }

    private void addExtCase(OperateOption option) {
        String isv = this.getModel().getDataEntity().getString("isv");
        if (HRStringUtils.isEmpty((String)isv)) {
            throw new HRBMBizException("isv should not be empty");
        }
        LOG.info("bizModelAllLineLog about LogicEntityNewEditPlugin.addExtCase():isv:{},extCaseStrValue:{}", (Object)isv, (Object)this.extCaseStrValue);
        option.setVariableValue("logicentity_extCaseKey", this.extCaseStrValue);
    }

    private String checkBaseDataTypeErrorMessage(List<DynamicObject> baseDataEntityRowList) {
        StringBuilder errorMessage = new StringBuilder();
        if (CollectionUtils.isEmpty(baseDataEntityRowList)) {
            return null;
        }
        HashMap baseDataTypeAndNameMap = Maps.newHashMapWithExpectedSize((int)baseDataEntityRowList.size());
        for (DynamicObject baseDataEntityRow : baseDataEntityRowList) {
            String propKey = baseDataEntityRow.getString("epropkey");
            if (StringUtils.isEmpty((String)propKey)) continue;
            baseDataTypeAndNameMap.put(propKey, baseDataEntityRow.getString("ename"));
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (int i = 0; i < entryEntity.size(); ++i) {
            Map result;
            String baseDataNumber;
            String baseDataPropFieldConfig;
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
            if (!FieldTypeEnum.BASEDATAPROPFIELD.getType().equals(dynamicObject.getString("fieldtype")) || StringUtils.isEmpty((String)(baseDataPropFieldConfig = dynamicObject.getString("fieldconfig"))) || baseDataTypeAndNameMap.get(baseDataNumber = (String)(result = (Map)SerializationUtils.fromJsonString((String)baseDataPropFieldConfig, Map.class)).get("baseDataNumber")) == null) continue;
            errorMessage.append(String.format(this.MESSAGE, baseDataTypeAndNameMap.get(baseDataNumber), i + 1, dynamicObject.getString("epropkey"))).append("\n");
        }
        return errorMessage.toString();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        BillShowParameter formShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if ("copy".equals(itemKey)) {
            DynamicObject template;
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(formShowParameter.getFormId());
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setHasRight(false);
            showParameter.getCustomParams().putAll(formShowParameter.getCustomParams());
            showParameter.getCustomParams().put("pkid", this.getModel().getDataEntity().getLong("id"));
            showParameter.getCustomParams().put("iscopy", true);
            showParameter.setCustomParam("logicentity_extCaseKey", (Object)this.computeExtCaseKeyForCopy((String)formShowParameter.getCustomParams().get("logicentity_extCaseKey")));
            DynamicObject pid = this.getModel().getDataEntity().getDynamicObject("pid");
            if (pid != null) {
                showParameter.getCustomParams().put("mainentity", pid.getLong("id"));
            }
            if ((template = this.getModel().getDataEntity().getDynamicObject("template")) == null) {
                boolean mulLine = this.getModel().getDataEntity().getBoolean("mulline");
                template = this.tempMappingDomainService.getTempMapping(pid != null ? pid.getString("number") : "", mulLine);
            }
            showParameter.getCustomParams().put("template", template == null ? 0L : template.getLong("id"));
            showParameter.setStatus(OperationStatus.ADDNEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private String computeExtCaseKeyForCopy(String oldExtKey) {
        String isv = Optional.ofNullable(this.getModel().getDataEntity()).map(it -> it.getString("isv")).orElse("");
        if (IsvUtils.isCurrentIsv((String)isv)) {
            return oldExtKey;
        }
        if (this.isBDOpenType()) {
            return ExtCaseEnum.BASEDATA_EXT_ENTITY.getStrId();
        }
        Long bizModelId = Optional.ofNullable(this.getModel().getDataEntity()).map(it -> it.getDynamicObject("bizobj")).map(it -> it.getLong("id")).orElse(null);
        BizModelDataBean bizModelDataBean = this.bizModelDataDomainService.getBizModelInfoById(BizModelTypeEnum.BIZ_OBJ, (Object)bizModelId);
        DynamicObject extCaseDy = this.extCaseDomainService.getMatchedExtCase(bizModelDataBean, true);
        return Optional.ofNullable(extCaseDy).map(it -> it.getLong("id")).map(it -> it.toString()).orElseThrow(() -> new HRBMBizException("ext case key is empty"));
    }

    private void handleBaseDataPropValue(String baseDataKey, boolean isClear, String newBaseDataPropKey, String newBaseDataPropName) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : entryEntity) {
            Map result;
            String baseDataNumber;
            String baseDataPropFieldConfig;
            if (!FieldTypeEnum.BASEDATAPROPFIELD.getType().equals(dynamicObject.getString("fieldtype")) || StringUtils.isEmpty((String)(baseDataPropFieldConfig = dynamicObject.getString("fieldconfig"))) || !baseDataKey.equals(baseDataNumber = (String)(result = (Map)JsonUtils.castType((String)baseDataPropFieldConfig, Map.class)).get("baseDataNumber"))) continue;
            if (isClear) {
                dynamicObject.set("fieldconfig", null);
                dynamicObject.set("fieldextattrname", null);
                continue;
            }
            String baseDataPropName = (String)result.get("baseDataPropName");
            String caption = newBaseDataPropName + "." + baseDataPropName;
            result.put("caption", caption);
            result.put("baseDataNumber", newBaseDataPropKey);
            result.put("baseDataName", newBaseDataPropName);
            dynamicObject.set("fieldconfig", (Object)JsonUtils.toStr((Object)result));
            dynamicObject.set("fieldextattrname", (Object)caption);
        }
        this.getView().updateView("entryentity");
        LogicEntitykUtils.controlEntry(this.getView(), this.getModel());
    }

    private void handleDeleteEntryEntity(BeforeDoOperationEventArgs args, List<String> nameList, List<Integer> indexList, List<DynamicObject> baseDataEntityRowList) {
        if (nameList.size() > 0) {
            this.getView().showErrorNotification(String.format(Locale.ROOT, BizModelMsgEnum.CURR_SELECT_PROP_NOT_DELETE.get(), String.join((CharSequence)",", nameList)));
            args.setCancel(true);
            return;
        }
        String baseDataTypeErrorMessage = this.checkBaseDataTypeErrorMessage(baseDataEntityRowList);
        if (StringUtils.isNotEmpty((String)baseDataTypeErrorMessage)) {
            this.getView().showErrorNotification(baseDataTypeErrorMessage);
            args.setCancel(true);
            return;
        }
        boolean hasEffective = false;
        DynamicObjectCollection propEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList hasEffectiveFieldNameList = Lists.newArrayListWithExpectedSize((int)16);
        for (int index : indexList) {
            DynamicObject row = this.getModel().getEntryRowEntity("entryentity", index - 1);
            boolean sync = row.getBoolean("sync");
            if (!sync) continue;
            hasEffective = true;
            hasEffectiveFieldNameList.add(row.getString("ename"));
        }
        if (!hasEffective) {
            propEntry.removeIf(prop -> indexList.contains(prop.getInt("seq")));
            this.getView().updateView("entryentity");
            LogicEntitykUtils.controlEntry(this.getView(), this.getModel());
        } else {
            String titleTip = String.format(Locale.ROOT, BizModelMsgEnum.DELETE_ENTRYENTITY_ENSURE_TIP.get(), String.join((CharSequence)",", hasEffectiveFieldNameList));
            this.getView().showConfirm(titleTip, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("deleteEntryEntityCallBackId", (IFormPlugin)this));
            this.getPageCache().put("needDeleteEntryEntityIndexList", JsonUtils.toStr(indexList));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"newentry")) {
            this.doAfterNewEntry();
        } else if (HRStringUtils.equals((String)operateKey, (String)"save") || HRStringUtils.equals((String)operateKey, (String)"saveandeffect")) {
            this.doAfterSave(args);
        } else if (HRStringUtils.equals((String)operateKey, (String)"modify")) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().updateView();
        }
    }

    private void doAfterSave(AfterDoOperationEventArgs args) {
        IFormView parentView;
        String fromType = (String)this.getView().getFormShowParameter().getCustomParam("fomtype");
        if ("bizList".equals(fromType) && args.getOperationResult().isSuccess()) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().updateView();
        }
        if ((parentView = this.getView().getParentView()) == null) {
            return;
        }
        if (parentView.getFormShowParameter().getFormId().equals("hrbm_bmmanagement") || parentView.getFormShowParameter().getFormId().equals("hrbm_bdmanagement")) {
            parentView.invokeOperation("refresh");
            this.getView().sendFormAction(parentView);
        }
    }

    private void doAfterNewEntry() {
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        this.getModel().setValue("eisv", (Object)ISVService.getISVInfo().getId(), entryCurrentRowIndex);
        this.getModel().setValue("eindex", (Object)this.getPropEntryIndex(), entryCurrentRowIndex);
        this.getModel().setValue("proptype", (Object)"10", entryCurrentRowIndex);
        this.getModel().setValue("epropkey", (Object)this.getPropEntryNumber(), entryCurrentRowIndex);
    }

    private String getPropEntryNumber() {
        return (String)this.logicEntityPageSourceBo.getPropKeyGenerateBo().generate(1, null, false).poll();
    }

    private Integer getPropEntryIndex() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        long pkId = this.getModel().getDataEntity().getLong("id");
        if (entryEntity.size() == 1) {
            return (Integer)this.propDomainService.getPropIndexList(Long.valueOf(pkId), 1).poll();
        }
        Optional<Integer> maxIndex = entryEntity.stream().map(dyc -> dyc.getInt("eindex")).max(Comparator.comparingInt(a -> a));
        if (!maxIndex.isPresent()) {
            return (Integer)this.propDomainService.getPropIndexList(Long.valueOf(pkId), 1).poll();
        }
        Integer index = maxIndex.get();
        if (index == 1) {
            index = HRBMAppConstants.THREE_HUNDRED;
        }
        if (index >= HRBMAppConstants.PROP_MAX_INDEX) {
            return HRBMAppConstants.PROP_MAX_INDEX;
        }
        int incrIndex = index + 10;
        if (incrIndex >= HRBMAppConstants.PROP_MAX_INDEX) {
            return HRBMAppConstants.PROP_MAX_INDEX;
        }
        return incrIndex;
    }
}

