/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.logicentity;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.isv.ISVService;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.MainEntity;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.common.metadatafield.parse.IMetaDataFieldParser;
import kd.hdtc.hrbm.business.common.metadatafield.parse.MetaDataFieldParserFactory;
import kd.hdtc.hrbm.business.common.util.ExtTemplateUtils;
import kd.hdtc.hrbm.business.domain.baseconfig.IBaseConfigDomainService;
import kd.hdtc.hrbm.business.domain.extcase.IExtCaseDomainService;
import kd.hdtc.hrbm.business.domain.model.IAppDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizModelDataDomainService;
import kd.hdtc.hrbm.business.domain.model.IEntityCardDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityRelDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropRelPropDomainService;
import kd.hdtc.hrbm.business.domain.model.ITempMappingDomainService;
import kd.hdtc.hrbm.business.domain.model.bo.LogicEntityPageSourceBo;
import kd.hdtc.hrbm.business.domain.model.bo.LogicEntityPageSourceBoBuilder;
import kd.hdtc.hrbm.business.domain.model.factory.PageTitleBoFactory;
import kd.hdtc.hrbm.common.constant.PropConstants;
import kd.hdtc.hrbm.common.constant.TempMappingConstants;
import kd.hdtc.hrbm.common.enums.ExtCaseEnum;
import kd.hdtc.hrbm.common.exception.HRBMBizException;
import kd.hdtc.hrbm.common.msgEnum.BizModelMsgEnum;
import kd.hdtc.hrbm.common.pojo.LogicEntityPageSourceParam;
import kd.hdtc.hrbm.common.pojo.PageTitleParam;
import kd.hdtc.hrbm.formplugin.web.common.util.CommonPageUtils;
import kd.hdtc.hrbm.formplugin.web.logicentity.LogicEntityEditPlugin;
import kd.hdtc.hrbm.formplugin.web.logicentity.LogicEntitykUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hr.hbp.common.util.HRStringUtils;

public class LogicEntityPageLoadEditPlugin
extends HDTCDataBaseEdit
implements HyperLinkClickListener,
TabSelectListener,
BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(LogicEntityEditPlugin.class);
    private static final String LOGIC_ENTITY_TAB = "logicentitytab";
    private static final String[] BTN_ARR = new String[]{"modify", "copy"};
    protected static final String SELECT_ITEMS = "selectitmes";
    protected static final String ALIAS = "alias";
    protected static final String VIEX_FLEX = "view_flex";
    protected static final String VIEW_ADVCONAP = "view_advconap";
    private static final String IS_ENTRY = "isentry";
    protected final String MESSAGE = ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u201c%1$s\u201d\u5df2\u88ab\u7b2c%2$s\u884c\u7684\u201c%3$s\u201d\u4f7f\u7528\uff0c\u8bf7\u91ca\u653e\u6b64\u57fa\u7840\u8d44\u6599\u5c5e\u6027\u540e\uff0c\u518d\u91cd\u65b0\u4fee\u6539", (String)"LogicEntityEditPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]);
    protected final ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);
    protected final IPropDomainService propDomainService = (IPropDomainService)ServiceFactory.getService(IPropDomainService.class);
    protected final ILogicEntityRelDomainService logicEntityRelDomainService = (ILogicEntityRelDomainService)ServiceFactory.getService(ILogicEntityRelDomainService.class);
    protected final IPropRelPropDomainService propRelDomainService = (IPropRelPropDomainService)ServiceFactory.getService(IPropRelPropDomainService.class);
    protected final IEntityCardDomainService entityCardDomainService = (IEntityCardDomainService)ServiceFactory.getService(IEntityCardDomainService.class);
    protected final ITempMappingDomainService tempMappingDomainService = (ITempMappingDomainService)ServiceFactory.getService(ITempMappingDomainService.class);
    protected final IBaseConfigDomainService baseConfigDomainService = (IBaseConfigDomainService)ServiceFactory.getService(IBaseConfigDomainService.class);
    protected final IAppDomainService appDomainService = (IAppDomainService)ServiceFactory.getService(IAppDomainService.class);
    protected final IExtCaseDomainService extCaseDomainService = (IExtCaseDomainService)ServiceFactory.getService(IExtCaseDomainService.class);
    protected final IBizModelDataDomainService bizModelDataDomainService = (IBizModelDataDomainService)ServiceFactory.getService(IBizModelDataDomainService.class);
    protected final IBaseConfigDomainService iBaseConfigDomainService = (IBaseConfigDomainService)ServiceFactory.createInstance(IBaseConfigDomainService.class);
    private static final String SCENE_COPY = "SCENE_COPY";
    private static final String SCENE_NEW = "SCENE_NEW";
    protected Map<String, Object> customParamMap;
    protected Object openTypeObj;
    protected Object template;
    protected Object isEntryObj;
    protected Object nodeId;
    protected Object mainEntityObj;
    protected Object mulLine;
    protected long billPkId;
    protected Boolean isCopy;
    protected long billPid;
    protected String extCaseStrValue;
    private Object subLogicEntity;
    private Object mainTitle;
    private Object changeTitle;
    private Object location;
    private List<String> cusPropList;
    protected LogicEntityPageSourceBo logicEntityPageSourceBo;

    public void registerListener(EventObject evt) {
        super.registerListener(evt);
        TextEdit textEdit = (TextEdit)this.getView().getControl("fieldextattrname");
        textEdit.addClickListener((ClickListener)this);
        TextEdit numberEdit = (TextEdit)this.getView().getControl("number");
        numberEdit.addClickListener((ClickListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        this.addItemClickListeners(new String[]{"copy"});
        BasedataEdit menuLocal = (BasedataEdit)this.getView().getControl("menulocal");
        menuLocal.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void initialize() {
        super.initialize();
        this.initCustomParam();
        this.initLogicEntityPageSourceBo();
    }

    private void initLogicEntityPageSourceBo() {
        if (this.logicEntityPageSourceBo == null) {
            this.logicEntityPageSourceBo = LogicEntityPageSourceBoBuilder.build((LogicEntityPageSourceParam)this.getLogicEntityPageSourceParam());
        }
    }

    private void initCustomParam() {
        this.customParamMap = this.getView().getFormShowParameter().getCustomParams();
        LOG.info("cus_param_map = {}", this.customParamMap);
        this.openTypeObj = this.customParamMap.get("opentype");
        this.template = this.customParamMap.get("template");
        this.isEntryObj = this.customParamMap.get(IS_ENTRY);
        this.nodeId = this.customParamMap.get("curnodeid");
        this.mainEntityObj = this.customParamMap.get("mainentity");
        this.mulLine = this.customParamMap.get("mulline");
        this.isCopy = (Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy");
        this.billPkId = ConvertUtils.toLong((Object)this.customParamMap.get("pkid"));
        this.extCaseStrValue = (String)this.getView().getFormShowParameter().getCustomParam("logicentity_extCaseKey");
        LOG.info("ext_case_value = {}", (Object)this.extCaseStrValue);
        this.subLogicEntity = this.customParamMap.get("sublogicentity");
        this.mainTitle = this.customParamMap.get("maintitle");
        this.changeTitle = this.customParamMap.get("changetitle");
        this.location = this.customParamMap.get("location");
        this.cusPropList = (List)this.customParamMap.get("propList");
    }

    protected boolean isBDOpenType() {
        return HRStringUtils.equals((String)((String)this.openTypeObj), (String)"bdmode");
    }

    public void afterCreateNewData(EventObject evt) {
        this.getView().getPageCache().put("currpagestatus", "addnew");
        if (ObjectUtils.isEmpty((Object)this.openTypeObj)) {
            return;
        }
        String formId = this.getView().getFormShowParameter().getFormId();
        this.getModel().setValue("pid", (Object)ConvertUtils.toLong((Object)this.mainEntityObj));
        this.getModel().setValue("bizobj", (Object)ConvertUtils.toLong((Object)this.nodeId));
        this.getModel().setValue("number", (Object)this.logicEntityPageSourceBo.getLogicEntityNumberGenerateBo().generate());
        this.getModel().setValue("isv", (Object)ISVService.getISVInfo().getId());
        this.getModel().setValue("index", (Object)this.logicEntityDomainService.getLogicEntityIndex(Long.valueOf(ConvertUtils.toLong((Object)this.nodeId))));
        this.getModel().setValue("sublogicentity", this.subLogicEntity);
        this.getModel().setValue("maintitle", this.mainTitle);
        this.getModel().setValue("changetitle", this.changeTitle);
        this.getModel().setValue("location", this.location);
        if (!ObjectUtils.isEmpty((Object)this.isEntryObj)) {
            this.addEntryObj();
        }
        if (!CollectionUtils.isEmpty(this.cusPropList)) {
            this.setTableValueByIdList(this.cusPropList.stream().map(Long::valueOf).collect(Collectors.toList()), "1", false);
        }
        if (!ObjectUtils.isEmpty((Object)this.template)) {
            this.getModel().setValue("template", (Object)ConvertUtils.toLong((Object)this.template));
            this.handleInheritFieldByTemplate(this.template, true);
        }
        if (!ObjectUtils.isEmpty((Object)this.mulLine)) {
            this.getModel().setValue("mulline", (Object)HRStringUtils.equals((String)this.mulLine.toString(), (String)"1"));
        }
        this.handleBizOtherCase();
        this.handleBDData();
        this.changeFromOtherBtn();
        this.controlFormFieldDisplay();
        this.changePropTypeSelect();
        LogicEntitykUtils.controlEntry(this.getView(), this.getModel());
    }

    private void handleBizOtherCase() {
        this.logicEntityPageSourceBo.getHandleDataModelBizCaseBo().handle();
    }

    private void handleBDData() {
        if (!this.isBDOpenType()) {
            return;
        }
        DynamicObject logicEntity = this.logicEntityDomainService.getLogicEntityInfoById((Object)this.billPkId);
        if (logicEntity != null && this.isCopy.booleanValue()) {
            this.getModel().setValue("mainentity", (Object)logicEntity.getBoolean("mainentity"));
            this.getModel().setValue("menulocal", (Object)logicEntity.getDynamicObject("menulocal"));
            this.getModel().setValue("controlentity", (Object)logicEntity.getBoolean("controlentity"));
        } else {
            this.getModel().setValue("mainentity", (Object)"1");
            this.getModel().setValue("template", (Object)TempMappingConstants.BASEDATA_TEMPLATE_ID);
        }
    }

    private void changeFromOtherBtn() {
        Boolean flag = Boolean.FALSE;
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.getValue() != OperationStatus.VIEW.getValue()) {
            flag = this.logicEntityPageSourceBo.getFromOtherPageOpenBo().isShowBtn();
        }
        this.setImportOtherBtnName(this.logicEntityPageSourceBo.getFromOtherPageOpenBo().getShowBtnName());
        this.getView().setVisible(flag, new String[]{"fromotherentity"});
    }

    protected final void setImportOtherBtnName(String name) {
        if (HRStringUtils.isEmpty((String)name)) {
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)1);
        HashMap textMap = Maps.newHashMapWithExpectedSize((int)1);
        textMap.put(Lang.get().toString(), name);
        map.put("text", textMap);
        this.getView().updateControlMetadata("fromotherentity", (Map)map);
    }

    protected final void setTableValueByIdList(Collection<Long> ids, String location, boolean importProp) {
        List propList = this.propDomainService.getPropInfoByIds(ids);
        if (CollectionUtils.isEmpty((Collection)propList)) {
            return;
        }
        this.addTableValue(propList, location, importProp);
    }

    private void addTableValue(List<DynamicObject> propList, String location, boolean importProp) {
        int index = LogicEntitykUtils.getEntryMaxIndex(this.getModel().getEntryEntity("entryentity"));
        Queue<String> proKeyQueue = this.getEntryPropKey(propList.size(), location, importProp);
        TableValueSetter vs = LogicEntitykUtils.buildCommonTableValueSetter();
        for (DynamicObject prop : propList) {
            index = LogicEntitykUtils.getEntryNextIndex(index);
            vs.addRow(new Object[]{prop.get("name"), prop.getString("fieldtype"), CollectionUtils.isEmpty(proKeyQueue) ? prop.getString("propkey") : proKeyQueue.poll(), prop.get("must"), prop.get("bizrule"), LogicEntitykUtils.getAlias(prop.getString("fieldtype"), prop.getString("fieldconfig")), prop.getString("fieldconfig"), "10", null, index, prop.get("description"), ISVService.getISVInfo().getId(), false, prop.getLong("id"), prop.getLong("id")});
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
    }

    private Queue<String> getEntryPropKey(int size, String location, boolean importProp) {
        return this.logicEntityPageSourceBo.getPropKeyGenerateBo().generate(size, location, importProp);
    }

    private void changePropTypeSelect() {
        Set fieldTypeSet = this.logicEntityPageSourceBo.getFieldTypeConfigBo().getConfigSet();
        ComboEdit comboEdit = (ComboEdit)this.getControl("fieldtype");
        List<ValueMapItem> allValueMapItemPropList = this.getAllValueMapItemPropList("fieldtype");
        List valueMapItemList = allValueMapItemPropList.stream().map(it -> this.getComboItem((ValueMapItem)it, fieldTypeSet)).collect(Collectors.toList());
        comboEdit.setComboItems(valueMapItemList);
    }

    private ComboItem getComboItem(ValueMapItem it, Set<String> fieldTypeSet) {
        if (fieldTypeSet.contains(it.getValue())) {
            return new ComboItem(it.getName(), it.getValue());
        }
        return new ComboItem(null, it.getName(), it.getValue(), false);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.changePropTypeSelect();
        this.controlFormFieldDisplay();
        this.controlRelL4L5Display();
    }

    private void controlRelL4L5Display() {
        if (!StringUtils.equals((String)this.extCaseStrValue, (String)ExtCaseEnum.PERSON_BILL_EXT_FIELD.getStrId())) {
            this.getView().setVisible(Boolean.valueOf(this.logicEntityPageSourceBo.getFromOtherPageOpenBo().isShowListRelPropRow()), new String[]{"importentityname", "importpropname"});
        }
    }

    private List<ValueMapItem> getAllValueMapItemPropList(String field) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hrbm_logicentity");
        ComboProp comboProp = (ComboProp)ConvertUtils.convert((Object)mainType.findProperty(field));
        return comboProp.getComboItems();
    }

    private void controlFormFieldDisplay() {
        if (this.isBDOpenType()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bizrule", "pid"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"menulocal", "controlentity"});
        }
    }

    private LogicEntityPageSourceParam getLogicEntityPageSourceParam() {
        return new LogicEntityPageSourceParam(this.getModel(), Long.valueOf(ConvertUtils.toLong((Object)this.mainEntityObj)), this.openTypeObj.toString(), Long.valueOf(ConvertUtils.toLong((Object)this.nodeId)), this.extCaseStrValue, this.customParamMap, this.getView().getFormShowParameter());
    }

    private void addEntryObj() {
        DynamicObjectCollection propEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject propDyc = propEntry.addNew();
        propDyc.set("must", (Object)true);
        propDyc.set("fieldtype", (Object)"BigIntField");
        propDyc.set("ename", (Object)"ID");
        propDyc.set("epropkey", (Object)"id");
        propDyc.set("eindex", (Object)1);
        propDyc.set("eisv", (Object)ISVService.getISVInfo().getId());
        propDyc.set("proptype", (Object)"10");
        propDyc.set("extend", (Object)true);
        propDyc.set("primary", (Object)true);
        this.getView().setEnable(Boolean.FALSE, ConvertUtils.toInt((Object)0), (String[])PropConstants.FIELD_SET.toArray((Object[])new String[0]));
    }

    public void afterBindData(EventObject evt) {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        String number = this.getView().getModel().getDataEntity().getString("number");
        String cusStatus = this.getView().getModel().getDataEntity().getString("cusstatus");
        String extCaseId = (String)this.getView().getFormShowParameter().getCustomParam("logicentity_extCaseKey");
        String isvType = this.getView().getModel().getDataEntity().getString("isvtype");
        if (this.logicEntityDomainService.checkNumberIsEnable(extCaseId, isvType) && !HRStringUtils.equals((String)"1", (String)cusStatus) && !MetadataUtils.isExist((String)number)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"number"});
        }
        String sceneType = this.getSceneType();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        List<Object> propList = new ArrayList<DynamicObject>();
        Map<Long, Long> proRelMap = Collections.EMPTY_MAP;
        if (StringUtils.equals((String)SCENE_NEW, (String)sceneType)) {
            this.getModel().setValue("isv", (Object)ISVService.getISVInfo().getId());
        } else if (StringUtils.equals((String)SCENE_COPY, (String)sceneType)) {
            propList = this.doCopyLogicEntity(this.billPkId, propList, (BillShowParameter)this.getView().getFormShowParameter(), this.billPid);
            this.getModel().setValue("isv", (Object)ISVService.getISVInfo().getId());
            proRelMap = this.propRelDomainService.getProRelByEntityIdAndRelType(Long.valueOf(this.billPkId), "B1").stream().collect(Collectors.toMap(dy -> dy.getLong("sourceprop"), dy -> dy.getLong("targetprop"), (v1, v2) -> v2));
        } else {
            propList = this.propDomainService.getExcludeWhitePropInfobyLogicEntityId(this.billPkId);
            this.handleOnlyProp(status);
            proRelMap = this.propRelDomainService.getProRelByEntityIdAndRelType(Long.valueOf(this.billPkId), "B1").stream().collect(Collectors.toMap(dy -> dy.getLong("sourceprop"), dy -> dy.getLong("targetprop"), (v1, v2) -> v2));
        }
        this.setEntityCardEntry(this.billPkId);
        this.setRelProp();
        this.doAfterBindData();
        this.changeFromOtherBtn();
        if (CollectionUtils.isEmpty(propList)) {
            return;
        }
        this.loadPropEntry(this.billPkId, propList, StringUtils.equals((String)SCENE_COPY, (String)sceneType), proRelMap);
        this.handleEntityField();
        LogicEntitykUtils.controlEntry(this.getView(), this.getModel());
        this.getModel().setDataChanged(false);
        this.getView().updateView("entryentity");
    }

    private void setRelProp() {
        Map<Long, Long> proRelMap = this.propRelDomainService.getProRelByEntityIdAndRelType(Long.valueOf(this.getModel().getDataEntity().getLong("id")), "B1").stream().collect(Collectors.toMap(dy -> dy.getLong("sourceprop"), dy -> dy.getLong("targetprop"), (v1, v2) -> v2));
        if (CollectionUtils.isEmpty(proRelMap)) {
            return;
        }
        DynamicObjectCollection entryEntityCol = this.getModel().getEntryEntity("entryentity");
        int index = 0;
        for (DynamicObject entityDy : entryEntityCol) {
            Long otherImportProp = proRelMap.get(entityDy.getLong("id"));
            if (otherImportProp != null) {
                this.getModel().setValue("personimportprop", (Object)otherImportProp, index);
                this.getModel().setValue("otherImportProp", (Object)otherImportProp, index);
            }
            ++index;
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String sourceName = Optional.ofNullable(evt).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)sourceName, (String)"menulocal")) {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            Object currentNodeId = this.getView().getFormShowParameter().getCustomParam("curnodeid");
            List appList = this.appDomainService.getAppInfoListByCloudId(Long.valueOf(ConvertUtils.toLong((Object)currentNodeId)));
            ArrayList platAppList = Lists.newArrayListWithCapacity((int)10);
            appList.stream().map(app -> app.getDynamicObjectCollection("appnumber")).filter(Objects::nonNull).forEach(app -> app.stream().map(ap -> ap.getDynamicObject("fbasedataid")).filter(Objects::nonNull).map(ap -> ap.getString("number")).forEach(ap -> platAppList.add(ap)));
            qFilters.add(new QFilter("app.number", "in", (Object)platAppList));
        }
    }

    private String getSceneType() {
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.getValue() == OperationStatus.ADDNEW.getValue()) {
            this.billPid = this.billPkId;
            DynamicObject parent = this.getView().getModel().getDataEntity().getDynamicObject("pid");
            if (parent != null) {
                this.billPid = parent.getLong("id");
            }
            if (this.billPkId > 0L) {
                return SCENE_COPY;
            }
            return SCENE_NEW;
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        this.billPkId = dataEntity.getLong("id");
        return "SCENE_" + status.getValue();
    }

    private List<DynamicObject> doCopyLogicEntity(long id, List<DynamicObject> propList, BillShowParameter showParameter, long pid) {
        long pkId = showParameter.getCustomParam("pkid") == null ? id : (Long)showParameter.getCustomParam("pkid");
        DynamicObject logicEntityInfo = this.logicEntityDomainService.getLogicEntityInfoById((Object)pkId);
        if (logicEntityInfo != null) {
            this.getModel().setValue("number", (Object)this.logicEntityDomainService.getLogicEntityNumber(Long.valueOf(pid), ConvertUtils.toString((Object)this.openTypeObj), Long.valueOf(ConvertUtils.toLong((Object)this.nodeId))));
            this.getModel().setValue("index", (Object)this.logicEntityDomainService.getLogicEntityIndex(Long.valueOf(ConvertUtils.toLong((Object)this.nodeId))));
            this.getModel().setValue("bizobj", logicEntityInfo.get("bizobj"));
            propList = this.propDomainService.getExcludeWhitePropInfobyLogicEntityId(pkId);
            if (!ObjectUtils.isEmpty((Object)this.template)) {
                this.getModel().setValue("template", (Object)ConvertUtils.toLong((Object)this.template));
                this.getView().getFormShowParameter().setCustomParam("template", (Object)ConvertUtils.toLong((Object)this.template));
            }
            this.handleCopyEntry();
            this.getView().updateView("entryentity");
        }
        return propList;
    }

    private void doAfterBindData() {
        if (!PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"hrbm", (String)"hrbm_bmmanagement", (String)"4715a0df000000ac")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"modify"});
        }
        if (!PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"hrbm", (String)"hrbm_bmmanagement", (String)"/KT6ZLHIL0Y8")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"saveandeffect"});
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean isMainEntity = dataEntity.getBoolean("mainentity");
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (status.getValue() == OperationStatus.VIEW.getValue()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"newentry", "deleteentry"});
            if (isMainEntity) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"copy"});
            } else {
                DynamicObject bizObj = dataEntity.getDynamicObject("bizobj");
                boolean showCopyBtn = this.baseConfigDomainService.isShowCopyBtn(bizObj != null ? bizObj.getString("number") : "");
                this.getView().setVisible(Boolean.valueOf(showCopyBtn), new String[]{"copy"});
            }
        } else if (status.getValue() == OperationStatus.ADDNEW.getValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"newentry", "deleteentry"});
            this.hideTabNavigation();
        } else if (status.getValue() == OperationStatus.EDIT.getValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"newentry", "deleteentry"});
            if (!HRStringUtils.equals((String)dataEntity.getString("isv"), (String)ISVService.getISVInfo().getId())) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"name", "index", "bizrule", "description"});
            }
            this.hideTabNavigation();
        }
        if (this.isBDOpenType()) {
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl("menulocal");
            basedataEdit.setMustInput(true);
            if (this.checkPropCusStatus()) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"controlentity"});
            }
        }
    }

    private boolean checkPropCusStatus() {
        return MetadataUtils.isExist((String)this.getModel().getDataEntity().getString("number"));
    }

    private void setEntityCardEntry(long logicId) {
        if (this.getView().getFormShowParameter().getStatus() != OperationStatus.VIEW) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{VIEW_ADVCONAP});
            return;
        }
        DynamicObject[] entityCards = this.entityCardDomainService.queryEntityCards(logicId);
        if (entityCards.length > 0) {
            Set logicIdSet = Arrays.stream(entityCards).map(dy -> dy.getLong("logicentity")).collect(Collectors.toSet());
            ListShowParameter listShowParameter = new ListShowParameter();
            listShowParameter.setBillFormId("hrbm_entitycardentry");
            listShowParameter.getOpenStyle().setTargetKey(VIEX_FLEX);
            listShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
            listShowParameter.getListFilterParameter().setFilter(new QFilter("logicentity", "in", logicIdSet));
            listShowParameter.getListFilterParameter().setOrderBy("index");
            this.getView().showForm((FormShowParameter)listShowParameter);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_ADVCONAP});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{VIEW_ADVCONAP});
        }
    }

    private void handleCopyEntry() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (CollectionUtils.isNotEmpty((Collection)entryEntity)) {
            entryEntity.forEach(row -> {
                row.set("epropkey", row.get("epropkey"));
                row.set("ecusstatus", (Object)"0");
            });
        }
    }

    private void handleOnlyProp(OperationStatus status) {
        this.getView().setVisible(Boolean.valueOf(OperationStatus.VIEW.equals((Object)status)), new String[]{"proponlylabel"});
    }

    private void loadPropEntry(long id, List<DynamicObject> propList, boolean isCopy, Map<Long, Long> proRelMap) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        entryEntity.clear();
        Set<Object> metadataPropNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        if (!isCopy && id != 0L) {
            metadataPropNumberSet = this.getMetadataPropNumbers(id);
        }
        HashSet finalMetadataPropNumberSet = metadataPropNumberSet;
        ArrayList fieldNumberList = Lists.newArrayListWithExpectedSize((int)10);
        fieldNumberList.add("id");
        if (isCopy) {
            String platTemplateId = this.tempMappingDomainService.getPlatTemplateIdByTempMappingId(Long.valueOf(this.template == null ? 0L : ConvertUtils.toLong((Object)this.template)));
            if (this.isBDOpenType()) {
                platTemplateId = this.tempMappingDomainService.getBaseDataPlatTemplateIdById(this.getModel().getDataEntity().getBoolean("controlentity"));
            }
            if (StringUtils.isNotEmpty((String)platTemplateId) && MetadataUtils.isExist((String)platTemplateId)) {
                fieldNumberList.addAll(MetadataUtils.getFieldNumberList((String)platTemplateId));
            }
        }
        Map<Long, DynamicObject> relPropMap = this.getRelPropMap(proRelMap);
        propList.stream().sorted(Comparator.comparing(prop -> prop.getInt("index"))).forEach(prop -> {
            Long otherImportProp;
            DynamicObject dyc = new DynamicObject(entryEntity.getDynamicObjectType());
            if (!isCopy) {
                dyc.set("id", (Object)prop.getLong("id"));
                dyc.set("ecusstatus", (Object)prop.getString("cusstatus"));
            }
            if ((otherImportProp = (Long)proRelMap.get(prop.getLong("id"))) != null) {
                dyc.set("otherImportProp", (Object)otherImportProp);
                dyc.set("personimportprop", relPropMap.get(otherImportProp));
            }
            dyc.set("epropkey", (Object)prop.getString("propkey"));
            dyc.set("ename", (Object)prop.getLocaleString("name"));
            dyc.set("fieldtype", (Object)prop.getString("fieldtype"));
            dyc.set("must", (Object)prop.getBoolean("must"));
            dyc.set("ebizrule", (Object)prop.getLocaleString("bizrule"));
            dyc.set("fieldconfig", (Object)prop.getString("fieldconfig"));
            dyc.set("proplabelmul", (Object)prop.getDynamicObjectCollection("proplabelmul"));
            dyc.set("eindex", (Object)prop.getInt("index"));
            dyc.set("primary", (Object)prop.getBoolean("primary"));
            dyc.set("proptype", (Object)prop.getString("proptype"));
            dyc.set("extend", (Object)prop.getBoolean("extend"));
            dyc.set("eisv", (Object)prop.getString("isv"));
            dyc.set("sync", (Object)false);
            if (isCopy) {
                dyc.set("extend", (Object)fieldNumberList.contains(prop.getString("propkey")));
                dyc.set("eisv", (Object)(dyc.getBoolean("extend") ? prop.getString("isv") : ISVService.getISVInfo().getId()));
                dyc.set("ecusstatus", (Object)0);
            } else if (id != 0L && finalMetadataPropNumberSet.contains(prop.getString("propkey"))) {
                dyc.set("sync", (Object)true);
            }
            entryEntity.add((Object)dyc);
        });
        List sortEntryEntity = entryEntity.stream().sorted(Comparator.comparing(row -> !row.getBoolean("extend"))).collect(Collectors.toList());
        entryEntity.clear();
        entryEntity.addAll(sortEntryEntity);
    }

    private Map<Long, DynamicObject> getRelPropMap(Map<Long, Long> proRelMap) {
        if (CollectionUtils.isEmpty(proRelMap)) {
            return Maps.newHashMap();
        }
        Set relPropIdSet = proRelMap.entrySet().stream().map(it -> (Long)it.getValue()).collect(Collectors.toSet());
        List relPropDyList = this.propDomainService.getSimplePropList(relPropIdSet);
        return relPropDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (o1, o2) -> o2));
    }

    private Set<String> getMetadataPropNumbers(Long id) {
        HashSet metadataPropNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        List logicEntityRelList = this.logicEntityRelDomainService.getLogicEntityRelInfoByLogicEntityId(id);
        logicEntityRelList.forEach(logic -> {
            String metadataNum = this.getMetadataNumber(logic.getString("metadatanum"));
            if (!MetadataDao.checkNumber((String)metadataNum)) {
                throw new HRBMBizException(String.format(Locale.ROOT, BizModelMsgEnum.METADATA_NOT_EXIST.get(), metadataNum));
            }
            MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)metadataNum);
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            List formMetadata = MetadataUtils.getFormMetadata((String)mainEntityType.getName());
            List<ControlAp> fileAps = null;
            if (CollectionUtils.isNotEmpty((Collection)formMetadata)) {
                fileAps = formMetadata.stream().filter(form -> form instanceof AttachmentPanelAp).collect(Collectors.toList());
            }
            List items = entityMetadata.getItems();
            Set entryEntityIdSet = items.stream().filter(item -> item instanceof EntryEntity).map(item -> item.getId()).collect(Collectors.toSet());
            items.forEach(item -> {
                if (item instanceof MainEntity) {
                    metadataPropNumberSet.add("id");
                    return;
                }
                if (item instanceof EntryEntity || entryEntityIdSet.contains(item.getParentId())) {
                    return;
                }
                metadataPropNumberSet.add(item.getKey());
            });
            if (fileAps != null && fileAps.size() > 0) {
                fileAps.forEach(ap -> metadataPropNumberSet.add(ap.getKey()));
            }
        });
        return metadataPropNumberSet;
    }

    private String getMetadataNumber(String metadataNumber) {
        return (String)Splitter.on((String)".").splitToList((CharSequence)metadataNumber).get(0);
    }

    private void handleEntityField() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (!ObjectUtils.isEmpty((Object)entryEntity)) {
            String curIsv = ISVService.getISVInfo().getId();
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject entity = (DynamicObject)entryEntity.get(i);
                String item = entity.getString("fieldconfig");
                String isv = entity.getString("eisv");
                boolean extend = entity.getBoolean("extend");
                this.setFieldItemName(entity, item);
                this.setExtFieldEnable(i, false);
                if (!HRStringUtils.equalsIgnoreCase((String)curIsv, (String)isv) || extend) {
                    this.getView().setEnable(Boolean.FALSE, ConvertUtils.toInt((Object)i), new String[]{"fieldextattrname"});
                    continue;
                }
                boolean hasFieldConfig = FieldTypeEnum.getExtField((String)entity.getString("fieldtype"));
                if (hasFieldConfig) continue;
                this.getView().setEnable(Boolean.valueOf(hasFieldConfig), i, new String[]{"fieldextattrname"});
            }
        }
    }

    private void setFieldItemName(DynamicObject entity, String item) {
        if (StringUtils.isEmpty((String)item)) {
            return;
        }
        String fieldType = entity.getString("fieldtype");
        IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser((String)fieldType);
        if (metaDataFieldParser != null) {
            String alias = metaDataFieldParser.parseAlias(item);
            entity.set("fieldextattrname", (Object)alias);
        }
    }

    protected void setExtFieldEnable(int entryCurrentRowIndex, boolean isDeleteAllValue) {
        if (isDeleteAllValue) {
            this.getModel().setValue("fieldextattrname", null, entryCurrentRowIndex);
            this.getModel().setValue("fieldconfig", null, entryCurrentRowIndex);
        }
    }

    private void handleInheritFieldByTemplate(Object template, boolean supportContainWhite) {
        DynamicObject tempDyc = this.tempMappingDomainService.getTempMappingById(Long.valueOf(ConvertUtils.toLong((Object)template)));
        if (tempDyc == null) {
            return;
        }
        DynamicObject templateEntity = tempDyc.getDynamicObject("template");
        if (templateEntity == null) {
            return;
        }
        String templateId = templateEntity.getString("id");
        DynamicObjectCollection entryEntity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        LinkedList propIndexList = this.propDomainService.getPropIndexList(null, MetadataUtils.getMainEntityType((String)templateId).getProperties().size());
        Set excludeColumns = this.iBaseConfigDomainService.getPropBlackList();
        ExtTemplateUtils.handleExtTemplateField((boolean)supportContainWhite, (Set)excludeColumns, (String)templateId, (DynamicObjectCollection)entryEntity, (LinkedList)propIndexList);
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObject currentEntryDy = (DynamicObject)entryEntity.get(args.getRowIndex());
        if ("0".equals(currentEntryDy.getString("ecusstatus"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5c5e\u6027\u5c1a\u672a\u751f\u6548\uff0c\u65e0\u6cd5\u67e5\u770b\u5c5e\u6027\u4fe1\u606f\uff0c\u8bf7\u5728\u5c5e\u6027\u751f\u6548\u540e\u518d\u8fdb\u884c\u70b9\u51fb\u67e5\u770b\u3002", (String)"LogicEntityEditPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long primaryKeyValue = currentEntryDy.getLong("id");
        Long id = this.getModel().getDataEntity().getLong("id");
        if (StringUtils.equals((String)"epropkey", (String)args.getFieldName()) && id != 0L) {
            CommonPageUtils.showBillForm(this.getView(), "hrbm_prop", primaryKeyValue, null, OperationStatus.VIEW, ShowType.MainNewTabPage);
        }
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey = evt.getTabKey();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        long id = dataEntity.getLong("id");
        if (HRStringUtils.equals((String)tabKey, (String)LOGIC_ENTITY_TAB)) {
            this.getView().setVisible(Boolean.FALSE, BTN_ARR);
            CommonPageUtils.showPageInContainer(this.getView(), "hrbm_logicentity_info", id, LOGIC_ENTITY_TAB);
        } else if (HRStringUtils.equals((String)tabKey, (String)"tab")) {
            if (!PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"hrbm", (String)"hrbm_bmmanagement", (String)"4715a0df000000ac")) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"modify"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"modify"});
            }
            DynamicObject bizObj = dataEntity.getDynamicObject("bizobj");
            boolean showCopyBtn = this.baseConfigDomainService.isShowCopyBtn(bizObj != null ? bizObj.getString("number") : "");
            this.getView().setVisible(Boolean.valueOf(showCopyBtn), new String[]{"copy"});
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter.getStatus().getValue() != OperationStatus.ADDNEW.getValue()) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        e.getFormShowParameter().setCaption(PageTitleBoFactory.generate((PageTitleParam)new PageTitleParam(formShowParameter)).getPageTitle());
    }

    private void hideTabNavigation() {
        HashMap<String, Boolean> ctrl = new HashMap<String, Boolean>();
        ctrl.put("hideNav", true);
        this.getView().updateControlMetadata("tabap", ctrl);
    }
}

