/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.logicentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.isv.ISVService;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.common.metadatafield.parse.IMetaDataFieldParser;
import kd.hdtc.hrbm.business.common.metadatafield.parse.MetaDataFieldParserFactory;
import kd.hdtc.hrbm.common.constant.HRBMAppConstants;
import kd.hdtc.hrbm.common.constant.LogicEntityConstants;
import kd.hdtc.hrbm.common.constant.PropConstants;
import kd.hdtc.hrbm.common.msgEnum.BizModelMsgEnum;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hr.hbp.common.util.HRStringUtils;

public class LogicEntitykUtils {
    private static final Set<String> OTHER_IMPORT_FIELD_LOCK_SET = Sets.newHashSet((Object[])new String[]{"fieldtype", "epropkey", "must", "fieldextattrname"});

    public static boolean checkEntryEntity(HDTCDataBaseEdit plugin) {
        DynamicObjectCollection propList = plugin.getView().getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ArrayList nameList = Lists.newArrayListWithCapacity((int)10);
        String curIsv = ISVService.getISVInfo().getId();
        propList.stream().filter(prop -> HRStringUtils.equalsIgnoreCase((String)curIsv, (String)prop.getString("eisv")) || !prop.getBoolean("extend")).forEach(prop -> {
            String name = prop.getString("ename");
            String fieldType = prop.getString("fieldtype");
            String fieldExt = prop.getString("fieldextattrname");
            if (LogicEntityConstants.MUST_INPUT_LIST.contains(fieldType) && HRStringUtils.isEmpty((String)fieldExt)) {
                nameList.add(name);
            }
        });
        if (CollectionUtils.isEmpty((Collection)nameList)) {
            return true;
        }
        StringBuilder sb = new StringBuilder();
        nameList.forEach(name -> sb.append(String.format(Locale.ROOT, BizModelMsgEnum.PROP_TYPE_VALUE_IS_EMPTY_TIP.get(), name)).append("\n"));
        plugin.getView().showMessage(BizModelMsgEnum.MISS_REQUIERD_TIP.get(), sb.toString(), MessageTypes.Default);
        return false;
    }

    public static void controlEntry(IFormView view, IDataModel mode) {
        DynamicObjectCollection entryEntity = mode.getEntryEntity("entryentity");
        String curIsv = ISVService.getISVInfo().getId();
        String[] otherImportLocks = OTHER_IMPORT_FIELD_LOCK_SET.toArray(new String[0]);
        for (int i = 0; i < entryEntity.size(); ++i) {
            DynamicObject propDy = (DynamicObject)entryEntity.get(i);
            String fieldType = propDy.getString("fieldtype");
            String isv = propDy.getString("eisv");
            boolean extend = propDy.getBoolean("extend");
            boolean sync = propDy.getBoolean("sync");
            String cusStatus = propDy.getString("ecusstatus");
            if (!HRStringUtils.equalsIgnoreCase((String)curIsv, (String)isv) || extend) {
                view.setEnable(Boolean.FALSE, i, (String[])PropConstants.FIELD_SET.toArray((Object[])new String[0]));
                continue;
            }
            if (HRStringUtils.equals((String)cusStatus, (String)"1") || sync) {
                view.setEnable(Boolean.FALSE, i, (String[])PropConstants.DEPT_FIELD_SET.toArray((Object[])new String[0]));
                continue;
            }
            if (propDy.getLong("otherImportProp") != 0L) {
                view.setEnable(Boolean.FALSE, i, otherImportLocks);
                continue;
            }
            view.setEnable(Boolean.valueOf(FieldTypeEnum.getExtField((String)fieldType)), i, new String[]{"fieldextattrname"});
        }
    }

    @Deprecated
    public static void setEntryFieldDisable(IFormView view) {
        IDataModel model = view.getModel();
        if (view.getFormShowParameter().getStatus().getValue() == OperationStatus.VIEW.getValue()) {
            return;
        }
        DynamicObjectCollection col = model.getEntryEntity("entryentity");
        if (CollectionUtils.isEmpty((Collection)col)) {
            return;
        }
        String[] fields = OTHER_IMPORT_FIELD_LOCK_SET.toArray(new String[0]);
        int i = 0;
        for (DynamicObject entityDy : col) {
            if (entityDy.getLong("otherImportProp") != 0L) {
                view.setEnable(Boolean.FALSE, i, fields);
            }
            ++i;
        }
    }

    public static int getEntryMaxIndex(DynamicObjectCollection col) {
        Optional<DynamicObject> maxIndexOp = col.stream().max(Comparator.comparingInt(dy -> dy.getInt("eindex")));
        int index = HRBMAppConstants.THREE_HUNDRED;
        if (maxIndexOp.isPresent()) {
            index = maxIndexOp.get().getInt("eindex");
            index = index < HRBMAppConstants.THREE_HUNDRED ? HRBMAppConstants.THREE_HUNDRED : index;
        }
        return index;
    }

    public static int getEntryNextIndex(int index) {
        index = (index += 10) > HRBMAppConstants.PROP_MAX_INDEX ? HRBMAppConstants.PROP_MAX_INDEX : index;
        return index;
    }

    public static TableValueSetter buildCommonTableValueSetter() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("ename", new Object[0]);
        vs.addField("fieldtype", new Object[0]);
        vs.addField("epropkey", new Object[0]);
        vs.addField("must", new Object[0]);
        vs.addField("ebizrule", new Object[0]);
        vs.addField("fieldextattrname", new Object[0]);
        vs.addField("fieldconfig", new Object[0]);
        vs.addField("proptype", new Object[0]);
        vs.addField("proplabelmul", new Object[0]);
        vs.addField("eindex", new Object[0]);
        vs.addField("edescription", new Object[0]);
        vs.addField("eisv", new Object[0]);
        vs.addField("extend", new Object[0]);
        vs.addField("otherImportProp", new Object[0]);
        vs.addField("personimportprop", new Object[0]);
        return vs;
    }

    public static String getAlias(String fieldType, String fieldConfig) {
        IMetaDataFieldParser metaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParser((String)fieldType);
        String alias = null;
        if (metaDataFieldParser != null) {
            alias = metaDataFieldParser.parseAlias(fieldConfig);
        }
        return alias;
    }
}

