/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.logicentity;

import com.google.common.collect.ImmutableMap;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.ITempMappingDomainService;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

public class ScheduleQuestEditPlugin
extends AbstractHDTCFormPlugin {
    ITempMappingDomainService tempMappingDomainService = (ITempMappingDomainService)ServiceFactory.getService(ITempMappingDomainService.class);
    ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);
    private static final Map<String, String> PERSON_TYPE_MAP = ImmutableMap.of((Object)"1", (Object)"hrpi_person", (Object)"2", (Object)"hrpi_employee", (Object)"3", (Object)"hrpi_depemp");
    private final String PERSON_LABEL\uff3fTEXT = ResManager.loadKDString((String)"\u4e2a\u4eba\u4fe1\u606f\uff0c\u6bd4\u5982\u5e74\u9f84\u3001\u8054\u7cfb\u7535\u8bdd\u3001\u5bb6\u5ead\u4f4f\u5740\u3001\u6559\u80b2\u7ecf\u5386\u7b49\u4e0d\u56e0\u4e3a\u4f01\u4e1a\u4ea7\u751f\u53d8\u66f4\u7684\u4fe1\u606f", (String)"ScheduleQuestEditPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]);
    private final String COMPANY\uff3fLABEL\uff3fTEXT = ResManager.loadKDString((String)"\u4f01\u4e1a\u670d\u52a1\u8fc7\u7a0b\u4e2d\u4ea7\u751f\u7684\u4fe1\u606f\uff0c\u5982\u534f\u8bae\u5de5\u4f5c\u5730\u3001\u4f01\u4e1a\u57f9\u8bad\u8bb0\u5f55\u3001\u85aa\u8d44\u53d1\u653e\u8d26\u6237\u3001\u8bd5\u7528\u671f\u8868\u73b0\u3001\u8bd5\u7528\u671f\u60c5\u51b5\u8bc4\u5b9a\u7b49\uff0c\u4e14\u7528\u5de5\u5173\u7cfb\u7c7b\u578b\u53d8\u66f4\u540e\uff0c\u4fe1\u606f\u4f1a\u8ddf\u968f\u65b0\u7684\u7528\u5de5\u7ecf\u5386\u66f4\u65b0\uff0c\u4e0d\u540c\u9636\u6bb5\u7684\u6570\u636e\u662f\u5426\u8981\u6309\u7167\u7ba1\u7406\u7ec4\u7ec7\u505a\u6743\u9650\u63a7\u5236\u6216\u5c55\u793a\u9650\u5236", (String)"ScheduleQuestEditPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]);
    private final String ORG\uff3fLABEL\uff3fTEXT = ResManager.loadKDString((String)"\u4f01\u4e1a\u670d\u52a1\u8fc7\u7a0b\u4e2d\u4ea7\u751f\u7684\u4efb\u804c\u60c5\u51b5\u53d8\u5316\uff0c\u5982\u8c03\u52a8\u3001\u5916\u6d3e\u6216\u517c\u804c\u4ea7\u751f\u7684\u4efb\u804c\u4fe1\u606f\u53d8\u5316\uff0c\u6216\u8ddf\u5c97\u4f4d/\u884c\u653f\u7ec4\u7ec7\u4e25\u683c\u5173\u8054\u7684\u4fe1\u606f", (String)"ScheduleQuestEditPlugin_2", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String operateKey = propertyChangedArgs.getProperty().getName();
        if ("infotype".equals(operateKey)) {
            if ("3".equals(this.getModel().getValue("infotype"))) {
                this.getModel().setValue("mulline", (Object)"2");
                this.getView().setEnable(Boolean.FALSE, new String[]{"mulline"});
            } else {
                this.getModel().setValue("mulline", (Object)"1");
                this.getView().setEnable(Boolean.TRUE, new String[]{"mulline"});
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        String mainLogicEntity = (String)this.getView().getFormShowParameter().getCustomParam("mainentity");
        DynamicObject logicEntity = this.logicEntityDomainService.getLogicEntityInfoById((Object)mainLogicEntity);
        if (!HRObjectUtils.isEmpty((Object)logicEntity)) {
            String logicEntityNumber = logicEntity.getString("number");
            if ("hrpi_person".equals(logicEntityNumber)) {
                this.getModel().setValue("infotype", (Object)"1");
            } else if ("hrpi_employee".equals(logicEntityNumber)) {
                this.getModel().setValue("infotype", (Object)"2");
            } else if ("hrpi_depemp".equals(logicEntityNumber)) {
                this.getModel().setValue("infotype", (Object)"3");
                this.getModel().setValue("mulline", (Object)"2");
                this.getView().setEnable(Boolean.FALSE, new String[]{"mulline"});
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Label personLabel = (Label)this.getView().getControl("personlabel");
        Label companyLabel = (Label)this.getView().getControl("companylabel");
        Label orgLabel = (Label)this.getView().getControl("orglabel");
        personLabel.setText(this.PERSON_LABEL\uff3fTEXT);
        companyLabel.setText(this.COMPANY\uff3fLABEL\uff3fTEXT);
        orgLabel.setText(this.ORG\uff3fLABEL\uff3fTEXT);
        this.getView().setEnable(Boolean.FALSE, new String[]{"company", "org"});
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            String infoType = (String)this.getModel().getValue("infotype");
            String mulLine = (String)this.getModel().getValue("mulline");
            String ruleStr = this.tempMappingDomainService.generateRuleStr(infoType, mulLine);
            DynamicObject tempMapping = this.tempMappingDomainService.getTempMappingByRule(ruleStr);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            customParams.put("template", tempMapping.getLong("id"));
            customParams.put("mulline", mulLine);
            String personTypeNumber = PERSON_TYPE_MAP.get(infoType);
            Object[] logicEntity = this.logicEntityDomainService.getLogicEntityInfoByNumber(personTypeNumber);
            if (!HRArrayUtils.isEmpty((Object[])logicEntity)) {
                customParams.put("mainentity", logicEntity[0].getString("id"));
            }
            this.getView().returnDataToParent((Object)customParams);
            this.getView().close();
        }
    }
}

