/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.logicentity;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.isv.ISVService;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.ISceneCardConfigDomainService;
import kd.hdtc.hrbm.business.domain.extcase.bo.ExtCaseUniversalRangeBo;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;

public class SelectLogicEntityEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener {
    private static final String LOGIC_ENTITY = "logicentity";
    private final ISceneCardConfigDomainService sceneCardConfigDomainService = (ISceneCardConfigDomainService)ServiceFactory.getService(ISceneCardConfigDomainService.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit menuLocal = (BasedataEdit)this.getView().getControl(LOGIC_ENTITY);
        menuLocal.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Button buttonOk = (Button)this.getView().getControl("btnok");
        buttonOk.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String sceneCardConfigId = (String)formShowParameter.getCustomParam("sceneCardconfigid");
        this.getModel().getDataEntity().set("sceneCardconfigid", (Object)sceneCardConfigId);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        if (LOGIC_ENTITY.equals(fieldName)) {
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            String bizObjId = (String)this.getView().getFormShowParameter().getCustomParam("bizobj");
            String sceneCardConfigId = (String)this.getView().getFormShowParameter().getCustomParam("sceneCardconfigid");
            this.buildAndAddQFilter(listShowParameter.getListFilterParameter().getQFilters(), bizObjId, sceneCardConfigId);
        }
    }

    public void buildAndAddQFilter(List<QFilter> qFilters, String bizObjId, String sceneCardConfigId) {
        ExtCaseUniversalRangeBo extCaseUniversalRange;
        qFilters.add(new QFilter("bizobj", "=", (Object)Long.parseLong(bizObjId)));
        qFilters.add(new QFilter("cusstatus", "=", (Object)"1"));
        qFilters.add(new QFilter("isfieldext", "=", (Object)Boolean.TRUE));
        if ("1864744323254333445".equals(bizObjId)) {
            qFilters.add(new QFilter("number", "like", (Object)"%hrpi_%"));
        }
        if ((extCaseUniversalRange = this.sceneCardConfigDomainService.getExtCaseUniversalRange(Long.valueOf(Long.parseLong(sceneCardConfigId)))) == null) {
            return;
        }
        if (extCaseUniversalRange.getCurrentIsvFlag() == 0) {
            qFilters.add(new QFilter("isv", "=", (Object)"kingdee"));
        } else if (extCaseUniversalRange.getCurrentIsvFlag() == 1) {
            qFilters.add(new QFilter("isv", "=", (Object)ISVService.getISVInfo().getId()));
        }
        Set bizObjIdSet = extCaseUniversalRange.getBizObjIdSet();
        if (CollectionUtils.isNotEmpty((Collection)bizObjIdSet) && bizObjIdSet.contains(Long.parseLong(bizObjId))) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)extCaseUniversalRange.getLogicEntityIdSet())) {
            QFilter qFilter = new QFilter("pid", "in", (Object)extCaseUniversalRange.getLogicEntityIdSet());
            qFilter.or("id", "in", (Object)extCaseUniversalRange.getLogicEntityIdSet());
            qFilters.add(qFilter);
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.returnData();
        }
    }

    private void returnData() {
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        IDataModel model = this.getModel();
        DynamicObject logicEntity = model.getDataEntity().getDynamicObject(LOGIC_ENTITY);
        if (logicEntity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u903b\u8f91\u5b9e\u4f53\u3002", (String)"SelectLogicEntityEditPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            return;
        }
        result.put("logicntityid", logicEntity.getLong("id"));
        result.put("sceneCardconfigid", this.getModel().getDataEntity().getString("sceneCardconfigid"));
        this.getView().returnDataToParent((Object)result);
        this.getView().close();
    }
}

