/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.sharedtaskpool;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.hdtc.hrbm.business.domain.extcase.bo.QueryEntityBo;
import kd.hdtc.hrbm.common.msgEnum.SharedTaskPoolEnum;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hr.hbp.common.util.HRStringUtils;

public class QueryApiSelectFieldFormPlugin
extends HDTCDataBaseEdit
implements TreeNodeClickListener,
TreeNodeCheckListener {
    private static final String CACHE_KEY_SELECTED_NODE_IDS = "nodeids";
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_TREEVIEW = "treeview";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{KEY_BTN_OK});
        TreeView tv = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
        tv.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        if (!this.isMultiSelected()) {
            tv.setMulti(false);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        this.fillTreeNodes();
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        if (HRStringUtils.equals((String)ctlSource.getKey(), (String)KEY_BTN_OK)) {
            String currNodeId = this.getPageCache().get(CACHE_KEY_SELECTED_NODE_IDS);
            if (StringUtils.isNotBlank((CharSequence)currNodeId)) {
                this.getView().returnDataToParent((Object)currNodeId);
            } else {
                this.getView().returnDataToParent((Object)"");
            }
            this.getView().close();
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if (HRStringUtils.equals((String)((String)e.getNodeId()), (String)"0")) {
            currNodeId = "";
        }
        this.getPageCache().put(CACHE_KEY_SELECTED_NODE_IDS, currNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
        if (this.isMultiSelected()) {
            return;
        }
        String currNodeId = (String)e.getNodeId();
        if (HRStringUtils.equals((String)((String)e.getNodeId()), (String)"0")) {
            currNodeId = "";
        }
        if (StringUtils.isBlank((CharSequence)currNodeId)) {
            return;
        }
        this.getView().returnDataToParent((Object)currNodeId);
        this.getView().close();
    }

    public void treeNodeCheck(TreeNodeCheckEvent e) {
        String cacheNodeIds = "";
        TreeView treeView = (TreeView)e.getSource();
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        if (checkedNodeIds != null) {
            checkedNodeIds.remove("0");
            cacheNodeIds = StringUtils.join((Object[])checkedNodeIds.toArray(), (String)",");
        }
        this.getPageCache().put(CACHE_KEY_SELECTED_NODE_IDS, cacheNodeIds);
    }

    private TreeNode getRootTreeNode() {
        TreeNode treeNode = new TreeNode("", "0", SharedTaskPoolEnum.ENTITY_FIELD_LIST.get());
        treeNode.setIsOpened(true);
        treeNode.setChildren(new ArrayList());
        String entityNodeListStr = (String)this.getView().getFormShowParameter().getCustomParam("queryEntityList");
        String fieldNodeListStr = (String)this.getView().getFormShowParameter().getCustomParam("queryFieldList");
        if (StringUtils.isNotEmpty((CharSequence)entityNodeListStr)) {
            List queryEntityModelList = JSONObject.parseArray((String)entityNodeListStr, QueryEntityBo.class);
            Map entityNumberAndQueryFieldListMap = (Map)JSONObject.parseObject((String)fieldNodeListStr, Map.class);
            queryEntityModelList.forEach(queryEntityModel -> {
                TreeNode entryNode = new TreeNode(treeNode.getId(), queryEntityModel.getEntityNumber(), queryEntityModel.getEntityName());
                List fieldTreeNodes = (List)entityNumberAndQueryFieldListMap.get(queryEntityModel.getEntityNumber());
                entryNode.addChildren(JSONObject.parseArray((String)JSONObject.toJSONString((Object)fieldTreeNodes), TreeNode.class));
                treeNode.getChildren().add(entryNode);
            });
        }
        return treeNode;
    }

    private void fillTreeNodes() {
        TreeNode rootNode = this.getRootTreeNode();
        TreeView tree = (TreeView)this.getView().getControl(KEY_TREEVIEW);
        tree.addNode(rootNode);
        if (this.isMultiSelected()) {
            tree.setMulti(true);
            String cacheNodeIds = (String)this.getView().getFormShowParameter().getCustomParam(CACHE_KEY_SELECTED_NODE_IDS);
            if (StringUtils.isNotBlank((CharSequence)cacheNodeIds)) {
                this.getPageCache().put(CACHE_KEY_SELECTED_NODE_IDS, cacheNodeIds);
                String[] arr = StringUtils.split((String)cacheNodeIds, (String)",");
                ArrayList<TreeNode> selectedNodes = new ArrayList<TreeNode>();
                for (String nodeId : arr) {
                    TreeNode node = rootNode.getTreeNode(nodeId, 5);
                    if (node == null) continue;
                    selectedNodes.add(node);
                }
                if (selectedNodes.size() > 0) {
                    tree.checkNodes(selectedNodes);
                }
            }
        }
    }

    private boolean isMultiSelected() {
        String isMulti = (String)this.getView().getFormShowParameter().getCustomParam("ismulti");
        if (StringUtils.isBlank((CharSequence)isMulti)) {
            return false;
        }
        return isMulti.equalsIgnoreCase("true") || isMulti.equalsIgnoreCase("1");
    }
}

