/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.sharedtaskpool;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.filter.CommonFilterColumnAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.list.ListColumnAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.baseconfig.IBaseConfigDomainService;
import kd.hdtc.hrbm.business.domain.extcase.SharedTaskPoolDomainService;
import kd.hdtc.hrbm.business.domain.extcase.bo.QueryEntityBo;
import kd.hdtc.hrbm.business.domain.extcase.bo.QueryFieldBo;
import kd.hdtc.hrbm.business.domain.extcase.parser.QueryEntityParser;
import kd.hdtc.hrbm.common.constant.HRBMAppConstants;
import kd.hdtc.hrbm.common.constant.SharedTaskPoolConstants;
import kd.hdtc.hrbm.common.msgEnum.SharedTaskPoolEnum;
import kd.hdtc.hrdbs.business.application.external.IBizAppDomainService;
import kd.hdtc.hrdbs.business.entity.IBaseCommonDomainService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hr.hbp.common.util.HRStringUtils;

public class SharedTaskPoolEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log LOG = LogFactory.getLog(SharedTaskPoolEditPlugin.class);
    private static final String ADD_FIELD = "addfield";
    public static final String CACHE_QUERY_FIELD_MODEL_MAP = "queryFieldModelMap";
    private static final String TASK_POOL_PROCESS_SUPPORT_FULLFIELD = "TASK_POOL_PROCESS_SUPPORT_FULLFIELD";
    private static final String TASK_POOL_FINISH_SUPPORT_FULLFIELD = "TASK_POOL_FINISH_SUPPORT_FULLFIELD";
    private static final List<String> PARAM_FIELD_FULL_LIST = Lists.newArrayList((Object[])new String[]{"TASK_POOL_PROCESS_SUPPORT_FULLFIELD", "TASK_POOL_FINISH_SUPPORT_FULLFIELD"});
    private static final String SOURCE_BILL_OLD_VALUE = "sourceBillOldValue";
    private static final String IS_SKIP_CHECK = "isSkipCheck";
    private static final String MODELTYPE = "modeltype";
    private DynamicObject sourceBill;
    SharedTaskPoolDomainService sharedTaskPoolDomainService = (SharedTaskPoolDomainService)ServiceFactory.getService(SharedTaskPoolDomainService.class);
    IBaseConfigDomainService baseConfigDomainService = (IBaseConfigDomainService)ServiceFactory.getService(IBaseConfigDomainService.class);
    IBaseCommonDomainService iBaseCommonDomainService = (IBaseCommonDomainService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IBaseCommonDomainService.class);
    IBizAppDomainService bizAppDomainService = (IBizAppDomainService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IBizAppDomainService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit sourceBill = (BasedataEdit)this.getView().getControl("sourcebill");
        sourceBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        Object pkId;
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        if (formShowParameter.getStatus().getValue() != OperationStatus.ADDNEW.getValue()) {
            formShowParameter.setStatus(OperationStatus.VIEW);
        }
        if (!ObjectUtils.isEmpty((Object)(pkId = ((BillShowParameter)formShowParameter).getPkId()))) {
            DynamicObject sharedTask = this.sharedTaskPoolDomainService.queryTaskPoolById(pkId);
            String name = sharedTask.getLocaleString("name").getLocaleValue();
            e.getFormShowParameter().setCaption(SharedTaskPoolEnum.TITLE_PREFIX.get() + name);
        } else {
            e.getFormShowParameter().setCaption(SharedTaskPoolEnum.NEW_SHARED_TASK_POOL.get());
        }
    }

    public void afterBindData(EventObject e) {
        OperationStatus status;
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        boolean isSysPreset = dataEntity.getBoolean("issyspreset");
        if (isSysPreset) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        }
        if (HRStringUtils.equals((String)(status = this.getView().getFormShowParameter().getStatus()).name(), (String)OperationStatus.VIEW.name()) || HRStringUtils.equals((String)status.name(), (String)OperationStatus.EDIT.name())) {
            DynamicObject taskPool = this.getModel().getDataEntity();
            String processQueryListNumber = taskPool.getString("processquerylist");
            String finishQueryListNumber = taskPool.getString("finishquerylist");
            if (HRStringUtils.isEmpty((String)processQueryListNumber) || HRStringUtils.isEmpty((String)finishQueryListNumber)) {
                return;
            }
            this.modifyLoadEntryEntity(processQueryListNumber, "processentryentity", "process");
            this.modifyLoadEntryEntity(finishQueryListNumber, "finishentryentity", "finish");
        }
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("isv", (Object)ISVServiceHelper.getISVInfo().getId());
        Object sourceBillObj = this.getView().getFormShowParameter().getCustomParam("sourcebill");
        if (!ObjectUtils.isEmpty((Object)sourceBillObj)) {
            String sourceBillId = sourceBillObj.toString();
            DynamicObject sourceBill = this.iBaseCommonDomainService.queryOneById("bos_entityobject", "", (Object)sourceBillId);
            this.getModel().setValue("sourcebill", (Object)sourceBill);
        }
        this.initEntryEntity("process", "task_task", "processentryentity");
        this.initEntryEntity("finish", "task_taskhistory", "finishentryentity");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldName = evt.getProperty().getName();
        if (HRStringUtils.equals((String)fieldName, (String)"sourcebill")) {
            ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter(MODELTYPE, "in", (Object)HRBMAppConstants.BASEDATA_TYPE_LIST));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String changeFieldName = Optional.ofNullable(e).map(PropertyChangedArgs::getProperty).map(IMetadata::getName).orElse("");
        if (HRStringUtils.equals((String)changeFieldName, (String)"sourcebill")) {
            Object[] changeSet = e.getChangeSet();
            if (ObjectUtils.isEmpty((Object[])changeSet)) {
                return;
            }
            Object changeData = changeSet[0];
            Object oldValue = changeData.getOldValue();
            if (ObjectUtils.isEmpty((Object)oldValue)) {
                this.handleFieldDefaultValue();
            } else {
                this.getView().getPageCache().put(SOURCE_BILL_OLD_VALUE, ((DynamicObject)oldValue).getString("id"));
                this.getView().showConfirm(SharedTaskPoolEnum.SOURCE_BILL_PROPERTY_CHANGE_TIP.get(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deleteentry", (IFormPlugin)this));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (StringUtils.startsWith((CharSequence)operateKey, (CharSequence)ADD_FIELD)) {
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue("sourcebill"))) {
                this.getView().showErrorNotification(SharedTaskPoolEnum.PLEASE_INPUT_SOURCE_BILL.get());
                args.setCancel(true);
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save")) {
            String tip = "";
            IPageCache pageCache = this.getView().getPageCache();
            if (!HRStringUtils.equals((String)pageCache.get(IS_SKIP_CHECK), (String)"true")) {
                tip = this.checkAddSourceBillField();
            }
            pageCache.remove(IS_SKIP_CHECK);
            if (HRStringUtils.isNotEmpty((String)tip)) {
                this.getView().showConfirm(tip, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("hrbm_sharedtaskpool", (IFormPlugin)this));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"deleteentryprocess")) {
            this.deleteRow("processentryentity");
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"deleteentryfinish")) {
            this.deleteRow("finishentryentity");
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"modify")) {
            this.getView().setStatus(OperationStatus.VIEW);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"preview")) {
            this.openPreviewPage();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        if (HRStringUtils.equals((String)"hrbm_sharedtaskpool", (String)event.getCallBackId()) && MessageBoxResult.Yes.equals((Object)event.getResult())) {
            this.getView().getPageCache().put(IS_SKIP_CHECK, "true");
            this.getView().invokeOperation("save");
        }
        if (HRStringUtils.equals((String)"deleteentry", (String)event.getCallBackId())) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.handleFieldDefaultValue();
                this.emptyCustomEntryEntityRow("processentryentity");
                this.emptyCustomEntryEntityRow("finishentryentity");
            } else {
                String sourceBillOldId = this.getPageCache().get(SOURCE_BILL_OLD_VALUE);
                this.getModel().beginInit();
                this.getModel().setValue("sourcebill", (Object)sourceBillOldId);
                this.getModel().endInit();
                this.getView().updateView("sourcebill");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (StringUtils.startsWith((CharSequence)operateKey, (CharSequence)ADD_FIELD)) {
            String actionId = "";
            String mainEntityNumber = "";
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"addfieldprocess")) {
                actionId = "addfieldprocess";
                mainEntityNumber = "task_task";
            } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"addfieldfinish")) {
                actionId = "addfieldfinish";
                mainEntityNumber = "task_taskhistory";
            }
            Object sourceBillObj = this.getModel().getValue("sourcebill");
            if (!ObjectUtils.isEmpty((Object)sourceBillObj)) {
                DynamicObject sourceBill = (DynamicObject)sourceBillObj;
                QueryEntityParser queryEntityParser = new QueryEntityParser(mainEntityNumber, sourceBill.getString("id"));
                List queryFieldBoList = queryEntityParser.getQueryFieldBoList();
                Map<String, QueryFieldBo> queryFieldBoMap = queryFieldBoList.stream().collect(Collectors.toMap(QueryFieldBo::getFullFieldNumber, field -> field));
                queryFieldBoMap.remove(sourceBill.getString("id"));
                this.getView().getPageCache().put(CACHE_QUERY_FIELD_MODEL_MAP, JSONObject.toJSONString(queryFieldBoMap));
                this.showQuerySelectFieldForm(queryEntityParser.getQueryEntityBoList(), queryEntityParser.getEntityNumberAndFieldTreeNodeListMap(), actionId, new HashSet<String>());
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") && args.getOperationResult().isSuccess()) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (HRStringUtils.equals((String)evt.getActionId(), (String)"addfieldprocess") && evt.getReturnData() != null) {
            this.handleResult(evt.getReturnData().toString(), "addfieldprocess");
        } else if (HRStringUtils.equals((String)evt.getActionId(), (String)"addfieldfinish") && evt.getReturnData() != null) {
            this.handleResult(evt.getReturnData().toString(), "addfieldfinish");
        }
    }

    private String checkAddSourceBillField() {
        ArrayList tipPrefixList = Lists.newArrayListWithExpectedSize((int)2);
        if (this.getAddSourceBillFieldCount("processentryentity", "process", "task_task") <= 0L) {
            tipPrefixList.add(SharedTaskPoolEnum.PROCESS_TAG.get());
        }
        if (this.getAddSourceBillFieldCount("finishentryentity", "finish", "task_taskhistory") <= 0L) {
            tipPrefixList.add(SharedTaskPoolEnum.FINISH_TAG.get());
        }
        if (CollectionUtils.isEmpty((Collection)tipPrefixList)) {
            return "";
        }
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String sourceBillName = dataEntity.getDynamicObject("sourcebill").getLocaleString("name").getLocaleValue();
        return String.format(Locale.ROOT, SharedTaskPoolEnum.PROCESS_AND_FINISH_SAVE_TIP.get(), String.join((CharSequence)"\u3001", tipPrefixList), sourceBillName);
    }

    private long getAddSourceBillFieldCount(String entryEntityTag, String fullFieldStr, String entityNumber) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityTag);
        return entryEntity.stream().filter(row -> !HRStringUtils.equals((String)row.getString("entitynumber" + fullFieldStr), (String)entityNumber)).count();
    }

    private void initEntryEntity(String fiedlSuffix, String defEntityNumber, String entryEntityTag) {
        Map<String, QueryFieldBo> queryFieldMap = this.getQueryFieldMap(defEntityNumber, null);
        Map<String, String> supportFieldMap = this.getSupportField(entryEntityTag);
        TableValueSetter vs = this.getTableValueSetter(fiedlSuffix);
        MainEntityType mainType = MetadataUtils.getMainEntityType((String)defEntityNumber);
        String entityName = mainType.getDisplayName().getLocaleValue();
        String entityNumber = mainType.getName();
        supportFieldMap.keySet().forEach(key -> {
            QueryFieldBo queryFieldBo = (QueryFieldBo)queryFieldMap.get(key);
            if (queryFieldBo != null) {
                String fullFieldName = queryFieldBo.getFullFieldName();
                vs.addRow(new Object[]{entityName, entityNumber, queryFieldBo.getFullFieldNumber(), fullFieldName, fullFieldName.substring(fullFieldName.lastIndexOf(".") + 1)});
            }
        });
        this.batchCreateNewEntryRow(entryEntityTag, vs);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityTag);
        entryEntity.stream().forEach(row -> {
            int index = entryEntity.indexOf(row);
            String fieldNumber = row.getString("fieldnumber" + fiedlSuffix);
            String supportOp = (String)supportFieldMap.get(fieldNumber);
            this.getModel().setValue("filter" + fiedlSuffix, (Object)supportOp.contains("filter"), index);
            this.getModel().setValue("hide" + fiedlSuffix, (Object)supportOp.contains("hide"), index);
        });
        this.handleFilterLock(entryEntityTag, defEntityNumber, null);
        this.getView().updateView(entryEntityTag);
    }

    private void modifyLoadEntryEntity(String queryListNumber, String entryEntityTag, String fieldSuffix) {
        String id = MetadataDao.getIdByNumber((String)queryListNumber, (MetaCategory)MetaCategory.Form);
        if (HRStringUtils.isEmpty((String)id)) {
            LOG.info("Metadata:{} is not exist.", (Object)queryListNumber);
            return;
        }
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)id, (MetaCategory)MetaCategory.Form);
        String queryConfEntityNumber = MetadataDao.getNumberById((String)formMeta.getEntityId());
        QueryEntityType queryEntityType = (QueryEntityType)MetadataUtils.getMainEntityType((String)queryConfEntityNumber);
        String mainEntityNumber = queryEntityType.getEntityName();
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)mainEntityNumber);
        String mainEntityName = mainEntityType.getDisplayName().getLocaleValue();
        JoinEntity joinEntity = (JoinEntity)queryEntityType.getJoinEntitys().get(0);
        String sonEntityNumber = joinEntity.getEntityName();
        String sonEntityName = joinEntity.getDisplayName();
        ArrayList ListColumnApList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList commonFilterColumnApList = Lists.newArrayListWithExpectedSize((int)10);
        formMeta.getItems().forEach(item -> {
            if (item instanceof ListColumnAp) {
                ListColumnApList.add((ListColumnAp)item);
            } else if (item instanceof CommonFilterColumnAp) {
                CommonFilterColumnAp commonFilterColumnAp = (CommonFilterColumnAp)item;
                String fieldName = commonFilterColumnAp.getFieldName();
                if (fieldName.startsWith(sonEntityNumber)) {
                    commonFilterColumnApList.add(commonFilterColumnAp.getFieldName());
                } else {
                    commonFilterColumnApList.add(mainEntityNumber + "." + commonFilterColumnAp.getFieldName());
                }
            }
        });
        Map<String, QueryFieldBo> queryFieldBoMap = this.getQueryFieldMap(mainEntityNumber, sonEntityNumber);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityTag);
        ListColumnApList.forEach(col -> {
            String fieldNumber = col.getListFieldId();
            if (StringUtils.equals((CharSequence)fieldNumber, (CharSequence)"fseq")) {
                return;
            }
            DynamicObject newRow = entryEntity.addNew();
            if (!fieldNumber.startsWith(sonEntityNumber)) {
                fieldNumber = mainEntityNumber + "." + fieldNumber;
            }
            newRow.set("entity" + fieldSuffix, (Object)(fieldNumber.startsWith(mainEntityNumber) ? mainEntityName : sonEntityName));
            newRow.set("entitynumber" + fieldSuffix, (Object)(fieldNumber.startsWith(mainEntityNumber) ? mainEntityNumber : sonEntityNumber));
            newRow.set("fieldnumber" + fieldSuffix, (Object)fieldNumber);
            newRow.set("fieldname" + fieldSuffix, (Object)((QueryFieldBo)queryFieldBoMap.get(fieldNumber)).getFullFieldName());
            newRow.set("sharedtasklistname" + fieldSuffix, (Object)col.getName().getLocaleValue());
            newRow.set("filter" + fieldSuffix, (Object)commonFilterColumnApList.contains(fieldNumber));
            newRow.set("hide" + fieldSuffix, (Object)HRStringUtils.isEmpty((String)col.getVisible()));
        });
        this.handleFilterLock(entryEntityTag, mainEntityNumber, sonEntityNumber);
        this.getView().updateView(entryEntityTag);
    }

    private void showQuerySelectFieldForm(List<QueryEntityBo> queryEntityBoList, Map<String, List<TreeNode>> entityNumberAndQueryFieldListMap, String actionId, Set<String> selectFullFieldNumberSet) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrbm_queryfieldf7");
        showParameter.getCustomParams().put("queryFieldList", JSONObject.toJSONString(entityNumberAndQueryFieldListMap));
        showParameter.getCustomParams().put("queryEntityList", JSONObject.toJSONString(queryEntityBoList));
        showParameter.getCustomParams().put("ismulti", "true");
        showParameter.getCustomParams().put("nodeids", String.join((CharSequence)",", selectFullFieldNumberSet));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void handleResult(String selectNodeId, String type) {
        String queryFieldBoMapStr = this.getView().getPageCache().get(CACHE_QUERY_FIELD_MODEL_MAP);
        Map queryFieldBoMap = (Map)JSONObject.parseObject((String)queryFieldBoMapStr, Map.class);
        List selectNodeIdList = ConvertUtils.toList((Object[])selectNodeId.split(","));
        String entryEntityTag = "processentryentity";
        String fieldTag = "process";
        String mainEntityNumber = "task_task";
        if (HRStringUtils.equals((String)type, (String)"addfieldfinish")) {
            entryEntityTag = "finishentryentity";
            mainEntityNumber = "task_taskhistory";
            fieldTag = "finish";
        }
        String finalFieldTag = fieldTag;
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityTag);
        TableValueSetter vs = this.getTableValueSetter(finalFieldTag);
        Set existNumberSet = entryEntity.stream().map(row -> row.getString("fieldnumber" + finalFieldTag)).collect(Collectors.toSet());
        selectNodeIdList.forEach(id -> {
            if (existNumberSet.contains(id)) {
                return;
            }
            QueryFieldBo queryFieldBo = (QueryFieldBo)JSONObject.parseObject((String)JSONObject.toJSONString(queryFieldBoMap.get(id)), QueryFieldBo.class);
            if (ObjectUtils.isEmpty((Object)queryFieldBo)) {
                return;
            }
            if (queryFieldBo.isComplexType()) {
                return;
            }
            String fullFieldName = queryFieldBo.getFullFieldName();
            String fieldName = fullFieldName.substring(fullFieldName.lastIndexOf(".") + 1);
            vs.addRow(new Object[]{queryFieldBo.getEntityName(), queryFieldBo.getEntityNumber(), queryFieldBo.getFullFieldNumber(), fullFieldName, fieldName, false, false});
        });
        this.batchCreateNewEntryRow(entryEntityTag, vs);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObject sourceBill = dataEntity.getDynamicObject("sourcebill");
        this.handleFilterLock(entryEntityTag, mainEntityNumber, sourceBill.getString("id"));
        this.getView().updateView(entryEntityTag);
    }

    private TableValueSetter getTableValueSetter(String finalFieldTag) {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("entity" + finalFieldTag, new Object[0]);
        vs.addField("entitynumber" + finalFieldTag, new Object[0]);
        vs.addField("fieldnumber" + finalFieldTag, new Object[0]);
        vs.addField("fieldname" + finalFieldTag, new Object[0]);
        vs.addField("sharedtasklistname" + finalFieldTag, new Object[0]);
        vs.addField("filter" + finalFieldTag, new Object[0]);
        vs.addField("hide" + finalFieldTag, new Object[0]);
        return vs;
    }

    private void deleteRow(String entryEntityTag) {
        EntryGrid grid = (EntryGrid)this.getView().getControl(entryEntityTag);
        int[] selectRows = grid.getSelectRows();
        if (ObjectUtils.isEmpty((Object)selectRows)) {
            this.getView().showTipNotification(SharedTaskPoolEnum.PLEASE_SELECT_DELETE_DATA.get());
            return;
        }
        AtomicInteger count = new AtomicInteger();
        String fiedlSuffix = HRStringUtils.equals((String)entryEntityTag, (String)"processentryentity") ? "process" : "finish";
        Map<String, String> baseConfValueMap = this.getSupportField(entryEntityTag);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityTag);
        ArrayList delRowList = Lists.newArrayListWithExpectedSize((int)10);
        Arrays.stream(selectRows).forEach(index -> {
            DynamicObject curRow = (DynamicObject)entryEntity.get(index);
            String fieldNumber = curRow.getString("fieldnumber" + fiedlSuffix);
            if (baseConfValueMap.containsKey(fieldNumber) && !((String)baseConfValueMap.get(fieldNumber)).contains("delete")) {
                count.getAndIncrement();
            } else {
                delRowList.add(index);
            }
        });
        int[] delRows = new int[delRowList.size()];
        for (int i = 0; i < delRowList.size(); ++i) {
            delRows[i] = (Integer)delRowList.get(i);
        }
        this.getModel().deleteEntryRows(entryEntityTag, delRows);
        if (count.get() > 0) {
            this.getView().showConfirm(SharedTaskPoolEnum.DELETE_TIP.get(), SharedTaskPoolEnum.NOT_DELETE_TIP.get(), MessageBoxOptions.OK, ConfirmTypes.Delete, null);
        }
    }

    private void handleFieldDefaultValue() {
        Object sourceBillObj = this.getModel().getValue("sourcebill");
        if (ObjectUtils.isEmpty((Object)sourceBillObj)) {
            return;
        }
        this.sourceBill = (DynamicObject)sourceBillObj;
        String billName = this.sourceBill.getLocaleString("name").getLocaleValue();
        MainEntityType mainEntityType = null;
        try {
            mainEntityType = MetadataUtils.getMainEntityType((String)this.sourceBill.getString("id"));
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        if (mainEntityType == null) {
            return;
        }
        String appId = mainEntityType.getAppId();
        Map appInfoMap = this.bizAppDomainService.queryBizAppByBizAppNumberList((Collection)Lists.newArrayList((Object[])new String[]{appId}));
        DynamicObject appInfo = (DynamicObject)appInfoMap.get(appId);
        String appName = "";
        if (appInfo != null) {
            appName = appInfo.getLocaleString("name").getLocaleValue();
            this.getModel().setValue("name", (Object)String.format(Locale.ROOT, SharedTaskPoolEnum.TASK_POOL_NAME.get(), appName, billName));
        }
        this.getModel().setValue("processqueryconfname", (Object)String.format(Locale.ROOT, SharedTaskPoolEnum.PROCESS_QUERYCONF_NAME.get(), appName, billName));
        this.getModel().setValue("processquerylistname", (Object)String.format(Locale.ROOT, SharedTaskPoolEnum.PROCESS_QUERYLIST_NAME.get(), appName, billName));
        this.getModel().setValue("finishqueryconfname", (Object)String.format(Locale.ROOT, SharedTaskPoolEnum.FINISHT_QUERYCONF_NAME.get(), appName, billName));
        this.getModel().setValue("finishquerylistname", (Object)String.format(Locale.ROOT, SharedTaskPoolEnum.FINISH_QUERYLIST_NAME.get(), appName, billName));
    }

    private void emptyCustomEntryEntityRow(String entryEntityTag) {
        String fieldSuffix;
        DynamicObjectCollection entryEntity;
        if (HRStringUtils.equals((String)entryEntityTag, (String)"processentryentity")) {
            entryEntity = this.getModel().getEntryEntity("processentryentity");
            fieldSuffix = "process";
        } else {
            entryEntity = this.getModel().getEntryEntity("finishentryentity");
            fieldSuffix = "finish";
        }
        ArrayList delRowList = Lists.newArrayListWithExpectedSize((int)10);
        Map<String, String> fullFieldMap = this.getSupportField(entryEntityTag);
        entryEntity.forEach(row -> {
            String fieldNumber = row.getString("fieldnumber" + fieldSuffix);
            if (!fullFieldMap.containsKey(fieldNumber)) {
                delRowList.add(entryEntity.indexOf(row));
            }
        });
        if (CollectionUtils.isEmpty((Collection)delRowList)) {
            return;
        }
        int[] delRows = new int[delRowList.size()];
        for (int i = 0; i < delRowList.size(); ++i) {
            delRows[i] = (Integer)delRowList.get(i);
        }
        this.getModel().deleteEntryRows(entryEntityTag, delRows);
    }

    private Map<String, String> getSupportField(String entryEntityTag) {
        Map resultMap = this.baseConfigDomainService.getValueByKeyList(PARAM_FIELD_FULL_LIST);
        if (CollectionUtils.isEmpty((Map)resultMap)) {
            return new HashMap<String, String>();
        }
        Map tempMap = HRStringUtils.equals((String)entryEntityTag, (String)"processentryentity") ? this.sharedTaskPoolDomainService.jsonStr2Map((String)resultMap.get(TASK_POOL_PROCESS_SUPPORT_FULLFIELD)) : this.sharedTaskPoolDomainService.jsonStr2Map((String)resultMap.get(TASK_POOL_FINISH_SUPPORT_FULLFIELD));
        return tempMap;
    }

    private void openPreviewPage() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrbm_preview");
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setHasRight(false);
        Map customParams = showParameter.getCustomParams();
        customParams.put("processquerylist", dataEntity.getString("processquerylist"));
        customParams.put("finishquerylist", dataEntity.getString("finishquerylist"));
        this.getView().showForm(showParameter);
    }

    private void batchCreateNewEntryRow(String entryEntityTag, TableValueSetter vs) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.batchCreateNewEntryRow(entryEntityTag, vs);
        model.endInit();
    }

    private void handleFilterLock(String entryEntityTag, String mainEntityNumber, String sonEntityNumber) {
        String fiedlSuffix = "process";
        if (HRStringUtils.equals((String)entryEntityTag, (String)"finishentryentity")) {
            fiedlSuffix = "finish";
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryEntityTag);
        Map<String, QueryFieldBo> queryFieldMap = this.getQueryFieldMap(mainEntityNumber, sonEntityNumber);
        String finalFiedlSuffix = fiedlSuffix;
        entryEntity.stream().forEach(row -> {
            int index = entryEntity.indexOf(row);
            String fieldNumber = row.getString("fieldnumber" + finalFiedlSuffix);
            QueryFieldBo queryFieldBo = (QueryFieldBo)queryFieldMap.get(fieldNumber);
            String belongComplexFieldType = queryFieldBo.getBelongComplexFieldType();
            String fieldType = queryFieldBo.getFieldType();
            if (HRStringUtils.isEmpty((String)belongComplexFieldType) && !SharedTaskPoolConstants.FILTER_SUPPORT_PROP_LIST.contains(fieldType)) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"filter" + finalFiedlSuffix});
            }
        });
    }

    private Map<String, QueryFieldBo> getQueryFieldMap(String mainEntityNumber, String sonEntityNumber) {
        QueryEntityParser queryEntityParser = HRStringUtils.isEmpty((String)sonEntityNumber) ? new QueryEntityParser(mainEntityNumber) : new QueryEntityParser(mainEntityNumber, sonEntityNumber);
        List queryFieldBoList = queryEntityParser.getQueryFieldBoList();
        return queryFieldBoList.stream().collect(Collectors.toMap(QueryFieldBo::getFullFieldNumber, field -> field));
    }
}

