/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.sharedtaskpool;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.metadata.dao.MetadataDao;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.SharedTaskPoolDomainService;
import kd.hdtc.hrbm.common.msgEnum.SharedTaskPoolEnum;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;

public class SharedTaskPoolListPlugin
extends HRDataBaseList {
    private static final List<String> METADATA_TEMPLATE_LIST = ImmutableList.of((Object)"hstc_sscbasedataprocess", (Object)"hstc_sscbdprocess_ql", (Object)"hstc_sscbasedatafinish", (Object)"hstc_sscbdfinish_ql");
    SharedTaskPoolDomainService sharedTaskPoolDomainService = (SharedTaskPoolDomainService)ServiceFactory.getService(SharedTaskPoolDomainService.class);

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (HRStringUtils.equals((String)operateKey, (String)"new")) {
            ArrayList tipList = Lists.newArrayListWithCapacity((int)4);
            METADATA_TEMPLATE_LIST.forEach(metadataNumber -> {
                if (!MetadataDao.checkNumber((String)metadataNumber)) {
                    tipList.add(metadataNumber);
                }
            });
            if (CollectionUtils.isEmpty((Collection)tipList)) {
                return;
            }
            this.getView().showErrorNotification(String.format(Locale.ROOT, SharedTaskPoolEnum.METADATA_TEMPLATE_NOT_EXISTS.get(), String.join((CharSequence)"\u3001", tipList)));
            args.setCancel(true);
        } else if (HRStringUtils.equals((String)operateKey, (String)"preview")) {
            if (listSelectedData.size() > 1) {
                this.getView().showTipNotification(SharedTaskPoolEnum.SUPPORT_SINGLE_PREVIE_TIP.get());
                args.setCancel(true);
                return;
            }
            this.openPreviewPage(listSelectedData.get(0).getPrimaryKeyValue());
        } else if (HRStringUtils.equals((String)operateKey, (String)"delete") && listSelectedData.size() > 1) {
            this.getView().showTipNotification(SharedTaskPoolEnum.SUPPORT_SINGLE_DELTE_TIP.get());
            args.setCancel(true);
            return;
        }
    }

    private void openPreviewPage(Object id) {
        DynamicObject taskPool = this.sharedTaskPoolDomainService.queryTaskPoolById(id);
        if (taskPool == null) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrbm_preview");
        OpenStyle openStyle = showParameter.getOpenStyle();
        openStyle.setShowType(ShowType.Modal);
        showParameter.setHasRight(false);
        Map customParams = showParameter.getCustomParams();
        customParams.put("processquerylist", taskPool.getString("processquerylist"));
        customParams.put("finishquerylist", taskPool.getString("finishquerylist"));
        this.getView().showForm(showParameter);
    }
}

