/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.tree;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.IBizModelManageDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityEntityService;
import kd.hdtc.hrbm.business.domain.task.bo.BizModelOperateResultBo;
import kd.hdtc.hrbm.common.constant.BizModelManagementConstants;
import kd.hdtc.hrbm.common.constant.TempMappingConstants;
import kd.hdtc.hrbm.common.enums.ExtCaseEnum;
import kd.hdtc.hrbm.common.msgEnum.BizModelMsgEnum;
import kd.hdtc.hrbm.formplugin.web.common.util.CommonPageUtils;
import kd.hdtc.hrbm.formplugin.web.tree.BizModeTreeCommonPlugin;
import kd.hdtc.hrbm.formplugin.web.tree.CustomTreeEntryGrid;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.IsvUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BdModeTreePlugin
extends BizModeTreeCommonPlugin
implements HyperLinkClickListener {
    private final ILogicEntityEntityService logicEntityEntityService = (ILogicEntityEntityService)ServiceFactory.getService(ILogicEntityEntityService.class);
    private final IBizModelManageDomainService bizModelManageDomainService = (IBizModelManageDomainService)ServiceFactory.getService(IBizModelManageDomainService.class);
    private final ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        TreeNode rootNode = this.bizObjDomainService.getLeftTreeNode(false);
        treeView.addNode(rootNode);
        this.getView().getPageCache().put("rootnode", SerializationUtils.toJsonString((Object)rootNode));
        if (rootNode == null || CollectionUtils.isEmpty((Collection)rootNode.getChildren())) {
            return;
        }
        this.refresh(((TreeNode)rootNode.getChildren().get(0)).getId(), "-1");
    }

    public void onGetControl(OnGetControlArgs e) {
        if ("treeentryentity".equalsIgnoreCase(e.getKey())) {
            TreeEntryGrid treeEntryGrid = this.newTreeEntryGrid(null);
            treeEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
            e.setControl((Control)treeEntryGrid);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getTreeEntryGrid().getItems().set(0, this.newTreeEntryGrid(null));
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        List nodeIdList = Splitter.on((String)".").splitToList((CharSequence)nodeId);
        String curNodeId = (String)nodeIdList.get(nodeIdList.size() - 1);
        this.handleDescription(this.cloudDomainService.getCloudInfoById((Object)ConvertUtils.toLong((Object)curNodeId)));
        ((CustomTreeEntryGrid)this.newTreeEntryGrid(false)).treeEntryGridBindPageData();
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        if (HRStringUtils.equals((String)operateKey, (String)"effect")) {
            args.setCancel(true);
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showTipNotification(BizModelMsgEnum.DATA_EMPTY.get());
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u5c06\u751f\u6548\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizModelTreePlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("effect", (IFormPlugin)this));
        } else if (HRStringUtils.equals((String)operateKey, (String)"exportcodetable")) {
            if (ArrayUtils.isEmpty((int[])selectRows)) {
                args.setCancel(true);
                this.getView().showTipNotification(BizModelMsgEnum.SELECT_ROW_IS_EMPTY_TIP.get());
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"copy")) {
            if (ArrayUtils.isEmpty((int[])selectRows)) {
                this.getView().showTipNotification(BizModelMsgEnum.DATA_EMPTY.get());
                args.setCancel(true);
                return;
            }
            if (selectRows.length > 1) {
                this.getView().showTipNotification(BizModelMsgEnum.BD_MODEL_COPY.get());
                args.setCancel(true);
                return;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        TreeEntryGrid treeEntryGrid;
        int[] selectRows;
        List<Long> idList;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("effect".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && (idList = this.getSelectTreeId(selectRows = (treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity")).getSelectRows())) != null) {
            this.baseDataEffect(idList);
        }
    }

    private void baseDataEffect(List<Long> idList) {
        DynamicObject[] caseDatas;
        for (DynamicObject caseData : caseDatas = this.logicEntityEntityService.query("cusstatus,isv,bizobj", (Object[])idList.toArray(new Long[0]))) {
            if (!HRStringUtils.equals((String)caseData.getString("cusstatus"), (String)"1")) continue;
            this.getView().showTipNotification(BizModelMsgEnum.HAS_EFFECT.get());
            return;
        }
        BizModelOperateResultBo bizModelOperateResultBo = this.bizModelManageDomainService.batchEffect(caseDatas);
        if (bizModelOperateResultBo.isSuccess()) {
            this.getView().showSuccessNotification(BizModelMsgEnum.EFFECT_SUCCESS_TIP.get());
        } else {
            int sumSize = caseDatas.length;
            List errorIdList = bizModelOperateResultBo.getErrorIdList();
            int errorSize = errorIdList.size();
            if (sumSize == errorSize) {
                this.getView().showErrorNotification(BizModelMsgEnum.EFFECT_ERROR.get());
            } else {
                String errorMessage = this.getErrorMessage(caseDatas, errorIdList);
                String message = String.format(Locale.ROOT, BizModelMsgEnum.ERROR_DEP_ERROR.get(), sumSize, sumSize - errorSize, errorSize, errorMessage);
                this.getView().showTipNotification(message);
            }
        }
        this.getView().invokeOperation("refresh");
    }

    private String getErrorMessage(DynamicObject[] caseDatas, List<Long> errorIdList) {
        StringBuilder builder = new StringBuilder();
        for (DynamicObject caseData : caseDatas) {
            if (!errorIdList.contains(caseData.getLong("id"))) continue;
            builder.append(caseData.getString("number")).append("\u3001");
        }
        return builder.toString().substring(0, builder.length() - 1);
    }

    private List<Long> getSelectTreeId(int[] selectRows) {
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)selectRows.length);
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("treeentryentity", selectRow);
            idList.add(entryRowEntity.getLong("id"));
        }
        return idList;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        if (HRStringUtils.equals((String)operateKey, (String)"addsonlogicentity")) {
            Map<String, Object> paramMap = this.getCusMap();
            paramMap.put("template", ConvertUtils.toString((Object)TempMappingConstants.BASEDATA_TEMPLATE_ID));
            CommonPageUtils.showBillNewForm(this.getView(), "hrbm_logicentity_display", null, paramMap, OperationStatus.ADDNEW, ShowType.MainNewTabPage);
        } else if (HRStringUtils.equals((String)operateKey, (String)"exportcodetable")) {
            this.getLogicEntityView(this.getSelectTreeId(selectRows), "hrbm_basiclogicentity", false, BizModelManagementConstants.BASE_DATA_BIZ_OBJ_TYPE_SET);
        } else if (HRStringUtils.equals((String)operateKey, (String)"copy")) {
            List<Long> idList = this.getSelectTreeId(selectRows);
            Map<String, Object> paramMap = this.getCusMap();
            DynamicObject logicEntity = this.logicEntityDomainService.getLogicEntityInfoById((Object)idList.get(0));
            if (logicEntity != null) {
                if (logicEntity.getDynamicObject("template") != null) {
                    paramMap.put("template", logicEntity.getLong("template.id"));
                } else {
                    paramMap.put("template", ConvertUtils.toString((Object)TempMappingConstants.BASEDATA_TEMPLATE_ID));
                }
                paramMap.put("mainentity", logicEntity.getBoolean("mainentity"));
            }
            paramMap.put("iscopy", true);
            CommonPageUtils.showBillNewForm(this.getView(), "hrbm_logicentity_display", idList.get(0), paramMap, OperationStatus.ADDNEW, ShowType.MainNewTabPage);
        }
    }

    private Map<String, Object> getCusMap() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("curnodeid", this.getCurNodeId());
        paramMap.put("opentype", "bdmode");
        paramMap.put("fomtype", "bizList");
        paramMap.put("logicentity_extCaseKey", ExtCaseEnum.BASEDATA_EXT_ENTITY.getStrId());
        return paramMap;
    }

    private String getExtCaseId(String isv) {
        return IsvUtils.isNotCurrentIsv((String)isv) ? ExtCaseEnum.EXT_FIELD.getStrId() : ExtCaseEnum.BASEDATA_EXT_ENTITY.getStrId();
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Optional<DynamicObject> logicEntityDyOptional = Optional.ofNullable(this.getModel()).map(it -> it.getDataEntity(true)).map(it -> it.getDynamicObjectCollection("treeentryentity")).map(it -> (DynamicObject)it.get(evt.getRowIndex()));
        Optional<Long> pkId = logicEntityDyOptional.map(it -> it.getLong("id"));
        if (!pkId.isPresent()) {
            return;
        }
        String isv = logicEntityDyOptional.map(it -> it.getString("isv")).get();
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put("opentype", "bdmode");
        params.put("fomtype", "bizList");
        params.put("curnodeid", this.getCurNodeId());
        params.put("logicentity_extCaseKey", this.getExtCaseId(isv));
        CommonPageUtils.showBillForm(this.getView(), "hrbm_logicentity_display", pkId.get(), params, OperationStatus.VIEW, ShowType.MainNewTabPage);
    }
}

