/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.tree;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.IBizObjDomainService;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class BizModeF7TreePlugin
extends StandardTreeListPlugin {
    protected final IBizObjDomainService bizObjDomainService = (IBizObjDomainService)ServiceFactory.getService(IBizObjDomainService.class);
    protected static final String ROOT_NODE = "rootnode";
    protected static final String SELECT_NODE_ID_CACHE_KEY = "SELECT_NODE_ID_KEY";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void setFilter(SetFilterEvent event) {
        QFilter qFilter = this.buildCurrentFilter();
        if (qFilter != null) {
            event.addCustomQFilter(qFilter);
        }
        super.setFilter(event);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent evt) {
        QFilter qFilter = this.buildCurrentFilter();
        if (qFilter != null) {
            evt.addQFilter(qFilter);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        this.getView().getPageCache().put(SELECT_NODE_ID_CACHE_KEY, e.getNodeId().toString());
        super.treeNodeClick(e);
    }

    public void initializeTree(EventObject evt) {
        String selectNodeId;
        TreeNode rootNode = this.getRootNode();
        this.getView().getPageCache().put(ROOT_NODE, SerializationUtils.toJsonString((Object)rootNode));
        this.getTreeModel().setRoot(rootNode);
        Object isOpenAll = this.getView().getFormShowParameter().getCustomParams().get("isOpenAll");
        if (isOpenAll != null && ((Boolean)isOpenAll).booleanValue()) {
            this.setNodeOpened(rootNode);
        }
        if (StringUtils.isNotEmpty((String)(selectNodeId = (String)this.getView().getFormShowParameter().getCustomParam("selectedNodeId")))) {
            this.getView().getPageCache().put(SELECT_NODE_ID_CACHE_KEY, selectNodeId);
        } else {
            TreeNode defaultSelectNode = this.getDefaultSelectNode(rootNode);
            if (defaultSelectNode != null) {
                this.getView().getPageCache().put(SELECT_NODE_ID_CACHE_KEY, defaultSelectNode.getId());
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        QFilter qFilter = this.buildCurrentFilter();
        if (qFilter != null) {
            args.getFastQFilters().add(qFilter);
        }
        super.filterContainerSearchClick(args);
    }

    public void afterBindData(EventObject e) {
        TreeNode selectNode;
        String selectNodeId = this.getView().getPageCache().get(SELECT_NODE_ID_CACHE_KEY);
        TreeNode rootNode = this.getRootNode();
        if (StringUtils.isNotEmpty((String)selectNodeId) && rootNode != null && (selectNode = rootNode.getTreeNode(selectNodeId)) != null) {
            TreeView treeView = (TreeView)this.getControl("treeview");
            treeView.focusNode(selectNode);
            this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)selectNode.getParentid(), (Object)selectNode.getId()));
        }
        super.afterBindData(e);
    }

    protected QFilter buildCurrentFilter() {
        String bizModelTypeEnumValue = (String)this.getView().getFormShowParameter().getCustomParam("biz_model_render_level");
        if (StringUtils.isNotEmpty((String)bizModelTypeEnumValue)) {
            return null;
        }
        String nodeId = this.getView().getPageCache().get(SELECT_NODE_ID_CACHE_KEY);
        if (StringUtils.isEmpty((String)nodeId)) {
            return new QFilter("1", "!=", (Object)1);
        }
        BizModelTypeEnum bizModelTypeEnum = this.getNodeTypeById(nodeId);
        if (bizModelTypeEnum == BizModelTypeEnum.LOGIC_ENTITY) {
            List nodeIdList = Splitter.on((String)".").splitToList((CharSequence)nodeId);
            String logicEntityId = (String)nodeIdList.get(4);
            return new QFilter("logicentity.id", "=", (Object)Long.parseLong(logicEntityId));
        }
        return new QFilter("1", "!=", (Object)1);
    }

    private BizModelTypeEnum getNodeTypeById(String nodeId) {
        List nodeIdList = Splitter.on((String)".").splitToList((CharSequence)nodeId);
        return BizModelTypeEnum.getBizModelTypeByLevel((int)nodeIdList.size());
    }

    private void setNodeOpened(TreeNode rootNode) {
        List treeNodeList = rootNode.getChildren();
        if (CollectionUtils.isNotEmpty((Collection)treeNodeList)) {
            treeNodeList.stream().forEach(t -> {
                t.setIsOpened(true);
                this.setNodeOpened((TreeNode)t);
            });
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Object isCacheSelectNode = this.getView().getFormShowParameter().getCustomParams().get("is_cache_select_node");
        if (isCacheSelectNode != null && ((Boolean)isCacheSelectNode).booleanValue()) {
            String selectNodeId = this.getView().getPageCache().get(SELECT_NODE_ID_CACHE_KEY);
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.getPageCache().put("selectedNodeId", selectNodeId);
            }
        }
    }

    protected TreeNode getRootNode() {
        QFilter logicEntityFilter;
        String bizModelTypeEnumValue = (String)this.getView().getFormShowParameter().getCustomParam("biz_model_render_level");
        String cloudFilterStr = (String)this.getView().getFormShowParameter().getCustomParam("cloud_filter");
        String appFilterStr = (String)this.getView().getFormShowParameter().getCustomParam("app_filter");
        String bizObjFilterStr = (String)this.getView().getFormShowParameter().getCustomParam("biz_obj_filter");
        String logicEntityFilterStr = (String)this.getView().getFormShowParameter().getCustomParam("logic_entity_filter");
        QFilter cloudFilter = StringUtils.isEmpty((String)cloudFilterStr) ? null : QFilter.fromSerializedString((String)cloudFilterStr);
        QFilter appFilter = StringUtils.isEmpty((String)appFilterStr) ? null : QFilter.fromSerializedString((String)appFilterStr);
        QFilter bizObjFilter = StringUtils.isEmpty((String)bizObjFilterStr) ? null : QFilter.fromSerializedString((String)bizObjFilterStr);
        QFilter qFilter = logicEntityFilter = StringUtils.isEmpty((String)logicEntityFilterStr) ? null : QFilter.fromSerializedString((String)logicEntityFilterStr);
        if (StringUtils.isNotEmpty((String)bizModelTypeEnumValue)) {
            return this.bizObjDomainService.getLeftF7TreeNode(false, cloudFilter, appFilter, bizObjFilter, null);
        }
        return this.bizObjDomainService.getLeftF7TreeNode(true, cloudFilter, appFilter, bizObjFilter, logicEntityFilter);
    }

    private TreeNode getDefaultSelectNode(TreeNode parentNode) {
        if (parentNode == null) {
            return null;
        }
        List childrenNodeList = parentNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)childrenNodeList)) {
            return parentNode;
        }
        return this.getDefaultSelectNode((TreeNode)childrenNodeList.get(0));
    }
}

