/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.tree;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.Tips;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.IBizObjDomainService;
import kd.hdtc.hrbm.business.domain.model.ICloudDomainService;
import kd.hdtc.hrbm.common.constant.BizObjConstants;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;
import kd.hdtc.hrbm.common.msgEnum.BizModelMsgEnum;
import kd.hdtc.hrbm.formplugin.web.handler.BizModelJumpPageHandler;
import kd.hdtc.hrbm.formplugin.web.tree.CustomTreeEntryGrid;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;

public class BizModeTreeCommonPlugin
extends HRDataBaseEdit
implements TreeNodeClickListener,
SearchEnterListener {
    protected static final String SEARCHAP = "searchap";
    protected static final String SEARCE_TREE_RESULT = "searchtreeresult";
    protected static final String SEARCHTEXT = "searchtext";
    protected static final String ROOT_NODE = "rootnode";
    protected static final String BIZ_MODEL_TOOLBAR_AP = "bizmodeltoolbarap";
    protected static final String ADD_SON_LOGICENTITY = "addsonlogicentity";
    protected static final String ADD_ENTITY_METADATA = "addentitymetadata";
    protected static final String ADD_PERSON_INFO = "addpersoninfo";
    protected static final String REVOKE_PERSON_INFO = "revokepersoninfo";
    protected static final Set<String> ALL_BIZ_MODEL_BTN_SET = ImmutableSet.of((Object)"addsonlogicentity", (Object)"addentitymetadata", (Object)"addpersoninfo", (Object)"revokepersoninfo", (Object)"addmgfileviews", (Object)"addpsfileviews", (Object[])new String[]{"addisbatchmenu", "modifycadrereport", "addcadremgfileviews"});
    protected static final String EXPORT_CODE_TABLE = "exportcodetable";
    protected static final String EXPORT_ALL_CODE_TABLE = "exportallcodetable";
    protected static final String SHOW_NAME = "showname";
    protected static final String PAGE_CONTAINER = "pagecontainer";
    protected final IBizObjDomainService bizObjDomainService = (IBizObjDomainService)ServiceFactory.getService(IBizObjDomainService.class);
    protected final ICloudDomainService cloudDomainService = (ICloudDomainService)ServiceFactory.getService(ICloudDomainService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        ((Search)this.getControl(SEARCHAP)).addEnterListener((SearchEnterListener)this);
    }

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"treeentryentity"});
    }

    protected Container getTreeEntryGrid() {
        FormRoot formRoot = (FormRoot)this.getView().getRootControl();
        return this.findContainer((Container)formRoot, PAGE_CONTAINER);
    }

    private Container findContainer(Container container, String controlKey) {
        List items = container.getItems();
        Container targetContainer = null;
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            for (Control item : items) {
                if (!(item instanceof Container)) continue;
                if (controlKey.equals(item.getKey())) {
                    targetContainer = (Container)item;
                    break;
                }
                targetContainer = this.findContainer((Container)item, controlKey);
            }
        }
        return targetContainer;
    }

    protected TreeEntryGrid newTreeEntryGrid(Boolean isCollapse) {
        CustomTreeEntryGrid newTreeEntryGrid = new CustomTreeEntryGrid();
        TreeEntryGrid oldTreeEntryGrid = (TreeEntryGrid)this.getTreeEntryGrid().getItems().get(0);
        newTreeEntryGrid.getItems().addAll(oldTreeEntryGrid.getItems());
        newTreeEntryGrid.setKey(oldTreeEntryGrid.getKey());
        newTreeEntryGrid.setEntryKey(oldTreeEntryGrid.getEntryKey());
        newTreeEntryGrid.setModel(oldTreeEntryGrid.getModel());
        newTreeEntryGrid.setView(oldTreeEntryGrid.getView());
        newTreeEntryGrid.setSplitPage(true);
        newTreeEntryGrid.setPageRow(1000);
        if (isCollapse != null) {
            newTreeEntryGrid.setCollapse(isCollapse);
        }
        return newTreeEntryGrid;
    }

    public void search(SearchEnterEvent evt) {
        List searchTreeResult;
        String text = evt.getText();
        if (HRStringUtils.isEmpty((String)text)) {
            this.getView().showTipNotification(BizModelMsgEnum.PLEASE_ENTER_THE_SEARCH_CONTENT.get());
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        IPageCache pageCache = this.getView().getPageCache();
        TreeNode root = (TreeNode)SerializationUtils.fromJsonString((String)pageCache.get(ROOT_NODE), TreeNode.class);
        String searchText = pageCache.get(SEARCHTEXT);
        if (HRStringUtils.isEmpty((String)searchText) || !HRStringUtils.equals((String)text, (String)searchText)) {
            pageCache.put(SEARCHTEXT, text);
            searchTreeResult = this.bizObjDomainService.getSearchTreeResult(root, text);
            pageCache.put(SEARCE_TREE_RESULT, SerializationUtils.toJsonString((Object)searchTreeResult));
        } else {
            searchTreeResult = SerializationUtils.fromJsonStringToList((String)pageCache.get(SEARCE_TREE_RESULT), TreeNode.class);
        }
        if (CollectionUtils.isEmpty((Collection)searchTreeResult)) {
            this.getView().showSuccessNotification(BizModelMsgEnum.SEARCH_FINISH.get());
            return;
        }
        TreeNode currSeachNode = (TreeNode)searchTreeResult.remove(0);
        treeView.focusNode(currSeachNode);
        treeView.treeNodeClick(currSeachNode.getParentid(), currSeachNode.getId());
        pageCache.put(SEARCE_TREE_RESULT, SerializationUtils.toJsonString((Object)searchTreeResult));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"refresh")) {
            args.setCancel(true);
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            Map focusNodeMap = treeView.getTreeState().getFocusNode();
            this.refresh(focusNodeMap.get("id").toString(), focusNodeMap.get("parentid").toString());
        }
    }

    protected void refresh(String nodeId, String parentId) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        IPageCache pageCache = this.getView().getPageCache();
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)pageCache.get(ROOT_NODE), TreeNode.class);
        TreeNode focusNode = rootNode.getTreeNode(nodeId);
        treeView.focusNode(focusNode);
        this.treeNodeClick(new TreeNodeEvent((Object)this, (Object)parentId, (Object)nodeId));
    }

    protected void handleDescription(DynamicObject dyc) {
        Label nameLabel = (Label)this.getControl(SHOW_NAME);
        if (dyc == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SHOW_NAME});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{SHOW_NAME});
        ILocaleString localeStringName = dyc.getLocaleString("name");
        String name = "";
        if (localeStringName != null) {
            name = localeStringName.getLocaleValue();
        }
        ILocaleString localeStringDescrition = dyc.getLocaleString("description");
        String descrition = "";
        if (localeStringDescrition != null) {
            descrition = localeStringDescrition.getLocaleValue();
        }
        if (HRStringUtils.isEmpty((String)descrition)) {
            descrition = BizModelMsgEnum.NOT_DESCRIPTION.get();
        }
        Tips tips = new Tips("text", null, new LocaleString(descrition), false, null);
        nameLabel.addTips(tips);
        nameLabel.setText(name);
    }

    protected String getCurNodeId() {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String nodeId = treeView.getTreeState().getFocusNodeId();
        List nodeIdList = Splitter.on((String)".").splitToList((CharSequence)nodeId);
        String curNodeId = (String)nodeIdList.get(nodeIdList.size() - 1);
        return curNodeId;
    }

    protected BizModelTypeEnum getCurNodeType() {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String nodeId = treeView.getTreeState().getFocusNodeId();
        List nodeIdList = Splitter.on((String)".").splitToList((CharSequence)nodeId);
        return BizModelTypeEnum.getBizModelTypeByLevel((int)nodeIdList.size());
    }

    protected void getLogicEntityView(List<Long> selectTreeIdList, String entityNumber, boolean isExportAll, Set<String> bizObjTypeSet) {
        ListShowParameter parameter = BizModelJumpPageHandler.getHandler().getLogicEntityViewParam(entityNumber, new CloseCallBack((IFormPlugin)this, "fromotherentity"), listShowParameter -> {
            List qFilters = listShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(this.getQFilter(selectTreeIdList, isExportAll, bizObjTypeSet));
            return listShowParameter;
        });
        this.getView().showForm((FormShowParameter)parameter);
    }

    private QFilter getQFilter(List<Long> selectTreeIdList, boolean isExportAll, Set<String> bizObjTypeSet) {
        QFilter qFilter = new QFilter("bizobj.type", "in", bizObjTypeSet);
        qFilter.and(new QFilter("cusstatus", "=", (Object)"1"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        if (isExportAll) {
            return qFilter;
        }
        if (CollectionUtils.isNotEmpty(selectTreeIdList)) {
            return qFilter.and(new QFilter("id", "in", selectTreeIdList));
        }
        BizModelTypeEnum curNodeType = this.getCurNodeType();
        Set<Long> bizObjIdSet = new HashSet<Long>();
        String curNodeId = this.getCurNodeId();
        if (BizModelTypeEnum.CLOUD == curNodeType) {
            List bizObjList = this.bizObjDomainService.getBizObjInfoByCloudId(Long.valueOf(ConvertUtils.toLong((Object)curNodeId)));
            bizObjIdSet = bizObjList.stream().filter(biz -> BizObjConstants.BIZ_MODEL_TYPE_SET.contains((Object)biz.getString("type"))).map(biz -> biz.getLong("id")).collect(Collectors.toSet());
        } else if (BizModelTypeEnum.APP == curNodeType) {
            List bizObjList = this.bizObjDomainService.getBizObjInfoByAppId(Long.valueOf(ConvertUtils.toLong((Object)curNodeId)));
            bizObjIdSet = bizObjList.stream().filter(biz -> BizObjConstants.BIZ_MODEL_TYPE_SET.contains((Object)biz.getString("type"))).map(biz -> biz.getLong("id")).collect(Collectors.toSet());
        } else {
            bizObjIdSet.add(ConvertUtils.toLong((Object)curNodeId));
        }
        return qFilter.and(new QFilter("bizobj", "in", bizObjIdSet));
    }
}

