/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.tree;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.baseconfig.IBaseConfigDomainService;
import kd.hdtc.hrbm.business.domain.extcase.IExtCaseDomainService;
import kd.hdtc.hrbm.business.domain.extcase.IExtCaseManageDomainService;
import kd.hdtc.hrbm.business.domain.model.IAppDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizModelManageDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrbm.business.domain.model.bean.BizModelDataBean;
import kd.hdtc.hrbm.business.domain.model.entity.IBizObjEntityService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityEntityService;
import kd.hdtc.hrbm.business.domain.task.bo.BizModelOperateResultBo;
import kd.hdtc.hrbm.common.constant.BizModelManagementConstants;
import kd.hdtc.hrbm.common.constant.ExtCaseConstants;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;
import kd.hdtc.hrbm.common.msgEnum.BizModelMsgEnum;
import kd.hdtc.hrbm.formplugin.web.common.util.CommonPageUtils;
import kd.hdtc.hrbm.formplugin.web.handler.BizModelJumpPageHandler;
import kd.hdtc.hrbm.formplugin.web.handler.BizModelValidatorHandler;
import kd.hdtc.hrbm.formplugin.web.tree.BizModeTreeCommonPlugin;
import kd.hdtc.hrbm.formplugin.web.tree.CustomTreeEntryGrid;
import kd.hdtc.hrbm.formplugin.web.tree.strategy.ButtonStrategyContext;
import kd.hdtc.hrbm.formplugin.web.tree.strategy.IButtonStrategy;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.IsvUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BizModelTreePlugin
extends BizModeTreeCommonPlugin
implements HyperLinkClickListener {
    private static final Log LOG = LogFactory.getLog(BizModelTreePlugin.class);
    private static final List<String> ADD_ENTITY_METADATA_LOGIC_ENTITY_LIST = ImmutableList.of((Object)"hrpi_person", (Object)"hrpi_employee", (Object)"hrpi_depemp", (Object)"hcf_candidate");
    private static final String ROOT_NODE = "rootnode";
    private static final String CUR_MAIN_ENTITY = "curMainEntity";
    private final IAppDomainService appDomainService = (IAppDomainService)ServiceFactory.getService(IAppDomainService.class);
    private final ILogicEntityEntityService logicEntityEntityService = (ILogicEntityEntityService)ServiceFactory.getService(ILogicEntityEntityService.class);
    private final IPropDomainService propDomainService = (IPropDomainService)ServiceFactory.getService(IPropDomainService.class);
    private final IBizModelManageDomainService bizModelManageDomainService = (IBizModelManageDomainService)ServiceFactory.getService(IBizModelManageDomainService.class);
    private final ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);
    private final IBizObjEntityService bizObjEntityService = (IBizObjEntityService)ServiceFactory.getService(IBizObjEntityService.class);
    private final IExtCaseDomainService extCaseDomainService = (IExtCaseDomainService)ServiceFactory.getService(IExtCaseDomainService.class);
    private final IBaseConfigDomainService baseConfigDomainService = (IBaseConfigDomainService)ServiceFactory.getService(IBaseConfigDomainService.class);
    private final IExtCaseManageDomainService extCaseManageDomainService = (IExtCaseManageDomainService)ServiceFactory.getService(IExtCaseManageDomainService.class);

    public void onGetControl(OnGetControlArgs e) {
        if ("treeentryentity".equalsIgnoreCase(e.getKey())) {
            TreeEntryGrid treeEntryGrid = this.newTreeEntryGrid(null);
            treeEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
            e.setControl((Control)treeEntryGrid);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getTreeEntryGrid().getItems().set(0, this.newTreeEntryGrid(null));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"addmgfileviews", "addpsfileviews", "addisbatchmenu", "addsonlogicentity", "addentitymetadata", "addpersoninfo", "revokepersoninfo", "modifycadrereport", "addcadremgfileviews"});
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        TreeNode rootNode = this.bizObjDomainService.getLeftTreeNode(true);
        treeView.addNode(rootNode);
        this.getView().getPageCache().put(ROOT_NODE, SerializationUtils.toJsonString((Object)rootNode));
        if (rootNode == null || CollectionUtils.isEmpty((Collection)rootNode.getChildren())) {
            return;
        }
        List cloudNodeList = rootNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)cloudNodeList)) {
            return;
        }
        TreeNode cloudNode = (TreeNode)cloudNodeList.get(0);
        List appNodeList = cloudNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)appNodeList)) {
            this.refresh(cloudNode.getId(), "-1");
            return;
        }
        TreeNode appNode = (TreeNode)appNodeList.get(0);
        List bizObjList = appNode.getChildren();
        if (CollectionUtils.isEmpty((Collection)bizObjList)) {
            this.refresh(appNode.getId(), "-1");
            return;
        }
        TreeNode treeNode = (TreeNode)bizObjList.get(0);
        this.refresh(treeNode.getId(), "-1");
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        if (HRStringUtils.equals((String)operateKey, (String)"effect")) {
            args.setCancel(true);
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showTipNotification(BizModelMsgEnum.DATA_EMPTY.get());
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4e1a\u52a1\u6a21\u578b\u5c06\u751f\u6548\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"BizModelTreePlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("effect", (IFormPlugin)this));
        } else if (HRStringUtils.equals((String)operateKey, (String)"addsonlogicentity")) {
            TreeView treeView = (TreeView)this.getView().getControl("treeview");
            String nodeId = treeView.getTreeState().getFocusNodeId();
            List nodeIdList = Splitter.on((String)".").splitToList((CharSequence)nodeId);
            if (nodeIdList.size() != 4) {
                this.getView().showTipNotification(BizModelMsgEnum.NEWE_SON_BASEDATA_NOT_SUPPORT_TIP.get());
                args.setCancel(true);
                return;
            }
            TreeEntryGrid grid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
            int[] selectedRows = grid.getEntryState().getSelectedRows();
            if (selectedRows.length > 1) {
                args.setCancel(true);
                this.getView().showTipNotification(BizModelMsgEnum.NEWE_SON_BASEDATA_MUL_SELECT_TIP.get());
                return;
            }
            if (CollectionUtils.isEmpty((Collection)this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity"))) {
                this.getView().showTipNotification(BizModelMsgEnum.NEWE_SON_BASEDATA_EMPTY_NOT_SUPPORT_TIP.get());
                args.setCancel(true);
                return;
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"addentitymetadata")) {
            String logicNumber;
            if (selectRows == null || selectRows.length == 0) {
                this.getView().showTipNotification(BizModelMsgEnum.ADD_ENTITY_METADATA_TIP.get());
                args.setCancel(true);
                return;
            }
            if (this.getSelectTreeId(selectRows).size() > 1) {
                this.getView().showTipNotification(BizModelMsgEnum.ADD_ENTITY_METADATA_SELECT_TIP.get());
                args.setCancel(true);
                return;
            }
            List<Long> selectLogicEntityIds = this.getSelectTreeId(selectRows);
            DynamicObject logicEntityInfo = this.logicEntityDomainService.getLogicEntityInfoById((Object)selectLogicEntityIds.get(0));
            String string = logicEntityInfo == null ? "" : (logicNumber = logicEntityInfo.getBoolean("mainentity") ? logicEntityInfo.getString("number") : logicEntityInfo.getString("pid.number"));
            if (!ADD_ENTITY_METADATA_LOGIC_ENTITY_LIST.contains(logicNumber)) {
                this.getView().showTipNotification(BizModelMsgEnum.ADD_ENTITY_METADATA_VALIDATE_TIP.get());
                args.setCancel(true);
                return;
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"addpersoninfo")) {
            if (!this.checkAddPersonInfo()) {
                args.setCancel(true);
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"revokepersoninfo") && !this.checkRevokePersonInfo()) {
            args.setCancel(true);
        }
        IButtonStrategy buttonStrategy = ButtonStrategyContext.getButtonStrategy(operateKey);
        if (buttonStrategy != null && !buttonStrategy.check(this.getView())) {
            args.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("effect".equals(callBackId)) {
            TreeEntryGrid treeEntryGrid;
            int[] selectRows;
            List<Long> idList;
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && (idList = this.getSelectTreeId(selectRows = (treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity")).getSelectRows())) != null) {
                this.logicEntityEffect(idList);
            }
        } else if ("revokepersoninfo".equals(callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes && this.isExistsPersonInfo((EntryGrid)this.getControl("treeentryentity"))) {
            if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"hrbm", (String)"hrbm_bmmanagement", (String)"41QGLJ/YI27I")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u64a4\u9500\u5165\u804c\u4eba\u5458\u4fe1\u606f\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"BizModelTreePlugin_15", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.cancelPersonInfo();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u6210\u529f", (String)"BizModelTreePlugin_16", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
        }
    }

    private void cancelPersonInfo() {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        List<Long> selectTreeIdList = this.getSelectTreeId(selectRows);
        DynamicObject curLogicEntity = this.logicEntityDomainService.getLogicEntityInfoById((Object)selectTreeIdList.get(0));
        Long extCaseManageId = this.extCaseManageDomainService.saveExtCaseManage(curLogicEntity, ExtCaseConstants.ExtCasePreData.NINTH.longValue(), 0L, null);
        this.extCaseManageDomainService.effect(extCaseManageId.longValue());
    }

    private List<Long> getSelectTreeId(int[] selectRows) {
        ArrayList idList = Lists.newArrayListWithExpectedSize((int)selectRows.length);
        for (int selectRow : selectRows) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("treeentryentity", selectRow);
            idList.add(entryRowEntity.getLong("id"));
        }
        return idList;
    }

    private void logicEntityEffect(List<Long> idList) {
        DynamicObject[] caseArr;
        for (DynamicObject caseData : caseArr = this.logicEntityEntityService.query("cusstatus,isv,bizobj", (Object[])idList.toArray(new Long[0]))) {
            if (!HRStringUtils.equals((String)caseData.getString("cusstatus"), (String)"1")) continue;
            this.getView().showTipNotification(BizModelMsgEnum.HAS_EFFECT.get());
            return;
        }
        BizModelOperateResultBo bizModelOperateResultBo = this.bizModelManageDomainService.batchEffect(caseArr);
        if (bizModelOperateResultBo.isSuccess()) {
            this.getView().showSuccessNotification(BizModelMsgEnum.EFFECT_SUCCESS_TIP.get());
        } else {
            int sumSize = caseArr.length;
            List errorIdList = bizModelOperateResultBo.getErrorIdList();
            int errorSize = errorIdList.size();
            if (sumSize == errorSize) {
                this.getView().showErrorNotification(BizModelMsgEnum.EFFECT_ERROR.get());
            } else {
                String errorMessage = this.getErrorMessage(caseArr, errorIdList);
                String message = String.format(Locale.ROOT, BizModelMsgEnum.ERROR_DEP_ERROR.get(), sumSize, sumSize - errorSize, errorSize, errorMessage);
                this.getView().showTipNotification(message);
            }
        }
        this.getView().invokeOperation("refresh");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        List<Long> selectTreeIdList;
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        if (HRStringUtils.equals((String)operateKey, (String)"addsonlogicentity")) {
            HashMap<String, String> params = new HashMap<String, String>();
            String curNodeId = this.getCurNodeId();
            String mainEntityId = this.getMainEntityId(curNodeId);
            params.put("opentype", "bizmode");
            params.put("curnodeid", curNodeId);
            params.put("mainentity", mainEntityId);
            this.openQuestPage(this.getView(), params, new CloseCallBack((IFormPlugin)this, "addsonlogicentity"), null);
        } else if (HRStringUtils.equals((String)operateKey, (String)"addentitymetadata")) {
            selectTreeIdList = this.getSelectTreeId(selectRows);
            DynamicObject curLogicEntity = this.logicEntityDomainService.getLogicEntityInfoById((Object)selectTreeIdList.get(0));
            if (curLogicEntity == null) {
                return;
            }
            long id = curLogicEntity.getLong("id");
            boolean isMainEntity = curLogicEntity.getBoolean("mainentity");
            this.getView().getPageCache().put(CUR_MAIN_ENTITY, isMainEntity ? ConvertUtils.toString((Object)id) : ConvertUtils.toString((Object)curLogicEntity.getDynamicObject("pid").getLong("id")));
            BizModelJumpPageHandler.getHandler().showAddEntityMetadataF7(this.getView(), selectTreeIdList.get(0), new CloseCallBack((IFormPlugin)this, "addentitymetadata"));
        } else if (HRStringUtils.equals((String)operateKey, (String)"exportcodetable")) {
            this.getLogicEntityView(this.getSelectTreeId(selectRows), "hrbm_logicentity", false, BizModelManagementConstants.BIZ_MODEL_BIZ_OBJ_TYPE_SET);
        } else if (HRStringUtils.equals((String)operateKey, (String)"exportallcodetable")) {
            this.getLogicEntityView(this.getSelectTreeId(selectRows), "hrbm_logicentity", true, BizModelManagementConstants.BIZ_MODEL_BIZ_OBJ_TYPE_SET);
        } else if (HRStringUtils.equals((String)operateKey, (String)"addpersoninfo")) {
            selectTreeIdList = this.getSelectTreeId(selectRows);
            DynamicObject curLogicEntity = this.logicEntityDomainService.getLogicEntityInfoById((Object)selectTreeIdList.get(0));
            this.getView().showForm(BizModelJumpPageHandler.getHandler().getAddPersonInfoPageParam(curLogicEntity));
        } else if (HRStringUtils.equals((String)operateKey, (String)"revokepersoninfo")) {
            ConfirmCallBackListener confirm = new ConfirmCallBackListener("revokepersoninfo", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5165\u804c\u4eba\u5458\u4fe1\u606f\u5c06\u88ab\u64a4\u9500\uff0c\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f", (String)"BizModelTreePlugin_7", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirm);
        }
        IButtonStrategy buttonStrategy = ButtonStrategyContext.getButtonStrategy(operateKey);
        if (buttonStrategy != null) {
            this.getView().showForm(buttonStrategy.getFormShowParameter(this.getView()));
        }
    }

    private String getErrorMessage(DynamicObject[] caseDataArr, List<Long> errorIdList) {
        StringBuilder builder = new StringBuilder();
        for (DynamicObject caseData : caseDataArr) {
            if (!errorIdList.contains(caseData.getLong("id"))) continue;
            builder.append(caseData.getString("number")).append("\u3001");
        }
        return builder.substring(0, builder.length() - 1);
    }

    protected String getMainEntityId(String curNodeId) {
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl("treeentryentity");
        int[] selectRows = treeEntryGrid.getSelectRows();
        if (selectRows == null || selectRows.length == 0) {
            Object[] rootLogicEntity = this.logicEntityDomainService.getRootLogicEntityByBizObjId(Long.parseLong(curNodeId));
            if (!HRArrayUtils.isEmpty((Object[])rootLogicEntity)) {
                return rootLogicEntity[0].getString("id");
            }
            return null;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        DynamicObject loginEntity = (DynamicObject)this.getModel().getEntryEntity("treeentryentity").get(entryCurrentRowIndex);
        DynamicObject query = this.logicEntityEntityService.query("fid,pid,mainentity", (Object)loginEntity.getLong("id"));
        if (query.getBoolean("mainentity")) {
            return query.getString("id");
        }
        return query.getDynamicObject("pid").getString("id");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Map returnData;
        if (HRStringUtils.equals((String)evt.getActionId(), (String)"addentitymetadata")) {
            ListSelectedRowCollection selectRowColl = (ListSelectedRowCollection)evt.getReturnData();
            if (CollectionUtils.isEmpty((Collection)selectRowColl)) {
                return;
            }
            String id = selectRowColl.get(0).getPrimaryKeyValue().toString();
            String curMainEntity = this.getView().getPageCache().get(CUR_MAIN_ENTITY);
            MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)id);
            try (TXHandle txHandle = TX.requiresNew();){
                DynamicObject logicEntity = this.logicEntityDomainService.structLogicEntityAndRel(id, curMainEntity, mainEntityType, this.getCurNodeId());
                this.propDomainService.structPropAndRel(mainEntityType, logicEntity);
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(BizModelMsgEnum.ADD_ENTITY_METADATA_SUCCESS_TIP.get());
            }
        } else if (HRStringUtils.equals((String)evt.getActionId(), (String)"addsonlogicentity") && (returnData = (Map)evt.getReturnData()) != null) {
            String bizObjId = (String)returnData.get("curnodeid");
            FormShowParameter billShowParameter = BizModelJumpPageHandler.getHandler().getMatchPageParamByType(Long.parseLong(bizObjId), BizModelTypeEnum.BIZ_OBJ, parameter -> {
                parameter.getCustomParams().putAll(returnData);
                return parameter;
            });
            billShowParameter.setCustomParam("fomtype", (Object)"bizList");
            this.getView().getPageCache().put("logicentitypageid", billShowParameter.getPageId());
            this.getView().showForm(billShowParameter);
        }
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = (String)evt.getNodeId();
        List nodeIdList = Splitter.on((String)".").splitToList((CharSequence)nodeId);
        int size = nodeIdList.size();
        Long curNodeId = Long.parseLong((String)nodeIdList.get(size - 1));
        if (size == 2) {
            this.handleDescription(this.cloudDomainService.getCloudInfoById((Object)curNodeId));
            this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity").clear();
            this.getView().updateView("treeentryentity");
        } else if (size == 3) {
            this.handleDescription(this.appDomainService.getAppInfoById((Object)curNodeId));
            this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity").clear();
            this.getView().updateView("treeentryentity");
        } else if (size == 4) {
            this.handleDescription(this.bizObjDomainService.getBizObjInfoById((Object)curNodeId));
            ((CustomTreeEntryGrid)this.newTreeEntryGrid(false)).treeEntryGridBindPageData();
        }
        this.showBizModelOperateBtn();
    }

    private void showBizModelOperateBtn() {
        this.getView().setVisible(Boolean.FALSE, ALL_BIZ_MODEL_BTN_SET.toArray(new String[0]));
        BizModelTypeEnum curNodeType = this.getCurNodeType();
        if (curNodeType == BizModelTypeEnum.BIZ_OBJ) {
            DynamicObject bizObj = this.bizObjEntityService.queryOne("number", (Object)Long.parseLong(this.getCurNodeId()));
            Set bizModelManageShowBtnList = this.baseConfigDomainService.getBizModelManageShowBtnList(bizObj != null ? bizObj.getString("number") : "");
            this.getView().setVisible(Boolean.TRUE, bizModelManageShowBtnList.toArray(new String[0]));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        Optional<Long> pkId = Optional.ofNullable(this.getModel()).map(it -> it.getDataEntity(true)).map(it -> it.getDynamicObjectCollection("treeentryentity")).map(it -> (DynamicObject)it.get(evt.getRowIndex())).map(it -> it.getLong("id"));
        if (!pkId.isPresent()) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("opentype", "bizmode");
        params.put("fomtype", "bizList");
        params.put("curnodeid", this.getCurNodeId());
        params.put("mainentity", this.getMainEntityId(this.getCurNodeId()));
        DynamicObject extCaseDy = this.getExtCaseDy(pkId.get());
        params.put("logicentity_extCaseKey", extCaseDy.getString("id"));
        CommonPageUtils.showBillForm(this.getView(), "hrbm_logicentity_display", pkId.get(), params, OperationStatus.VIEW, ShowType.MainNewTabPage);
    }

    private DynamicObject getExtCaseDy(Long id) {
        DynamicObject logicEntityDy = this.logicEntityDomainService.getLogicEntityInfoById((Object)id);
        BizModelDataBean bizModelDataBean = new BizModelDataBean(BizModelTypeEnum.LOGIC_ENTITY, logicEntityDy);
        String isv = Optional.ofNullable(logicEntityDy.getString("isv")).orElse("");
        return this.extCaseDomainService.getMatchedExtCase(bizModelDataBean, IsvUtils.isCurrentIsv((String)isv));
    }

    private boolean checkAddPersonInfo() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        int length = entryGrid.getSelectRows().length;
        if (length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6dfb\u52a0\u81f3\u5165\u804c\u4eba\u5458\u4fe1\u606f\u7684\u5b50\u903b\u8f91\u5b9e\u4f53\u3002", (String)"BizModelTreePlugin_8", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6279\u91cf\u65b0\u589e\u5165\u804c\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BizModelTreePlugin_9", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject curLogicEntity = this.getCurLogicEntity(entryGrid);
        return BizModelValidatorHandler.getHandler().validateAddPersonInfo(this.getView(), curLogicEntity);
    }

    private boolean checkRevokePersonInfo() {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        int length = entryGrid.getSelectRows().length;
        if (length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u4ece\u201c\u5165\u804c\u4eba\u5458\u4fe1\u606f\u201d\u4e2d\u64a4\u9500\u7684\u5b50\u903b\u8f91\u5b9e\u4f53\u3002", (String)"BizModelTreePlugin_10", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (length > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6279\u91cf\u64a4\u9500\u5165\u804c\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BizModelTreePlugin_11", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject curLogicEntity = this.getCurLogicEntity(entryGrid);
        return BizModelValidatorHandler.getHandler().validateRevokePersonInfo(this.getView(), curLogicEntity);
    }

    private DynamicObject getCurLogicEntity(EntryGrid entryGrid) {
        List<Long> selectTreeIdList = this.getSelectTreeId(entryGrid.getSelectRows());
        return this.logicEntityDomainService.getLogicEntityInfoById((Object)selectTreeIdList.get(0));
    }

    private boolean isExistsPersonInfo(EntryGrid entryGrid) {
        DynamicObject curLogicEntity = this.getCurLogicEntity(entryGrid);
        return BizModelValidatorHandler.getHandler().validateRevokePersonInfo(this.getView(), curLogicEntity);
    }

    protected void openQuestPage(IFormView view, Map<String, String> params, CloseCallBack callBack, Function<? super FormShowParameter, ? super FormShowParameter> func) {
        String bizObjId = params.get("curnodeid");
        if (HRStringUtils.isEmpty((String)bizObjId)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u6240\u9009\u7684\u4e1a\u52a1\u5bf9\u8c61\uff0c\u8bf7\u68c0\u67e5\u5de6\u6811\u662f\u5426\u9009\u4e2d\u4e86\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"BizModelTreePlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject bizObjDy = this.bizObjEntityService.query("classify,tempmapple,questionnaire,type", (Object)Long.parseLong(bizObjId));
        String classify = bizObjDy.getString("classify");
        String questionnaire = bizObjDy.getString("questionnaire");
        DynamicObject tempMapping = bizObjDy.getDynamicObject("tempmapple");
        if ("10".equals(classify) && !HRObjectUtils.isEmpty((Object)tempMapping)) {
            params.put("template", tempMapping.getString("id"));
            FormShowParameter billShowParameter = BizModelJumpPageHandler.getHandler().getMatchPageParamByType(bizObjDy.getLong("id"), BizModelTypeEnum.BIZ_OBJ, parameter -> {
                parameter.getCustomParams().putAll(params);
                return parameter;
            });
            billShowParameter.setCloseCallBack(callBack);
            if (func != null) {
                func.apply((FormShowParameter)billShowParameter);
            }
            billShowParameter.setCustomParam("fomtype", (Object)"bizList");
            this.getView().showForm(billShowParameter);
        } else if (HRStringUtils.isNotEmpty((String)questionnaire)) {
            FormShowParameter formShowParameter = BizModelJumpPageHandler.getHandler().getQuestPageParam(questionnaire, params, callBack);
            if (func != null) {
                func.apply((FormShowParameter)formShowParameter);
            }
            view.showForm(formShowParameter);
        } else {
            view.showTipNotification(BizModelMsgEnum.NEW_SON_NOT_SUPPORT_TIP.get());
        }
    }
}

