/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.tree;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.RaiseEventType;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.entity.rule.RaiseEventSource;
import kd.bos.entity.rule.RuleContainer;
import kd.bos.entity.rule.RuleExecuteContext;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.gridconfig.GridConfigRenderUtils;
import kd.bos.form.rule.FormRuleExecuteContext;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.IAppDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizObjDomainService;
import kd.hdtc.hrbm.business.domain.model.ICloudDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class CustomTreeEntryGrid
extends TreeEntryGrid {
    private static final String FIRST_LOGIC = "firstLogic";
    private static final String SON_LOGIC = "sonLogic";
    private static final String INDEX = "index";
    private static final String APP_ID = "app.id";
    private static final String CLOUD_ID = "cloud.id";
    private static final String SORT_CODE = "sort_code";
    private static final ImmutableSet<String> TYPE_SET = ImmutableSet.of((Object)"40", (Object)"50");
    private DynamicObject[] logicEntityArr;
    private List<Map<String, List<DynamicObject>>> qualifiedData = new ArrayList<Map<String, List<DynamicObject>>>();
    private DynamicObjectCollection logicEntityDataForPage = new DynamicObjectCollection();
    private final ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);
    protected final ICloudDomainService cloudDomainService = (ICloudDomainService)ServiceFactory.getService(ICloudDomainService.class);
    private final IAppDomainService appDomainService = (IAppDomainService)ServiceFactory.getService(IAppDomainService.class);
    protected final IBizObjDomainService bizObjDomainService = (IBizObjDomainService)ServiceFactory.getService(IBizObjDomainService.class);

    public boolean isNeedPaged() {
        return true;
    }

    public void bindData(BindingContext bctx) {
        GridConfigRenderUtils.renderGridConfig((IFormView)this.getView(), (String)this.getEntryKey());
        this.treeEntryGridBindPageData();
    }

    public void treeEntryGridBindPageData() {
        AbstractGrid.GridState entryState = this.getEntryState();
        int startIndex = 0;
        int endIndex = 0;
        int rowCount = this.getRowCount();
        int pageCount = 0;
        if (this.isNeedPaged()) {
            int pageShowRows = entryState.getPageRows();
            int currPageIndex = entryState.getCurrentPageIndex();
            pageCount = rowCount / pageShowRows + (rowCount % pageShowRows > 0 ? 1 : 0);
            if (pageCount == 0) {
                pageCount = 1;
            }
            if (currPageIndex < 1) {
                entryState.setCurrentPageIndex(Integer.valueOf(1));
            } else if (currPageIndex >= pageCount) {
                entryState.setCurrentPageIndex(Integer.valueOf(pageCount));
            }
            startIndex = (currPageIndex - 1) * pageShowRows;
            endIndex = Math.min(startIndex + this.getPageRow(), rowCount);
        } else {
            endIndex = rowCount;
        }
        ArrayList<Object> rows = new ArrayList<Object>();
        ArrayList<RowDataEntity> objs = new ArrayList<RowDataEntity>();
        Object[] dataEntitys = this.getEntryDataEntities(startIndex, endIndex);
        if (!ObjectUtils.isEmpty((Object[])dataEntitys)) {
            this.handleEntryData(objs, rows, (DynamicObject[])dataEntitys);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("rowcount", rowCount);
        data.put("rows", rows);
        data.put("pagerows", entryState.getState().get("pageRows"));
        data.put("pageindex", entryState.getCurrentPageIndex());
        data.put("isSplitPage", true);
        data.put("phide", !this.isNeedPaged());
        data.put("pagecount", pageCount);
        data.put("datacount", rowCount);
        data.put("dataindex", this.getDataIndex());
        this.fireBindEntryGridDataEvent(objs, data, startIndex);
        IDataEntityProperty property = this.getModel().getProperty(this.getEntryKey());
        if (property instanceof SubEntryProp) {
            data.put("pr", this.getModel().getEntryCurrentRowIndex(property.getParent().getName()));
        }
        IClientViewProxy proxy = (IClientViewProxy)this.view.getService(IClientViewProxy.class);
        proxy.setEntryProperty(this.getKey(), "data", data);
        this.selectRows(-1);
    }

    protected int getRowCount() {
        return this.getQualifiedData(this.getEntryState());
    }

    public int getQualifiedData(AbstractGrid.GridState entryState) {
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String formId = this.getView().getFormShowParameter().getFormId();
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (HRStringUtils.isEmpty((String)nodeId)) {
            return 0;
        }
        List nodeIdList = Splitter.on((String)".").splitToList((CharSequence)nodeId);
        int layer = nodeIdList.size();
        String curNodeId = (String)nodeIdList.get(nodeIdList.size() - 1);
        Set<Long> bizObjIdSet = new HashSet<Long>();
        if (layer == 4) {
            bizObjIdSet.add(ConvertUtils.toLong((Object)curNodeId));
        } else if ("hrbm_bdmanagement".equals(formId) && layer == 2) {
            List appList = this.appDomainService.getAppInfoListByCloudId(Long.valueOf(ConvertUtils.toLong((Object)curNodeId)));
            Set appIdSet = appList.stream().map(app -> app.getLong("id")).collect(Collectors.toSet());
            List bizObjList = this.bizObjDomainService.getBizObjInfoByAppIds(appIdSet);
            bizObjIdSet = bizObjList.stream().filter(biz -> TYPE_SET.contains((Object)biz.getString("type"))).map(biz -> biz.getLong("id")).collect(Collectors.toSet());
        }
        this.logicEntityArr = this.logicEntityDomainService.getLogicEntityByBizObjId(bizObjIdSet);
        if (HRArrayUtils.isEmpty((Object[])this.logicEntityArr)) {
            return 0;
        }
        return this.structQualifiedData(entryState.getPageRows());
    }

    private int structQualifiedData(int pageShowRows) {
        List firstLogicList = Arrays.stream(this.logicEntityArr).filter(logic -> logic.getBoolean("mainentity")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(firstLogicList)) {
            return 0;
        }
        Collections.sort(firstLogicList, Comparator.comparingInt(o -> o.getInt(INDEX)));
        List firstLogicPartition = Lists.partition(firstLogicList, (int)pageShowRows);
        firstLogicPartition.forEach(firstLogic -> {
            HashMap pageDataMap = new HashMap();
            pageDataMap.put(FIRST_LOGIC, firstLogic);
            Set mainEntityIdSet = firstLogic.stream().map(logic -> logic.getLong("id")).collect(Collectors.toSet());
            List sonLogicList = Arrays.stream(this.logicEntityArr).filter(logic -> !logic.getBoolean("mainentity")).filter(logic -> logic.getDynamicObject("pid") != null).filter(logic -> mainEntityIdSet.contains(logic.getDynamicObject("pid").getLong("id"))).collect(Collectors.toList());
            pageDataMap.put(SON_LOGIC, sonLogicList);
            this.qualifiedData.add(pageDataMap);
        });
        return firstLogicList.size();
    }

    protected DynamicObject[] getEntryDataEntities(int startIndex, int endIndex) {
        int currentPageIndex = this.getEntryState().getCurrentPageIndex();
        if (CollectionUtils.isEmpty(this.qualifiedData)) {
            return new DynamicObject[0];
        }
        List<DynamicObject> firstLogicList = this.qualifiedData.get(currentPageIndex - 1).get(FIRST_LOGIC);
        Collections.sort(firstLogicList, Comparator.comparingInt(o -> o.getInt(INDEX)));
        return firstLogicList.toArray(new DynamicObject[0]);
    }

    private void handleEntryData(List<RowDataEntity> objs, List<Object> rows, DynamicObject[] dataEntitys) {
        EntityType entityType = (EntityType)this.getModel().getDataEntityType().getAllEntities().get("treeentryentity");
        int totalTasksCnt = this.queryTreeNodeChildren(dataEntitys);
        this.getModel().getDataEntity(true);
        DynamicObjectCollection treeEntity = this.getModel().getDataEntity().getDynamicObjectCollection("treeentryentity");
        treeEntity.clear();
        treeEntity.addAll((Collection)this.logicEntityDataForPage);
        this.setEntryEntitySortCode(treeEntity);
        treeEntity.setStartRowIndex(0);
        for (int i = 0; i < totalTasksCnt; ++i) {
            objs.add(new RowDataEntity(i, (DynamicObject)this.logicEntityDataForPage.get(i)));
        }
        if (this.getRuleCount() > 0) {
            RuleContainer ruleContainer = (RuleContainer)this.getView().getService(RuleContainer.class);
            ruleContainer.raise(new RaiseEventSource(RaiseEventType.Initialized, objs, (IDataEntityType)entityType), (RuleExecuteContext)new FormRuleExecuteContext(this.getView()));
        }
        objs.forEach(rowDataEntity -> {
            BindingContext bindCtx = new BindingContext((IDataEntityType)entityType, rowDataEntity.getDataEntity(), rowDataEntity.getRowIndex());
            rows.add(this.getRowBindValue(bindCtx));
        });
    }

    private void setEntryEntitySortCode(DynamicObjectCollection treeEntity) {
        Map<Long, DynamicObject> entryMap = treeEntity.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
        TreeView treeView = (TreeView)this.getView().getControl("treeview");
        String nodeId = treeView.getTreeState().getFocusNodeId();
        if (HRStringUtils.isEmpty((String)nodeId)) {
            return;
        }
        List nodeIdList = Splitter.on((String)".").splitToList((CharSequence)nodeId);
        String curNodeId = (String)nodeIdList.get(nodeIdList.size() - 1);
        int layer = nodeIdList.size();
        if (layer == 4) {
            this.setBizEntryEntitySortCode(curNodeId, entryMap);
        } else if (layer == 2) {
            this.setCloudEntryEntitySortCode(curNodeId, entryMap);
        }
    }

    private void setBizEntryEntitySortCode(String curNodeId, Map<Long, DynamicObject> entryMap) {
        DynamicObject bizObjInfo = this.bizObjDomainService.getBizObjInfoById((Object)Long.parseLong(curNodeId));
        if (bizObjInfo == null) {
            return;
        }
        DynamicObject appInfo = this.appDomainService.getAppInfoById((Object)bizObjInfo.getLong(APP_ID));
        DynamicObject cloudInfo = this.cloudDomainService.getCloudInfoById((Object)appInfo.getLong(CLOUD_ID));
        String bizSortCode = cloudInfo.getInt(INDEX) + "." + appInfo.getInt(INDEX) + "." + bizObjInfo.getInt(INDEX) + ".";
        for (Map<String, List<DynamicObject>> pageDataMap : this.qualifiedData) {
            List<DynamicObject> firstLogicDys = pageDataMap.get(FIRST_LOGIC);
            List<DynamicObject> sonLogicDys = pageDataMap.get(SON_LOGIC);
            for (DynamicObject firstDy : firstLogicDys) {
                int firstLogicIndex = firstDy.getInt(INDEX);
                Long firstId = firstDy.getLong("id");
                if (!entryMap.containsKey(firstId)) continue;
                entryMap.get(firstId).set(SORT_CODE, (Object)(bizSortCode + firstLogicIndex));
                for (DynamicObject sonDy : sonLogicDys) {
                    entryMap.get(sonDy.getLong("id")).set(SORT_CODE, (Object)(bizSortCode + firstLogicIndex + "." + sonDy.getInt(INDEX)));
                }
            }
        }
    }

    private void setCloudEntryEntitySortCode(String curNodeId, Map<Long, DynamicObject> entryMap) {
        if (this.logicEntityArr == null || this.logicEntityArr.length == 0) {
            return;
        }
        DynamicObject cloudInfo = this.cloudDomainService.getCloudInfoById((Object)Long.parseLong(curNodeId));
        long cloudIndex = cloudInfo.getInt(INDEX);
        List appList = this.appDomainService.getAppInfoListByCloudId(Long.valueOf(ConvertUtils.toLong((Object)curNodeId)));
        Set appIdSet = appList.stream().map(app -> app.getLong("id")).collect(Collectors.toSet());
        Map<Long, Integer> appIndexMap = appList.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject.getInt(INDEX)));
        List bizObjList = this.bizObjDomainService.getBizObjInfoByAppIds(appIdSet);
        Map<Long, DynamicObject> bizIndexMap = bizObjList.stream().collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject));
        for (Map<String, List<DynamicObject>> pageDataMap : this.qualifiedData) {
            List<DynamicObject> firstLogicDys = pageDataMap.get(FIRST_LOGIC);
            List<DynamicObject> sonLogicDys = pageDataMap.get(SON_LOGIC);
            for (DynamicObject firstDy : firstLogicDys) {
                int firstLogicIndex = firstDy.getInt(INDEX);
                Long firstId = firstDy.getLong("id");
                long bizId = firstDy.getDynamicObject("bizobj").getLong("id");
                DynamicObject bizObjInfo = bizIndexMap.get(bizId);
                int appIndex = appIndexMap.get(bizObjInfo.getLong(APP_ID));
                String bizSortCode = cloudIndex + "." + appIndex + "." + bizObjInfo.getInt(INDEX) + ".";
                if (!entryMap.containsKey(firstId)) continue;
                entryMap.get(firstId).set(SORT_CODE, (Object)(bizSortCode + firstLogicIndex));
                for (DynamicObject sonDy : sonLogicDys) {
                    entryMap.get(sonDy.getLong("id")).set(SORT_CODE, (Object)(bizSortCode + firstLogicIndex + "." + sonDy.getInt(INDEX)));
                }
            }
        }
    }

    private int queryTreeNodeChildren(DynamicObject[] dys) {
        List logicEntityList = ConvertUtils.toList((Object[])dys);
        int currentPageIndex = this.getEntryState().getCurrentPageIndex();
        List<DynamicObject> sonLogicList = this.qualifiedData.get(currentPageIndex - 1).get(SON_LOGIC);
        Collections.sort(sonLogicList, Comparator.comparingInt(o -> o.getInt(INDEX)));
        Object[] sonLogicEntityArr = sonLogicList.toArray(new DynamicObject[0]);
        if (!ObjectUtils.isEmpty((Object[])sonLogicEntityArr)) {
            logicEntityList.addAll(ConvertUtils.toList((Object[])sonLogicEntityArr));
        }
        DynamicObjectCollection treeEntity = this.getModel().getEntryEntity("treeentryentity");
        logicEntityList.forEach(logic -> {
            DynamicObject dyc = new DynamicObject(treeEntity.getDynamicObjectType());
            dyc.set("id", (Object)logic.getLong("id"));
            DynamicObject parentdyc = logic.getDynamicObject("pid");
            dyc.set("pid", (Object)(parentdyc == null ? 0L : parentdyc.getLong("id")));
            dyc.set("name", (Object)logic.getLocaleString("name"));
            dyc.set("number", (Object)logic.getString("number"));
            dyc.set(INDEX, (Object)logic.getInt(INDEX));
            dyc.set("isv", (Object)logic.getString("isv"));
            dyc.set("bizrule", (Object)logic.getLocaleString("bizrule"));
            dyc.set("cusstatus", (Object)logic.getString("cusstatus"));
            dyc.set("description", (Object)logic.getLocaleString("description"));
            this.logicEntityDataForPage.add((Object)dyc);
        });
        return logicEntityList.size();
    }

    public void setPageIndex(int pageIndex) {
        AbstractGrid.GridState entryState = this.getEntryState();
        entryState.setCurrentPageIndex(Integer.valueOf(pageIndex));
        this.treeEntryGridBindPageData();
    }

    public void setPageRows(int rows) {
        AbstractGrid.GridState entryState = this.getEntryState();
        entryState.setPageRows(rows);
        this.treeEntryGridBindPageData();
    }
}

