/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.tree.strategy;

import java.util.HashMap;
import java.util.Map;
import kd.hdtc.hrbm.formplugin.web.tree.strategy.AddBatchMenuButtonStrategy;
import kd.hdtc.hrbm.formplugin.web.tree.strategy.AddCadreMGFileButtonStrategy;
import kd.hdtc.hrbm.formplugin.web.tree.strategy.AddMGFileButtonStrategy;
import kd.hdtc.hrbm.formplugin.web.tree.strategy.AddPSFileButtonStrategy;
import kd.hdtc.hrbm.formplugin.web.tree.strategy.CadreReportButtonStrategy;
import kd.hdtc.hrbm.formplugin.web.tree.strategy.IButtonStrategy;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class ButtonStrategyContext {
    public static IButtonStrategy getButtonStrategy(String button) {
        return (IButtonStrategy)StrategyInstanceHolder.STRATEGY_MAP.get(button);
    }

    public static IButtonStrategy getButtonStrategyByExtCaseNumber(String extCaseNumber) {
        String buttonNumber = (String)StrategyInstanceHolder.CARD_BUTTON_MAP.get(extCaseNumber);
        if (StringUtils.isNotEmpty((String)buttonNumber)) {
            return ButtonStrategyContext.getButtonStrategy(buttonNumber);
        }
        return null;
    }

    private static class StrategyInstanceHolder {
        private static final Map<String, IButtonStrategy> STRATEGY_MAP = new HashMap<String, IButtonStrategy>(16);
        private static final Map<String, String> CARD_BUTTON_MAP = new HashMap<String, String>(16);

        private StrategyInstanceHolder() {
        }

        static {
            CARD_BUTTON_MAP.put("1030_S", "addmgfileviews");
            CARD_BUTTON_MAP.put("1090_S", "addmgfileviews");
            CARD_BUTTON_MAP.put("1140_S", "addpsfileviews");
            CARD_BUTTON_MAP.put("1150_S", "addpsfileviews");
            CARD_BUTTON_MAP.put("1160_S", "addisbatchmenu");
            CARD_BUTTON_MAP.put("1170_S", "addisbatchmenu");
            CARD_BUTTON_MAP.put("", "modifycadrereport");
            CARD_BUTTON_MAP.put("6010_S", "addcadremgfileviews");
            STRATEGY_MAP.put("addisbatchmenu", new AddBatchMenuButtonStrategy());
            STRATEGY_MAP.put("addmgfileviews", new AddMGFileButtonStrategy());
            STRATEGY_MAP.put("addpsfileviews", new AddPSFileButtonStrategy());
            STRATEGY_MAP.put("modifycadrereport", new CadreReportButtonStrategy());
            STRATEGY_MAP.put("addcadremgfileviews", new AddCadreMGFileButtonStrategy());
        }
    }
}

