/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.opplugin.web.ext;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.IExtCaseManageDomainService;
import kd.hdtc.hrbm.common.constant.ExtCaseConstants;
import kd.hdtc.hrbm.opplugin.web.ext.validate.PersonInfoSaveValidator;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;

public class PersonInfoSaveOp
extends HDTCDataBaseOp {
    private final IExtCaseManageDomainService extCaseManageDomainService = (IExtCaseManageDomainService)ServiceFactory.getService(IExtCaseManageDomainService.class);

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new PersonInfoSaveValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        for (DynamicObject dynamicObject : args.getDataEntities()) {
            Long extCaseManageId = this.extCaseManageDomainService.saveExtCaseManage(dynamicObject.getDynamicObject("obj"), ExtCaseConstants.ExtCasePreData.EIGHT.longValue(), 0L, this.getCaseRule(dynamicObject));
            this.extCaseManageDomainService.effect(extCaseManageId.longValue());
        }
    }

    private Map<String, Object> getCaseRule(DynamicObject dy) {
        HashMap caseRuleMap = Maps.newHashMapWithExpectedSize((int)16);
        String showType = dy.getString("showtype");
        showType = showType == null ? "" : showType;
        caseRuleMap.put("obj", dy.getString("obj.number"));
        caseRuleMap.put("showtype", showType);
        caseRuleMap.put("ismul", dy.getString("ismul"));
        StringBuilder sb = new StringBuilder();
        dy.getDynamicObjectCollection("showcols").stream().sorted(Comparator.comparingInt(item -> item.getInt("fbasedataid.index"))).forEach(item -> sb.append(item.getString("fbasedataid.propkey")).append(","));
        if (sb.length() > 0) {
            caseRuleMap.put("showcols", sb.substring(0, sb.length() - 1));
        }
        return caseRuleMap;
    }
}

