/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.opplugin.web.extcase.validate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;

public class SceneCardConfigSaveValidator
extends HDTCDataBaseValidator {
    private final String FUNCTION_EMPTY_ERROR_MESSAGE = ResManager.loadKDString((String)"\u5361\u7247\u7c7b\u578b\u4e3a\u591a\u573a\u666f\u65f6\uff0c\u5173\u8054\u64cd\u4f5c\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SceneCardConfigSaveValidator_6", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]);
    private final String FUNCTION_EXT_CASE_ERROR_MESSAGE = ResManager.loadKDString((String)"\u201c\u5173\u8054\u529f\u80fd\u7c7b\u578b\u201d\u662f\u573a\u666f\u7c7b\u65f6\uff0c\u201c\u5173\u8054\u6269\u5c55\u573a\u666f\u201d\u5fc5\u586b\u3002", (String)"SceneCardConfigSaveValidator_1", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]);
    private final String PAGE_ERROR_MESSAGE = ResManager.loadKDString((String)"\u201c\u5173\u8054\u529f\u80fd\u7c7b\u578b\u201d\u662f\u89c6\u56fe\u7c7b\u6216\u8005\u9875\u9762\u7c7b\u65f6\uff0c\u201c\u5173\u8054\u9875\u9762\u201d\u5fc5\u586b\u3002", (String)"SceneCardConfigSaveValidator_2", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]);
    private final String MODEL_ERROR_MESSAGE = ResManager.loadKDString((String)"\u201c\u5173\u8054\u529f\u80fd\u7c7b\u578b\u201d\u662f\u6a21\u578b\u7c7b\u65f6\uff0c\u201c\u5173\u8054\u6a21\u578b\u5361\u7247\u201d\u5fc5\u586b", (String)"SceneCardConfigSaveValidator_7", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]);
    private final String PARAM_RULE_ERROR_MESSAGE = ResManager.loadKDString((String)"\u5173\u8054\u64cd\u4f5c%s\u914d\u7f6e\u7684\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u4ec5\u5141\u8bb8\u8f93\u5165JSON\u683c\u5f0f\u3002", (String)"SceneCardConfigSaveValidator_5", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]);
    private final String MUST_ERROR_MESSAGE = ResManager.loadKDString((String)"\u201c\u5361\u7247\u8df3\u8f6c\u7c7b\u578b\u201d\u662f\u8df3\u8f6c\u81f3\u6269\u5c55\u573a\u666f\u65f6\uff0c\u201c\u5173\u8054\u6269\u5c55\u573a\u666f\u201d\u5fc5\u586b", (String)"SceneCardConfigSaveValidator_8", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]);

    public void validate() {
        this.checkCardConfig();
        this.checkRelOperation();
        this.checkCardActLevel();
    }

    private void checkCardConfig() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObjectCollection containCaseCollection;
            DynamicObject dataEntity = dy.getDataEntity();
            String cardJumpType = dataEntity.getString("cardjumptype");
            if ("1010".equals(cardJumpType) && CollectionUtils.isEmpty((Collection)(containCaseCollection = dataEntity.getDynamicObjectCollection("containcase")))) {
                this.addErrorMessage((ExtendedDataEntity)dy, this.MUST_ERROR_MESSAGE);
            }
        });
    }

    private void checkCardActLevel() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject dataEntity = dy.getDataEntity();
            DynamicObjectCollection bdCollection = dataEntity.getDynamicObjectCollection("bdentryentity");
            bdCollection.forEach(bdEntry -> {
                String bizModelType = bdEntry.getString("bizmodeltype");
                String cardActLevel = bdEntry.getString("cardactlevel");
                if ("hrbm_app".equals(bizModelType) && "cloud".equals(cardActLevel)) {
                    this.addErrorMessage((ExtendedDataEntity)dy, ResManager.loadKDString((String)"\u5f53\u201c\u4e1a\u52a1\u6a21\u578b\u7c7b\u578b\u201d\u662f\u5e94\u7528\u65f6\uff0c\u5361\u7247\u4f5c\u7528\u5c42\u7ea7\u4ec5\u5141\u8bb8\u9009\u62e9\u5e94\u7528\u3001\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"SceneCardConfigSaveValidator_3", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]));
                }
                if ("hrbm_bizobj".equals(bizModelType) && !"bizobj".equals(cardActLevel)) {
                    this.addErrorMessage((ExtendedDataEntity)dy, ResManager.loadKDString((String)"\u5f53\u201c\u4e1a\u52a1\u6a21\u578b\u7c7b\u578b\u201d\u662f\u4e1a\u52a1\u5bf9\u8c61\u65f6\uff0c\u5361\u7247\u4f5c\u7528\u5c42\u7ea7\u4ec5\u5141\u8bb8\u9009\u62e9\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"SceneCardConfigSaveValidator_4", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]));
                }
            });
        });
    }

    private void checkRelOperation() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject dataEntity = dy.getDataEntity();
            String cardType = dataEntity.getString("cardtype");
            if ("1010".equals(cardType)) {
                DynamicObjectCollection opCollection = dataEntity.getDynamicObjectCollection("opentryentity");
                if (CollectionUtils.isEmpty((Collection)opCollection)) {
                    this.addErrorMessage((ExtendedDataEntity)dy, this.FUNCTION_EMPTY_ERROR_MESSAGE);
                } else {
                    opCollection.forEach(opEntry -> {
                        DynamicObjectCollection relModelCardCollection;
                        String functionType = opEntry.getString("functiontype");
                        if ("1010".equals(functionType)) {
                            DynamicObject functionExtCase = opEntry.getDynamicObject("functionextcase");
                            if (functionExtCase == null) {
                                this.addErrorMessage((ExtendedDataEntity)dy, this.FUNCTION_EXT_CASE_ERROR_MESSAGE);
                            }
                        } else if ("1020".equals(functionType) || "1030".equals(functionType)) {
                            String pageId = opEntry.getString("pageid");
                            if (StringUtils.isEmpty((String)pageId)) {
                                this.addErrorMessage((ExtendedDataEntity)dy, this.PAGE_ERROR_MESSAGE);
                            }
                        } else if ("1040".equals(functionType) && CollectionUtils.isEmpty((Collection)(relModelCardCollection = opEntry.getDynamicObjectCollection("relmodelcard")))) {
                            this.addErrorMessage((ExtendedDataEntity)dy, this.MODEL_ERROR_MESSAGE);
                        }
                        String paramRule = opEntry.getString("paramrule");
                        String functionName = opEntry.getString("functionname");
                        if (StringUtils.isNotEmpty((String)paramRule) && !StringUtils.isValidJson((String)paramRule)) {
                            this.addErrorMessage((ExtendedDataEntity)dy, String.format(Locale.ROOT, this.PARAM_RULE_ERROR_MESSAGE, functionName));
                        }
                    });
                }
            }
        });
    }
}

