/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.opplugin.web.logicentity;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.common.util.ExtTemplateUtils;
import kd.hdtc.hrbm.business.domain.baseconfig.IBaseConfigDomainService;
import kd.hdtc.hrbm.business.domain.extcase.IExtCaseManageDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizModelManageDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizObjDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropRelPropDomainService;
import kd.hdtc.hrbm.business.domain.model.factory.LogicEntitySaveBizHandleBoFactory;
import kd.hdtc.hrbm.common.exception.HRBMBizException;
import kd.hdtc.hrbm.common.pojo.LogicEntitySaveBizHandleBoParam;
import kd.hdtc.hrbm.opplugin.web.logicentity.LogicEntitySaveValidator;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class LogicEntitySaveOp
extends HDTCDataBaseOp {
    private static final Log LOG = LogFactory.getLog(LogicEntitySaveOp.class);
    private final ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);
    private final IPropDomainService propDomainService = (IPropDomainService)ServiceFactory.getService(IPropDomainService.class);
    private final IBizObjDomainService bizObjDomainService = (IBizObjDomainService)ServiceFactory.getService(IBizObjDomainService.class);
    private final IPropRelPropDomainService propRelDomainService = (IPropRelPropDomainService)ServiceFactory.getService(IPropRelPropDomainService.class);
    private final IExtCaseManageDomainService extCaseManageDomainService = (IExtCaseManageDomainService)ServiceFactory.getService(IExtCaseManageDomainService.class);
    private final IBizModelManageDomainService bizModelManageDomainService = (IBizModelManageDomainService)ServiceFactory.getService(IBizModelManageDomainService.class);
    private final IBaseConfigDomainService iBaseConfigDomainService = (IBaseConfigDomainService)ServiceFactory.createInstance(IBaseConfigDomainService.class);

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new LogicEntitySaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        OperateOption option = this.getOption();
        this.handleTempField(e, option);
        this.handleLogicNumber(e);
    }

    private void handleLogicNumber(BeforeOperationArgs e) {
        DynamicObject[] logicDyArr = e.getDataEntities();
        DynamicObject logicDy = logicDyArr[0];
        String number = logicDy.getString("number");
        logicDy.set("number", (Object)number.toLowerCase(Locale.ROOT));
    }

    private void handleTempField(BeforeOperationArgs e, OperateOption option) {
        String pageStatus = option.getVariableValue("pageStatus", "");
        if (HRStringUtils.isEmpty((String)pageStatus)) {
            return;
        }
        String platTemplateId = option.getVariableValue("template", "");
        if (HRStringUtils.isEmpty((String)platTemplateId)) {
            return;
        }
        if (HRStringUtils.equals((String)pageStatus, (String)OperationStatus.ADDNEW.name())) {
            DynamicObjectCollection entryEntity = e.getDataEntities()[0].getDynamicObjectCollection("entryentity");
            entryEntity.removeIf(row -> {
                if (HRStringUtils.equals((String)row.getString("epropkey"), (String)"id")) {
                    return false;
                }
                return row.getBoolean("extend");
            });
            LinkedList propIndexList = this.propDomainService.getPropIndexList(null, MetadataUtils.getMainEntityType((String)platTemplateId).getProperties().size());
            Set excludeColumns = this.iBaseConfigDomainService.getPropBlackList();
            ExtTemplateUtils.handleExtTemplateField((boolean)false, (Set)excludeColumns, (String)platTemplateId, (DynamicObjectCollection)entryEntity, (LinkedList)propIndexList);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject dyc = e.getDataEntities()[0];
        String extCaseKeyStr = this.getOption().getVariableValue("logicentity_extCaseKey", "");
        long extCaseId = ConvertUtils.toLong((Object)(HRStringUtils.isEmpty((String)extCaseKeyStr) ? Long.valueOf(0L) : extCaseKeyStr));
        if (extCaseId == 0L) {
            throw new HRBMBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u5230\u6269\u5c55\u573a\u666f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"LogicEntitySaveOp_0", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]));
        }
        if (HRStringUtils.equals((String)"save", (String)operationKey) || HRStringUtils.equals((String)"saveandeffect", (String)operationKey)) {
            this.saveData(dyc, extCaseId);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject dyc = e.getDataEntities()[0];
        if (HRStringUtils.equals((String)"saveandeffect", (String)operationKey)) {
            OperateOption option = this.getOption();
            long extCaseId = ConvertUtils.toLong((Object)option.getVariableValue("logicentity_extCaseKey"));
            if (extCaseId == 0L) {
                LOG.info("bizModelAllLineLog about LogicEntitySaveOp.afterExecuteOperationTransaction():extCaseId is null return");
                throw new HRBMBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u5339\u914d\u5230\u6269\u5c55\u573a\u666f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"LogicEntitySaveOp_0", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]));
            }
            try {
                boolean effect = this.bizModelManageDomainService.effect(dyc, Long.valueOf(extCaseId));
                if (effect) {
                    return;
                }
                option.setVariableValue("operateResult", "fail");
            }
            catch (Exception ex) {
                LOG.warn("[hrbm]The data has been saved and failed to take effect", (Throwable)ex);
                option.setVariableValue("operateResult", "fail");
            }
        }
    }

    private void saveData(DynamicObject dyc, long extCaseId) {
        OperateOption option = this.getOption();
        String openType = option.getVariableValue("pagetype", "");
        String nodeId = option.getVariableValue("curnodeid", "");
        if (HRStringUtils.equals((String)openType, (String)"bdmode")) {
            DynamicObject newBizObj = this.bizObjDomainService.addBizObjByBDLogicEntity(dyc.getLocaleString("name"), dyc.getString("number"), Long.valueOf(ConvertUtils.toLong((Object)nodeId)));
            dyc.set("bizobj", (Object)newBizObj);
        }
        dyc.set("cusstatus", (Object)"0");
        dyc.set("status", (Object)"C");
        dyc.set("enable", (Object)"1");
        long LogicEntityPagePkid = dyc.getLong("id");
        List oldRelList = this.propRelDomainService.getProRelByEntityIdAndRelType(Long.valueOf(LogicEntityPagePkid), "B1");
        LogicEntitySaveBizHandleBoFactory.generate((LogicEntitySaveBizHandleBoParam)new LogicEntitySaveBizHandleBoParam(ConvertUtils.toString((Object)extCaseId), dyc)).handle();
        this.propDomainService.savePropAndPropRel(dyc.getDynamicObjectCollection("entryentity"), LogicEntityPagePkid, this.getPropNumberPrefix(dyc));
        this.propRelDomainService.saveCopyProRel(dyc.getDynamicObjectCollection("entryentity"), oldRelList);
        this.extCaseManageDomainService.saveExtCaseManage(dyc, extCaseId, LogicEntityPagePkid, null);
    }

    private String getPropNumberPrefix(DynamicObject logicEntityDy) {
        String logicEntityNumber = logicEntityDy.getString("number");
        String extMetaNum = logicEntityDy.getString("extmetanum");
        return HRStringUtils.isEmpty((String)extMetaNum) ? logicEntityNumber : extMetaNum;
    }

    private boolean isApplyMaxIndex(DynamicObject logicEntity, String openType) {
        DynamicObject logicEntityInfo = this.logicEntityDomainService.getLogicEntityInfoById((Object)logicEntity.getLong("id"));
        if (!HRObjectUtils.isEmpty((Object)logicEntityInfo)) {
            return false;
        }
        if (HRStringUtils.equals((String)openType, (String)"bdmode")) {
            return true;
        }
        String classify = logicEntity.getDynamicObject("bizobj").getString("classify");
        if ("10".equals(classify)) {
            return false;
        }
        return false;
    }
}

