/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.opplugin.web.logicentity;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrbm.business.domain.model.factory.LogicEntityBizCaseValidateBoFactory;
import kd.hdtc.hrbm.common.pojo.LogicEntityBizCaseValidateParam;
import kd.hdtc.hrbm.common.pojo.LogicEntityValidatorResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.PatternUtil;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hr.hbp.common.util.HRStringUtils;

public class LogicEntitySaveValidator
extends HDTCDataBaseValidator {
    private final ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);
    private final String PROP_REPEAT_ERROR_MESSAGE = ResManager.loadKDString((String)"\u5143\u6570\u636e\u4e2d\u5df2\u5b58\u5728\u5c5e\u6027\u6807\u8bc6\u4e3a\u201c%s\u201d\u7684\u5c5e\u6027\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u6dfb\u52a0\u3002\u8bf7\u4fee\u6539\u3002", (String)"LogicEntitySaveValidator_1", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]);
    private final String PROP_KEY_ERROR_MESSAGE = ResManager.loadKDString((String)"\u201cattachmentpanelap_std\u201d\u4e3a\u9644\u4ef6\u9762\u677f\u56fa\u5b9a\u6807\u8bc6\uff0c\u8bf7\u4fee\u6539\u5c5e\u6027\u7c7b\u578b\u6216\u5c5e\u6027\u6807\u8bc6\u3002", (String)"LogicEntitySaveValidator_3", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]);
    private final IPropDomainService propDomainService = (IPropDomainService)ServiceFactory.getService(IPropDomainService.class);

    public void validate() {
        String openType = this.getOption().getVariableValue("pagetype");
        if (!HRStringUtils.equals((String)openType, (String)"bdmode")) {
            this.checkName();
        }
        this.checkPropKeyUnique();
        this.numberLegalityValidate();
        this.checkNumber();
        this.doBizCaseValidate();
    }

    private void checkNumber() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject dataEntity = dy.getDataEntity();
            String number = dataEntity.getString("number");
            String numberPreFix = this.getNumberPreFix(dataEntity);
            this.checkLogicNumberUnique((ExtendedDataEntity)dy);
            String extCaseKeyStr = this.getOption().getVariableValue("logicentity_extCaseKey", "0");
            if (!this.logicEntityDomainService.checkNumberIsEnable(extCaseKeyStr, dataEntity.getString("isvtype"))) {
                return;
            }
            if (HRStringUtils.equals((String)"1", (String)dataEntity.getString("cusstatus"))) {
                return;
            }
            if (!number.startsWith(numberPreFix) || number.equals(numberPreFix)) {
                this.addErrorMessage((ExtendedDataEntity)dy, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e8c\u5f00\u5b9e\u4f53\u5143\u6570\u636e\u6807\u8bc6\u5fc5\u987b\u4ee5\u201c%s\u201c\u5f00\u5934\uff0c\u4e14\u6700\u540e\u6dfb\u52a0\u81f3\u5c111\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LogicEntitySaveOp_3", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]), numberPreFix));
            }
            if (number.length() > 20) {
                this.addErrorMessage((ExtendedDataEntity)dy, ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u6700\u591a\u53ef\u8f93\u516520\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LogicEntitySaveOp_4", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]));
            }
            if (!PatternUtil.validateNumber((String)number)) {
                this.addErrorMessage((ExtendedDataEntity)dy, ResManager.loadKDString((String)"\u7f16\u7801\u4ec5\u652f\u6301\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u201c_\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LogicEntitySaveOp_2", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]));
            }
        });
    }

    private String getNumberPreFix(DynamicObject dataEntity) {
        String appId;
        StringBuilder sb = new StringBuilder();
        String isvId = ISVServiceHelper.getISVInfo().getId();
        long pid = dataEntity.getLong("pid.id");
        long bizObjId = dataEntity.getLong("bizobj.id");
        Map variableMap = this.getOption().getVariables();
        String pageType = (String)variableMap.get("pagetype");
        if (HRStringUtils.equals((String)pageType, (String)"bdmode")) {
            String nodeId = (String)variableMap.get("curnodeid");
            bizObjId = ConvertUtils.toLong((Object)nodeId);
        }
        if (StringUtils.isEmpty((String)(appId = this.logicEntityDomainService.getLogicEntityAppId(Long.valueOf(pid), pageType, Long.valueOf(bizObjId))))) {
            return sb.append(isvId).append("_").toString();
        }
        sb.append(isvId).append("_").append(appId).append("_");
        return sb.toString();
    }

    private void doBizCaseValidate() {
        String extCaseKeyStr = this.getOption().getVariableValue("logicentity_extCaseKey", "0");
        LogicEntityValidatorResult validateResult = LogicEntityBizCaseValidateBoFactory.generate((LogicEntityBizCaseValidateParam)new LogicEntityBizCaseValidateParam(this.getOption(), this.getDataEntities(), ConvertUtils.toString((Object)extCaseKeyStr))).validate();
        validateResult.getErrorMsgResultMap().entrySet().forEach(entry -> this.addErrorMessage((ExtendedDataEntity)entry.getKey(), (String)entry.getValue()));
        validateResult.getWarningMsgResultMap().entrySet().forEach(entry -> this.addWarningMessage((ExtendedDataEntity)entry.getKey(), (String)entry.getValue()));
        validateResult.getInfoMsgResultMap().entrySet().forEach(entry -> this.addMessage((ExtendedDataEntity)entry.getKey(), (String)entry.getValue()));
    }

    private void checkLogicNumberUnique(ExtendedDataEntity dy) {
        DynamicObject dataEntity = dy.getDataEntity();
        String number = dataEntity.getString("number");
        Object[] logicEntityArr = this.logicEntityDomainService.getLogicEntityInfoByNumber(number);
        if (ArrayUtils.isEmpty((Object[])logicEntityArr) && MetadataUtils.isExist((String)number)) {
            Map variableMap = this.getOption().getVariables();
            String pageType = (String)variableMap.get("pagetype");
            if (HRStringUtils.equals((String)pageType, (String)"bdmode")) {
                this.addErrorMessage(dy, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f00\u53d1\u5e73\u53f0\u5df2\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201d\u7684\u57fa\u7840\u8d44\u6599\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LogicEntitySaveOp_7", (String)"hdtc-hrbm-opplugin", (Object[])new Object[]{number}), new Object[0]));
            } else {
                this.addErrorMessage(dy, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f00\u53d1\u5e73\u53f0\u5df2\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201c\u7684\u5143\u6570\u636e\uff0c\u5982\u9700\u5f15\u5165\u4e1a\u52a1\u6a21\u578b\uff0c\u8bf7\u5728\u201c\u5b9e\u4f53\u5217\u8868\u201d\u9875\u9762\u70b9\u51fb\u3010\u6dfb\u52a0\u5b9e\u4f53\u5143\u6570\u636e\u3011\u5373\u53ef\u5f15\u5165\u8be5\u5b9e\u4f53\u3002", (String)"LogicEntitySaveOp_6", (String)"hdtc-hrbm-opplugin", (Object[])new Object[]{number}), new Object[0]));
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])logicEntityArr) && dataEntity.getLong("id") != logicEntityArr[0].getLong("id")) {
            this.addErrorMessage(dy, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7f16\u7801\u4e3a\u201c%s\u201c\u7684\u5143\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LogicEntitySaveOp_5", (String)"hdtc-hrbm-opplugin", (Object[])new Object[]{number}), new Object[0]));
        }
    }

    private void checkPropKeyUnique() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        LinkedHashSet logicEntityIdSet = Sets.newLinkedHashSetWithExpectedSize((int)dataEntities.length);
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject dataEntity = dy.getDataEntity();
            long logicEntityId = dataEntity.getLong("id");
            if (logicEntityId > 0L) {
                logicEntityIdSet.add(logicEntityId);
            }
        });
        Map logicEntityIdPropInfoMap = this.propDomainService.getPropInfoMapByLogicEntityId((Collection)logicEntityIdSet);
        Arrays.stream(dataEntities).forEach(dy -> {
            Map propIdAndPropMap;
            DynamicObject dataEntity = dy.getDataEntity();
            long logicEntityId = dataEntity.getLong("id");
            DynamicObjectCollection propCollection = dataEntity.getDynamicObjectCollection("entryentity");
            if (logicEntityId > 0L && CollectionUtils.isNotEmpty((Map)(propIdAndPropMap = (Map)logicEntityIdPropInfoMap.get(logicEntityId)))) {
                HashSet propKeyDbSet = Sets.newHashSetWithExpectedSize((int)propIdAndPropMap.size());
                propIdAndPropMap.forEach((propId, prop) -> propKeyDbSet.add(prop.getString("propkey")));
                propCollection.forEach(propRow -> {
                    long propId = propRow.getLong("id");
                    String ePropKey = propRow.getString("epropkey");
                    DynamicObject propDb = (DynamicObject)propIdAndPropMap.get(propId);
                    if (propDb == null && propKeyDbSet.contains(ePropKey) && !this.isPersonInfoAttachProp(dataEntity, (DynamicObject)propRow)) {
                        this.addErrorMessage((ExtendedDataEntity)dy, String.format(Locale.ROOT, this.PROP_REPEAT_ERROR_MESSAGE, ePropKey));
                    }
                });
            }
            OperateOption option = this.getOption();
            String pageStatus = option.getVariableValue("pageStatus", "");
            String platTemplateId = option.getVariableValue("template", "");
            if (OperationStatus.ADDNEW.name().equals(pageStatus) && MetadataUtils.isExist((String)platTemplateId)) {
                List fieldNumberList = MetadataUtils.getFieldNumberList((String)platTemplateId);
                propCollection.forEach(propRow -> {
                    String ePropKey = propRow.getString("epropkey");
                    boolean extend = propRow.getBoolean("extend");
                    if (!extend && fieldNumberList.contains(ePropKey)) {
                        this.addErrorMessage((ExtendedDataEntity)dy, String.format(Locale.ROOT, this.PROP_REPEAT_ERROR_MESSAGE, ePropKey));
                    }
                });
            }
            HashSet propKeySet = Sets.newHashSetWithExpectedSize((int)propCollection.size());
            propCollection.forEach(propRow -> {
                String ePropKey = propRow.getString("epropkey");
                if (propKeySet.contains(ePropKey)) {
                    this.addErrorMessage((ExtendedDataEntity)dy, String.format(Locale.ROOT, this.PROP_REPEAT_ERROR_MESSAGE, ePropKey));
                }
                if (this.isPersonInfoNoAttachProp(dataEntity, (DynamicObject)propRow)) {
                    this.addErrorMessage((ExtendedDataEntity)dy, String.format(Locale.ROOT, this.PROP_KEY_ERROR_MESSAGE, ePropKey));
                }
                propKeySet.add(ePropKey);
            });
        });
    }

    private boolean isPersonInfoNoAttachProp(DynamicObject dataEntity, DynamicObject propRow) {
        DynamicObject bizObj = dataEntity.getDynamicObject("bizobj");
        String ePropKey = propRow.getString("epropkey");
        String fieldType = propRow.getString("fieldtype");
        return bizObj != null && "hrpi_person".equals(bizObj.getString("number")) && !"AttachmentPanelAp".equals(fieldType) && "attachmentpanelap_std".equals(ePropKey);
    }

    private boolean isPersonInfoAttachProp(DynamicObject dataEntity, DynamicObject propRow) {
        DynamicObject bizObj = dataEntity.getDynamicObject("bizobj");
        String ePropKey = propRow.getString("epropkey");
        String fieldType = propRow.getString("fieldtype");
        return bizObj != null && "hrpi_person".equals(bizObj.getString("number")) && "AttachmentPanelAp".equals(fieldType) && "attachmentpanelap_std".equals(ePropKey);
    }

    private void numberLegalityValidate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject dataEntity = dy.getDataEntity();
            DynamicObjectCollection propCollection = dataEntity.getDynamicObjectCollection("entryentity");
            propCollection.forEach(propRow -> {
                String ePropKey;
                if (!propRow.getBoolean("extend") && !PatternUtil.validateNumber((String)(ePropKey = propRow.getString("epropkey")))) {
                    String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s:\u5c5e\u6027\u6807\u8bc6\u4ec5\u652f\u6301\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u201c_\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"LogicEntitySaveValidator_4", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]), ePropKey);
                    this.addErrorMessage((ExtendedDataEntity)dy, message);
                }
            });
        });
    }

    private void checkName() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject dataEntity = dy.getDataEntity();
            long pid = dataEntity.getLong("pid.id");
            String name = dataEntity.getString("name");
            long logicEntityId = dataEntity.getLong("id");
            long bizObjId = dataEntity.getLong("bizobj.id");
            boolean existsName = this.logicEntityDomainService.existsLogicEntityByPidAndName(Long.valueOf(pid), name, Long.valueOf(logicEntityId), Long.valueOf(bizObjId));
            if (existsName) {
                this.addErrorMessage((ExtendedDataEntity)dy, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u540d\u79f0\u201c%s\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"LogicEntitySaveValidator_0", (String)"hdtc-hrbm-opplugin", (Object[])new Object[0]), name));
            }
        });
    }
}

