/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.opplugin.web.sharedtaskpool;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrbm.common.exception.HRBMBizException;
import kd.hdtc.hrbm.common.msgEnum.SharedTaskPoolEnum;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hr.hbp.common.util.HRStringUtils;

public class ShareTaskEnableOp
extends HDTCDataBaseOp {
    private static final Log LOG = LogFactory.getLog(ShareTaskEnableOp.class);
    private final IBaseEntityService queryTaskPoolEntityService = CommonEntityServiceFactory.getEntityService((String)"task_querylistpool");

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Object[] dataEntities = e.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        String operationKey = e.getOperationKey();
        if (HRStringUtils.equals((String)operationKey, (String)"enable")) {
            this.disableOrEnableTaskPool((DynamicObject[])dataEntities, "enable", "0");
        } else if (HRStringUtils.equals((String)operationKey, (String)"disable")) {
            this.disableOrEnableTaskPool((DynamicObject[])dataEntities, "disable", "1");
        }
    }

    private void disableOrEnableTaskPool(DynamicObject[] dataEntities, String op, String fieldValue) {
        List pkIdList = Arrays.stream(dataEntities).filter(data -> HRStringUtils.equals((String)data.getString("enable"), (String)fieldValue)).map(data -> data.getLong("id")).collect(Collectors.toList());
        Object[] hrIdArr = this.queryTaskPoolEntityService.query("id,enable,status", new QFilter("id", "in", pkIdList).toArray());
        if (ObjectUtils.isEmpty((Object[])hrIdArr)) {
            return;
        }
        OperationResult operationResult = OperationServiceHelper.executeOperate((String)op, (String)"task_querylistpool", (DynamicObject[])hrIdArr, (OperateOption)OperateOption.create());
        if (!operationResult.isSuccess()) {
            LOG.info(operationResult.getMessage());
            if (HRStringUtils.equals((String)op, (String)"enable")) {
                throw new HRBMBizException(SharedTaskPoolEnum.ENABLE_FAIL.get());
            }
            throw new HRBMBizException(SharedTaskPoolEnum.DISABLE_FAIL.get());
        }
    }
}

