/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.opplugin.web.sharedtaskpool;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.SharedTaskPoolDomainService;
import kd.hdtc.hrbm.common.exception.HRBMBizException;
import kd.hdtc.hrbm.common.msgEnum.SharedTaskPoolEnum;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicQueryApplicationService;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenResult;
import kd.hdtc.hrdbs.common.util.LogUtils;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hr.hbp.common.util.HRStringUtils;

public class ShareTaskPoolSaveOp
extends HDTCDataBaseOp {
    private static final Log LOG = LogFactory.getLog(ShareTaskPoolSaveOp.class);
    private static final String HSTC_TAG = "hstc_";
    private static final String SORT_CODE = "_s**";
    private static final String PLACEHOLDER = "**";
    private static final Map<String, String> SUFFIX_MAP = ImmutableMap.of((Object)"processqueryconf", (Object)"_q", (Object)"finishqueryconf", (Object)"_qh", (Object)"processquerylist", (Object)"_ql", (Object)"finishquerylist", (Object)"_qhl");
    SharedTaskPoolDomainService sharedTaskPoolDomainService = (SharedTaskPoolDomainService)ServiceFactory.getService(SharedTaskPoolDomainService.class);
    IDynamicQueryApplicationService dynamicQueryApplicationService = (IDynamicQueryApplicationService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IDynamicQueryApplicationService.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        Object[] dataEntities = e.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        Object dataEntity = dataEntities[0];
        DynamicObject sourceBill = dataEntity.getDynamicObject("sourcebill");
        if (sourceBill == null) {
            throw new HRBMBizException(SharedTaskPoolEnum.SOURCE_BILL_NOT_EMPTY.get());
        }
        long pkId = dataEntity.getLong("id");
        if (pkId != 0L) {
            this.createQueryConAndList((DynamicObject)dataEntity);
            return;
        }
        String sourceBillNumber = sourceBill.getString("id");
        String sourceBillName = sourceBill.getLocaleString("name").getLocaleValue();
        try (DLock dLock = DLock.create((String)("hrbm" + sourceBillNumber));){
            if (!dLock.tryLock()) {
                throw new HRBMBizException(String.format(Locale.ROOT, SharedTaskPoolEnum.CONCURRENT_TIP.get(), sourceBillName));
            }
            try {
                this.queryNumberInit((DynamicObject)dataEntity, sourceBill);
                this.createQueryConAndList((DynamicObject)dataEntity);
            }
            catch (Exception ex) {
                dLock.unlock();
                throw new HRBMBizException(ex.getMessage());
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Object[] logicEntitys = e.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])logicEntitys)) {
            return;
        }
        boolean success = this.sharedTaskPoolDomainService.syncCustomTaskPool((DynamicObject)logicEntitys[0]);
        if (!success) {
            throw new HRBMBizException(SharedTaskPoolEnum.SAVE_SUCCESS_AND_SYNC_FAIL.get());
        }
    }

    private void queryNumberInit(DynamicObject dataEntity, DynamicObject sourceBill) {
        List numberList = this.sharedTaskPoolDomainService.getAllShareTaskNumbers();
        dataEntity.set("processqueryconf", (Object)this.handleCode(sourceBill, "processqueryconf", numberList));
        dataEntity.set("processquerylist", (Object)this.handleCode(sourceBill, "processquerylist", numberList));
        dataEntity.set("finishqueryconf", (Object)this.handleCode(sourceBill, "finishqueryconf", numberList));
        dataEntity.set("finishquerylist", (Object)this.handleCode(sourceBill, "finishquerylist", numberList));
    }

    private void createQueryConAndList(DynamicObject taskPool) {
        QueryGenResult queryGenResult = (QueryGenResult)LogUtils.printTimeCostLog((String)"generation process query config/list ", () -> this.dynamicQueryApplicationService.generatePlatformQuery(this.sharedTaskPoolDomainService.buildGenParamForProcess(taskPool)));
        if (queryGenResult.isSuccess()) {
            queryGenResult = (QueryGenResult)LogUtils.printTimeCostLog((String)"generation finish query config/list ", () -> this.dynamicQueryApplicationService.generatePlatformQuery(this.sharedTaskPoolDomainService.buildGenParamForFinish(taskPool)));
            if (!queryGenResult.isSuccess()) {
                throw new HRBMBizException(SharedTaskPoolEnum.CREATE_QUERY_CONF_FAIL_TIP.get());
            }
        } else {
            throw new HRBMBizException(SharedTaskPoolEnum.CREATE_QUERY_CONF_FAIL_TIP.get());
        }
    }

    private String handleCode(DynamicObject sourceBill, String number, List<String> numberList) {
        StringBuilder sb;
        String isv = ISVServiceHelper.getISVInfo().getId();
        String sourceBillNumber = sourceBill.getString("number");
        String sourceBillNumberNoAppTag = sourceBillNumber.substring(sourceBillNumber.lastIndexOf("_") + 1);
        boolean isKingdee = true;
        if (HRStringUtils.equals((String)isv, (String)"kingdee")) {
            sb = new StringBuilder(HSTC_TAG);
        } else {
            sb = new StringBuilder(isv).append("_").append(HSTC_TAG);
            isKingdee = false;
        }
        sb.append(SORT_CODE).append(SUFFIX_MAP.get(number));
        int substrLeng = 25 - sb.length();
        if (sourceBillNumberNoAppTag.length() > substrLeng) {
            sourceBillNumberNoAppTag = sourceBillNumberNoAppTag.substring(0, substrLeng);
        }
        if (isKingdee) {
            sb.insert(HSTC_TAG.length(), sourceBillNumberNoAppTag);
        } else {
            sb.insert((isv + "_" + HSTC_TAG).length(), sourceBillNumberNoAppTag);
        }
        int maxSort = 0;
        for (String code : numberList) {
            int sortIndexBegin;
            String sortNumber;
            int tempMaxSort;
            String preffux;
            if (!code.startsWith(preffux = sb.substring(0, sb.indexOf(SORT_CODE))) || !code.endsWith(SUFFIX_MAP.get(number)) || (tempMaxSort = HRStringUtils.isEmpty((String)(sortNumber = code.substring(sortIndexBegin = preffux.length() + 2, sortIndexBegin + 2))) ? 0 : Integer.parseInt(sortNumber)) <= maxSort) continue;
            maxSort = tempMaxSort;
        }
        if (maxSort > 0) {
            return sb.toString().replace(PLACEHOLDER, String.format("%02d", maxSort + 1));
        }
        return sb.toString().replace(PLACEHOLDER, "01");
    }
}

