/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.formplugin.web.fileimport;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigCommonFieldBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubSceneBo;
import kd.hdtc.hrcc.common.MsgEnum.FileImportMsgEnum;
import kd.hdtc.hrcc.formplugin.web.handler.FileImportConfigFieldHandler;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;

public class FileImportConfigEditPlugin
extends HDTCDataBaseEdit
implements CellClickListener,
BeforeF7SelectListener {
    private static final Integer REL_TREE_MAX_LEVEL = 5;
    private static final String CHANGE_MAIN_ENTITY_CALL_BACK = "CHANGE_MAIN_ENTITY_CALL_BACK";
    private static final String CHANGE_TARGET_ENTITY_CALL_BACK = "CHANGE_TARGET_ENTITY_CALL_BACK";
    private static final String MAIN_ENTITY_OLD_VALUE_CACHE_KEY = "MAIN_ENTITY_OLD_VALUE_CACHE_KEY";
    private static final String TARGET_ENTITY_OLD_INDEX_CACHE_KEY = "TARGET_ENTITY_OLD_INDEX_CACHE_KEY";
    private static final String TARGET_ENTITY_OLD_VALUE_CACHE_KEY = "TARGET_ENTITY_OLD_VALUE_CACHE_KEY";
    private FileImportConfigFieldHandler fileImportConfigHandler;

    public void preOpenForm(PreOpenFormEventArgs e) {
        OperationStatus operationStatus = e.getFormShowParameter().getStatus();
        if (operationStatus == OperationStatus.EDIT) {
            e.getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
        super.preOpenForm(e);
    }

    public void initialize() {
        super.initialize();
        this.fileImportConfigHandler = new FileImportConfigFieldHandler(this.getView());
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        EntryGrid relEntryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        relEntryGrid.addCellClickListener((CellClickListener)this);
        EntryGrid configEntryGrid = (EntryGrid)this.getView().getControl("cfgentryentity");
        configEntryGrid.addCellClickListener((CellClickListener)this);
        EntryGrid showFieldEntryGrid = (EntryGrid)this.getView().getControl("showfieldentryentity");
        showFieldEntryGrid.addCellClickListener((CellClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.changeKeyField();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
        this.getView().updateView("showfieldentryentity");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        if ((StringUtils.equals((String)operateKey, (String)"newrelentry") || StringUtils.equals((String)operateKey, (String)"insertrelentry")) && !this.validateMainEntity()) {
            args.setCancel(true);
            return;
        }
        if (StringUtils.equals((String)"insertrelentry", (String)operateKey)) {
            DynamicObject currentRow;
            DynamicObjectCollection treeEntry = this.getModel().getEntryEntity("treeentryentity");
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
            DynamicObject dynamicObject = currentRow = CollectionUtils.isEmpty((Collection)treeEntry) ? null : (DynamicObject)treeEntry.get(entryCurrentRowIndex);
            if (currentRow == null) {
                return;
            }
            if (!this.validateAndGetInsertTip(currentRow)) {
                args.setCancel(true);
                return;
            }
            Long pid = currentRow.getLong("pid");
            if (this.getCurrentLayer(pid, treeEntry, 1) >= REL_TREE_MAX_LEVEL) {
                this.getView().showTipNotification(String.format(Locale.ROOT, FileImportMsgEnum.INSERT_UP_TO_MAX_LAYERS.get(), REL_TREE_MAX_LEVEL));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((String)"deletecolentry", (String)operateKey)) {
            String showColNumber;
            Set valueSet;
            DynamicObject currentRow;
            DynamicObjectCollection fieldEntry = this.getModel().getEntryEntity("showfieldentryentity");
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("showfieldentryentity");
            DynamicObject dynamicObject = currentRow = CollectionUtils.isEmpty((Collection)fieldEntry) ? null : (DynamicObject)fieldEntry.get(entryCurrentRowIndex);
            if (currentRow == null) {
                return;
            }
            String keyFields = this.getModel().getDataEntity().getString("keyfields");
            if (StringUtils.isNotEmpty((String)keyFields) && (valueSet = Arrays.stream(keyFields.split(",")).filter(data -> StringUtils.isNotEmpty((String)data)).collect(Collectors.toSet())).contains(showColNumber = currentRow.getString("showcolnumber"))) {
                this.getView().showErrorNotification(FileImportMsgEnum.CANNOT_DELETE_KEY_FIELD.get());
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        long pid;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        DynamicObjectCollection treeEntry = this.getModel().getEntryEntity("treeentryentity");
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("treeentryentity");
        DynamicObject currentSelectedRow = CollectionUtils.isEmpty((Collection)treeEntry) ? null : (DynamicObject)treeEntry.get(entryCurrentRowIndex);
        long l = pid = currentSelectedRow == null ? 0L : currentSelectedRow.getLong("pid");
        if (StringUtils.equals((String)operateKey, (String)"modify")) {
            this.getView().setStatus(OperationStatus.EDIT);
        } else if (StringUtils.equals((String)operateKey, (String)"newrelentry")) {
            if (pid == 0L) {
                String entityId = this.getView().getModel().getDataEntity().getString("mainentity.id");
                this.getModel().setValue("sourceentity", (Object)entityId, entryCurrentRowIndex);
            } else {
                if (currentSelectedRow == null) {
                    return;
                }
                int newRow = this.getModel().insertEntryRow("treeentryentity", currentSelectedRow.getInt("seq") - 1);
                this.getModel().setValue("sourceentity", (Object)currentSelectedRow.getDynamicObject("targetentity"), newRow);
            }
        } else if (StringUtils.equals((String)"insertrelentry", (String)operateKey)) {
            DynamicObject parentEntry = this.getRowById(pid);
            int parentRow = parentEntry.getInt("seq");
            this.getModel().setValue("sourceentity", (Object)parentEntry.getDynamicObject("targetentity"), entryCurrentRowIndex);
            this.enableOrDisableRelTreeRow(Boolean.FALSE, parentRow - 1);
        } else if (StringUtils.equals((String)"deleterelentry", (String)operateKey)) {
            this.changeKeyField();
            if (currentSelectedRow == null) {
                return;
            }
            Long id = currentSelectedRow.getLong("id");
            long subCount = treeEntry.stream().filter(entry -> entry.getLong("pid") == id.longValue()).count();
            if (subCount == 0L) {
                this.enableOrDisableRelTreeRow(Boolean.TRUE, currentSelectedRow.getInt("seq") - 1);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (StringUtils.equals((String)"mainentity", (String)propertyName)) {
            ChangeData changeData = e.getChangeSet()[0];
            Object oldValue = changeData.getOldValue();
            if (oldValue != null) {
                this.getView().showConfirm(FileImportMsgEnum.CHANGE_MAIN_ENTITY_CONFIRM.get(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHANGE_MAIN_ENTITY_CALL_BACK, (IFormPlugin)this));
                this.getPageCache().put(MAIN_ENTITY_OLD_VALUE_CACHE_KEY, ((DynamicObject)oldValue).getString("id"));
            } else {
                this.changeKeyField();
            }
        } else if (StringUtils.equals((String)"targetentity", (String)propertyName)) {
            ChangeData changeData = e.getChangeSet()[0];
            int entryCurrentRowIndex = changeData.getRowIndex();
            this.getModel().setValue("targetrelfield", null, entryCurrentRowIndex);
            Object oldValue = changeData.getOldValue();
            if (oldValue != null) {
                this.getView().showConfirm(FileImportMsgEnum.CHANGE_MAIN_ENTITY_CONFIRM.get(), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CHANGE_TARGET_ENTITY_CALL_BACK, (IFormPlugin)this));
                this.getPageCache().put(TARGET_ENTITY_OLD_VALUE_CACHE_KEY, ((DynamicObject)oldValue).getString("id"));
                this.getPageCache().put(TARGET_ENTITY_OLD_INDEX_CACHE_KEY, String.valueOf(entryCurrentRowIndex));
            }
        } else if (StringUtils.equals((String)"fieldnumber", (String)propertyName)) {
            ChangeData changeData = e.getChangeSet()[0];
            int entryCurrentRowIndex = changeData.getRowIndex();
            String fieldType = (String)this.getModel().getValue("fieldtype", entryCurrentRowIndex);
            String fieldNumber = (String)this.getModel().getValue("fieldnumber", entryCurrentRowIndex);
            FileImportSubSceneBo fileImportSubSceneBo = this.fileImportConfigHandler.getPropDetailFormCache(fieldNumber, fieldType);
            if (fileImportSubSceneBo != null) {
                this.getModel().setValue("num", (Object)fileImportSubSceneBo.getNum(), entryCurrentRowIndex);
                this.getModel().setValue("size", (Object)fileImportSubSceneBo.getSize(), entryCurrentRowIndex);
                this.getModel().setValue("format", (Object)fileImportSubSceneBo.getFormat(), entryCurrentRowIndex);
                this.getModel().setValue("issupportsame", (Object)fileImportSubSceneBo.isSupportSame(), entryCurrentRowIndex);
                this.getModel().setValue("specialide", (Object)fileImportSubSceneBo.getSpecialIde(), entryCurrentRowIndex);
                if (fileImportSubSceneBo.getNum() <= 1) {
                    this.getModel().setValue("issingleupdate", (Object)true, entryCurrentRowIndex);
                }
            }
        } else if (StringUtils.equals((String)"keyfields", (String)propertyName)) {
            ChangeData changeData = e.getChangeSet()[0];
            Object oldValue = changeData.getOldValue();
            Object newValue = changeData.getNewValue();
            this.syncToShowEntryEntity((String)oldValue, (String)newValue);
        } else if (StringUtils.equals((String)"showcolnumber", (String)propertyName)) {
            ChangeData changeData = e.getChangeSet()[0];
            int entryCurrentRowIndex = changeData.getRowIndex();
            String showColNumber = (String)this.getModel().getValue("showcolnumber", entryCurrentRowIndex);
            if (StringUtils.isEmpty((String)showColNumber)) {
                this.getModel().setValue("showcolname", null, entryCurrentRowIndex);
                this.getModel().setValue("showcolentity", null, entryCurrentRowIndex);
            } else {
                FileImportConfigCommonFieldBo fileImportConfigCommonFieldBo = this.fileImportConfigHandler.getFieldDetailFormCache(showColNumber);
                if (fileImportConfigCommonFieldBo != null) {
                    this.getModel().setValue("showcolname", (Object)fileImportConfigCommonFieldBo.getShowColName(), entryCurrentRowIndex);
                    this.getModel().setValue("showcolentity", (Object)fileImportConfigCommonFieldBo.getShowColEntity(), entryCurrentRowIndex);
                }
            }
        } else if (StringUtils.equals((String)"fieldtype", (String)propertyName)) {
            ChangeData changeData = e.getChangeSet()[0];
            int entryCurrentRowIndex = changeData.getRowIndex();
            this.getModel().setValue("fieldnumber", null, entryCurrentRowIndex);
            this.getModel().setValue("specialide", null, entryCurrentRowIndex);
            this.getModel().setValue("num", null, entryCurrentRowIndex);
            this.getModel().setValue("size", null, entryCurrentRowIndex);
            this.getModel().setValue("format", null, entryCurrentRowIndex);
            this.getModel().setValue("issupportsame", null, entryCurrentRowIndex);
            this.getModel().setValue("specialide", null, entryCurrentRowIndex);
            this.getModel().setValue("issingleupdate", (Object)false, entryCurrentRowIndex);
        }
        if (StringUtils.equals((String)"targetentity", (String)propertyName)) {
            this.changeKeyField();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject businessDomain;
        String fieldName = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((String)"childbusinessdomain", (String)fieldName) && (businessDomain = this.getModel().getDataEntity().getDynamicObject("businessdomain")) == null) {
            this.getView().showErrorNotification(FileImportMsgEnum.SELECT_BUSINESS_DOMAIN.get());
            beforeF7SelectEvent.setCancel(true);
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)CHANGE_MAIN_ENTITY_CALL_BACK, (String)callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getView().getModel().beginInit();
                this.getModel().deleteEntryData("treeentryentity");
                this.getModel().deleteEntryData("cfgentryentity");
                this.getModel().deleteEntryData("showfieldentryentity");
                this.cleanFieldColValue();
                this.changeKeyField();
                this.getView().getModel().endInit();
                this.getView().updateView("treeentryentity");
                this.getView().updateView("cfgentryentity");
                this.getView().updateView("showfieldentryentity");
            } else {
                String changeDataStr = this.getPageCache().get(MAIN_ENTITY_OLD_VALUE_CACHE_KEY);
                if (StringUtils.isNotEmpty((String)changeDataStr)) {
                    this.getView().getModel().beginInit();
                    this.getModel().setValue("mainentity", (Object)changeDataStr);
                    this.getView().getModel().endInit();
                    this.getView().updateView("mainentity");
                }
            }
        } else if (StringUtils.equals((String)CHANGE_TARGET_ENTITY_CALL_BACK, (String)callBackId)) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getView().getModel().beginInit();
                this.getModel().deleteEntryData("cfgentryentity");
                this.getModel().deleteEntryData("showfieldentryentity");
                this.cleanFieldColValue();
                this.changeKeyField();
                this.getView().getModel().endInit();
                this.getView().updateView("cfgentryentity");
                this.getView().updateView("showfieldentryentity");
            } else {
                String changeDataStr = this.getPageCache().get(TARGET_ENTITY_OLD_VALUE_CACHE_KEY);
                String changeDataIndex = this.getPageCache().get(TARGET_ENTITY_OLD_INDEX_CACHE_KEY);
                if (StringUtils.isNotEmpty((String)changeDataStr)) {
                    this.getView().getModel().beginInit();
                    this.getModel().setValue("targetentity", (Object)changeDataStr, Integer.parseInt(changeDataIndex));
                    this.getView().getModel().endInit();
                    this.getView().updateView("treeentryentity");
                }
            }
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        if (StringUtils.equals((String)fieldKey, (String)"sourcerelfield")) {
            Object sourceEntityObj = this.getModel().getValue("sourceentity", row);
            List<Object> items = new ArrayList(10);
            ComboEdit keyFieldEdit = (ComboEdit)this.getControl("sourcerelfield");
            if (!ObjectUtils.isEmpty((Object)sourceEntityObj)) {
                String entityNumber = ((DynamicObject)sourceEntityObj).getString("number");
                items = this.fileImportConfigHandler.getSingleEntityColList(entityNumber);
            }
            keyFieldEdit.setComboItems(items);
        } else if (StringUtils.equals((String)fieldKey, (String)"targetrelfield")) {
            List<Object> items = new ArrayList(10);
            ComboEdit keyFieldEdit = (ComboEdit)this.getControl("targetrelfield");
            Object targetEntityObj = this.getModel().getValue("targetentity", row);
            if (!ObjectUtils.isEmpty((Object)targetEntityObj)) {
                String entityNumber = ((DynamicObject)targetEntityObj).getString("number");
                items = this.fileImportConfigHandler.getSingleEntityColList(entityNumber);
            }
            keyFieldEdit.setComboItems(items);
        } else if (StringUtils.equals((String)fieldKey, (String)"fieldnumber")) {
            ComboEdit keyFieldEdit = (ComboEdit)this.getControl("fieldnumber");
            String fieldType = (String)this.getModel().getValue("fieldtype", row);
            List<ComboItem> items = this.fileImportConfigHandler.getAllEntityFileColListByType(fieldType);
            keyFieldEdit.setComboItems(items);
        } else if (StringUtils.equals((String)fieldKey, (String)"showcolnumber")) {
            List<ComboItem> itemList = this.fileImportConfigHandler.getAllEntityColList();
            ComboEdit keyFieldEdit = (ComboEdit)this.getControl("showcolnumber");
            DynamicObjectCollection showList = this.getModel().getEntryEntity("showfieldentryentity");
            if (CollectionUtils.isNotEmpty((Collection)showList)) {
                Set hasDataSet = showList.stream().map(data -> data.getString("showcolnumber")).filter(data -> StringUtils.isNotEmpty((String)data)).collect(Collectors.toSet());
                keyFieldEdit.setComboItems(itemList.stream().filter(data -> !hasDataSet.contains(data.getValue())).collect(Collectors.toList()));
            } else {
                keyFieldEdit.setComboItems(itemList);
            }
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }

    private void initData() {
        DynamicObjectCollection cfgCollection;
        DynamicObjectCollection showFieldCollection = this.getModel().getDataEntity().getDynamicObjectCollection("showfieldentryentity");
        if (showFieldCollection != null) {
            for (int index = 0; index < showFieldCollection.size(); ++index) {
                String showColNumber = ((DynamicObject)showFieldCollection.get(index)).getString("showcolnumber");
                FileImportConfigCommonFieldBo fileImportConfigCommonFieldBo = this.fileImportConfigHandler.getFieldDetailFormCache(showColNumber);
                if (fileImportConfigCommonFieldBo == null) continue;
                this.getModel().setValue("showcolname", (Object)fileImportConfigCommonFieldBo.getShowColName(), index);
                this.getModel().setValue("showcolentity", (Object)fileImportConfigCommonFieldBo.getShowColEntity(), index);
            }
        }
        if ((cfgCollection = this.getModel().getDataEntity().getDynamicObjectCollection("cfgentryentity")) != null) {
            for (int index = 0; index < cfgCollection.size(); ++index) {
                String fieldType = ((DynamicObject)cfgCollection.get(index)).getString("fieldtype");
                this.fileImportConfigHandler.getAllEntityFileColListByType(fieldType);
                String fieldNumber = ((DynamicObject)cfgCollection.get(index)).getString("fieldnumber");
                FileImportSubSceneBo fileImportSubSceneBo = this.fileImportConfigHandler.getPropDetailFormCache(fieldNumber, fieldType);
                if (fileImportSubSceneBo == null) continue;
                this.getModel().setValue("num", (Object)fileImportSubSceneBo.getNum(), index);
                this.getModel().setValue("size", (Object)fileImportSubSceneBo.getSize(), index);
                this.getModel().setValue("format", (Object)fileImportSubSceneBo.getFormat(), index);
                this.getModel().setValue("issupportsame", (Object)fileImportSubSceneBo.isSupportSame(), index);
            }
        }
    }

    private boolean validateAndGetInsertTip(DynamicObject currentRow) {
        ArrayList fieldNameList = Lists.newArrayListWithCapacity((int)3);
        if (currentRow.get("sourcerelfield") == null) {
            fieldNameList.add(FileImportMsgEnum.ENTITY_FIELD_TIP.get());
        }
        if (currentRow.get("targetentity") == null) {
            fieldNameList.add(FileImportMsgEnum.REL_ENTITY_NAME_TIP.get());
        }
        if (currentRow.get("targetrelfield") == null) {
            fieldNameList.add(FileImportMsgEnum.REL_ENTITY_FIELD_TIP.get());
        }
        if (CollectionUtils.isEmpty((Collection)fieldNameList)) {
            return true;
        }
        this.getView().showTipNotification(FileImportMsgEnum.PLEASE_WRITE_TIP.get() + fieldNameList.stream().collect(Collectors.joining(",")));
        return false;
    }

    private DynamicObject getRowById(Long id) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("treeentryentity");
        Optional<DynamicObject> entity = entryEntity.stream().filter(entry -> id.longValue() == entry.getLong("id")).findFirst();
        return entity.get();
    }

    private int getCurrentLayer(Long id, DynamicObjectCollection treeEntry, int layer) {
        if (id != 0L) {
            DynamicObject parentNode = treeEntry.stream().filter(node -> (long)id.compareTo(node.getLong("id")) == 0L).findFirst().get();
            return this.getCurrentLayer(parentNode.getLong("pid"), treeEntry, ++layer);
        }
        return layer;
    }

    private boolean validateMainEntity() {
        String entityNumber = this.getView().getModel().getDataEntity().getString("mainentity.id");
        if (StringUtils.isEmpty((String)entityNumber)) {
            this.getView().showErrorNotification(FileImportMsgEnum.MAIN_ENTITY_EMPTY.get());
            return false;
        }
        return true;
    }

    private void enableOrDisableRelTreeRow(Boolean coin, int index) {
        this.getView().setEnable(coin, index, new String[]{"targetentity", "sourcerelfield", "targetrelfield"});
    }

    private void changeKeyField() {
        List<ComboItem> itemList = this.fileImportConfigHandler.getAllEntityColList();
        ComboEdit keyFieldEdit = (ComboEdit)this.getControl("keyfields");
        keyFieldEdit.setComboItems(itemList);
    }

    private void cleanFieldColValue() {
        this.getView().getModel().setValue("keyfields", null);
        this.getView().updateView("keyfields");
    }

    private void syncToShowEntryEntity(String oldValue, String newValue) {
        DynamicObjectCollection showColEntryEntity = this.getModel().getEntryEntity("showfieldentryentity");
        List<Object> remainEntryEntityList = new ArrayList(10);
        if (CollectionUtils.isNotEmpty((Collection)showColEntryEntity) && StringUtils.isNotEmpty((String)oldValue)) {
            Set oldValueSet = Arrays.stream(oldValue.split(",")).filter(data -> StringUtils.isNotEmpty((String)data)).collect(Collectors.toSet());
            remainEntryEntityList = showColEntryEntity.stream().filter(showCol -> !oldValueSet.contains(showCol.getString("showcolnumber"))).collect(Collectors.toList());
        }
        this.getModel().beginInit();
        this.getModel().deleteEntryData("showfieldentryentity");
        if (StringUtils.isNotEmpty((String)newValue)) {
            List newValueList = Arrays.stream(newValue.split(",")).filter(data -> StringUtils.isNotEmpty((String)data)).collect(Collectors.toList());
            this.getModel().batchCreateNewEntryRow("showfieldentryentity", newValueList.size() + remainEntryEntityList.size());
            AtomicInteger index = new AtomicInteger();
            newValueList.stream().forEach(keyStr -> {
                this.getModel().setValue("showcolnumber", keyStr, index.get());
                FileImportConfigCommonFieldBo fileImportConfigCommonFieldBo = this.fileImportConfigHandler.getFieldDetailFormCache((String)keyStr);
                if (fileImportConfigCommonFieldBo != null) {
                    this.getModel().setValue("showcolname", (Object)fileImportConfigCommonFieldBo.getShowColName(), index.get());
                    this.getModel().setValue("showcolentity", (Object)fileImportConfigCommonFieldBo.getShowColEntity(), index.get());
                    index.getAndIncrement();
                }
            });
            if (CollectionUtils.isNotEmpty(remainEntryEntityList)) {
                remainEntryEntityList.stream().forEach(remainEntry -> {
                    this.getModel().setValue("showcolnumber", remainEntry.get("showcolnumber"), index.get());
                    this.getModel().setValue("showcolname", remainEntry.get("showcolname"), index.get());
                    this.getModel().setValue("showcolentity", remainEntry.get("showcolentity"), index.get());
                    index.getAndIncrement();
                });
            }
        }
        this.getModel().endInit();
        this.getView().updateView("showfieldentryentity");
    }
}

