/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.formplugin.web.fileimport;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.domain.fileimport.IFileImportTaskDomainService;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportTaskBean;
import kd.hdtc.hrcc.common.MsgEnum.FileImportMsgEnum;
import kd.hdtc.hrcc.common.enums.FileImportTaskDealStatusEnum;
import kd.hdtc.hrcc.formplugin.web.handler.FileImportDownloadFailMsgHandler;
import kd.hdtc.hrcc.formplugin.web.handler.ShowFieldValueHandler;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;

public class FileImportTaskInfoEditPlugin
extends HDTCDataBaseEdit {
    private static final String TASK_NAME_LABEL = "tasknamelabel";
    private static final String TASK_NUMBER_LABEL = "tasknumberlabel";
    private static final String SUCCESS_NUM_LABEL = "successnumlabel";
    private static final String FAIL_NUM_LABEL = "failnumlabel";
    private static final String EXPORT_FAIL_MSG = "exportfailmsg";
    private static final String CONTINUE_IMPORT = "continueimport";
    private static final String CONTINUE_TASK_CONFIRM = "CONTINUE_TASK_CONFIRM";
    private static final String DELETE_FILE = "deletefile";
    private static final String TASK_TYPE_CACHE_KEY = "taskType";
    private static final String SUCCESS_LABEL = "successlabel";
    private static final String ING_LABEL = "inglabel";
    private static final String FAIL_LABEL = "faillabel";
    private static final String ABORTED_LABEL = "abortedlabel";
    private IFileImportTaskDomainService fileImportTaskDomainServiceImpl = (IFileImportTaskDomainService)ServiceFactory.getService(IFileImportTaskDomainService.class);

    public void beforeBindData(EventObject e) {
        this.renderLabelValue();
        this.showAndHideLabel(this.getModel().getDataEntity().getString("taskstatus"));
        ShowFieldValueHandler showFieldValueHandler = new ShowFieldValueHandler(this.getView());
        showFieldValueHandler.renderData();
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)DELETE_FILE)) {
            this.validDelFileImport(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (StringUtils.equals((String)EXPORT_FAIL_MSG, (String)operateKey) && operationResult.isSuccess()) {
            FileImportDownloadFailMsgHandler fileImportDownloadFailMsgHandler = new FileImportDownloadFailMsgHandler(this.getView());
            fileImportDownloadFailMsgHandler.exportData();
        } else if (StringUtils.equals((String)CONTINUE_IMPORT, (String)operateKey) && operationResult.isSuccess()) {
            this.continueTask(this.getModel().getDataEntity().getLong("id"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)CONTINUE_TASK_CONFIRM, (String)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String taskId = messageBoxClosedEvent.getCustomVaule();
            this.fileImportTaskDomainServiceImpl.continueTask(Long.parseLong(taskId));
            this.getView().invokeOperation("refresh");
        }
    }

    private void validDelFileImport(BeforeDoOperationEventArgs args) {
        if (StringUtils.equals((String)"1", (String)this.getView().getPageCache().get(TASK_TYPE_CACHE_KEY))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5220\u9664\u9644\u4ef6\u7684\u4efb\u52a1\u4e0d\u80fd\u91cd\u590d\u5220\u9664\u3002", (String)"FileImportTaskInfoEditPlugin_0", (String)"hdtc-hrcc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("successentryentity");
        int[] selectRowArr = entryGrid.getSelectRows();
        if (selectRowArr == null || selectRowArr.length < 1) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u3002", (String)"FileImportTaskInfoEditPlugin_1", (String)"hdtc-hrcc-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        HashSet idxSet = new HashSet(16);
        Arrays.stream(selectRowArr).forEach(idxSet::add);
        AbstractOperate op = (AbstractOperate)args.getSource();
        DynamicObjectCollection successDynCol = this.getModel().getDataEntity(true).getDynamicObjectCollection("successentryentity");
        ArrayList<Long> successEntryPkIdList = new ArrayList<Long>(10);
        for (int i = 0; i < successDynCol.size(); ++i) {
            if (!idxSet.contains(i)) continue;
            successEntryPkIdList.add(((DynamicObject)successDynCol.get(i)).getLong("id"));
        }
        op.getOption().setVariableValue("successEntryPkIdList", JSONArray.toJSONString(successEntryPkIdList));
    }

    private void renderLabelValue() {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        if (dynamicObject != null) {
            this.setLabelValue(TASK_NAME_LABEL, dynamicObject.getString("config.name"));
            this.setLabelValue(TASK_NUMBER_LABEL, dynamicObject.getString("number"));
            FileImportTaskBean fileImportTaskBean = this.fileImportTaskDomainServiceImpl.getValidTaskInfoById(dynamicObject.getLong("id"));
            if (fileImportTaskBean != null) {
                this.setLabelValue(SUCCESS_NUM_LABEL, String.valueOf(fileImportTaskBean.getSuccessNum()));
                this.setLabelValue(FAIL_NUM_LABEL, String.valueOf(fileImportTaskBean.getFailNum()));
                this.getView().getPageCache().put(TASK_TYPE_CACHE_KEY, fileImportTaskBean.getTaskType());
                this.getModel().setValue("taskstatus", (Object)fileImportTaskBean.getTaskStatus());
            }
        }
    }

    private void setLabelValue(String labelCoin, String value) {
        Label labelApName = (Label)this.getView().getControl(labelCoin);
        if (labelApName != null) {
            labelApName.setText(value);
        }
    }

    private void continueTask(long taskId) {
        this.getView().showConfirm(FileImportMsgEnum.CONTINUE_TASK_CONFIRM.get(), null, MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(CONTINUE_TASK_CONFIRM, (IFormPlugin)this), null, String.valueOf(taskId));
    }

    private void showAndHideLabel(String status) {
        this.getView().setVisible(Boolean.FALSE, new String[]{SUCCESS_LABEL, ING_LABEL, FAIL_LABEL, ABORTED_LABEL});
        if (StringUtils.equals((String)FileImportTaskDealStatusEnum.EXECUTING.getStatus(), (String)status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ING_LABEL});
        } else if (StringUtils.equals((String)FileImportTaskDealStatusEnum.COMPLETE.getStatus(), (String)status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SUCCESS_LABEL});
        } else if (StringUtils.equals((String)FileImportTaskDealStatusEnum.FAIL.getStatus(), (String)status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{FAIL_LABEL});
        } else if (StringUtils.equals((String)FileImportTaskDealStatusEnum.ABORTED.getStatus(), (String)status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{ABORTED_LABEL});
        }
    }
}

