/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.formplugin.web.fileimport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.ext.form.control.CountDown;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.form.control.events.CountDownEvent;
import kd.bos.ext.form.control.events.CountDownListener;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.domain.fileimport.IFileImportTaskDomainService;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportTaskData;
import kd.hdtc.hrcc.common.MsgEnum.FileImportMsgEnum;
import kd.hdtc.hrcc.formplugin.web.utils.FileImportShowDetailUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;

public class FileImportTaskListPlugin
extends AbstractHDTCFormPlugin
implements CountDownListener {
    private IFileImportTaskDomainService fileImportTaskDomainServiceImpl = (IFileImportTaskDomainService)ServiceFactory.getService(IFileImportTaskDomainService.class);
    private static final String RANDOM = "random";
    private static final String SHOW_DATA = "showData";
    private static final String CUSTOM_CONTROL_AP = "customcontrolap";
    private static final String REFRESH = "refresh";
    private static final String TASK_SUM_LABEL = "tasksumlabel";
    private static final String EXECUTED_LABEL = "executedlabel";
    private static final String SUCCESS_LABEL = "successlabel";
    private static final String COUNT_DOWN_AP = "countdownap";
    private static final int DURATION_TIME = 10;
    private static final String SHOW_DETAIL = "showDetail";
    private static final String CHANG_CONFIG = "changConfig";
    private static final String CHANGE_PAGE_INFO = "changePageInfo";
    private static final String CONTINUE_TASK = "continueTask";
    private static final String CURRENT_PAGE = "currentPage";
    private static final String PAGE_SIZE = "pageSize";
    private static final String TOTAL_PAGE = "totalPage";
    private static final int INIT_PAGE_SIZE = 20;
    private static final int INIT_PAGE_INDEX = 1;
    private static final String CONFIG_NAME_CACHE_KEY = "CONFIG_NAME_CACHE_KEY";
    private static final String CONTINUE_TASK_CONFIRM = "CONTINUE_TASK_CONFIRM";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{REFRESH});
        CountDown countdown = (CountDown)this.getView().getControl(COUNT_DOWN_AP);
        countdown.addCountDownListener((CountDownListener)this);
    }

    public void onCountDownEnd(CountDownEvent evt) {
        CountDown countdown = (CountDown)this.getView().getControl(COUNT_DOWN_AP);
        this.initData();
        countdown.setDuration(10);
        super.onCountDownEnd(evt);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (HRStringUtils.equals((String)REFRESH, (String)source.getKey())) {
            this.initData();
        }
    }

    public void customEvent(CustomEventArgs e) {
        String eventName = e.getEventName();
        if (CHANGE_PAGE_INFO.equals(eventName)) {
            String jsonStr = e.getEventArgs();
            JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
            int currentPage = jsonObject.getInteger(CURRENT_PAGE);
            int pageSize = jsonObject.getInteger(PAGE_SIZE);
            this.putPageInfoToCache(currentPage, pageSize);
            this.initData();
        } else if (CONTINUE_TASK.equals(eventName)) {
            String taskId = e.getEventArgs();
            this.continueTask(taskId);
        } else if (SHOW_DETAIL.equals(eventName)) {
            String taskId = e.getEventArgs();
            this.showTaskDetail(taskId);
        } else if (CHANG_CONFIG.equals(eventName)) {
            String filterJson = e.getEventArgs();
            JSONArray jsonArray = JSONObject.parseArray((String)filterJson);
            HashSet queryConfigNameSet = new HashSet(16);
            jsonArray.stream().forEach(data -> {
                JSONArray filterArr;
                JSONObject json = (JSONObject)data;
                String code = json.getString("code");
                if (StringUtils.isNotEmpty((String)code) && StringUtils.equals((String)"configName", (String)code) && CollectionUtils.isNotEmpty((Collection)(filterArr = ((JSONObject)data).getJSONArray("filter")))) {
                    filterArr.stream().forEach(filter -> queryConfigNameSet.add(String.valueOf(filter)));
                }
            });
            this.getPageCache().put(CONFIG_NAME_CACHE_KEY, SerializationUtils.toJsonString(queryConfigNameSet));
            this.getPageCache().put(CURRENT_PAGE, String.valueOf(1));
            this.initData();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
        CountDown countdown = (CountDown)this.getView().getControl(COUNT_DOWN_AP);
        countdown.setDuration(10);
        countdown.start();
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)CONTINUE_TASK_CONFIRM, (String)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String taskId = messageBoxClosedEvent.getCustomVaule();
            this.fileImportTaskDomainServiceImpl.continueTask(Long.parseLong(taskId));
            this.initData();
        }
    }

    private void putPageInfoToCache(int currentPage, int pageSize) {
        this.getPageCache().put(CURRENT_PAGE, String.valueOf(currentPage));
        this.getPageCache().put(PAGE_SIZE, String.valueOf(pageSize));
    }

    private void initData() {
        Set configNameSet;
        String currentPageStr = this.getPageCache().get(CURRENT_PAGE);
        String pageSizeStr = this.getPageCache().get(PAGE_SIZE);
        int pageIndex = StringUtils.isEmpty((String)currentPageStr) ? 1 : Integer.parseInt(currentPageStr);
        int pageSize = StringUtils.isEmpty((String)pageSizeStr) ? 20 : Integer.parseInt(pageSizeStr);
        QFilter configNameFilter = null;
        String configNameFilterStr = this.getPageCache().get(CONFIG_NAME_CACHE_KEY);
        if (StringUtils.isNotEmpty((String)configNameFilterStr) && CollectionUtils.isNotEmpty((Collection)(configNameSet = (Set)SerializationUtils.fromJsonString((String)configNameFilterStr, Set.class)))) {
            configNameFilter = new QFilter("config.name", "in", (Object)configNameSet);
        }
        FileImportTaskData fileImportTaskData = this.fileImportTaskDomainServiceImpl.getAllValidTaskInfoList(configNameFilter, pageIndex - 1, pageSize);
        this.renderCustomApData(CUSTOM_CONTROL_AP, fileImportTaskData);
        this.setLabelValue(TASK_SUM_LABEL, String.valueOf(fileImportTaskData.getTotal()));
        this.setLabelValue(EXECUTED_LABEL, String.valueOf(fileImportTaskData.getIngCount()));
        this.setLabelValue(SUCCESS_LABEL, String.valueOf(fileImportTaskData.getCompleteCount()));
    }

    private void renderCustomApData(String apId, FileImportTaskData fileImportTaskData) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl(apId);
        if (customcontrol == null) {
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put(RANDOM, new SecureRandom().nextInt(10000000));
        result.put(SHOW_DATA, fileImportTaskData.getTaskList());
        result.put(CURRENT_PAGE, fileImportTaskData.getPageIndex() + 1);
        result.put(PAGE_SIZE, fileImportTaskData.getPageSize());
        result.put(TOTAL_PAGE, fileImportTaskData.getTotal());
        customcontrol.setData(result);
        this.getView().updateView(apId);
    }

    private void showTaskDetail(String taskId) {
        BaseShowParameter showParameter = FileImportShowDetailUtils.getShowMainNewParameter(this.getView(), taskId, "hrcc_fileimporttaskinfo", taskId);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void setLabelValue(String labelCoin, String value) {
        Label labelApName = (Label)this.getView().getControl(labelCoin);
        if (labelApName != null) {
            labelApName.setText(value);
        }
    }

    private void continueTask(String taskId) {
        this.getView().showConfirm(FileImportMsgEnum.CONTINUE_TASK_CONFIRM.get(), null, MessageBoxOptions.OKCancel, null, new ConfirmCallBackListener(CONTINUE_TASK_CONFIRM, (IFormPlugin)this), null, taskId);
    }
}

