/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.formplugin.web.fileimport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FlexBeforeClosedEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.domain.fileimport.IFileImportConfigDomainService;
import kd.hdtc.hrcc.business.domain.fileimport.entity.IFileImportTaskEntityService;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFileZipTaskBean;
import kd.hdtc.hrcc.formplugin.web.handler.ShowFieldValueHandler;
import kd.hdtc.hrcc.formplugin.web.utils.FileImportShowDetailUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;

public class FileImportUploadFileEditPlugin
extends HDTCDataBaseEdit
implements UploadListener {
    private static final String ATTACH_KEY = "attachmentpanelap";
    private final IFileImportConfigDomainService fileImportConfigDomainService = (IFileImportConfigDomainService)ServiceFactory.getService(IFileImportConfigDomainService.class);
    private IFileImportTaskEntityService fileImportTaskEntityService = (IFileImportTaskEntityService)ServiceFactory.getService(IFileImportTaskEntityService.class);

    public void registerListener(EventObject eventObject) {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl(ATTACH_KEY);
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        formOperate.getOption().setVariableValue("sceneConfInfo", this.getPageCache().get("sceneConfInfo"));
        if (StringUtils.equals((String)"save", (String)operateKey)) {
            int attachmentCount = (Integer)this.getModel().getValue("attachmentcountfield");
            if (attachmentCount == 0) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20zip\u683c\u5f0f\u538b\u7f29\u5305\u3002", (String)"FileImportUploadFileEditPlugin_1", (String)"hdtc-hrcc-formplugin", (Object[])new Object[0]));
                return;
            }
            formOperate.getOption().setVariableValue("operationkey", "save");
            formOperate.getOption().setVariableValue("allZipFileInfoList", this.getView().getPageCache().get("allZipFileInfoList"));
        } else if (StringUtils.equals((String)"prestep", (String)operateKey)) {
            if (this.getView().getModel().getDataChanged()) {
                this.showConfirm(new ConfirmCallBackListener("prestepbutton", (IFormPlugin)this));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((String)"closepage", (String)operateKey)) {
            if (this.getView().getModel().getDataChanged()) {
                this.showConfirm(new ConfirmCallBackListener("closepage", (IFormPlugin)this));
                args.setCancel(true);
            }
        } else if (StringUtils.equals((String)"startimport", (String)operateKey)) {
            formOperate.getOption().setVariableValue("operationkey", "startimport");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
    }

    public void flexBeforeClosed(FlexBeforeClosedEvent e) {
        super.flexBeforeClosed(e);
    }

    public void destory() {
        super.destory();
    }

    public void beforeBindData(EventObject e) {
        this.handleSceneTips();
        this.handleCtrlVisible(this.getView(), null);
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().getDataEntity(true).set("id", (Object)DB.genGlobalLongId());
        this.getModel().getDataEntity(true).set("name", this.getModel().getValue("number"));
        this.getModel().setDataChanged(false);
    }

    private void handleSceneTips() {
        Object primaryKeyValue = this.checkConfPkId();
        if (primaryKeyValue == null) {
            return;
        }
        FileImportConfigBo fileImportConfigBo = this.fileImportConfigDomainService.getConfigBoById(Long.valueOf(Long.parseLong(primaryKeyValue.toString())));
        if (fileImportConfigBo == null) {
            return;
        }
        this.getView().getPageCache().put("sceneConfInfo", JSONObject.toJSONString((Object)fileImportConfigBo));
        Label scenePromptLabel = (Label)this.getView().getControl("labelap");
        scenePromptLabel.setText(fileImportConfigBo.getPrompt());
    }

    private Object checkConfPkId() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object primaryKeyValue = params.get("confPkId");
        if (primaryKeyValue == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u573a\u666f\u914d\u7f6e\u3002", (String)"FileImportUploadFileEditPlugin_0", (String)"hdtc-hrcc-formplugin", (Object[])new Object[0]));
            return null;
        }
        return primaryKeyValue;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (StringUtils.equals((String)"save", (String)operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().updateView("tabap1");
            this.doStepAction(this.getView(), true);
            this.handleCtrlVisible(this.getView(), "save");
            ShowFieldValueHandler showFieldValueHandler = new ShowFieldValueHandler(this.getView());
            showFieldValueHandler.renderData();
        } else if (StringUtils.equals((String)"startimport", (String)operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.handleCtrlVisible(this.getView(), "startimport");
            String pageId = this.getView().getParentView() != null ? this.getView().getParentView().getPageId() : this.getView().getPageId();
            this.getView().showForm(FileImportShowDetailUtils.getSinglePageByShowParameter(pageId, "hrcc_tasklist", false));
            this.getView().close();
        }
    }

    private void showConfirm(ConfirmCallBackListener confirm) {
        this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"FileImportUploadFileEditPlugin_2", (String)"hdtc-hrcc-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, confirm);
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (StringUtils.equals((String)callBackId, (String)"prestepbutton") && event.getResult() == MessageBoxResult.Yes) {
            this.getModel().getDataEntity(true).getDynamicObjectCollection("successentryentity").clear();
            this.getModel().getDataEntity(true).getDynamicObjectCollection("failentryentity").clear();
            this.previous();
            this.handleCtrlVisible(this.getView(), "prestep");
        } else if (StringUtils.equals((String)callBackId, (String)"closepage") && event.getResult() == MessageBoxResult.Yes) {
            this.fileImportTaskEntityService.delete(this.getModel().getDataEntity(true).getPkValue());
            this.getView().close();
        }
    }

    public void afterUpload(UploadEvent evt) {
        ArrayList<FileImportFileZipTaskBean> allZipFileInfoList = new ArrayList<FileImportFileZipTaskBean>(10);
        for (Object url : evt.getUrls()) {
            Map fileMap = (Map)url;
            FileImportFileZipTaskBean fileImportZipFileInfoBean = new FileImportFileZipTaskBean((String)fileMap.get("name"), (String)fileMap.get("url"));
            allZipFileInfoList.add(fileImportZipFileInfoBean);
        }
        if (CollectionUtils.isNotEmpty(allZipFileInfoList)) {
            String allZipFileStr = this.getView().getPageCache().get("allZipFileInfoList");
            if (StringUtils.isNotEmpty((String)allZipFileStr)) {
                allZipFileInfoList.addAll(JSONArray.parseArray((String)allZipFileStr, FileImportFileZipTaskBean.class));
            }
            this.getView().getPageCache().put("allZipFileInfoList", JSONArray.toJSONString(allZipFileInfoList));
        }
    }

    public void click(EventObject evt) {
    }

    private void handleCtrlVisible(IFormView formView, String opKey) {
        String tabIndex = (String)formView.getFormShowParameter().getCustomParam("wizardTabIndex");
        if (StringUtils.equals((String)opKey, (String)"prestep") && StringUtils.equals((String)"0", (String)tabIndex)) {
            formView.setVisible(Boolean.FALSE, new String[]{"prestepbutton"});
            formView.setVisible(Boolean.FALSE, new String[]{"startimport"});
            formView.setVisible(Boolean.TRUE, new String[]{"nextstepbutton"});
            formView.setVisible(Boolean.TRUE, new String[]{"close"});
        } else if (StringUtils.equals((String)opKey, (String)"save") && StringUtils.equals((String)"1", (String)tabIndex)) {
            formView.setVisible(Boolean.TRUE, new String[]{"prestepbutton"});
            formView.setVisible(Boolean.TRUE, new String[]{"startimport"});
            formView.setVisible(Boolean.FALSE, new String[]{"nextstepbutton"});
            formView.setVisible(Boolean.TRUE, new String[]{"close"});
        } else if (StringUtils.equals((String)opKey, (String)"startimport")) {
            formView.setVisible(Boolean.FALSE, new String[]{"prestepbutton"});
            formView.setVisible(Boolean.FALSE, new String[]{"startimport"});
            formView.setVisible(Boolean.FALSE, new String[]{"nextstepbutton"});
            formView.setVisible(Boolean.FALSE, new String[]{"close"});
        } else {
            formView.setEnable(Boolean.FALSE, new String[]{"wizardap"});
            formView.setVisible(Boolean.FALSE, new String[]{"prestepbutton"});
            formView.setVisible(Boolean.FALSE, new String[]{"startimport"});
        }
    }

    private void previous() {
        this.doStepAction(this.getView(), false);
    }

    public void doStepAction(IFormView formView, boolean forward) {
        Tab tab = (Tab)formView.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        int tabIndex = 0;
        for (int i = 0; i < tab.getItems().size(); ++i) {
            Control control = (Control)tab.getItems().get(i);
            if (!control.getKey().equals(currentTab)) continue;
            if (forward) {
                tab.activeTab(((Control)tab.getItems().get(i + 1)).getKey());
                tabIndex = i + 1;
                break;
            }
            tab.activeTab(((Control)tab.getItems().get(i - 1)).getKey());
            tabIndex = i - 1;
            break;
        }
        formView.getFormShowParameter().setCustomParam("wizardTabIndex", (Object)(tabIndex + ""));
        this.getView().getModel().setDataChanged(false);
    }

    public void remove(UploadEvent evt) {
        Object[] urlArr = evt.getUrls();
        String allZipFileStr = this.getView().getPageCache().get("allZipFileInfoList");
        List fileImportFileZipTaskBeanList = null;
        if (StringUtils.isNotEmpty((String)allZipFileStr)) {
            fileImportFileZipTaskBeanList = JSONArray.parseArray((String)allZipFileStr, FileImportFileZipTaskBean.class);
        }
        if (fileImportFileZipTaskBeanList == null || fileImportFileZipTaskBeanList.size() < 1) {
            return;
        }
        for (Object urlObj : urlArr) {
            Map fileMap = (Map)urlObj;
            for (int i = fileImportFileZipTaskBeanList.size() - 1; i >= 0; --i) {
                FileImportFileZipTaskBean fileImportFileZipTaskBean = (FileImportFileZipTaskBean)fileImportFileZipTaskBeanList.get(i);
                if (!StringUtils.equals((String)fileImportFileZipTaskBean.getZipFileName(), (String)((String)fileMap.get("name")))) continue;
                fileImportFileZipTaskBeanList.remove(fileImportFileZipTaskBean);
            }
        }
        this.getView().getPageCache().put("allZipFileInfoList", JSONArray.toJSONString((Object)fileImportFileZipTaskBeanList));
    }
}

