/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.formplugin.web.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboItem;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigCommonFieldBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubSceneBo;
import kd.hdtc.hrcc.business.domain.fileimport.utils.EntityFieldDealUtils;
import kd.hdtc.hrcc.common.enums.FileFieldTypeEnum;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class FileImportConfigFieldHandler {
    private static final String SINGLE_CACHE_KEY = "SINGLE_CACHE_KEY";
    private static final String SINGLE_CACHE_KEY_DETAIL = "SINGLE_CACHE_KEY_DETAIL";
    private static final String PRE_CACHE_KEY_FULL = "PRE_CACHE_KEY_FULL";
    private static final String PRE_CACHE_KEY_FULL_DETAIL = "PRE_CACHE_KEY_FULL_DETAIL";
    private static final String PRE_CACHE_KEY_PICTURE = "PRE_CACHE_KEY_PICTURE";
    private static final String PRE_CACHE_KEY_PICTURE_DETAIL = "PRE_CACHE_KEY_PICTURE_DETAIL";
    private static final String PRE_CACHE_KEY_ATTACHMENT = "PRE_CACHE_KEY_ATTACHMENT";
    private static final String PRE_CACHE_KEY_ATTACHMENT_DETAIL = "PRE_CACHE_KEY_ATTACHMENT_DETAIL";
    private static final String PRE_CACHE_KEY_ATTACHMENT_AP = "PRE_CACHE_KEY_ATTACHMENT_AP";
    private static final String PRE_CACHE_KEY_ATTACHMENT_AP_DETAIL = "PRE_CACHE_KEY_ATTACHMENT_AP_DETAIL";
    private IFormView formView;

    public FileImportConfigFieldHandler(IFormView view) {
        this.formView = view;
    }

    public List<ComboItem> getSingleEntityColList(String entityNumber) {
        return this.getComboItemListFromCache(entityNumber, SINGLE_CACHE_KEY);
    }

    public List<ComboItem> getAllEntityColList() {
        Set<String> numberList = this.getAllEntityNumberList();
        List<ComboItem> itemList = this.getAllEntityColList(numberList);
        return itemList;
    }

    public List<ComboItem> getAllEntityFileColListByType(String type) {
        if (StringUtils.isEmpty((String)type)) {
            return null;
        }
        Set<String> numberList = this.getAllEntityNumberList();
        List<ComboItem> itemList = null;
        if (StringUtils.equals((String)FileFieldTypeEnum.PICTURE.getType(), (String)type)) {
            itemList = this.getAllEntityFileColList(numberList, PRE_CACHE_KEY_PICTURE);
        } else if (StringUtils.equals((String)FileFieldTypeEnum.ATTACHMENT_FIELD.getType(), (String)type)) {
            itemList = this.getAllEntityFileColList(numberList, PRE_CACHE_KEY_ATTACHMENT);
        } else if (StringUtils.equals((String)FileFieldTypeEnum.ATTACHMENT_PANEL.getType(), (String)type)) {
            itemList = this.getAllEntityFileColList(numberList, PRE_CACHE_KEY_ATTACHMENT_AP);
        }
        return itemList;
    }

    public FileImportConfigCommonFieldBo getFieldDetailFormCache(String bizKey) {
        String propStr = this.formView.getPageCache().get(this.buildCacheKey(PRE_CACHE_KEY_FULL_DETAIL, bizKey));
        if (StringUtils.isEmpty((String)propStr)) {
            return null;
        }
        FileImportConfigCommonFieldBo fileImportConfigCommonFieldBo = (FileImportConfigCommonFieldBo)SerializationUtils.fromJsonString((String)propStr, FileImportConfigCommonFieldBo.class);
        return fileImportConfigCommonFieldBo;
    }

    public FileImportSubSceneBo getPropDetailFormCache(String bizKey, String type) {
        String propStr = null;
        if (StringUtils.equals((String)FileFieldTypeEnum.PICTURE.getType(), (String)type)) {
            propStr = this.formView.getPageCache().get(this.buildCacheKey(PRE_CACHE_KEY_PICTURE_DETAIL, bizKey));
        } else if (StringUtils.equals((String)FileFieldTypeEnum.ATTACHMENT_FIELD.getType(), (String)type)) {
            propStr = this.formView.getPageCache().get(this.buildCacheKey(PRE_CACHE_KEY_ATTACHMENT_DETAIL, bizKey));
        } else if (StringUtils.equals((String)FileFieldTypeEnum.ATTACHMENT_PANEL.getType(), (String)type)) {
            propStr = this.formView.getPageCache().get(this.buildCacheKey(PRE_CACHE_KEY_ATTACHMENT_AP_DETAIL, bizKey));
        }
        if (StringUtils.isEmpty((String)propStr)) {
            return null;
        }
        FileImportSubSceneBo fileImportSubSceneBo = (FileImportSubSceneBo)SerializationUtils.fromJsonString((String)propStr, FileImportSubSceneBo.class);
        return fileImportSubSceneBo;
    }

    private String buildCacheKey(String cacheKye, String spacialCoin) {
        return cacheKye + "&" + spacialCoin;
    }

    private List<ComboItem> getAllEntityFileColList(Set<String> entityNumberList, String cacheKey) {
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(10);
        if (CollectionUtils.isEmpty(entityNumberList)) {
            return itemList;
        }
        entityNumberList.stream().forEach(entityNumber -> {
            List<ComboItem> currentEntityColList = this.getComboItemListFromCache((String)entityNumber, cacheKey);
            if (CollectionUtils.isNotEmpty(currentEntityColList)) {
                itemList.addAll(currentEntityColList);
            }
        });
        return itemList;
    }

    private List<ComboItem> getAllEntityColList(Set<String> entityNumberList) {
        ArrayList<ComboItem> itemList = new ArrayList<ComboItem>(10);
        if (CollectionUtils.isEmpty(entityNumberList)) {
            return itemList;
        }
        entityNumberList.stream().forEach(entityNumber -> {
            List<ComboItem> currentEntityColList = this.getComboItemListFromCache((String)entityNumber, PRE_CACHE_KEY_FULL);
            if (CollectionUtils.isNotEmpty(currentEntityColList)) {
                itemList.addAll(currentEntityColList);
            }
        });
        return itemList;
    }

    private List<ComboItem> getComboItemListFromCache(String entityNumber, String cacheKey) {
        String relCacheKey = this.buildCacheKey(cacheKey, entityNumber);
        String cacheComboItemsStr = this.formView.getPageCache().get(relCacheKey);
        List<ComboItem> itemList = StringUtils.isEmpty((String)cacheComboItemsStr) ? this.getComboItemListFromDbAndPutToCache(entityNumber, cacheKey) : SerializationUtils.fromJsonStringToList((String)cacheComboItemsStr, ComboItem.class);
        return itemList;
    }

    private List<ComboItem> getComboItemListFromDbAndPutToCache(String entityNumber, String cacheKey) {
        List itemList = new ArrayList(10);
        String relCacheKey = this.buildCacheKey(cacheKey, entityNumber);
        if (StringUtils.equals((String)cacheKey, (String)SINGLE_CACHE_KEY)) {
            itemList = EntityFieldDealUtils.initComboFieldVal((String)entityNumber, (valueKey, prop) -> {
                if (prop instanceof BasedataProp) {
                    this.buildBaseDataPropBo(SINGLE_CACHE_KEY_DETAIL, (String)valueKey, (BasedataProp)prop, entityNumber);
                } else {
                    FileImportConfigCommonFieldBo fileImportConfigCommonFieldBo = new FileImportConfigCommonFieldBo();
                    fileImportConfigCommonFieldBo.setShowColNumber(prop.getName());
                    if (prop.getDisplayName() != null) {
                        fileImportConfigCommonFieldBo.setShowColName(prop.getDisplayName().getLocaleValue());
                    }
                    fileImportConfigCommonFieldBo.setShowColEntity(entityNumber);
                    this.formView.getPageCache().put(this.buildCacheKey(SINGLE_CACHE_KEY_DETAIL, (String)valueKey), SerializationUtils.toJsonString((Object)fileImportConfigCommonFieldBo));
                }
            });
        } else if (StringUtils.equals((String)cacheKey, (String)PRE_CACHE_KEY_FULL)) {
            itemList = EntityFieldDealUtils.initComboFullFieldVal((String)entityNumber, (valueKey, prop) -> {
                if (prop instanceof BasedataProp) {
                    this.buildBaseDataPropBo(PRE_CACHE_KEY_FULL_DETAIL, (String)valueKey, (BasedataProp)prop, entityNumber);
                } else {
                    FileImportConfigCommonFieldBo fileImportConfigCommonFieldBo = new FileImportConfigCommonFieldBo();
                    fileImportConfigCommonFieldBo.setShowColNumber(prop.getName());
                    if (prop.getDisplayName() != null) {
                        fileImportConfigCommonFieldBo.setShowColName(prop.getDisplayName().getLocaleValue());
                    }
                    fileImportConfigCommonFieldBo.setShowColEntity(entityNumber);
                    this.formView.getPageCache().put(this.buildCacheKey(PRE_CACHE_KEY_FULL_DETAIL, (String)valueKey), SerializationUtils.toJsonString((Object)fileImportConfigCommonFieldBo));
                }
            });
        } else if (StringUtils.equals((String)cacheKey, (String)PRE_CACHE_KEY_PICTURE)) {
            itemList = EntityFieldDealUtils.getComboPictureVal((String)entityNumber, (valueKey, prop) -> {
                FileImportSubSceneBo fileImportSubSceneBo = new FileImportSubSceneBo();
                fileImportSubSceneBo.setNum(1);
                fileImportSubSceneBo.setSize(prop.getMaxImgSize());
                fileImportSubSceneBo.setSingleUpdate(true);
                fileImportSubSceneBo.setSpecialIde(prop.getName());
                this.formView.getPageCache().put(this.buildCacheKey(PRE_CACHE_KEY_PICTURE_DETAIL, (String)valueKey), SerializationUtils.toJsonString((Object)fileImportSubSceneBo));
            });
        } else if (StringUtils.equals((String)cacheKey, (String)PRE_CACHE_KEY_ATTACHMENT)) {
            itemList = EntityFieldDealUtils.getComboAttachmentVal((String)entityNumber, (valueKey, prop) -> {
                FileImportSubSceneBo fileImportSubSceneBo = new FileImportSubSceneBo();
                fileImportSubSceneBo.setNum(prop.getMaxAtmCount());
                fileImportSubSceneBo.setSize(prop.getMaxAtmSize());
                fileImportSubSceneBo.setFormat(prop.getExtendName());
                fileImportSubSceneBo.setSupportSame(!prop.getCheckDuplicateFileName());
                fileImportSubSceneBo.setSpecialIde(prop.getName());
                this.formView.getPageCache().put(this.buildCacheKey(PRE_CACHE_KEY_ATTACHMENT_DETAIL, (String)valueKey), SerializationUtils.toJsonString((Object)fileImportSubSceneBo));
            });
        } else if (StringUtils.equals((String)cacheKey, (String)PRE_CACHE_KEY_ATTACHMENT_AP)) {
            itemList = EntityFieldDealUtils.getComboAttachmentApVal((String)entityNumber, (valueKey, prop) -> {
                FileImportSubSceneBo fileImportSubSceneBo = new FileImportSubSceneBo();
                fileImportSubSceneBo.setNum(prop.getMaxAtmCount());
                fileImportSubSceneBo.setSize(prop.getMaxAtmSize());
                fileImportSubSceneBo.setFormat(prop.getExtendName());
                fileImportSubSceneBo.setSupportSame(!prop.getCheckDuplicateFileName());
                fileImportSubSceneBo.setSpecialIde(prop.getKey());
                this.formView.getPageCache().put(this.buildCacheKey(PRE_CACHE_KEY_ATTACHMENT_AP_DETAIL, (String)valueKey), SerializationUtils.toJsonString((Object)fileImportSubSceneBo));
            });
        }
        this.formView.getPageCache().put(relCacheKey, SerializationUtils.toJsonString(itemList));
        return itemList;
    }

    private void buildBaseDataPropBo(String cachePre, String valueKey, BasedataProp prop, String entityNumber) {
        String dName;
        String displayName = prop.getDisplayName() == null ? "" : prop.getDisplayName().getLocaleValue();
        StringBuilder valueId = new StringBuilder(valueKey).append(".").append("id");
        FileImportConfigCommonFieldBo fileImportConfigCommonFieldBoId = new FileImportConfigCommonFieldBo();
        fileImportConfigCommonFieldBoId.setShowColNumber(prop.getName());
        fileImportConfigCommonFieldBoId.setShowColName(displayName + "id");
        fileImportConfigCommonFieldBoId.setShowColEntity(entityNumber);
        this.formView.getPageCache().put(this.buildCacheKey(cachePre, valueId.toString()), SerializationUtils.toJsonString((Object)fileImportConfigCommonFieldBoId));
        if (StringUtils.isNotEmpty((String)prop.getNumberProp())) {
            StringBuilder valueNumber = new StringBuilder(valueKey).append(".").append(prop.getNumberProp());
            FileImportConfigCommonFieldBo fileImportConfigCommonFieldBoNumber = new FileImportConfigCommonFieldBo();
            fileImportConfigCommonFieldBoNumber.setShowColNumber(prop.getName());
            dName = prop.getNumbProp() == null ? prop.getNumberProp() : prop.getNumbProp().getDisplayName().toString();
            fileImportConfigCommonFieldBoNumber.setShowColName(displayName + dName);
            fileImportConfigCommonFieldBoNumber.setShowColEntity(entityNumber);
            this.formView.getPageCache().put(this.buildCacheKey(cachePre, valueNumber.toString()), SerializationUtils.toJsonString((Object)fileImportConfigCommonFieldBoNumber));
        }
        if (StringUtils.isNotEmpty((String)prop.getDisplayProp())) {
            StringBuilder valueName = new StringBuilder(valueKey).append(".").append(prop.getDisplayProp());
            FileImportConfigCommonFieldBo fileImportConfigCommonFieldBoName = new FileImportConfigCommonFieldBo();
            fileImportConfigCommonFieldBoName.setShowColNumber(prop.getName());
            dName = prop.getDispProp() == null ? prop.getDisplayProp() : prop.getDispProp().getDisplayName().toString();
            fileImportConfigCommonFieldBoName.setShowColName(displayName + dName);
            fileImportConfigCommonFieldBoName.setShowColEntity(entityNumber);
            this.formView.getPageCache().put(this.buildCacheKey(cachePre, valueName.toString()), SerializationUtils.toJsonString((Object)fileImportConfigCommonFieldBoName));
        }
    }

    private Set<String> getAllEntityNumberList() {
        HashSet<String> entitySet = new HashSet<String>(16);
        String mainEntityNumber = this.formView.getModel().getDataEntity().getString("mainentity.id");
        if (StringUtils.isEmpty((String)mainEntityNumber)) {
            return entitySet;
        }
        entitySet.add(mainEntityNumber);
        DynamicObjectCollection treeEntry = this.formView.getModel().getEntryEntity("treeentryentity");
        if (CollectionUtils.isEmpty((Collection)treeEntry)) {
            return entitySet;
        }
        treeEntry.forEach(entry -> {
            String entryNumber = entry.getString("targetentity.number");
            if (StringUtils.isNotEmpty((String)entryNumber)) {
                entitySet.add(entryNumber);
            }
        });
        return entitySet;
    }
}

