/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.formplugin.web.handler;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrcc.common.MsgEnum.FileImportMsgEnum;
import kd.hdtc.hrcc.common.enums.FileImportSubTaskDealStatusEnum;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.FileUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class FileImportDownloadFailMsgHandler {
    private static final Log Logger = LogFactory.getLog(FileImportDownloadFailMsgHandler.class);
    private IFormView formView;

    public FileImportDownloadFailMsgHandler(IFormView view) {
        this.formView = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportData() {
        long pkId = this.formView.getModel().getDataEntity().getLong("id");
        String taskNumber = this.formView.getModel().getDataEntity().getString("number");
        Logger.info("FileImportDownloadFailMsgHandler exportData start id:{} taskNumber:{}", (Object)pkId, (Object)taskNumber);
        if (pkId == 0L || StringUtils.isEmpty((String)taskNumber)) {
            this.formView.showTipNotification(FileImportMsgEnum.DOWNLOAD_DATA_IS_INVALID.get());
            return;
        }
        DynamicObjectCollection dynamicCollection = this.formView.getModel().getDataEntity().getDynamicObjectCollection("successentryentity");
        List<DynamicObject> executeFailList = dynamicCollection.stream().filter(data -> StringUtils.equals((String)data.getString("dealstatus"), (String)FileImportSubTaskDealStatusEnum.FAIL.getStatus())).collect(Collectors.toList());
        DynamicObjectCollection validateFailDynamicCollection = this.formView.getModel().getDataEntity().getDynamicObjectCollection("failentryentity");
        if (CollectionUtils.isEmpty(executeFailList) && CollectionUtils.isEmpty((Collection)validateFailDynamicCollection)) {
            this.formView.showTipNotification(FileImportMsgEnum.DOWNLOAD_DATA_IS_NULL.get());
            return;
        }
        String fileName = this.getExcelFileName(taskNumber);
        File file = FileUtils.createFile(null, (String)fileName);
        XSSFWorkbook workbook = new XSSFWorkbook();
        this.createFailMsg((Workbook)workbook, validateFailDynamicCollection, executeFailList);
        InputStream subFileInput = null;
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            workbook.write((OutputStream)outputStream);
            subFileInput = Files.newInputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);
            String tempFileUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(file.getName(), subFileInput, 60);
            this.formView.download(tempFileUrl);
        }
        catch (IOException ex) {
            Logger.error("FileImportDownloadFailMsgHandler exportData error", (Throwable)ex);
            FileUtils.deleteLocalFile((File)file);
        }
        finally {
            try {
                if (subFileInput != null) {
                    subFileInput.close();
                }
                workbook.close();
            }
            catch (IOException exception) {
                Logger.error("FileImportDownloadFailMsgHandler exportData close workbook error", (Throwable)exception);
            }
        }
    }

    private String getExcelFileName(String taskNumber) {
        StringBuilder fileName = new StringBuilder(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4efb\u52a1(%1$s)\u5931\u8d25\u4fe1\u606f", (String)"FileImportDownloadFailMsgHandler_1", (String)"hdtc-hrcc-formplugin", (Object[])new Object[0]), taskNumber));
        return fileName.append(".xlsx").toString();
    }

    private void createFailMsg(Workbook workbook, DynamicObjectCollection validateFailDynamicCollection, List<DynamicObject> executeFailList) {
        Sheet sheet = workbook.createSheet(ResManager.loadKDString((String)"\u5b50\u4efb\u52a1\u6267\u884c\u5931\u8d25\u4fe1\u606f", (String)"FileImportDownloadFailMsgHandler_3", (String)"hdtc-hrcc-formplugin", (Object[])new Object[0]));
        Row row = sheet.createRow(0);
        this.createHeaderCell(workbook, row, (Pair<Integer, String>)Pair.of((Object)0, (Object)ResManager.loadKDString((String)"zip\u5305", (String)"FileImportDownloadFailMsgHandler_ValidateFail_0", (String)"hdtc-hrcc-formplugin", (Object[])new Object[0])));
        this.createHeaderCell(workbook, row, (Pair<Integer, String>)Pair.of((Object)1, (Object)ResManager.loadKDString((String)"\u6587\u4ef6\u540d", (String)"FileImportDownloadFailMsgHandler_ValidateFail_1", (String)"hdtc-hrcc-formplugin", (Object[])new Object[0])));
        this.createHeaderCell(workbook, row, (Pair<Integer, String>)Pair.of((Object)2, (Object)ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"FileImportDownloadFailMsgHandler_ValidateFail_2", (String)"hdtc-hrcc-formplugin", (Object[])new Object[0])));
        sheet.setColumnWidth(0, 2560);
        sheet.setColumnWidth(1, 12800);
        sheet.setColumnWidth(2, 25600);
        AtomicInteger index = new AtomicInteger(1);
        if (CollectionUtils.isNotEmpty((Collection)validateFailDynamicCollection)) {
            validateFailDynamicCollection.stream().forEach(data -> {
                Row dataRow = sheet.createRow(index.getAndIncrement());
                this.createCell(workbook, dataRow, (Pair<Integer, String>)Pair.of((Object)0, (Object)data.getString("failzipname")));
                this.createCell(workbook, dataRow, (Pair<Integer, String>)Pair.of((Object)1, (Object)data.getString("failfilename")));
                this.createCell(workbook, dataRow, (Pair<Integer, String>)Pair.of((Object)2, (Object)data.getString("failmsg")));
            });
        }
        if (CollectionUtils.isNotEmpty(executeFailList)) {
            executeFailList.stream().forEach(data -> {
                Row dataRow = sheet.createRow(index.getAndIncrement());
                this.createCell(workbook, dataRow, (Pair<Integer, String>)Pair.of((Object)0, (Object)data.getString("zipname")));
                this.createCell(workbook, dataRow, (Pair<Integer, String>)Pair.of((Object)1, (Object)data.getString("filename")));
                this.createCell(workbook, dataRow, (Pair<Integer, String>)Pair.of((Object)2, (Object)data.getString("msg")));
            });
        }
    }

    private void createHeaderCell(Workbook workbook, Row row, Pair<Integer, String> showMsg) {
        Cell cellMsg = row.createCell(((Integer)showMsg.getLeft()).intValue());
        cellMsg.setCellValue((String)showMsg.getRight());
        CellStyle cellStyle = this.getHeaderCellStyle(workbook);
        cellMsg.setCellStyle(cellStyle);
    }

    private void createCell(Workbook workbook, Row row, Pair<Integer, String> showMsg) {
        Cell cellMsg = row.createCell(((Integer)showMsg.getLeft()).intValue());
        cellMsg.setCellValue((String)showMsg.getRight());
    }

    private CellStyle getHeaderCellStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        style.setFont(headerFont);
        return style;
    }
}

