/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.formplugin.web.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFieldBo;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class ShowFieldValueHandler {
    private static final Log LOGGER = LogFactory.getLog(ShowFieldValueHandler.class);
    private IFormView formView;

    public ShowFieldValueHandler(IFormView view) {
        this.formView = view;
    }

    public void renderData() {
        DynamicObject dynamicObject = this.formView.getModel().getDataEntity();
        if (dynamicObject == null) {
            return;
        }
        String showField = DynamicObjectUtils.getBigText((DynamicObject)dynamicObject, (String)"showfield");
        if (StringUtils.isEmpty((String)showField)) {
            return;
        }
        try {
            DynamicObjectCollection successCollection;
            int index;
            List info = JSONObject.parseArray((String)showField, FileImportFieldBo.class);
            Set entityNumberSet = info.stream().map(FileImportFieldBo::getEntityNumber).collect(Collectors.toSet());
            EntryGrid grid = (EntryGrid)this.formView.getControl("successentryentity");
            if (grid == null) {
                return;
            }
            HashMap<String, String> longNumberMap = new HashMap<String, String>(info.size());
            if (grid != null) {
                FileImportFieldBo fileImportFieldBo2;
                DynamicProperty dynamicProperty;
                int showNum = 0;
                for (index = 0; index < info.size() && index < 8 && (dynamicProperty = this.getPropInfoByEntityNumber((fileImportFieldBo2 = (FileImportFieldBo)info.get(index)).getEntityNumber(), fileImportFieldBo2.getFiledNumber())) != null; ++index) {
                    LocaleString disPlayName = dynamicProperty.getDisplayName();
                    disPlayName = StringUtils.isEmpty((String)disPlayName.getLocaleValue()) ? new LocaleString(dynamicProperty.getName()) : disPlayName;
                    String showFieldCoin = "field" + (index + 1);
                    grid.setColumnProperty(showFieldCoin, "header", (Object)disPlayName);
                    longNumberMap.put(fileImportFieldBo2.getFullFiledNumber(), showFieldCoin);
                    ++showNum;
                }
                this.formView.getModel().setValue("shownum", (Object)(showNum > 8 ? 8 : showNum));
            }
            if (CollectionUtils.isNotEmpty((Collection)(successCollection = dynamicObject.getDynamicObjectCollection("successentryentity")))) {
                index = 0;
                while (index < successCollection.size()) {
                    DynamicObject successData = (DynamicObject)successCollection.get(index);
                    String showValue = DynamicObjectUtils.getBigText((DynamicObject)successData, (String)"showvalue");
                    if (StringUtils.isEmpty((String)showValue)) {
                        return;
                    }
                    List fileImportFieldBoList = JSONObject.parseArray((String)showValue, FileImportFieldBo.class);
                    int finalIndex = index++;
                    fileImportFieldBoList.stream().forEach(fileImportFieldBo -> {
                        String showFieldCoin = (String)longNumberMap.get(fileImportFieldBo.getFullFiledNumber());
                        if (StringUtils.isEmpty((String)showFieldCoin)) {
                            return;
                        }
                        this.formView.getModel().setValue(showFieldCoin, (Object)fileImportFieldBo.getValue(), finalIndex);
                    });
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("ShowFieldValueHandler error", ex.getCause());
            LOGGER.error(ex.getMessage());
        }
    }

    private Map<String, MainEntityType> getEntityTypeMap(Set<String> entitySet) {
        HashMap<String, MainEntityType> entityTypeMap = new HashMap<String, MainEntityType>(entitySet.size());
        entitySet.stream().forEach(entityNumber -> {
            MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
            entityTypeMap.put((String)entityNumber, mainEntityType);
        });
        return entityTypeMap;
    }

    private DynamicProperty getPropInfoByEntityNumber(String entityNumber, String fullPropNumber) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        if (fullPropNumber.indexOf(".") <= 0) {
            return mainEntityType.getProperty(fullPropNumber);
        }
        String[] numberArr = fullPropNumber.split("\\.", 2);
        DynamicProperty prop = mainEntityType.getProperty(numberArr[0]);
        if (prop == null) {
            return null;
        }
        if (prop instanceof BasedataProp) {
            BasedataProp basedataProp = (BasedataProp)prop;
            prop = this.getPropInfoByEntityNumber(basedataProp.getBaseEntityId(), numberArr[1]);
        }
        return prop;
    }
}

