/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.formplugin.web.transferconf;

import com.google.common.collect.ImmutableList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.domain.transfer.configitem.IConfigItemDomainService;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfItemCountCardPlugin
extends GridCardPlugin {
    private static final String VI = "vi";
    private static final String WAITING_IMAGE = "/images/pc/other/xtfw_loading_32_32.gif";
    private static final String REFRESHCOUNT = "refreshcount";
    private static final String REFRESH_CARD = "refreshCard";
    private static final String CONTENT = "content";
    private static final List<String> COUNT_NUM_LIST = ImmutableList.of((Object)"extcount", (Object)"presetcount");
    private static final List<String> COUNT_NAME_LIST = ImmutableList.of((Object)"extname", (Object)"presetname");
    private static final List<String> COUNT_IMG_LIST = ImmutableList.of((Object)"extimg", (Object)"presetimg");
    private static final List<String> COUNT_JUMP_LIST = ImmutableList.of((Object)"jumpext", (Object)"jumpreset");
    private IConfigItemDomainService configItemDomainService = (IConfigItemDomainService)ServiceFactory.getService(IConfigItemDomainService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        COUNT_NUM_LIST.forEach(count -> ((Label)this.getControl((String)count)).addClickListener((ClickListener)this));
        COUNT_NAME_LIST.forEach(name -> ((Label)this.getControl((String)name)).addClickListener((ClickListener)this));
        COUNT_JUMP_LIST.forEach(jump -> this.addClickListeners(new String[]{jump}));
        ((Vector)this.getControl(REFRESHCOUNT)).addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{CONTENT});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setLoadingImageVisible(Boolean.FALSE);
        this.setLabelNum();
    }

    public void click(EventObject e) {
        super.click(e);
        String opKey = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            opKey = ((Control)source).getKey();
        }
        if (HRStringUtils.equals((String)opKey, (String)COUNT_NUM_LIST.get(0)) || HRStringUtils.equals((String)opKey, (String)COUNT_NAME_LIST.get(0)) || HRStringUtils.equals((String)opKey, (String)COUNT_JUMP_LIST.get(0))) {
            this.showConfigForm(opKey, null, "3ZUOQ2HNFPGU");
        }
        if (HRStringUtils.equals((String)opKey, (String)COUNT_NUM_LIST.get(1)) || HRStringUtils.equals((String)opKey, (String)COUNT_NAME_LIST.get(1)) || HRStringUtils.equals((String)opKey, (String)COUNT_JUMP_LIST.get(1))) {
            this.showConfigForm(opKey, null, "3ZUONWL36=FA");
        } else if (HRStringUtils.equals((String)opKey, (String)REFRESHCOUNT)) {
            this.sendActionReFresh();
        }
    }

    private void showConfigForm(String opkey, List<QFilter> qFilterList, String schemeId) {
        ListShowParameter showParameter;
        String pageId = SessionManager.getCurrent().get(this.getView().getPageId() + opkey);
        if (HRStringUtils.isEmpty((String)pageId) || SessionManager.getCurrent().getView(pageId) == null) {
            showParameter = new ListShowParameter();
            showParameter.setFormId("bos_templatetreelist");
            SessionManager.getCurrent().put(this.getView().getPageId() + opkey, showParameter.getPageId());
        } else {
            showParameter = (ListShowParameter)SessionManager.getCurrent().getFormShowParameter(pageId);
        }
        if (HRStringUtils.isNotEmpty((String)schemeId)) {
            showParameter.setFilterSchemeId(schemeId);
        }
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(false);
        showParameter.setBillFormId("hrcc_configitems");
        showParameter.setAppId("hrcc");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void sendActionReFresh() {
        this.setlabelNumVisible(Boolean.FALSE);
        this.setLoadingImageVisible(Boolean.TRUE);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("name", REFRESH_CARD);
        param.put("duration", 0);
        param.put("async", true);
        proxy.addAction("addClientCallBack", param);
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (e != null && HRStringUtils.equals((String)e.getName(), (String)REFRESH_CARD) && e.getName().startsWith("refresh")) {
            this.setLabelNum();
            this.setLoadingImageVisible(Boolean.FALSE);
            this.setlabelNumVisible(Boolean.TRUE);
        }
    }

    private void setLabelNum() {
        int extConfCount = this.configItemDomainService.queryExtendConfigNumber();
        ((Label)this.getView().getControl(COUNT_NUM_LIST.get(0))).setText(extConfCount + "");
        int presetConfCount = this.configItemDomainService.queryPresetConfigNumber();
        ((Label)this.getView().getControl(COUNT_NUM_LIST.get(1))).setText(presetConfCount + "");
    }

    private void setLoadingImageVisible(Boolean isVisible) {
        HashMap<String, Boolean> prop = new HashMap<String, Boolean>(1);
        prop.put(VI, isVisible);
        COUNT_IMG_LIST.forEach(img -> {
            this.getView().updateControlMetadata(img, prop);
            if (isVisible.booleanValue()) {
                ((Image)this.getControl((String)img)).setUrl(WAITING_IMAGE);
            }
        });
    }

    private void setlabelNumVisible(Boolean isVisible) {
        HashMap<String, Boolean> prop = new HashMap<String, Boolean>(1);
        prop.put(VI, isVisible);
        COUNT_NUM_LIST.forEach(count -> this.getView().updateControlMetadata(count, prop));
    }
}

