/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.formplugin.web.transferconf;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.domain.common.entity.ICommonEntityService;
import kd.hdtc.hrcc.business.domain.common.entity.impl.CommonServiceImpl;
import kd.hdtc.hrcc.business.domain.config.IHRCCBaseConfigDomainService;
import kd.hdtc.hrcc.formplugin.web.utils.CommonPageUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hr.hbp.common.util.HRStringUtils;

public class CrossEvnTransEditPlugin
extends HDTCDataBaseEdit {
    private static final String INSTRUCTION = "instruction";
    private static final String OFF_LINE_INSTRUCTION = "https://vip.kingdee.com/article/517349359789209600";
    private static final String ON_LINE_INSTRUCTION = "https://vip.kingdee.com/article/517349677683956736";
    private static final String RADIO_GROUP = "radiogroup";
    private static final String ENV_RADIO_GROUP = "envradiogroup";
    private static final String OUT_CONFIG_AP = "outconfigap";
    private static final String OUT_TARGET_AP = "outtargetap";
    private static final String ONLINE_CONFIG_AP = "onlineconfigap";
    private static final String ONLINE_TARGET_AP = "onlinetargetap";
    private static final String OPERATE_STEP_AP = "operatestepap";
    private static final String OFF_LINE_TRANS_PROCESS = "offlinetransprocess";
    private static final String ONLINE_TRANS_PROCESS = "onlinetransprocess";
    private static final String RADIOGROUP = "radiogroup";
    private static final String CONF_ITEM_COUNT_CARD = "confitemcountcard";
    private static final String CONF_QUICK_OPEN = "confquickopen";
    private static final String BASIC_CONFIG_CENTER = "basicconfigcenter";
    private static final String TRANSFER_PACKAGE_MANAGE = "transterpackagemanage";
    private static final String RICC_INITCONFIG = "ricc_initconfig";
    private final String configInitErrorMsg = ResManager.loadKDString((String)"\u521d\u6b21\u64cd\u4f5c\u8bf7\u914d\u7f6e\u7cfb\u7edf\u53c2\u6570\uff0c\u64cd\u4f5c\u8def\u5f84\uff1a\u3010\u5b9e\u65bd\u670d\u52a1\u4e91\u3011\u2192\u3010\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3011\u2192\u3010\u57fa\u7840\u8bbe\u7f6e\u3011\u2192\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u70b9\u51fb\u201c\u4fdd\u5b58\u201d\u3002", (String)"CrossEvnTransEditPlugin_0", (String)"hdtc-hrcc-formplugin", (Object[])new Object[0]);
    private static final List<String> BTN_LIST = Lists.newArrayList((Object[])new String[]{"instruction", "basicconfigcenter1", "basicconfigcenter2", "linkdatamanagecenter", "thirdpartyapp", "transconfigscheme", "transconfigscheme1", "transterpackagemanage1", "transterpackagemanage2", "transterpackagemanage3"});
    IHRCCBaseConfigDomainService IHRCCBaseConfigDomainService = (IHRCCBaseConfigDomainService)ServiceFactory.getService(IHRCCBaseConfigDomainService.class);
    private final ICommonEntityService riccInitConfigEntityService = new CommonServiceImpl("ricc_initconfig");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(BTN_LIST.toArray(new String[0]));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.showCardPage(CONF_ITEM_COUNT_CARD, "hrcc_confitemcountcard");
        this.showCardPage(CONF_QUICK_OPEN, "hrcc_confquickopen");
        this.changeShowAp();
        if (!this.checkInitConfig()) {
            this.getView().showErrorNotification(this.configInitErrorMsg);
        }
    }

    private boolean checkInitConfig() {
        QFilter qFilter = new QFilter("id", "!=", null);
        return this.riccInitConfigEntityService.isExists(qFilter);
    }

    private void showCardPage(String targetKey, String formId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId(formId);
        this.getView().showForm(showParameter);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (HRStringUtils.equals((String)key, (String)INSTRUCTION)) {
            this.openInstructionUrl();
        } else if (key.startsWith(BASIC_CONFIG_CENTER)) {
            CommonPageUtils.showRiccFormInHrccApp(this.getView(), "ricc_templatetreelist", "ricc_configitems", BASIC_CONFIG_CENTER);
        } else if (HRStringUtils.equals((String)key, (String)"linkdatamanagecenter")) {
            CommonPageUtils.showRiccFormInHrccApp(this.getView(), "bos_list", "ricc_destaccount", key);
        } else if (HRStringUtils.equals((String)key, (String)"thirdpartyapp")) {
            CommonPageUtils.showRiccFormInHrccApp(this.getView(), "bos_list", "third_app", key);
        } else if (key.startsWith(TRANSFER_PACKAGE_MANAGE)) {
            CommonPageUtils.showRiccFormInHrccApp(this.getView(), "bos_list", "ricc_datapacket", TRANSFER_PACKAGE_MANAGE);
        } else if (key.startsWith("transconfigscheme")) {
            CommonPageUtils.showFormInHrccApp(this.getView(), "bos_templatetreelist", "hrcc_configitems", key);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.changeShowAp();
        super.propertyChanged(e);
    }

    private void changeShowAp() {
        DynamicObject modelValue = this.getModel().getDataEntity();
        String radioGroupVal = modelValue.getString("radiogroup");
        String envRadioGroupVal = modelValue.getString(ENV_RADIO_GROUP);
        if (StringUtils.equals((String)"0", (String)radioGroupVal) && StringUtils.equals((String)"0", (String)envRadioGroupVal)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{OUT_CONFIG_AP, OFF_LINE_TRANS_PROCESS});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OUT_TARGET_AP, ONLINE_CONFIG_AP, ONLINE_TARGET_AP, ONLINE_TRANS_PROCESS});
        } else if (StringUtils.equals((String)"0", (String)radioGroupVal) && StringUtils.equals((String)"1", (String)envRadioGroupVal)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{OUT_TARGET_AP, OFF_LINE_TRANS_PROCESS});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OUT_CONFIG_AP, ONLINE_CONFIG_AP, ONLINE_TARGET_AP, ONLINE_TRANS_PROCESS});
        } else if (StringUtils.equals((String)"1", (String)radioGroupVal) && StringUtils.equals((String)"0", (String)envRadioGroupVal)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ONLINE_CONFIG_AP, ONLINE_TRANS_PROCESS});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OUT_CONFIG_AP, OUT_TARGET_AP, ONLINE_TARGET_AP, OFF_LINE_TRANS_PROCESS});
        } else if (StringUtils.equals((String)"1", (String)radioGroupVal) && StringUtils.equals((String)"1", (String)envRadioGroupVal)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{ONLINE_TARGET_AP, ONLINE_TRANS_PROCESS});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{OUT_CONFIG_AP, OUT_TARGET_AP, ONLINE_CONFIG_AP, OFF_LINE_TRANS_PROCESS});
        }
        this.getView().updateView(OPERATE_STEP_AP);
    }

    private void openInstructionUrl() {
        String radioGroupField = this.getModel().getValue("radiogroup").toString();
        if (HRStringUtils.equals((String)radioGroupField, (String)"0")) {
            String offLineInstruction = this.IHRCCBaseConfigDomainService.queryBaseConfigValueByNumber("off_line_instruction");
            if (HRStringUtils.isEmpty((String)offLineInstruction)) {
                this.getView().openUrl(OFF_LINE_INSTRUCTION);
            } else {
                this.getView().openUrl(offLineInstruction);
            }
        } else {
            String onLineInstruction = this.IHRCCBaseConfigDomainService.queryBaseConfigValueByNumber("on_line_instruction");
            if (HRStringUtils.isEmpty((String)onLineInstruction)) {
                this.getView().openUrl(ON_LINE_INSTRUCTION);
            } else {
                this.getView().openUrl(onLineInstruction);
            }
        }
    }
}

