/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.mservice;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.FieldBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.HrConfItemDataBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.MainEntityBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.RowDataBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.SysConfItemBo;
import kd.hdtc.hrcc.business.domain.transfer.configitem.impl.ConfigItemDomainServiceImpl;
import kd.hdtc.hrcc.business.domain.transfer.configitem.model.TransferDataParamBo;
import kd.hdtc.hrcc.common.util.CommonUtils;
import kd.hdtc.hrcc.mservice.api.IConfigItemService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.FileUtils;
import org.apache.commons.io.FilenameUtils;

public class ConfigItemServiceImpl
implements IConfigItemService {
    private static final Log LOG = LogFactory.getLog(ConfigItemServiceImpl.class);
    private String curConfItemUrl;
    private final Lang curLang = RequestContext.get().getLang();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> exportPacket(Map<String, Object> paras) {
        Map<String, Object> retMap = new HashMap<String, Object>(8);
        if (paras.get("entity_number") == null) {
            return retMap;
        }
        ConfigItemDomainServiceImpl configItemDomainService = new ConfigItemDomainServiceImpl();
        long starTime = 0L;
        try {
            LOG.info("ConfigItemServiceImpl.exportPacket,paras is {}", (Object)SerializationUtils.toJsonString(paras));
            starTime = System.currentTimeMillis();
            String entityNumber = (String)paras.get("entity_number");
            List listSelectedRows = (List)paras.get("listSelectedRowList");
            retMap = this.getNoSelectDataRetMap(retMap, listSelectedRows);
            if (!ObjectUtils.isEmpty(retMap)) {
                Map<String, Object> map = retMap;
                return map;
            }
            List idList = listSelectedRows.stream().map(sr -> sr.getPrimaryKeyValue()).collect(Collectors.toList());
            TransferDataParamBo transferDataParamBo = new TransferDataParamBo(entityNumber, entityNumber, "id", "");
            transferDataParamBo.setCp("in");
            transferDataParamBo.setFieldValueList(idList);
            ArrayList mainEntityBoList = new ArrayList(10);
            List confItemDataList = configItemDomainService.getConfItemData(transferDataParamBo, mainEntityBoList);
            ArrayList allConfItemEntityNumList = new ArrayList(10);
            LOG.info("exportPacket,confItemData.size={}", (Object)confItemDataList.size());
            if (CollectionUtils.isEmpty((Collection)confItemDataList)) {
                Map<String, Object> map = this.getNoSelectDataRetMap(retMap, null);
                return map;
            }
            confItemDataList.forEach(mainEntityBo -> allConfItemEntityNumList.add(mainEntityBo.getEntityNumber()));
            List hrConfItemItselfBoList = configItemDomainService.getHrConfItemItselfData(allConfItemEntityNumList);
            ArrayList<SysConfItemBo> allSysConfItemList = new ArrayList<SysConfItemBo>(10);
            confItemDataList.forEach(mainEntityBo -> allSysConfItemList.addAll(mainEntityBo.getSysConfItemBoList()));
            List<Map<String, Object>> mulDataMapList = this.getMulDataMapList(confItemDataList, entityNumber);
            List<Map<String, Object>> relDataBaseMapList = this.getRelSysConfItemLy(allSysConfItemList);
            this.handleHrConfItemRelData(hrConfItemItselfBoList, relDataBaseMapList);
            retMap.put("code", 0);
            retMap.put("msg", "");
            retMap.put("dev_msg", "");
            retMap.put("relybd_list", relDataBaseMapList);
            retMap.put("multidata_list", mulDataMapList);
            retMap.put("export_url", this.curConfItemUrl);
        }
        catch (KDBizException kdBizException) {
            ErrorCode errorCode = kdBizException.getErrorCode();
            retMap.put("code", 1);
            LOG.info("kdBizException.errorCode", (Object)kdBizException.getErrorCode());
            LOG.error("ConfigItemServiceImpl.exportPacket kdBizException", (Throwable)kdBizException);
            if (errorCode != null && "circularEntityNumExists".equals(errorCode.getCode())) {
                String pattern = ResManager.loadKDString((String)"\u5b9e\u4f53\u914d\u7f6e\u9879\u4f9d\u8d56\u5173\u7cfb\u51fa\u73b0\u5faa\u73af\u4f9d\u8d56\u60c5\u51b5\uff0c\u5faa\u73af\u4f9d\u8d56\u6570\u636e\uff1a{0}", (String)"ConfigItemServiceImpl_0", (String)"hdtc-hrcc-business", (Object[])new Object[0]);
                retMap.put("msg", MessageFormat.format(pattern, errorCode.getMessage()));
            }
        }
        catch (Exception exception) {
            retMap.put("code", 1);
            retMap.put("msg", "importPacket is Exception.");
            retMap.put("dev_msg", CommonUtils.getStackTrace((Throwable)exception));
            LOG.error("ConfigItemServiceImpl.exportPacket is exception", (Throwable)exception);
        }
        finally {
            LOG.info("exportPacket end,cost={},retMap={}", (Object)(System.currentTimeMillis() - starTime), (Object)SerializationUtils.toJsonString(retMap));
        }
        return retMap;
    }

    private void handleHrConfItemRelData(List<HrConfItemDataBo> hrConfItemItselfBoList, List<Map<String, Object>> relDataBaseMapList) {
        if (CollectionUtils.isEmpty(hrConfItemItselfBoList)) {
            return;
        }
        for (HrConfItemDataBo hrConfItemDataBo : hrConfItemItselfBoList) {
            HashMap<String, Object> confItemMap = new HashMap<String, Object>(16);
            confItemMap.put("entity_number", hrConfItemDataBo.getEntityNumber());
            confItemMap.put("id_list", hrConfItemDataBo.getIdList());
            relDataBaseMapList.add(confItemMap);
        }
    }

    private Map<String, Object> getNoSelectDataRetMap(Map<String, Object> retMap, List<ListSelectedRow> listSelectedRows) {
        if (CollectionUtils.isEmpty(listSelectedRows)) {
            retMap.put("code", 1);
            retMap.put("msg", "no data.");
            retMap.put("dev_msg", "");
            return retMap;
        }
        return retMap;
    }

    private List<Map<String, Object>> getRelSysConfItemLy(List<SysConfItemBo> allSysConfItemList) {
        ArrayList<Map<String, Object>> relDataBaseMapList = new ArrayList<Map<String, Object>>(16);
        if (ObjectUtils.isEmpty(allSysConfItemList)) {
            return relDataBaseMapList;
        }
        Map<String, Set> relSysDataMap = allSysConfItemList.stream().collect(Collectors.toMap(SysConfItemBo::getConfItemEntityNumber, SysConfItemBo::getIdValSet, (key1, key2) -> key1));
        for (Map.Entry<String, Set> sysDataEntry : relSysDataMap.entrySet()) {
            HashMap<String, Object> sysConfItemMap = new HashMap<String, Object>(16);
            sysConfItemMap.put("entity_number", sysDataEntry.getKey());
            sysConfItemMap.put("id_list", new ArrayList(sysDataEntry.getValue()));
            relDataBaseMapList.add(sysConfItemMap);
        }
        return relDataBaseMapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Map<String, Object>> getMulDataMapList(List<MainEntityBo> confItemDataList, String curEntityNumber) {
        ArrayList<Map<String, Object>> mulDataMapList = new ArrayList<Map<String, Object>>(16);
        Iterator<MainEntityBo> iterator = confItemDataList.iterator();
        while (iterator.hasNext()) {
            File fileTemp;
            InputStream input;
            block21: {
                block22: {
                    block19: {
                        block20: {
                            MainEntityBo mainEntityBo = iterator.next();
                            String appId = mainEntityBo.getAppId();
                            String confItemEntityNumber = mainEntityBo.getEntityNumber();
                            input = null;
                            HashMap<String, Object> mulDataMap = new HashMap<String, Object>(16);
                            fileTemp = null;
                            try {
                                String fileName = appId + "-" + confItemEntityNumber + ".json";
                                fileTemp = FileUtils.createFile(null, (String)fileName);
                                String jsonFilePath = fileTemp.getAbsolutePath();
                                FileUtils.writeStr2File(null, (String)fileName, (String)JSON.toJSONString((Object)mainEntityBo));
                                input = Files.newInputStream(Paths.get(FilenameUtils.getFullPath((String)jsonFilePath) + FilenameUtils.getName((String)fileName), new String[0]), new OpenOption[0]);
                                String tempFileUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, input, 28800);
                                if (tempFileUrl.startsWith("tempfile") && !tempFileUrl.contains("http")) {
                                    tempFileUrl = UrlService.getDomainContextUrl() + "/" + tempFileUrl;
                                }
                                if (curEntityNumber.equals(confItemEntityNumber)) {
                                    this.curConfItemUrl = tempFileUrl;
                                    if (fileTemp == null) break block19;
                                    break block20;
                                }
                                List rowDataBoList = mainEntityBo.getRowDataBoList();
                                ArrayList<HashMap<String, Object>> retDataMapList = new ArrayList<HashMap<String, Object>>(rowDataBoList.size());
                                for (RowDataBo rowDataBo : rowDataBoList) {
                                    List fieldBoList = rowDataBo.getFieldBoList();
                                    HashMap<String, Object> dataMap = new HashMap<String, Object>(8);
                                    this.assemblyRelConfItemDataMap(fieldBoList, dataMap);
                                    retDataMapList.add(dataMap);
                                }
                                mulDataMap.put("entity_number", confItemEntityNumber);
                                mulDataMap.put("export_url", tempFileUrl);
                                mulDataMap.put("selected_info", retDataMapList);
                                mulDataMapList.add(mulDataMap);
                                if (fileTemp == null) break block21;
                                break block22;
                            }
                            catch (Exception e) {
                                LOG.error("ConfigItemServiceImpl.getMulDataMapList is exception.", (Throwable)e);
                                continue;
                            }
                        }
                        FileUtils.deleteLocalFile((File)fileTemp);
                    }
                    if (input == null) continue;
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        LOG.error("ConfigItemServiceImpl.getMulDataMapList input close is exception.", (Throwable)e);
                    }
                    continue;
                }
                FileUtils.deleteLocalFile((File)fileTemp);
            }
            if (input == null) continue;
            try {
                input.close();
            }
            catch (IOException e) {
                LOG.error("ConfigItemServiceImpl.getMulDataMapList input close is exception.", (Throwable)e);
            }
            continue;
            finally {
                if (fileTemp != null) {
                    FileUtils.deleteLocalFile(fileTemp);
                }
                if (input == null) continue;
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOG.error("ConfigItemServiceImpl.getMulDataMapList input close is exception.", (Throwable)e);
                }
            }
        }
        return mulDataMapList;
    }

    private void assemblyRelConfItemDataMap(List<FieldBo> fieldBoList, Map<String, Object> dataMap) {
        for (FieldBo fieldBo : fieldBoList) {
            Object fieldValue;
            String fieldName = fieldBo.getFieldName();
            if ("id".equals(fieldName)) {
                dataMap.put("id", fieldBo.getFieldValue());
                continue;
            }
            if ("number".equals(fieldName)) {
                dataMap.put("number", fieldBo.getFieldValue());
                continue;
            }
            if (!"name".equals(fieldName) || (fieldValue = fieldBo.getFieldValue()) == null) continue;
            List mulNameFieldBoList = (List)fieldValue;
            List mulNameList = mulNameFieldBoList.stream().filter(bo -> this.curLang.toString().equals(bo.getFieldName())).map(bo -> bo.getFieldValue()).collect(Collectors.toList());
            dataMap.put("name", CollectionUtils.isNotEmpty(mulNameList) ? mulNameList.get(0) : "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> importPacket(Map<String, Object> paramMap) {
        Map<String, Object> retMap = new HashMap<String, Object>(16);
        LOG.info("importPacket paras is {}", (Object)SerializationUtils.toJsonString(paramMap));
        long start = System.currentTimeMillis();
        ConfigItemDomainServiceImpl configItemDomainService = new ConfigItemDomainServiceImpl();
        try {
            Object importUrlObj = paramMap.get("import_url");
            if (ObjectUtils.isEmpty(paramMap) || ObjectUtils.isEmpty((Object)importUrlObj)) {
                retMap.put("code", 1);
                retMap.put("msg", "paramMap is empty.");
                Map<String, Object> map = retMap;
                return map;
            }
            retMap = configItemDomainService.handleConfItemImportData(importUrlObj.toString());
        }
        catch (Exception exception) {
            LOG.error("ConfigItemServiceImpl.importPacket is Exception", (Throwable)exception);
            retMap.put("code", 1);
            retMap.put("msg", "importPacket is Exception.");
            retMap.put("dev_msg", CommonUtils.getStackTrace((Throwable)exception));
        }
        finally {
            long end = System.currentTimeMillis();
            String logInfo = "ConfigItemServiceImpl.importPacket is end. cast=" + (end - start) + "ms; paramMap:" + SerializationUtils.toJsonString(paramMap);
            LOG.info(logInfo);
        }
        return retMap;
    }
}

