/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.mservice;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.common.model.confitem.metapackage.MetaDataPackageResult;
import kd.hdtc.hrcc.business.common.model.confitem.metapackage.MetaPackageParam;
import kd.hdtc.hrcc.business.common.model.confitem.metapackage.PresetDataPackageParam;
import kd.hdtc.hrcc.mservice.api.IMetaDataPackageService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.MetaDatePresetDataDomainServiceImpl;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdbs.common.util.FileUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class MetaDataPackageServiceImpl
implements IMetaDataPackageService {
    public MetaDataPackageResult metaDataPackage(List<Map<String, Object>> metaPackageParamMapList, List<Map<String, Object>> presetDataPackageParamMapList) {
        Map serviceResult;
        MetaDataPackageResult result = new MetaDataPackageResult();
        if (CollectionUtils.isEmpty(metaPackageParamMapList) && CollectionUtils.isEmpty(presetDataPackageParamMapList)) {
            result = MetaDataPackageResult.buildErrorResult((String)ResManager.loadKDString((String)"\u6ca1\u6709\u8981\u6253\u5305\u7684\u5185\u5bb9\uff0c\u8bf7\u786e\u8ba4", (String)"MetaDataPackageResult_1", (String)"hdtc-hrcc-business", (Object[])new Object[0]));
            return result;
        }
        List metaPackageParamList = MetaPackageParam.validAndToBoList(metaPackageParamMapList, (MetaDataPackageResult)result);
        List presetDataPackageParamList = PresetDataPackageParam.validAndToBoList(presetDataPackageParamMapList, (MetaDataPackageResult)result);
        HashMap<String, Map> appIdParams = new HashMap<String, Map>();
        if (CollectionUtils.isNotEmpty((Collection)metaPackageParamList)) {
            for (MetaPackageParam metaPackageParam : metaPackageParamList) {
                String appId = metaPackageParam.getAppId();
                if (StringUtils.isEmpty((String)appId)) continue;
                Map params = appIdParams.getOrDefault(appId, new HashMap(16));
                if (metaPackageParam.isPackageAppMataData()) {
                    params.put("appInfo", Collections.singletonList(appId));
                }
                List pageList = params.getOrDefault("page", new ArrayList(10));
                if (CollectionUtils.isNotEmpty((Collection)metaPackageParam.getPageIdList())) {
                    pageList.addAll(metaPackageParam.getPageIdList());
                    params.put("page", pageList);
                }
                appIdParams.put(appId, params);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)presetDataPackageParamList)) {
            MetaDatePresetDataDomainServiceImpl metaDataPresetDataDomainService = new MetaDatePresetDataDomainServiceImpl();
            long currentTime = DateTimeUtils.getNowDateTime().getTime();
            for (PresetDataPackageParam presetDataPackageParam : presetDataPackageParamList) {
                String sqlFileName;
                String url;
                String appId = presetDataPackageParam.getAppId();
                String entityNumber = presetDataPackageParam.getEntityNumber();
                List idList = presetDataPackageParam.getIdList();
                if (StringUtils.isEmpty((String)appId) || StringUtils.isEmpty((String)entityNumber) || CollectionUtils.isEmpty((Collection)idList)) continue;
                Map params = appIdParams.getOrDefault(appId, new HashMap(16));
                List presetData = params.getOrDefault("preinsData", new ArrayList(10));
                QFilter qFilter = new QFilter("fid", "in", (Object)idList);
                String presetSql = metaDataPresetDataDomainService.getPresetDataString(entityNumber, qFilter.toString());
                if (StringUtils.isEmpty((String)presetSql) || StringUtils.isEmpty((String)(url = FileUtils.writeContentAndGetUrl((String)appId, (String)(sqlFileName = entityNumber + '_' + currentTime + ".sql"), (String)presetSql)))) continue;
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("urlname", (Object)sqlFileName);
                jsonObj.put("url", (Object)url);
                jsonObj.put("databasetype", (Object)"");
                presetData.add(jsonObj);
                params.put("preinsData", presetData);
                appIdParams.put(appId, params);
            }
        }
        if (CollectionUtils.isNotEmpty((Map)(serviceResult = (Map)HRMServiceHelper.invokeBizService((String)"imsc", (String)"ricc", (String)"metaDataPackService", (String)"exportPack", (Object[])new Object[]{null, appIdParams}))) && !((Boolean)serviceResult.get("success")).booleanValue()) {
            result = MetaDataPackageResult.buildErrorResult((String)String.valueOf(serviceResult.get("msg")));
            return result;
        }
        return MetaDataPackageResult.buildSuccessResult();
    }
}

