/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.mservice.openapi.controller;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.common.utils.ConfItemDyObjectUtils;
import kd.hdtc.hrcc.mservice.openapi.model.TableDataModel;
import kd.hdtc.hrdbs.business.base.AbstractHDTCApiController;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import org.apache.commons.lang3.tuple.Pair;

@ApiController(value="hrcc", desc="\u6839\u636e\u6761\u4ef6\u83b7\u53d6\u52a8\u6001\u5bf9\u8c61\u6570\u636e")
@ApiMapping(value="/openapi/hrcc")
public class GetDataController
extends AbstractHDTCApiController
implements Serializable {
    private static final long serialVersionUID = 2961489890105868433L;
    private static final Log LOG = LogFactory.getLog(GetDataController.class);

    @ApiPostMapping(value="/getDynamicData")
    public CustomApiResult<JSONObject> getDynamicData(@ApiParam(value="dynamicObjectDataModel") @Valid @ApiParam(value="dynamicObjectDataModel") @Valid Map<String, List<Object>> dynDataModelMap) {
        if (CollectionUtils.isEmpty(dynDataModelMap)) {
            LOG.error("GetDataController getDynamicData error ", (Object)"params is null");
            return CustomApiResult.fail((String)"400", (String)"params cannot be null");
        }
        if (dynDataModelMap.size() > 50) {
            LOG.error("GetDataController getDynamicData error ", (Object)"size is too larger:limit 50");
            return CustomApiResult.fail((String)"400", (String)"size is too larger:limit 50");
        }
        HRBaseServiceHelper hrBaseServiceHelper = null;
        JSONObject resultJson = new JSONObject();
        for (Map.Entry<String, List<Object>> model : dynDataModelMap.entrySet()) {
            DynamicObject[] dataArr;
            if (!StringUtils.isNotEmpty((String)model.getKey()) || !CollectionUtils.isNotEmpty((Collection)model.getValue()) || (dataArr = (hrBaseServiceHelper = new HRBaseServiceHelper(model.getKey())).loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", model.getValue())})) == null || dataArr.length <= 0) continue;
            HashMap<String, Map> resultMap = new HashMap<String, Map>(dataArr.length);
            for (DynamicObject dynamicObject : dataArr) {
                resultMap.put(dynamicObject.getString("id"), ConfItemDyObjectUtils.convertDynamicObjectToMap((DynamicObject)dynamicObject));
            }
            resultJson.put(model.getKey(), resultMap);
        }
        return CustomApiResult.success((Object)resultJson);
    }

    @ApiPostMapping(value="/getTableData")
    public CustomApiResult<List<Pair>> getTableData(@ApiParam(value="tableDataModel") @Valid @ApiParam(value="tableDataModel") @Valid List<TableDataModel> tableDataModelList) {
        if (CollectionUtils.isEmpty(tableDataModelList)) {
            LOG.error("GetDataController getTableData error ", (Object)"params is null");
            return CustomApiResult.fail((String)"400", (String)"params cannot be null");
        }
        if (tableDataModelList.size() > 50) {
            LOG.error("GetDataController getTableData error ", (Object)"size is too larger:limit 50");
            return CustomApiResult.fail((String)"400", (String)"size is too larger:limit 50");
        }
        ArrayList<Pair> resultData = new ArrayList<Pair>(tableDataModelList.size());
        for (TableDataModel model : tableDataModelList) {
            Pair data = Pair.of((Object)model.getNumber(), null);
            if (StringUtils.isNotEmpty((String)model.getDbRouter()) && StringUtils.isNotEmpty((String)model.getNumber()) && CollectionUtils.isNotEmpty(model.getCols()) && StringUtils.isNotEmpty((String)model.getConditionCol()) && CollectionUtils.isNotEmpty(model.getIds())) {
                Map<String, Object> dataMap = this.getDataByDataSet(model);
                data = Pair.of((Object)model.getNumber(), dataMap);
            }
            resultData.add(data);
        }
        return CustomApiResult.success(resultData);
    }

    private Map<String, Object> getDataByDataSet(TableDataModel model) {
        List<Object> ids = model.getIds();
        List sims = ids.stream().map(data -> "?").collect(Collectors.toList());
        String simStr = Joiner.on((String)",").join(sims);
        String cols = Joiner.on((String)",").join(model.getCols());
        String sql = "select " + model.getConditionCol() + "," + cols + " from " + model.getNumber() + " where " + model.getConditionCol() + " in ( " + simStr + " )";
        HashMap<String, Object> dataMap = new HashMap<String, Object>(4);
        try (DataSet rs = HRDBUtil.queryDataSet((String)"GetDataController", (DBRoute)new DBRoute(model.getDbRouter()), (String)sql, (Object[])ids.toArray());){
            while (rs.hasNext()) {
                Row data2 = rs.next();
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put(model.getConditionCol(), data2.get(0));
                int index = 1;
                for (String col : model.getCols()) {
                    map.put(col, data2.get(index++));
                }
                dataMap.put(String.valueOf(data2.get(0)), map);
            }
        }
        return dataMap;
    }
}

