/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.opplugin.web.transferconf.op;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.domain.transfer.configitem.IConfigItemDomainService;
import kd.hdtc.hrcc.business.domain.transfer.entity.IConfigItemEntityService;
import kd.hdtc.hrcc.business.domain.transfer.entity.IConfigItemRelEntityService;
import kd.hdtc.hrcc.opplugin.web.transferconf.validate.ConfItemValidator;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfigItemSaveOp
extends HDTCDataBaseOp {
    private IConfigItemDomainService configItemDomainService = (IConfigItemDomainService)ServiceFactory.getService(IConfigItemDomainService.class);
    private IConfigItemEntityService configItemEntityService = (IConfigItemEntityService)ServiceFactory.getService(IConfigItemEntityService.class);
    private IConfigItemRelEntityService relEntityConfService = (IConfigItemRelEntityService)ServiceFactory.getService(IConfigItemRelEntityService.class);
    private List<Long> confItemPkIdList = new ArrayList<Long>(10);
    private boolean isModifier = false;
    private DynamicObject dbDyn;
    private DynamicObject[] relDynArr;

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        eventArgs.addValidator((AbstractValidator)new ConfItemValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if (HRStringUtils.equals((String)"save", (String)operationKey)) {
            DynamicObject dataEntity = args.getDataEntities()[0];
            BasedataEntityType dataEntityType = (BasedataEntityType)dataEntity.getDataEntityType();
            if (dataEntityType.getProperty("entryentity") != null) {
                this.confItemPkIdList = this.configItemDomainService.batchSaveConfigItem(dataEntity);
            } else {
                OperateOption option = this.getOption();
                String isPageSaveStr = "";
                if (option.containsVariable("ispagesave")) {
                    isPageSaveStr = this.getOption().getVariableValue("ispagesave");
                }
                if (HRStringUtils.equals((String)isPageSaveStr, (String)"true")) {
                    long pkId = dataEntity.getLong("id");
                    DynamicObject[] dbDynArr = this.configItemEntityService.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "=", (Object)pkId)});
                    this.relDynArr = this.relEntityConfService.loadDynamicObjectArray(new QFilter[]{new QFilter("configitem", "=", (Object)pkId)});
                    this.configItemDomainService.saveConfigItem(dataEntity);
                    if (!dataEntity.getBoolean("issyspreset")) {
                        this.confItemPkIdList.add(dataEntity.getLong("id"));
                        if (dbDynArr != null && dbDynArr.length > 0) {
                            this.dbDyn = dbDynArr[0];
                        }
                    }
                    this.isModifier = true;
                } else {
                    args.setCancelOperation(true);
                    this.configItemDomainService.saveConfigItemNotOp(args.getDataEntities());
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        JSONObject confItemResult;
        OperationResult operationResult = this.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && CollectionUtils.isNotEmpty(this.confItemPkIdList) && !HRStringUtils.equals((String)(confItemResult = this.configItemDomainService.syncConfigItem(this.confItemPkIdList, false)).getString("success"), (String)"true")) {
            String confItemResultMsg = confItemResult.getString("msg");
            if (!this.isModifier) {
                this.configItemDomainService.delConfItemAndRelCof(this.confItemPkIdList);
            } else {
                DynamicObject[] dbDynArr = this.configItemEntityService.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "=", (Object)this.dbDyn.getLong("id"))});
                DynamicObjectUtils.copy((DynamicObject)this.dbDyn, (DynamicObject)dbDynArr[0]);
                this.configItemEntityService.save(dbDynArr);
                if (this.relDynArr != null && this.relDynArr.length > 0) {
                    this.relEntityConfService.deleteByFilter(new QFilter("configitem", "=", (Object)this.relDynArr[0].getLong("id")).toArray());
                    this.relEntityConfService.save(this.relDynArr);
                }
            }
            operationResult.setSuccessPkIds(operationResult.getSuccessPkIds().stream().filter(pkId -> Long.parseLong(pkId.toString()) != 0L).collect(Collectors.toList()));
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setPkValue(e.getDataEntities()[0].getPkValue());
            operateErrorInfo.setMessage(confItemResultMsg);
            operateErrorInfo.setEntityKey("ricc_configitems");
            operationResult.addErrorInfo(operateErrorInfo);
        }
    }
}

