/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.opplugin.web.transferconf.op;

import com.alibaba.fastjson.JSONObject;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.domain.transfer.configitem.IConfigItemDomainService;
import kd.hdtc.hrcc.business.domain.transfer.entity.IConfigGroupEntityService;
import kd.hdtc.hrcc.opplugin.web.transferconf.validate.ConfigTreeValidator;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfigTreeSaveOp
extends HDTCDataBaseOp {
    private IConfigItemDomainService configItemDomainService = (IConfigItemDomainService)ServiceFactory.getService(IConfigItemDomainService.class);
    private IConfigGroupEntityService configTreeEntityService = (IConfigGroupEntityService)ServiceFactory.getService(IConfigGroupEntityService.class);
    private DynamicObject dbDyn;

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        eventArgs.addValidator((AbstractValidator)new ConfigTreeValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        Long pkId = dataEntities[0].getLong("id");
        DynamicObject[] dbDynArr = this.configTreeEntityService.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "=", (Object)pkId)});
        if (dbDynArr != null && dbDynArr.length > 0) {
            this.dbDyn = dbDynArr[0];
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs afterOperationArgs) {
        DynamicObject[] dataEntities = afterOperationArgs.getDataEntities();
        OperateOption option = this.getOption();
        OperationResult operationResult = this.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && option.containsVariable("pageData")) {
            Long pkId = dataEntities[0].getLong("id");
            JSONObject result = this.configItemDomainService.syncConfigTree(pkId, Boolean.FALSE.booleanValue());
            String treeMsg = result.getString("msg");
            if (!HRStringUtils.equals((String)result.getString("success"), (String)"true")) {
                if (this.dbDyn == null) {
                    this.configTreeEntityService.delete((Object)pkId);
                } else {
                    DynamicObject[] dbDynArr = this.configTreeEntityService.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "=", (Object)pkId)});
                    DynamicObjectUtils.copy((DynamicObject)this.dbDyn, (DynamicObject)dbDynArr[0]);
                    this.configTreeEntityService.save(dbDynArr);
                }
                String treeFailMsg = String.format(ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u5206\u7ec4\u540c\u6b65\u5931\u8d25\uff1a%s", (String)"ConfigTreeSaveOp_0", (String)"hdtc-hrcc-formplugin", (Object[])new Object[0]), treeMsg);
                throw new HDTCBizException(treeFailMsg);
            }
        }
    }
}

