/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.opplugin.web.transferconf.op;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrcc.business.domain.common.entity.impl.CommonServiceImpl;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class RelEntityConfSaveOp
extends HDTCDataBaseOp {
    private static final Log LOG = LogFactory.getLog(RelEntityConfSaveOp.class);
    public static final String ORDER = "order";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        if (HRStringUtils.equals((String)"save", (String)operationKey)) {
            e.setCancelOperation(true);
            DynamicObject[] dataEntityArr = e.getDataEntities();
            if (dataEntityArr.length == 0) {
                return;
            }
            CommonServiceImpl commonService = new CommonServiceImpl("hrcc_relentityconf");
            ArrayList newRelEntityList = Lists.newArrayListWithCapacity((int)dataEntityArr.length);
            ArrayList idList = Lists.newArrayListWithCapacity((int)dataEntityArr.length);
            Arrays.stream(dataEntityArr).sorted(Comparator.comparing(dyn -> dyn.getInt(ORDER))).forEach(dataEntity -> {
                DynamicObject toRelEntityDyn = commonService.generateEmptyDynamicObject();
                HRDynamicObjectUtils.copy((DynamicObject)dataEntity, (DynamicObject)toRelEntityDyn);
                long id = dataEntity.getLong("id");
                toRelEntityDyn.set("id", (Object)id);
                idList.add(id);
                newRelEntityList.add(toRelEntityDyn);
            });
            LOG.info("RelEntityConfSaveOp.beginOperationTransaction,idList={}", (Object)idList);
            commonService.delete(idList.toArray());
            commonService.save(newRelEntityList.toArray(new DynamicObject[0]));
        }
    }
}

