/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.opplugin.web.transferconf.op.fileimport;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.application.fileimport.IFileImportFileOpApplicationService;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.domain.fileimport.entity.IFileImportConfigEntityService;
import kd.hdtc.hrcc.business.domain.fileimport.entity.IFileImportTaskEntityService;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFieldBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFileFieldInfoBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFileZipTaskBean;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportPreviewResultBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportValidateFailDataBean;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportValidateSuccessDataBean;
import kd.hdtc.hrcc.business.domain.fileimport.utils.FileImportUtils;
import kd.hdtc.hrcc.common.enums.FileImportTaskDealStatusEnum;
import kd.hdtc.hrcc.opplugin.web.transferconf.validate.fileimport.FileImportSaveValidator;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;

public class FileImportSaveTaskOp
extends HDTCDataBaseOp {
    private IFileImportFileOpApplicationService fileImportFileOpApplicationService = (IFileImportFileOpApplicationService)ServiceFactory.getService(IFileImportFileOpApplicationService.class);
    private IFileImportTaskEntityService fileImportTaskEntityService = (IFileImportTaskEntityService)ServiceFactory.getService(IFileImportTaskEntityService.class);
    private IFileImportConfigEntityService fileImportConfigEntityService = (IFileImportConfigEntityService)ServiceFactory.getService(IFileImportConfigEntityService.class);

    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        RefObject opValue;
        OperateOption option = this.getOption();
        if (option.tryGetVariableValue("operationkey", opValue = new RefObject()) && StringUtils.equals((String)option.getVariableValue("operationkey"), (String)"save")) {
            this.unzipFile();
            eventArgs.addValidator((AbstractValidator)new FileImportSaveValidator());
        } else if (option.tryGetVariableValue("operationkey", opValue) && StringUtils.equals((String)option.getVariableValue("operationkey"), (String)"startimport")) {
            eventArgs.addValidator((AbstractValidator)new FileImportSaveValidator());
        }
    }

    private void unzipFile() {
        FileImportConfigBo fileImportConfigBo = (FileImportConfigBo)JSONObject.parseObject((String)this.getOption().getVariableValue("sceneConfInfo"), FileImportConfigBo.class);
        List allZipFileInfoList = JSONArray.parseArray((String)this.getOption().getVariableValue("allZipFileInfoList"), FileImportFileZipTaskBean.class);
        for (FileImportFileZipTaskBean fileImportFileZipTaskBean : allZipFileInfoList) {
            FileImportUtils.deleteLocalDirFile((String)fileImportConfigBo.getConfigNumber(), (String)fileImportFileZipTaskBean.getZipFileName());
            FileImportUtils.unzipFileToLocal((String)fileImportFileZipTaskBean.getZipFileUrl(), (String)fileImportConfigBo.getConfigNumber(), (String)fileImportFileZipTaskBean.getZipFileName());
            this.getOption().setVariableValue("allZipFileInfoList", JSONArray.toJSONString((Object)allZipFileInfoList));
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] dataEntityArr = args.getDataEntities();
        DynamicObject taskDyn = dataEntityArr[0];
        if (StringUtils.equals((String)args.getOperationKey(), (String)"save")) {
            FileImportPreviewResultBo fileImportPreviewResultBo = (FileImportPreviewResultBo)JSONObject.parseObject((String)this.getOption().getVariableValue("fileImportPreviewResultBo"), FileImportPreviewResultBo.class);
            FileImportConfigBo fileImportConfigBo = (FileImportConfigBo)JSONObject.parseObject((String)this.getOption().getVariableValue("sceneConfInfo"), FileImportConfigBo.class);
            MainEntityType dataEntityType = (MainEntityType)taskDyn.getDataEntityType();
            fileImportPreviewResultBo.analysisSuccessDataBeanList(fileImportPreviewResultBo, fileImportConfigBo);
            fileImportPreviewResultBo.analysisFailDataBeanList(fileImportPreviewResultBo);
            List failDataList = fileImportPreviewResultBo.getFailDataList();
            List successDataList = fileImportPreviewResultBo.getSuccessDataList();
            if (CollectionUtils.isNotEmpty((Collection)successDataList)) {
                DynamicObject mainConfigDyn = this.fileImportConfigEntityService.generateEmptyDynamicObject();
                mainConfigDyn.set("id", (Object)fileImportConfigBo.getConfigId());
                DynamicObjectCollection subTaskDynCol = taskDyn.getDynamicObjectCollection("successentryentity");
                Map<String, FileImportFileFieldInfoBo.FileInfo> fileInfoMap = this.uploadSubFileToRemote(successDataList, fileImportConfigBo);
                taskDyn.set("config", (Object)mainConfigDyn);
                taskDyn.set("taskstatus", (Object)"0");
                taskDyn.set("shownum", (Object)fileImportConfigBo.getShowFieldSet().size());
                DynamicObjectUtils.setBigText((DynamicObject)taskDyn, (String)"showfield", (String)JSONObject.toJSONString((Object)fileImportConfigBo.getShowFieldSet()));
                this.buildSubTaskEntryDyn(successDataList, subTaskDynCol, fileInfoMap, dataEntityType);
            }
            this.buildValidFailEntry(failDataList, taskDyn, dataEntityType);
        } else if (StringUtils.equals((String)args.getOperationKey(), (String)"prestep")) {
            DynamicObject[] taskDynArr = this.fileImportTaskEntityService.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "=", (Object)taskDyn.getLong("id"))});
            taskDynArr[0].getDynamicObjectCollection("failentryentity").clear();
            taskDynArr[0].getDynamicObjectCollection("successentryentity").clear();
            this.fileImportTaskEntityService.save(taskDynArr);
        }
    }

    private void buildValidFailEntry(List<FileImportValidateFailDataBean> failDataList, DynamicObject taskDyn, MainEntityType dataEntityType) {
        if (CollectionUtils.isNotEmpty(failDataList)) {
            DynamicObjectCollection failEntryCol = taskDyn.getDynamicObjectCollection("failentryentity");
            Map entityType = dataEntityType.getAllEntities();
            EntityType entryType = (EntityType)entityType.get("failentryentity");
            for (FileImportValidateFailDataBean failDataBean : failDataList) {
                DynamicObject faiDyn = new DynamicObject((DynamicObjectType)entryType);
                faiDyn.set("failzipname", (Object)failDataBean.getZipName());
                faiDyn.set("failfilename", (Object)failDataBean.getFileName());
                faiDyn.set("failmsg", (Object)failDataBean.getFailMsg());
                failEntryCol.add((Object)faiDyn);
            }
        }
    }

    private void buildSubTaskEntryDyn(List<FileImportValidateSuccessDataBean> successDataList, DynamicObjectCollection subTaskDynCol, Map<String, FileImportFileFieldInfoBo.FileInfo> fileInfoMap, MainEntityType dataEntityType) {
        Map entityType = dataEntityType.getAllEntities();
        EntityType entryType = (EntityType)entityType.get("successentryentity");
        IBaseEntityService sceneEntityService = CommonEntityServiceFactory.getEntityService((String)"hrcc_fileimpsubcfg");
        Set subSceneIdSet = successDataList.stream().map(bean -> bean.getFileImportSubSceneBo().getSubSceneId()).collect(Collectors.toSet());
        DynamicObject[] subSceneDynArr = sceneEntityService.query("id,config,name,numbe,singleplugin", new QFilter[]{new QFilter("id", "in", subSceneIdSet)});
        if (subSceneDynArr == null) {
            return;
        }
        Map<Long, DynamicObject> subSceneIdVsDynMap = Arrays.stream(subSceneDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
        for (FileImportValidateSuccessDataBean successDataBean : successDataList) {
            FileImportFieldBo idFileImportFieldBo = successDataBean.getFileImportFieldBoList().stream().filter(dataBean -> StringUtils.equals((String)dataBean.getFiledNumber(), (String)"id")).findFirst().get();
            FileImportFileFieldInfoBo.FileInfo fileInfo = fileInfoMap.get(successDataBean.getFileName());
            DynamicObject subTaskDyn = new DynamicObject((DynamicObjectType)entryType);
            DynamicObject scene = subSceneIdVsDynMap.get(successDataBean.getFileImportSubSceneBo().getSubSceneId());
            subTaskDyn.set("scene", (Object)scene);
            subTaskDyn.set("zipname", (Object)successDataBean.getZipName());
            subTaskDyn.set("zipurl", (Object)fileInfo.getTemUrl());
            subTaskDyn.set("filename", (Object)successDataBean.getFileName());
            subTaskDyn.set("dealstatus", (Object)"0");
            subTaskDyn.set("tmpurl", (Object)fileInfo.getTemUrl());
            subTaskDyn.set("datapkid", (Object)Long.parseLong(idFileImportFieldBo.getValue()));
            subTaskDyn.set("fieldtype", (Object)successDataBean.getFileImportSubSceneBo().getFieldType());
            subTaskDyn.set("entitynumber", (Object)idFileImportFieldBo.getEntityNumber());
            subTaskDyn.set("filednumber", (Object)successDataBean.getFileImportSubSceneBo().getFieldInfo().getFiledNumber());
            if (scene != null) {
                subTaskDyn.set("singleplugin", (Object)scene.getString("singleplugin"));
            }
            DynamicObjectUtils.setBigText((DynamicObject)subTaskDyn, (String)"showvalue", (String)JSONObject.toJSONString((Object)successDataBean.getFileImportFieldBoList()));
            subTaskDynCol.add((Object)subTaskDyn);
        }
    }

    private Map<String, FileImportFileFieldInfoBo.FileInfo> uploadSubFileToRemote(List<FileImportValidateSuccessDataBean> successDataList, FileImportConfigBo fileImportConfigBo) {
        ArrayList<File> fileList = new ArrayList<File>(10);
        for (FileImportValidateSuccessDataBean successDataBean : successDataList) {
            String fileName = successDataBean.getFileName();
            File fileInfo = FileImportUtils.getFileInfo((String)successDataBean.getZipName(), (String)fileImportConfigBo.getConfigNumber(), (String)fileName);
            if (ObjectUtils.isEmpty((Object)fileInfo)) continue;
            fileList.add(fileInfo);
        }
        HashMap<String, FileImportFileFieldInfoBo.FileInfo> fileInfoMap = new HashMap<String, FileImportFileFieldInfoBo.FileInfo>(16);
        if (CollectionUtils.isNotEmpty(fileList)) {
            List fileInfoList = FileImportUtils.uploadTempFile(fileList);
            for (File fileInfo : fileInfoList) {
                fileInfoMap.put(fileInfo.getFileName(), (FileImportFileFieldInfoBo.FileInfo)fileInfo);
            }
        }
        return fileInfoMap;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        super.afterExecuteOperationTransaction(args);
        if (StringUtils.equals((String)args.getOperationKey(), (String)"startimport") && this.getOperationResult().isSuccess()) {
            DynamicObject[] dataEntityArr;
            for (DynamicObject dataEntity : dataEntityArr = args.getDataEntities()) {
                String taskId = this.fileImportFileOpApplicationService.generateFileImportJob(dataEntity);
                dataEntity.set("taskId", (Object)taskId);
                dataEntity.set("taskstatus", (Object)FileImportTaskDealStatusEnum.EXECUTING.getStatus());
            }
            this.fileImportTaskEntityService.save(dataEntityArr);
        } else if (StringUtils.equals((String)args.getOperationKey(), (String)"nextstepbutton") && !this.getOperationResult().isSuccess()) {
            this.afterNextDelLocalSceneFile(args);
        }
    }

    private void afterNextDelLocalSceneFile(AfterOperationArgs args) {
        DynamicObject[] dataEntityArr = args.getDataEntities();
        String sceneNumber = dataEntityArr[0].getString("config.number");
        DynamicObjectCollection subTaskDynCol = dataEntityArr[0].getDynamicObjectCollection("subtaskentryentity");
        for (DynamicObject subTaskDyn : subTaskDynCol) {
            FileImportUtils.deleteLocalDirFile((String)sceneNumber, (String)subTaskDyn.getString("zipname"));
        }
    }
}

