/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.opplugin.web.transferconf.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.domain.transfer.entity.IConfigItemEntityService;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;

public class ConfigItemEnableValidator
extends HDTCDataBaseValidator {
    private final String enableErrorMsg = ResManager.loadKDString((String)"\u5b9e\u4f53%s\u5df2\u5b58\u5728\u542f\u7528\u7684\u914d\u7f6e\u9879\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConfigItemEnableValidator_0", (String)"hdtc-hrcc-opplugin", (Object[])new Object[0]);
    private final String mulDataErrorMsg = ResManager.loadKDString((String)"\u76f8\u540c\u5b9e\u4f53\u53ea\u80fd\u64cd\u4f5c\u4e00\u6761\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConfigItemEnableValidator_1", (String)"hdtc-hrcc-opplugin", (Object[])new Object[0]);
    private final IConfigItemEntityService entityService = (IConfigItemEntityService)ServiceFactory.getService(IConfigItemEntityService.class);

    public Set<String> preparePropertys() {
        Set propertySet = super.preparePropertys();
        propertySet.add("bizentity");
        propertySet.add("confignumber");
        return propertySet;
    }

    public void validate() {
        this.getValidateContext().setValidatePrefix("confignumber");
        this.enableValidator();
    }

    private void enableValidator() {
        Set<String> enableBizEntitySet = this.getDbHasEnableDataBizEntity();
        Map<String, List<ExtendedDataEntity>> bizEntityGroupMap = this.groupDataEntity();
        bizEntityGroupMap.forEach((bizEntity, dynList) -> {
            if (dynList.size() > 1) {
                dynList.forEach(dy -> this.addErrorMessage((ExtendedDataEntity)dy, this.mulDataErrorMsg));
            } else if (enableBizEntitySet.contains(bizEntity)) {
                ExtendedDataEntity entity = (ExtendedDataEntity)dynList.get(0);
                String msg = String.format(Locale.ROOT, this.enableErrorMsg, entity.getDataEntity().getString("name"));
                this.addErrorMessage(entity, msg);
            }
        });
    }

    private Map<String, List<ExtendedDataEntity>> groupDataEntity() {
        HashMap<String, List<ExtendedDataEntity>> bizEntityGroupMap = new HashMap<String, List<ExtendedDataEntity>>(16);
        for (ExtendedDataEntity dy : this.dataEntities) {
            List dynList = bizEntityGroupMap.getOrDefault(dy.getDataEntity().getString("bizentity.id"), new ArrayList(10));
            dynList.add(dy);
            bizEntityGroupMap.put(dy.getDataEntity().getString("bizentity.id"), dynList);
        }
        return bizEntityGroupMap;
    }

    private Set<String> getDbHasEnableDataBizEntity() {
        HashSet entitySet = new HashSet(16);
        Arrays.stream(this.dataEntities).forEach(entity -> {
            DynamicObject dyn = entity.getDataEntity();
            DynamicObject bizEntity = dyn.getDynamicObject("bizentity");
            entitySet.add(bizEntity.getString("id"));
        });
        QFilter entityFilter = new QFilter("bizentity", "in", entitySet);
        List dbConfigItemList = this.entityService.queryOriginalList("bizentity", new QFilter[]{entityFilter, QFilterConstants.Q_ENABLE});
        HashSet<String> bizEntitySet = new HashSet<String>(16);
        dbConfigItemList.forEach(dyn -> bizEntitySet.add(dyn.getString("bizentity")));
        return bizEntitySet;
    }
}

