/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.opplugin.web.transferconf.validate;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.domain.common.entity.impl.CommonServiceImpl;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;

public class ConfigTreeValidator
extends HDTCDataBaseValidator {
    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        this.checkNumber((ExtendedDataEntity[])dataEntities);
    }

    private void checkNumber(ExtendedDataEntity[] dataEntities) {
        if (dataEntities.length == 1) {
            Map<Long, String> idVsNumMap;
            CommonServiceImpl commonService = new CommonServiceImpl("ricc_configtree");
            DynamicObject confItemDyn = dataEntities[0].getDataEntity();
            QFilter filter = new QFilter("id", "=", (Object)confItemDyn.getLong("id"));
            filter.or(new QFilter("number", "=", (Object)confItemDyn.getString("number")));
            List dynList = commonService.queryOriginalList("id, number", new QFilter[]{filter});
            if (CollectionUtils.isNotEmpty((Collection)dynList) && (idVsNumMap = dynList.stream().filter(dyn -> confItemDyn.getLong("id") != dyn.getLong("id")).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("number"), (key1, key2) -> key1))).containsValue(confItemDyn.getString("number"))) {
                String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7f16\u7801\u201d \u503c \u201c%s\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"ConfigTreeValidator_2", (String)"hdtc-hrcc-opplugin", (Object[])new Object[0]), confItemDyn.getString("number"));
                this.addErrorMessage(dataEntities[0], message);
            }
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String message;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String number = dynamicObject.getString("number");
            if (!StringUtils.isNotBlank((CharSequence)number) || dynamicObject.getBoolean("issyspreset")) continue;
            if (number.length() == 1) {
                message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u975e\u9884\u7f6e\u6570\u636e\u7f16\u7801\u9700\u4ee5\u201cc_\u201d\u5f00\u5934", (String)"ConfigTreeValidator_0", (String)"hdtc-hrcc-opplugin", (Object[])new Object[0]), number);
                this.addErrorMessage(dataEntity, message);
                continue;
            }
            if (number.length() <= 1 || "c_".equals(number.substring(0, 2))) continue;
            message = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u975e\u9884\u7f6e\u6570\u636e\u7f16\u7801\u9700\u4ee5\u201cc_\u201d\u5f00\u5934", (String)"ConfigTreeValidator_1", (String)"hdtc-hrcc-opplugin", (Object[])new Object[0]), number);
            this.addErrorMessage(dataEntity, message);
        }
    }
}

