/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.common.model.confitem.entitydata;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.hdtc.hrcc.business.common.enums.HisEventEntityTypeEnum;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.CtrlRelTableBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.FieldBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.HisEventBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.RowDataBo;
import kd.hdtc.hrcc.business.common.model.confitem.valid.EntityItemClassRelBean;
import kd.hdtc.hrcc.business.common.utils.confItem.ConfItemUtils;
import kd.hdtc.hrcc.business.domain.common.entity.impl.CommonServiceImpl;
import kd.hdtc.hrcc.business.domain.transfer.configitem.model.TransferDataParamBo;
import kd.hdtc.hrcc.common.enums.EntityPropertyTypeEnum;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.revocation.HisModelEventDataService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class EntityBo
implements Serializable {
    private static final Log LOG = LogFactory.getLog(EntityBo.class);
    private static final long serialVersionUID = 6422184573884861517L;
    private String parentEntity;
    private Boolean isControlMod;
    private Boolean isHisMod;
    private Boolean isNeedAllHis;
    private String appId;
    private String entityNumber;
    private String dbRouteKey;
    private Boolean isTreeEntity = false;
    private Set<String> parentFieldSet = new HashSet<String>(16);
    private Set<String> relF7ProSet = new HashSet<String>(16);
    private Map<String, String> relF7ProVsF7EntityNumMap = new HashMap<String, String>(16);
    private List<CtrlRelTableBo> ctrlRelTableBoList = new ArrayList<CtrlRelTableBo>(10);
    private List<HisEventBo> hisEventBoList = new ArrayList<HisEventBo>(10);
    private List<RowDataBo> rowDataBoList = new ArrayList<RowDataBo>(10);
    private String mainTableName;
    public static final QFilter ENABLE_FILTER = new QFilter("enable", "=", (Object)"1");

    public EntityBo() {
    }

    public EntityBo(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public EntityBo(String entityNumber, String parentEntity, Boolean isNeedAllHis) {
        this.entityNumber = entityNumber;
        this.parentEntity = parentEntity;
        this.isNeedAllHis = isNeedAllHis;
    }

    public void generateEntityData(List<TransferDataParamBo> transferDataParamBoList) {
        this.analysisEntityInfo(transferDataParamBoList);
        QFilter dataFilter = this.getTransferEntityDataFilter(transferDataParamBoList);
        if (dataFilter == null) {
            return;
        }
        CommonServiceImpl entityService = new CommonServiceImpl(this.entityNumber);
        Object[] entityDataArr = entityService.loadDynamicObjectArray(new QFilter[]{dataFilter});
        List<DynamicObject> allEntityDataList = this.getTreeEntityDirectParentData(entityService, (DynamicObject[])entityDataArr);
        if (ObjectUtils.isEmpty((Object[])entityDataArr)) {
            LOG.info("generateEntityFieldData,entityDataArr is null");
            return;
        }
        Object[] objectArray = entityDataArr = CollectionUtils.isNotEmpty(allEntityDataList) ? allEntityDataList.toArray(new DynamicObject[0]) : entityDataArr;
        if (this.isHisMod.booleanValue()) {
            this.queryHisEventData((DynamicObject[])entityDataArr);
        }
        if (this.isControlMod.booleanValue()) {
            this.queryCtrRelTableData((DynamicObject[])entityDataArr);
        }
        this.handleDataInfo((DynamicObject[])entityDataArr);
        this.handleStructLongId(transferDataParamBoList);
        this.setRowDataIdx(transferDataParamBoList);
    }

    private List<DynamicObject> getTreeEntityDirectParentData(CommonServiceImpl entityService, DynamicObject[] entityDataArr) {
        ArrayList<DynamicObject> allEntityDataList = new ArrayList<DynamicObject>(10);
        if (this.isTreeEntity.booleanValue() && !ObjectUtils.isEmpty((Object[])entityDataArr) && CollectionUtils.isNotEmpty(this.parentFieldSet)) {
            allEntityDataList.addAll(Arrays.asList(entityDataArr));
            MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)this.entityNumber);
            for (String parentField : this.parentFieldSet) {
                Object[] towParentEntityDataDynArr;
                StringBuilder fullProNameSb;
                String fullParentField;
                Object[] parentEntityDataDynArr = this.getParentEntityData(entityService, entityDataArr, allEntityDataList, parentField, fullParentField = (fullProNameSb = this.getFullProName((EntityType)mainEntityType, parentField, new StringBuilder(), null)).toString());
                if (ObjectUtils.isEmpty((Object[])parentEntityDataDynArr) || ObjectUtils.isEmpty((Object[])(towParentEntityDataDynArr = this.getParentEntityData(entityService, (DynamicObject[])parentEntityDataDynArr, allEntityDataList, parentField, fullParentField)))) continue;
                this.getParentEntityData(entityService, (DynamicObject[])towParentEntityDataDynArr, allEntityDataList, parentField, fullParentField);
            }
        }
        return this.getDistinctDynList(allEntityDataList);
    }

    private List<DynamicObject> getDistinctDynList(List<DynamicObject> allEntityDataList) {
        if (CollectionUtils.isEmpty(allEntityDataList)) {
            return new ArrayList<DynamicObject>();
        }
        HashSet<Object> idSet = new HashSet<Object>(16);
        ArrayList<DynamicObject> distinctDynList = new ArrayList<DynamicObject>(10);
        for (DynamicObject dyn : allEntityDataList) {
            Object idObject = dyn.get("id");
            if (idSet.contains(idObject)) continue;
            distinctDynList.add(dyn);
            idSet.add(idObject);
        }
        return distinctDynList;
    }

    private StringBuilder getFullProName(EntityType mainEntityType, String findProName, StringBuilder fullProNameSb, String parentEntity) {
        for (IDataEntityProperty property : mainEntityType.getProperties()) {
            String propertyName = property.getName();
            if (StringUtils.isNotEmpty((String)property.getAlias()) && StringUtils.equals((String)propertyName, (String)findProName)) {
                if (StringUtils.isNotEmpty((String)parentEntity) && !fullProNameSb.toString().contains(parentEntity)) {
                    fullProNameSb.append(parentEntity).append(".").append(propertyName);
                    continue;
                }
                fullProNameSb.append(propertyName);
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            EntityType entityType = (EntityType)((EntryProp)property).getItemType();
            this.getFullProName(entityType, findProName, fullProNameSb, propertyName);
        }
        return fullProNameSb;
    }

    private DynamicObject[] getParentEntityData(CommonServiceImpl entityService, DynamicObject[] entityDataArr, List<DynamicObject> allEntityDataList, String parentField, String fullProName) {
        if (entityDataArr == null) {
            return null;
        }
        HashSet<Object> allEntityIdSet = new HashSet<Object>(16);
        if (CollectionUtils.isNotEmpty(allEntityDataList)) {
            allEntityIdSet.addAll(allEntityDataList.stream().map(dyn -> dyn.get("id")).collect(Collectors.toSet()));
        }
        Set<Object> parentFieldValueSet = this.getParentFieldIdValSet(entityDataArr, parentField, fullProName, allEntityIdSet);
        Object[] directParentDynArr = MetadataUtils.hisEntity((String)this.entityNumber) ? entityService.loadDynamicObjectArray(new QFilter[]{new QFilter("boid", "in", parentFieldValueSet)}) : entityService.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", parentFieldValueSet)});
        if (ObjectUtils.isEmpty((Object[])directParentDynArr)) {
            return null;
        }
        allEntityDataList.addAll(Arrays.asList(directParentDynArr));
        return directParentDynArr;
    }

    private Set<Object> getParentFieldIdValSet(DynamicObject[] entityDataArr, String parentField, String fullProName, Set<Object> allEntityIdSet) {
        HashSet<Object> parentFieldValueSet = new HashSet<Object>(16);
        for (DynamicObject entityDyn : entityDataArr) {
            if (fullProName.contains(".")) {
                this.getSubDynParentIdSet(fullProName, allEntityIdSet, parentField, parentFieldValueSet, entityDyn);
                continue;
            }
            this.getDataIdByDyn(allEntityIdSet, parentField, parentFieldValueSet, entityDyn);
        }
        return parentFieldValueSet;
    }

    private void getSubDynParentIdSet(String fullProName, Set<Object> allEntityIdSet, String parentFieldId, Set<Object> parentFieldValueSet, DynamicObject entityDyn) {
        String[] fullNameArr = fullProName.split("\\.");
        DynamicObjectCollection dynCol = entityDyn.getDynamicObjectCollection(fullNameArr[0]);
        if (dynCol != null) {
            for (DynamicObject subDyn : dynCol) {
                this.getDataIdByDyn(allEntityIdSet, parentFieldId, parentFieldValueSet, subDyn);
            }
        }
    }

    private void getDataIdByDyn(Set<Object> allEntityIdSet, String parentFieldId, Set<Object> allIdSet, Object subDetailObj) {
        String newParentFieldId = parentFieldId + ".id";
        if (subDetailObj instanceof DynamicObjectCollection) {
            this.getDynColDataId(allEntityIdSet, allIdSet, (DynamicObjectCollection)subDetailObj, newParentFieldId, false);
        } else {
            DynamicObject detailDyn = (DynamicObject)subDetailObj;
            Object subParentDyn = detailDyn.get(parentFieldId);
            if (subParentDyn != null) {
                if (subParentDyn instanceof DynamicObjectCollection) {
                    this.getDynColDataId(allEntityIdSet, allIdSet, (DynamicObjectCollection)subParentDyn, newParentFieldId, true);
                } else {
                    allIdSet.add(detailDyn.get(newParentFieldId));
                }
            }
        }
    }

    private void getDynColDataId(Set<Object> allEntityIdSet, Set<Object> allIdSet, DynamicObjectCollection subDetailObj, String newParentFieldId, boolean isMulBaseF7) {
        for (DynamicObject dyn : subDetailObj) {
            if (isMulBaseF7 && !allEntityIdSet.contains(dyn.get("fbasedataid.id"))) {
                allIdSet.add(dyn.get("fbasedataid.id"));
                continue;
            }
            if (isMulBaseF7 || allEntityIdSet.contains(dyn.get(newParentFieldId))) continue;
            allIdSet.add(dyn.get(newParentFieldId));
        }
    }

    private void handleDataInfo(DynamicObject[] entityDataArr) {
        Arrays.stream(entityDataArr).forEach(dyn -> {
            RowDataBo rowDataBo = this.convertDynToRowBo((DynamicObject)dyn, false);
            rowDataBo.setPkId(dyn.get("id"));
            if (this.isHisMod.booleanValue()) {
                rowDataBo.setBoId(dyn.getLong("boid"));
            }
            this.rowDataBoList.add(rowDataBo);
        });
    }

    protected void handleStructLongId(List<TransferDataParamBo> transferDataParamBoList) {
        for (RowDataBo rowDataBo : this.rowDataBoList) {
            rowDataBo.setStructLongId(rowDataBo.getPkId().toString());
        }
    }

    protected void setRowDataIdx(List<TransferDataParamBo> transferDataParamBoList) {
    }

    private void analysisEntityInfo(List<TransferDataParamBo> transferDataParamBoList) {
        TransferDataParamBo transferDataParamBo = transferDataParamBoList.get(0);
        MainEntityType dataEntityType = transferDataParamBo.getDataEntityType();
        this.dbRouteKey = dataEntityType.getDBRouteKey();
        this.appId = dataEntityType.getAppId();
        this.isControlMod = MetadataUtils.checkBaseDataCtrl((String)this.entityNumber);
        this.isHisMod = this.isHisModEntity(this.entityNumber);
        this.mainTableName = dataEntityType.getAlias();
        this.analysisEntityAllRefF7Pro();
        this.analysisOtherBiz(transferDataParamBo);
    }

    public void queryCtrRelTableData(DynamicObject[] entityDataArr) {
        List<Object> entityDataIdList = Arrays.stream(entityDataArr).map(dyn -> dyn.get("id")).collect(Collectors.toList());
        this.getCtrRelData(entityDataIdList, this.mainTableName);
    }

    public void getCtrRelData(List<Object> entityDataIdList, String mainTableName) {
        CtrlRelTableBo ctrlRelTableUBo;
        CtrlRelTableBo ctrlRelTableExcBo;
        this.ctrlRelTableBoList.clear();
        CtrlRelTableBo ctrlRelTableUserEgBo = this.getTableKsqlData(mainTableName + "usereg", "FDATAID", entityDataIdList);
        if (!ObjectUtils.isEmpty((Object)ctrlRelTableUserEgBo)) {
            this.ctrlRelTableBoList.add(ctrlRelTableUserEgBo);
        }
        if (!ObjectUtils.isEmpty((Object)(ctrlRelTableExcBo = this.getTableKsqlData(mainTableName + "exc", "FDATAID", entityDataIdList)))) {
            this.ctrlRelTableBoList.add(ctrlRelTableExcBo);
        }
        if (!ObjectUtils.isEmpty((Object)(ctrlRelTableUBo = this.getTableKsqlData(mainTableName + "_u", "FDATAID", entityDataIdList)))) {
            this.ctrlRelTableBoList.add(ctrlRelTableUBo);
        }
    }

    public void queryHisEventData(DynamicObject[] mainEntityDataArr) {
        DynamicObject dyEventGroup;
        Set<Long> vidSet = Arrays.stream(mainEntityDataArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        if (!ObjectUtils.isEmpty(vidSet) && !ObjectUtils.isEmpty((Object)(dyEventGroup = HisModelEventDataService.getInstance().getEventGroupDyByEntity(this.entityNumber)))) {
            DynamicObject dyEvent = dyEventGroup.getDynamicObject("evententity");
            DynamicObject dyBsEvent = dyEventGroup.getDynamicObject("busevententity");
            DynamicObject dyVersionEvent = dyEventGroup.getDynamicObject("hisevententity");
            String eventEntityNumber = dyEvent.getString("number");
            String bussEventEntityNumber = dyBsEvent.getString("number");
            String versionEventEntityNumber = dyVersionEvent.getString("number");
            CommonServiceImpl eventServiceHelper = new CommonServiceImpl(eventEntityNumber);
            CommonServiceImpl bussEventServiceHelper = new CommonServiceImpl(bussEventEntityNumber);
            CommonServiceImpl versionEventServiceHelper = new CommonServiceImpl(versionEventEntityNumber);
            Object[] versionEventDataArr = versionEventServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("vid", "in", (Object)vidSet.toArray(new Long[0]))});
            if (ObjectUtils.isEmpty((Object[])versionEventDataArr)) {
                return;
            }
            this.setHisEventBoList(versionEventEntityNumber, (DynamicObject[])versionEventDataArr, HisEventEntityTypeEnum.VER_EVENT_TYPE.getType());
            Set bizIds = Arrays.stream(versionEventDataArr).map(data -> data.getLong("busievent")).collect(Collectors.toSet());
            Object[] dyBussEvents = bussEventServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", bizIds)});
            if (ObjectUtils.isEmpty((Object[])dyBussEvents)) {
                return;
            }
            this.setHisEventBoList(bussEventEntityNumber, (DynamicObject[])dyBussEvents, HisEventEntityTypeEnum.BIZ_EVENT_TYPE.getType());
            Set eventIdSet = Arrays.stream(dyBussEvents).map(data -> data.getLong("event")).collect(Collectors.toSet());
            Object[] eventDynArr = eventServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", eventIdSet)});
            if (!ObjectUtils.isEmpty((Object[])eventDynArr)) {
                this.setHisEventBoList(eventEntityNumber, (DynamicObject[])eventDynArr, HisEventEntityTypeEnum.EVENT_TYPE.getType());
            }
        }
    }

    private void setHisEventBoList(String hisEventEntityNum, DynamicObject[] eventDataArr, String eventType) {
        HisEventBo verHisEventBo = new HisEventBo(this.entityNumber, this.appId, this.dbRouteKey, hisEventEntityNum);
        ArrayList<RowDataBo> versionEvenBotList = new ArrayList<RowDataBo>(10);
        Arrays.stream(eventDataArr).forEach(dyn -> {
            RowDataBo rowDataBo = this.convertDynToRowBo((DynamicObject)dyn, false);
            rowDataBo.setPkId(dyn.getLong("id"));
            versionEvenBotList.add(rowDataBo);
        });
        verHisEventBo.setRowDataBoList(versionEvenBotList);
        verHisEventBo.setHisEventType(eventType);
        this.hisEventBoList.add(verHisEventBo);
    }

    public CtrlRelTableBo getTableKsqlData(String tableName, String filterField, List<Object> entityDataIdList) {
        StringBuilder strWhere;
        if (HRStringUtils.isEmpty((String)tableName) || CollectionUtils.isEmpty(entityDataIdList)) {
            return null;
        }
        CtrlRelTableBo ctrlRelTableBo = new CtrlRelTableBo(this.entityNumber, this.appId, this.dbRouteKey);
        DBRoute dbRoute = DBRoute.of((String)this.dbRouteKey);
        if (DB.exitsTable((DBRoute)dbRoute, (String)tableName)) {
            strWhere = new StringBuilder();
            if (HRStringUtils.isNotEmpty((String)filterField) && !this.getEntityNumber().equals("bos_entityobject")) {
                strWhere.append(filterField).append(" in (").append(Joiner.on((char)',').join(entityDataIdList)).append(") ");
            } else if (HRStringUtils.isNotEmpty((String)filterField) && !this.isNotStrId(this.getEntityNumber())) {
                strWhere.append(filterField).append(" in ('");
                for (int i = 0; i < entityDataIdList.size(); ++i) {
                    if (i != entityDataIdList.size() - 1) {
                        strWhere.append(entityDataIdList.get(i)).append("','");
                        continue;
                    }
                    strWhere.append(entityDataIdList.get(i)).append("')");
                }
            }
        } else {
            return null;
        }
        PreInsDataScriptBuilder preInsDataScriptBuilder = new PreInsDataScriptBuilder();
        List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)tableName);
        String ksql = preInsDataScriptBuilder.genInsertSQLScript(dbRoute, tableName, String.join((CharSequence)",", columnNames), strWhere.toString(), null, null).get("sql").toString();
        ctrlRelTableBo.setTableName(tableName);
        ctrlRelTableBo.setKsql(ksql);
        ctrlRelTableBo.setCtrEntityField(filterField);
        return ctrlRelTableBo;
    }

    private QFilter getTransferEntityDataFilter(List<TransferDataParamBo> transferDataParamBoList) {
        QFilter filter = null;
        if (ObjectUtils.isEmpty(transferDataParamBoList)) {
            return null;
        }
        for (TransferDataParamBo entityFilterBo : transferDataParamBoList) {
            List<Object> fieldValueList = entityFilterBo.getFieldValueList();
            if (CollectionUtils.isEmpty(fieldValueList)) continue;
            String cpFieldPro = entityFilterBo.getFieldKey();
            if (filter == null) {
                if (this.isHisMod.booleanValue() && "id".equals(cpFieldPro)) {
                    filter = new QFilter("boid", "in", entityFilterBo.getFieldValueList());
                    continue;
                }
                filter = new QFilter(entityFilterBo.getFieldKey(), entityFilterBo.getCp(), entityFilterBo.getFieldValueList());
                continue;
            }
            QFilter subFilter = this.isHisMod != false && "id".equals(cpFieldPro) ? new QFilter("boid", "in", entityFilterBo.getFieldValueList()) : new QFilter(entityFilterBo.getFieldKey(), entityFilterBo.getCp(), entityFilterBo.getFieldValueList());
            if ("or".equals(entityFilterBo.getConnectCondition())) {
                filter.or(subFilter);
                continue;
            }
            filter.and(subFilter);
        }
        if (filter == null) {
            return null;
        }
        if (this.isHisMod.booleanValue() && !this.isNeedAllHis.booleanValue()) {
            filter.and(new QFilter("datastatus", "=", (Object)"1"));
        }
        return filter;
    }

    public QFilter getEntityKeyFieldFilter(List<RowDataBo> entityRowBoList, Set<String> keyFieldSet, boolean isHisModEntity, boolean isNeedAllHis) {
        Map<String, List<Object>> keyFieldFilterValueMap;
        QFilter keyFieldFilter;
        if (CollectionUtils.isEmpty(entityRowBoList)) {
            return null;
        }
        HashSet pkIdSet = Sets.newHashSetWithExpectedSize((int)entityRowBoList.size());
        entityRowBoList.forEach(rowDataBo -> pkIdSet.add(rowDataBo.getPkId()));
        QFilter entityKeyFieldFilter = new QFilter("id", "in", (Object)pkIdSet);
        if (isHisModEntity) {
            entityKeyFieldFilter.or(new QFilter("boid", "in", (Object)pkIdSet));
        }
        if ((keyFieldFilter = this.getKeyFieldFilter(keyFieldFilterValueMap = this.getKeyFieldFilterValueMap(entityRowBoList, keyFieldSet))) != null) {
            entityKeyFieldFilter.or(keyFieldFilter);
        }
        if (isHisModEntity && !isNeedAllHis) {
            entityKeyFieldFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        }
        LOG.info("getEntityKeyFieldFilter,keyFieldSet={},entityKeyFieldFilter={}", keyFieldSet, (Object)entityKeyFieldFilter.toSerializedString());
        return entityKeyFieldFilter;
    }

    public QFilter getKeyFieldFilter(Map<String, List<Object>> keyFieldFilterValueMap) {
        if (ObjectUtils.isEmpty(keyFieldFilterValueMap)) {
            return null;
        }
        HashMap<String, QFilter> proFilterMap = new HashMap<String, QFilter>(16);
        HashSet<String> f7RelProNameSet = new HashSet<String>(16);
        for (Map.Entry<String, List<Object>> keyFieldFilterEntry : keyFieldFilterValueMap.entrySet()) {
            String keyFieldProName = keyFieldFilterEntry.getKey();
            if (keyFieldProName.contains(".")) {
                f7RelProNameSet.add(keyFieldProName);
                continue;
            }
            List<Object> fieldFilterValList = keyFieldFilterEntry.getValue();
            if (CollectionUtils.isEmpty(fieldFilterValList)) continue;
            proFilterMap.putIfAbsent(keyFieldProName, new QFilter(keyFieldProName, "in", new HashSet<Object>(fieldFilterValList)));
        }
        this.orF7RelProNumberFilter(keyFieldFilterValueMap, proFilterMap, f7RelProNameSet);
        QFilter fieldNameFilter = null;
        for (QFilter keyFieldNameFilter : proFilterMap.values()) {
            if (fieldNameFilter == null) {
                fieldNameFilter = keyFieldNameFilter;
                continue;
            }
            fieldNameFilter.and(keyFieldNameFilter);
        }
        return fieldNameFilter;
    }

    public Map<String, List<Object>> getKeyFieldFilterValueMap(List<RowDataBo> entityRowBoList, Set<String> keyFieldSet) {
        if (ObjectUtils.isEmpty(entityRowBoList) || ObjectUtils.isEmpty(keyFieldSet)) {
            return new HashMap<String, List<Object>>(0);
        }
        HashMap<String, List<Object>> keyFieldFilterValueMap = new HashMap<String, List<Object>>(16);
        for (RowDataBo rowDataBo : entityRowBoList) {
            List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
            for (FieldBo fieldBo : fieldBoList) {
                String fieldName = fieldBo.getFieldName();
                String fieldType = fieldBo.getFieldType();
                if (EntityPropertyTypeEnum.MUL_I_LANG_TEXT_PROP.getByType().equals(fieldType) || EntityPropertyTypeEnum.ENTRY_PROP.getByType().equals(fieldType) || EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(fieldType) || !keyFieldSet.contains(fieldName)) continue;
                keyFieldFilterValueMap.putIfAbsent(fieldName, new ArrayList(10));
                List filterObjList = (List)keyFieldFilterValueMap.get(fieldName);
                if (StringUtils.isEmpty((String)fieldType)) {
                    filterObjList.add(fieldBo.getFieldValue());
                    continue;
                }
                this.setF7KeyFieldRelNumberFilterVal(keyFieldFilterValueMap, fieldBo, fieldName, filterObjList);
            }
        }
        return keyFieldFilterValueMap;
    }

    private void orF7RelProNumberFilter(Map<String, List<Object>> keyFieldFilterValueMap, Map<String, QFilter> proFilterMap, Set<String> f7RelProNameSet) {
        for (String f7RelProName : f7RelProNameSet) {
            String f7ProName = f7RelProName.split("\\.")[0];
            QFilter f7Filter = proFilterMap.get(f7ProName);
            List<Object> f7RelProValList = keyFieldFilterValueMap.get(f7RelProName);
            f7Filter.or(new QFilter(f7RelProName, "in", new HashSet<Object>(f7RelProValList)));
        }
    }

    private void setF7KeyFieldRelNumberFilterVal(Map<String, List<Object>> keyFieldFilterValueMap, FieldBo fieldBo, String fieldName, List<Object> filterObjList) {
        Map<String, Object> singleF7Map = ConfItemUtils.getSingleF7Map(fieldBo.getFieldValue());
        Object pkId = singleF7Map.get("id");
        String number = (String)singleF7Map.get("number");
        if (StringUtils.isNotEmpty((String)number)) {
            String f7NumberPro = fieldName + "." + "number";
            keyFieldFilterValueMap.putIfAbsent(f7NumberPro, new ArrayList(10));
            keyFieldFilterValueMap.get(f7NumberPro).add(number);
        }
        filterObjList.add(pkId);
    }

    public RowDataBo convertDynToRowBo(DynamicObject dyn, boolean isEntryOrSubEntry) {
        if (ObjectUtils.isEmpty((Object)dyn)) {
            return null;
        }
        DataEntityPropertyCollection dePros = dyn.getDataEntityType().getProperties();
        if (CollectionUtils.isEmpty((Collection)dePros)) {
            return null;
        }
        RowDataBo rowDataBo = new RowDataBo();
        List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
        for (IDataEntityProperty pro : dePros) {
            String proName = pro.getName();
            Object value = dyn.get(proName);
            if (ObjectUtils.isEmpty((Object)value) || proName.endsWith("_id")) continue;
            FieldBo fieldBo = new FieldBo();
            if (value instanceof DynamicObject) {
                this.setBaseData(dyn, proName, (DynamicObject)value, fieldBo, isEntryOrSubEntry);
            } else if (value instanceof DynamicObjectCollection && pro instanceof EntryProp) {
                ArrayList<RowDataBo> entryRowBoList = new ArrayList<RowDataBo>(10);
                DynamicObjectCollection dyEntryCol = (DynamicObjectCollection)value;
                for (DynamicObject dyEntry : dyEntryCol) {
                    entryRowBoList.add(this.convertDynToRowBo(dyEntry, true));
                }
                fieldBo.setFieldName(proName).setFieldValue(entryRowBoList);
                if (pro instanceof SubEntryProp) {
                    fieldBo.setFieldType(EntityPropertyTypeEnum.SUB_ENTRY_PROP.getByType());
                } else {
                    fieldBo.setFieldType(EntityPropertyTypeEnum.ENTRY_PROP.getByType());
                }
            } else if (pro instanceof MuliLangTextProp) {
                this.convertMulLangTextPropToBo(proName, (OrmLocaleValue)value, fieldBo);
            } else if (pro instanceof DateTimeProp || pro instanceof DateProp) {
                this.setDateTypeData(proName, value, fieldBo);
            } else if (pro instanceof MulBasedataProp && value instanceof MulBasedataDynamicObjectCollection) {
                this.convertMulBaseDataPropToBo(dyn, proName, (MulBasedataDynamicObjectCollection)value, fieldBo, isEntryOrSubEntry);
            } else if (pro instanceof LongProp && HRStringUtils.isEmpty((String)pro.getAlias())) {
                fieldBo.setFieldName(proName).setFieldValue(value);
            } else {
                if (HRStringUtils.isEmpty((String)pro.getAlias())) continue;
                fieldBo.setFieldName(proName).setFieldValue(value);
            }
            fieldBoList.add(fieldBo);
        }
        if (dyn.getDataEntityType().getProperties().containsKey((Object)"id")) {
            rowDataBo.setPkId(dyn.get("id"));
        }
        rowDataBo.setFieldBoList(fieldBoList);
        return rowDataBo;
    }

    private void convertMulBaseDataPropToBo(DynamicObject dyn, String proName, MulBasedataDynamicObjectCollection value, FieldBo fieldBo, boolean isEntryOrSubEntry) {
        MulBasedataDynamicObjectCollection mulBaseDataDynCol = value;
        ArrayList<RowDataBo> mulBaseRowBoList = new ArrayList<RowDataBo>(10);
        for (DynamicObject mulBaseDyn : mulBaseDataDynCol) {
            mulBaseRowBoList.add(this.convertDynToRowBo(mulBaseDyn, isEntryOrSubEntry));
        }
        fieldBo.setFieldName(proName).setFieldValue(mulBaseRowBoList);
        fieldBo.setFieldType(EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType());
        if (isEntryOrSubEntry) {
            fieldBo.setParentId(dyn.get("id"));
        }
    }

    private void convertMulLangTextPropToBo(String proName, OrmLocaleValue value, FieldBo fieldBo) {
        OrmLocaleValue ormLocaleValue = value;
        ArrayList<FieldBo> mulFieldBoList = new ArrayList<FieldBo>(10);
        for (Map.Entry ormLocal : ormLocaleValue.entrySet()) {
            FieldBo mulFieldBo = new FieldBo();
            mulFieldBo.setFieldName((String)ormLocal.getKey()).setFieldValue(ormLocal.getValue());
            mulFieldBoList.add(mulFieldBo);
        }
        fieldBo.setFieldName(proName).setFieldValue(mulFieldBoList);
        fieldBo.setFieldType(EntityPropertyTypeEnum.MUL_I_LANG_TEXT_PROP.getByType());
    }

    private void setBaseData(DynamicObject dyn, String proName, DynamicObject value, FieldBo fieldBo, boolean isEntryOrSubEntry) {
        DynamicObject baseDyn = value;
        DataEntityPropertyCollection baseDataPros = baseDyn.getDataEntityType().getProperties();
        Object pkId = baseDyn.get("id");
        ArrayList<FieldBo> f7BoList = new ArrayList<FieldBo>(10);
        FieldBo f7IdBo = new FieldBo();
        f7IdBo.setFieldName("id").setFieldValue(pkId);
        f7BoList.add(f7IdBo);
        Set baseDataFieldNameSet = baseDataPros.stream().map(IMetadata::getName).collect(Collectors.toSet());
        if (baseDataFieldNameSet.contains("number")) {
            FieldBo f7NumBo = new FieldBo();
            f7NumBo.setFieldName("number").setFieldValue(baseDyn.getString("number"));
            f7BoList.add(f7NumBo);
        }
        fieldBo.setFieldName(proName).setFieldValue(f7BoList).setRelF7IdVal(pkId);
        fieldBo.setFieldType(EntityPropertyTypeEnum.BASE_DATA_PROP.getByType());
        boolean containerId = dyn.getDataEntityType().getProperties().containsKey((Object)"id");
        if (isEntryOrSubEntry && containerId) {
            fieldBo.setParentId(dyn.get("id"));
        }
    }

    private void setDateTypeData(String proName, Object value, FieldBo fieldBo) {
        if (value instanceof Date) {
            fieldBo.setFieldName(proName).setFieldValue(((Date)value).getTime());
        } else {
            Timestamp time = (Timestamp)value;
            if (!ObjectUtils.isEmpty((Object)time)) {
                fieldBo.setFieldName(proName).setFieldValue(time.getTime());
            }
        }
    }

    public boolean isHisModEntity(String entityNum) {
        LOG.info("ConfigItemDomainServiceImpl config item entity number is {}", (Object)entityNum);
        String inhRelation = HisCommonService.getInstance().entityInhRelation(entityNum);
        return EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(inhRelation) || EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(inhRelation);
    }

    public void analysisEntityAllRefF7Pro() {
        Map allRefF7EntityPropertyMap = MetadataUtils.getAllRefF7EntityProperty((String)this.entityNumber);
        for (Map.Entry propertyEntry : allRefF7EntityPropertyMap.entrySet()) {
            String proName = (String)propertyEntry.getKey();
            IDataEntityProperty property = (IDataEntityProperty)propertyEntry.getValue();
            String baseEntityId = ((IBasedataField)property).getBaseEntityId();
            this.relF7ProVsF7EntityNumMap.put(proName, baseEntityId);
            this.relF7ProSet.add(proName);
        }
    }

    protected void analysisOtherBiz(TransferDataParamBo transferDataParamBo) {
    }

    public void boToDynamicObject(DynamicObject currentObj, RowDataBo rowDataBo) {
        if (ObjectUtils.isEmpty((Object)rowDataBo) || ObjectUtils.isEmpty((Object)currentObj) || CollectionUtils.isEmpty(rowDataBo.getFieldBoList())) {
            return;
        }
        IDataEntityType curEntityDataEntityType = currentObj.getDataEntityType();
        String entityName = curEntityDataEntityType.getName();
        DataEntityPropertyCollection properties = curEntityDataEntityType.getProperties();
        for (FieldBo fieldBo : rowDataBo.getFieldBoList()) {
            String propName;
            String boProName = fieldBo.getFieldName();
            IDataEntityProperty prop = this.getProperty(properties, boProName);
            if (ObjectUtils.isEmpty((Object)prop) || (propName = prop.getName()).endsWith("_id")) continue;
            Object fieldValue = fieldBo.getFieldValue();
            if (propName.equals("id")) {
                currentObj.set(prop, this.idCovert(entityName, fieldValue));
                continue;
            }
            if (prop instanceof BasedataProp) {
                this.setBaseDataPro(currentObj, fieldValue, prop, prop.getName());
                continue;
            }
            if (prop instanceof MulBasedataProp) {
                this.handleMulBaseDataPro(fieldBo, currentObj, propName);
                continue;
            }
            if (prop instanceof DateTimeProp) {
                currentObj.set(propName, (Object)this.objToTime(fieldValue));
                continue;
            }
            if (prop instanceof DecimalProp) {
                currentObj.set(prop, (Object)this.num(fieldValue));
                continue;
            }
            if (prop instanceof BooleanProp) {
                currentObj.set(propName, (Object)this.booleanPro(fieldValue));
                continue;
            }
            if (prop instanceof EntryProp) {
                List<RowDataBo> entryRowBoList = ConfItemUtils.getRowDataBoList(fieldValue);
                this.boToEntry(currentObj, entryRowBoList, prop.getName());
                continue;
            }
            if (prop instanceof MuliLangTextProp) {
                this.setMulLangTextPro(currentObj, ConfItemUtils.getFieldBoList(fieldValue), propName);
                continue;
            }
            currentObj.set(propName, fieldValue);
        }
    }

    public IDataEntityProperty getProperty(DataEntityPropertyCollection properties, String proKey) {
        String bdKey;
        IDataEntityProperty bdProp;
        IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)proKey);
        if (proKey.endsWith("_id") && !ObjectUtils.isEmpty((Object)(bdProp = (IDataEntityProperty)properties.get((Object)(bdKey = proKey.substring(0, proKey.lastIndexOf("_id"))))))) {
            prop = bdProp;
        }
        return prop;
    }

    public boolean isNotStrId(String entityName) {
        return !"sch_job".equals(entityName) && !"sch_schedule".equals(entityName) && !"bos_entityobject".equals(entityName) && !"sch_taskdefine".equals(entityName);
    }

    public Object idCovert(String entityName, Object id) {
        if (this.isNotStrId(entityName)) {
            return id;
        }
        try {
            id = Long.parseLong(id.toString());
        }
        catch (NumberFormatException exception) {
            LOG.error("idCovert\u53d1\u751f\u5f02\u5e38", (Throwable)exception);
            return id;
        }
        return id;
    }

    public void setBaseDataPro(DynamicObject currentObj, Object f7FieldValue, IDataEntityProperty prop, String baseProName) {
        List<FieldBo> f7FieldBoList = ConfItemUtils.getFieldBoList(f7FieldValue);
        if (CollectionUtils.isEmpty(f7FieldBoList)) {
            return;
        }
        BasedataProp baseDataPro = (BasedataProp)prop;
        String baseEntityId = baseDataPro.getBaseEntityId();
        HRBaseServiceHelper refBaseHelper = new HRBaseServiceHelper(baseEntityId);
        DynamicObject baseDyn = refBaseHelper.generateEmptyDynamicObject();
        FieldBo idFieldBo = f7FieldBoList.get(0);
        boolean isContainNumber = baseDyn.getDataEntityType().getProperties().containsKey((Object)"number");
        if (isContainNumber && f7FieldBoList.size() == 2) {
            baseDyn.set("number", f7FieldBoList.get(1).getFieldValue());
        }
        baseDyn.set("id", idFieldBo.getFieldValue());
        currentObj.set(baseProName, (Object)baseDyn);
    }

    public void handleEntryMulBaseDataPro(FieldBo mulFieldBo, DynamicObject currentObj, String propName) {
        IDataEntityType dataEntityType = currentObj.getDataEntityType();
        for (IDataEntityProperty property : dataEntityType.getProperties()) {
            if (!(property instanceof EntryProp)) continue;
            MulBasedataDynamicObjectCollection entryMulDynCol = null;
            DataEntityPropertyCollection entryProperties = ((EntryProp)property).getItemType().getProperties();
            DynamicObjectCollection entryDynCol = currentObj.getDynamicObjectCollection(property.getName());
            DynamicObject curEntryDyn = null;
            for (DynamicObject dyn : entryDynCol) {
                if (!dyn.get("id").equals(mulFieldBo.getParentId())) continue;
                curEntryDyn = dyn;
                break;
            }
            if (curEntryDyn == null) {
                return;
            }
            for (IDataEntityProperty iDataEntityProperty : entryProperties) {
                if (!(iDataEntityProperty instanceof MulBasedataProp) || !iDataEntityProperty.getName().equals(propName)) continue;
                entryMulDynCol = (MulBasedataDynamicObjectCollection)curEntryDyn.getDynamicObjectCollection(propName);
                break;
            }
            if (entryMulDynCol == null) {
                return;
            }
            Object mulBaseDataObj = mulFieldBo.getFieldValue();
            List<RowDataBo> mulBaseRowBoList = ConfItemUtils.getRowDataBoList(mulBaseDataObj);
            DynamicObjectType dynamicObjectType = entryMulDynCol.getDynamicObjectType();
            if (CollectionUtils.isEmpty(mulBaseRowBoList)) {
                return;
            }
            this.setMulF7Data(entryMulDynCol, mulBaseRowBoList, dynamicObjectType);
        }
    }

    private void setMulF7Data(MulBasedataDynamicObjectCollection entryMulDynCol, List<RowDataBo> mulBaseRowBoList, DynamicObjectType dynamicObjectType) {
        for (RowDataBo rowDataBo : mulBaseRowBoList) {
            List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
            DynamicObject mulBaseDyn = new DynamicObject(dynamicObjectType);
            for (FieldBo fieldBo : fieldBoList) {
                this.setMulBaseDynByFieldBo(fieldBo, mulBaseDyn);
            }
            entryMulDynCol.add(mulBaseDyn);
        }
    }

    public void handleMulBaseDataPro(FieldBo mulFieldBo, DynamicObject currentObj, String propName) {
        Object mulBaseDataObj = mulFieldBo.getFieldValue();
        List<RowDataBo> mulBaseRowBoList = ConfItemUtils.getRowDataBoList(mulBaseDataObj);
        MulBasedataDynamicObjectCollection mulBaseColDyn = (MulBasedataDynamicObjectCollection)currentObj.getDynamicObjectCollection(propName);
        DynamicObjectType dynamicObjectType = currentObj.getDynamicObjectCollection(propName).getDynamicObjectType();
        if (CollectionUtils.isEmpty(mulBaseRowBoList)) {
            return;
        }
        this.setMulF7Data(mulBaseColDyn, mulBaseRowBoList, dynamicObjectType);
    }

    private void setMulBaseDynByFieldBo(FieldBo fieldBo, DynamicObject mulBaseDyn) {
        DataEntityPropertyCollection mulProCol = mulBaseDyn.getDataEntityType().getProperties();
        for (IDataEntityProperty property : mulProCol) {
            if (!fieldBo.getFieldName().equals(property.getName())) continue;
            if (property instanceof BasedataProp && "fbasedataid".equals(property.getName())) {
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityId);
                DynamicObject baseDyn = new DynamicObject((DynamicObjectType)dataEntityType);
                List<FieldBo> fieldBoList = ConfItemUtils.getFieldBoList(fieldBo.getFieldValue());
                for (FieldBo bo : fieldBoList) {
                    if ("id".equals(bo.getFieldName())) {
                        baseDyn.set("id", bo.getFieldValue());
                    }
                    if (!"number".equals(bo.getFieldName())) continue;
                    baseDyn.set("number", bo.getFieldValue());
                }
                mulBaseDyn.set("fbasedataid", (Object)baseDyn);
                continue;
            }
            if (!(property instanceof LongProp) || !"pkid".equals(property.getName())) continue;
            mulBaseDyn.set("pkid", fieldBo.getFieldValue());
        }
    }

    public Timestamp objToTime(Object value) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        if (value instanceof Double) {
            double dou = (Double)value * 8.64E7;
            Date zeroDate = DateUtils.stringToDate((String)"1899-12-30", (DatePattern)DatePattern.YYYY_MM_DD);
            return new Timestamp((long)dou + (zeroDate != null ? zeroDate.getTime() : 0L));
        }
        if (value instanceof String) {
            String dateStr = String.valueOf(value);
            Date date = null;
            int length = dateStr.length();
            if (length == DatePattern.YYYY_MM_DD.getValue().length()) {
                date = DateUtils.stringToDate((String)value.toString(), (DatePattern)DatePattern.YYYY_MM_DD);
            } else if (length == DatePattern.YYYY_MM_DD_HH_MM_SS.getValue().length()) {
                date = DateUtils.stringToDate((String)value.toString(), (DatePattern)DatePattern.YYYY_MM_DD_HH_MM_SS);
            }
            if (date != null) {
                return new Timestamp(date.getTime());
            }
            return null;
        }
        String s0 = value.toString();
        if (s0 == null) {
            return null;
        }
        String str = s0.trim();
        if (str.length() == 0) {
            return null;
        }
        if (this.isLong(str)) {
            return new Timestamp(Long.parseLong(str));
        }
        return null;
    }

    public BigDecimal num(Object value) {
        if (ObjectUtils.isEmpty((Object)value)) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Boolean) {
            return Boolean.TRUE.equals(value) ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        String strVal = value.toString().trim();
        if (strVal.length() == 0) {
            return BigDecimal.ZERO;
        }
        if (strVal.indexOf(44) >= 0) {
            strVal = strVal.replace(",", "");
        }
        return "-".equals(strVal) ? BigDecimal.ZERO : new BigDecimal(strVal);
    }

    public boolean booleanPro(Object obj) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return false;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        String str = obj.toString().trim();
        if (str.length() == 0) {
            return false;
        }
        return "true".equalsIgnoreCase(str) || "1".equalsIgnoreCase(str) || "off".equalsIgnoreCase(str) || "success".equalsIgnoreCase(str) || "yes".equalsIgnoreCase(str) || "ok".equalsIgnoreCase(str);
    }

    private void boToEntry(DynamicObject currentObj, List<RowDataBo> entryRowBoList, String entryKey) {
        String curEntityNumber = currentObj.getDynamicObjectType().getName();
        DynamicObjectCollection entryCol = currentObj.getDynamicObjectCollection(entryKey);
        entryCol.clear();
        DataEntityPropertyCollection properties = entryCol.getDynamicObjectType().getProperties();
        for (RowDataBo rowDataBo : entryRowBoList) {
            List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
            DynamicObject newEntry = entryCol.addNew();
            for (FieldBo fieldBo : fieldBoList) {
                String propKey = fieldBo.getFieldName();
                Object fieldValue = fieldBo.getFieldValue();
                IDataEntityProperty prop = this.getProperty(properties, propKey);
                if (ObjectUtils.isEmpty((Object)prop)) continue;
                String propName = prop.getName();
                if (propName.equals("id") || prop.getName().equals("entryid")) {
                    newEntry.set(prop, this.idCovert(curEntityNumber, fieldValue));
                    continue;
                }
                if (prop instanceof BasedataProp) {
                    this.setBaseDataPro(newEntry, fieldValue, prop, propName);
                    continue;
                }
                if (!(prop instanceof MulBasedataProp)) {
                    if (prop instanceof DateTimeProp) {
                        newEntry.set(propName, (Object)this.objToTime(fieldValue));
                        continue;
                    }
                    if (prop instanceof DecimalProp) {
                        newEntry.set(propName, (Object)this.num(fieldValue));
                        continue;
                    }
                    if (prop instanceof BooleanProp) {
                        newEntry.set(propName, (Object)this.booleanPro(fieldValue));
                        continue;
                    }
                    if (prop instanceof EntryProp) {
                        if (!this.setBoToEntryDyn(newEntry, fieldValue, propName)) continue;
                        return;
                    }
                    if (prop instanceof MuliLangTextProp) {
                        List<FieldBo> mulFieldBoList = ConfItemUtils.getFieldBoList(fieldValue);
                        this.setMulLangTextPro(newEntry, mulFieldBoList, propName);
                        continue;
                    }
                    newEntry.set(propName, fieldValue);
                    continue;
                }
                this.handleEntryMulBaseDataPro(fieldBo, currentObj, propName);
            }
        }
    }

    private boolean setBoToEntryDyn(DynamicObject newEntry, Object fieldValue, String propName) {
        List<RowDataBo> subEntryRowBoList = ConfItemUtils.getRowDataBoList(fieldValue);
        if (CollectionUtils.isEmpty(subEntryRowBoList)) {
            return true;
        }
        DynamicObjectCollection subs = newEntry.getDynamicObjectCollection(propName);
        for (RowDataBo subRowDataBo : subEntryRowBoList) {
            DynamicObject infoDyn = subs.addNew();
            this.boToDynamicObject(infoDyn, subRowDataBo);
        }
        return false;
    }

    private void setMulLangTextPro(DynamicObject newEntry, List<FieldBo> mulFieldBoList, String propName) {
        LocaleString localeObj = new LocaleString();
        for (FieldBo fieldBo : mulFieldBoList) {
            localeObj.put(fieldBo.getFieldName(), (Object)fieldBo.getFieldValue().toString());
        }
        newEntry.set(propName, (Object)localeObj);
    }

    public boolean isLong(String dStr) {
        int j = dStr.length();
        for (int flag = 0; flag < j; ++flag) {
            char charAt = dStr.charAt(flag);
            if (charAt >= '0' && charAt <= '9') continue;
            return false;
        }
        return true;
    }

    public Map<Object, Boolean> getEntityOrgCtrInfo(String entityKey, Set<Object> orgIds) {
        HashMap<Object, Boolean> retMap = new HashMap<Object, Boolean>(16);
        if (HRStringUtils.isEmpty((String)entityKey) || ObjectUtils.isEmpty(orgIds)) {
            return retMap;
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityKey);
        if (ctrlView == null) {
            return retMap;
        }
        Set<Long> orgIdSet = this.getCuOrgIds(ctrlView, new ArrayList<Object>(orgIds));
        orgIdSet.forEach(orgId -> retMap.put(this.integerToLong(orgId), Boolean.TRUE));
        orgIds.forEach(orgId -> retMap.putIfAbsent(this.integerToLong(orgId), Boolean.FALSE));
        return retMap;
    }

    private Object integerToLong(Object id) {
        if (id instanceof Integer) {
            return Long.parseLong(id.toString());
        }
        return id;
    }

    private Set<Long> getCuOrgIds(DynamicObject ctrlView, List<Object> orgIds) {
        Long viewId = (Long)ctrlView.getPkValue();
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid from t_org_structure where fviewid = ", new Object[0]).append(viewId.toString(), new Object[0]);
        builder.append(" and fisctrlunit = '1' and ", new Object[0]);
        builder.appendIn("forgid", orgIds);
        return (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, resultSet -> {
            HashSet<Long> result = new HashSet<Long>(16);
            while (resultSet.next()) {
                result.add(resultSet.getLong("forgid"));
            }
            return result;
        });
    }

    public List<DynamicObject> getEnableConfItemInfoByEntityNumbers(String selectFields, Set<String> filterValSet, String entityNumber, String filterProperty) {
        CommonServiceImpl configItemService = new CommonServiceImpl(entityNumber);
        return configItemService.queryOriginalList(selectFields, new QFilter[]{new QFilter(filterProperty, "in", filterValSet), ENABLE_FILTER});
    }

    public Map<String, String> getItemClassFieldTypeMap(MainEntityType mainEntityType) {
        HashMap<String, String> itemClassProVsTypeProMap = new HashMap<String, String>(16);
        Map allFieldPropertyMap = mainEntityType.getAllFields();
        for (Map.Entry propertyEntry : allFieldPropertyMap.entrySet()) {
            String itemClassTypeProName = MetadataUtils.getItemClassTypeProName((MainEntityType)mainEntityType, (String)((String)propertyEntry.getKey()));
            if (StringUtils.isEmpty((String)itemClassTypeProName)) continue;
            String typePropName = ((ItemClassProp)propertyEntry.getValue()).getTypePropName();
            itemClassProVsTypeProMap.put(itemClassTypeProName, typePropName);
        }
        return itemClassProVsTypeProMap;
    }

    public Map<String, List<Map<String, Object>>> getRelItemClassF7Entity(MainEntityType mainEntityType, List<RowDataBo> rowDataBoList, String proName) {
        String itemClassTypeProName = MetadataUtils.getItemClassTypeProName((MainEntityType)mainEntityType, (String)proName);
        if (StringUtils.isEmpty((String)itemClassTypeProName)) {
            return new HashMap<String, List<Map<String, Object>>>();
        }
        HashMap<Object, EntityItemClassRelBean> entityItemClassRelBeanMap = new HashMap<Object, EntityItemClassRelBean>(16);
        this.buildEntityItemClassMapByClassTypeProName(rowDataBoList, itemClassTypeProName, entityItemClassRelBeanMap);
        this.buildEntityItemCassRelF7(rowDataBoList, proName, entityItemClassRelBeanMap);
        HashMap<String, List<Map<String, Object>>> entityVsF7Map = new HashMap<String, List<Map<String, Object>>>(16);
        for (Map.Entry itemClassRelBeanEntry : entityItemClassRelBeanMap.entrySet()) {
            EntityItemClassRelBean entityItemClassRelBean = (EntityItemClassRelBean)itemClassRelBeanEntry.getValue();
            String entityNumber = entityItemClassRelBean.getItemClassTypeProVal();
            entityVsF7Map.putIfAbsent(entityNumber, new ArrayList(10));
            ((List)entityVsF7Map.get(entityNumber)).add(entityItemClassRelBean.getItemClassRelF7Map());
        }
        return entityVsF7Map;
    }

    private Map<Object, EntityItemClassRelBean> buildEntityItemClassMapByClassTypeProName(List<RowDataBo> rowDataBoList, String itemClassTypeProName, Map<Object, EntityItemClassRelBean> entityItemClassRelBeanMap) {
        if (CollectionUtils.isEmpty(rowDataBoList)) {
            return entityItemClassRelBeanMap;
        }
        for (RowDataBo rowDataBo : rowDataBoList) {
            for (FieldBo fieldBo : rowDataBo.getFieldBoList()) {
                String fieldName = fieldBo.getFieldName();
                String fieldType = fieldBo.getFieldType();
                if (EntityPropertyTypeEnum.ENTRY_PROP.getByType().equals(fieldType)) {
                    this.buildEntityItemClassMapByClassTypeProName(ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue()), itemClassTypeProName, entityItemClassRelBeanMap);
                    continue;
                }
                if (EntityPropertyTypeEnum.SUB_ENTRY_PROP.getByType().equals(fieldType)) {
                    this.buildEntityItemClassMapByClassTypeProName(ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue()), itemClassTypeProName, entityItemClassRelBeanMap);
                    continue;
                }
                if (!itemClassTypeProName.equals(fieldName)) continue;
                entityItemClassRelBeanMap.put(rowDataBo.getPkId(), new EntityItemClassRelBean(rowDataBo.getPkId(), (String)fieldBo.getFieldValue()));
            }
        }
        return entityItemClassRelBeanMap;
    }

    private void buildEntityItemCassRelF7(List<RowDataBo> rowDataBoList, String itemClassRelF7ProName, Map<Object, EntityItemClassRelBean> entityItemClassRelBeanMap) {
        if (CollectionUtils.isEmpty(rowDataBoList)) {
            return;
        }
        for (Map.Entry<Object, EntityItemClassRelBean> relBeanEntry : entityItemClassRelBeanMap.entrySet()) {
            Object rowDataPkId = relBeanEntry.getKey();
            EntityItemClassRelBean entityItemClassRelBean = relBeanEntry.getValue();
            for (RowDataBo rowDataBo : rowDataBoList) {
                if (rowDataPkId.equals(rowDataBo.getPkId())) {
                    this.setItemClassRelF7(itemClassRelF7ProName, entityItemClassRelBean, rowDataBo);
                    continue;
                }
                this.analysisEntryAndSubEntry(itemClassRelF7ProName, entityItemClassRelBeanMap, rowDataBo);
            }
        }
    }

    private void setItemClassRelF7(String itemClassRelF7ProName, EntityItemClassRelBean entityItemClassRelBean, RowDataBo rowDataBo) {
        for (FieldBo fieldBo : rowDataBo.getFieldBoList()) {
            String fieldName = fieldBo.getFieldName();
            if (!itemClassRelF7ProName.equals(fieldName)) continue;
            entityItemClassRelBean.setItemClassRelF7Map(ConfItemUtils.getSingleF7Map(fieldBo.getFieldValue()));
        }
    }

    private void analysisEntryAndSubEntry(String itemClassRelF7ProName, Map<Object, EntityItemClassRelBean> entityItemClassRelBeanMap, RowDataBo rowDataBo) {
        for (FieldBo fieldBo : rowDataBo.getFieldBoList()) {
            String fieldType = fieldBo.getFieldType();
            if (!EntityPropertyTypeEnum.ENTRY_PROP.getByType().equals(fieldType) && !EntityPropertyTypeEnum.SUB_ENTRY_PROP.getByType().equals(fieldType)) continue;
            this.buildEntityItemCassRelF7(ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue()), itemClassRelF7ProName, entityItemClassRelBeanMap);
        }
    }

    public Map<Object, String> getItemClassTypeEntityNumByRowData(List<RowDataBo> rowDataBoList, String itemClassTypeProName, Map<Object, String> idVsEntityNumMap) {
        if (CollectionUtils.isEmpty(rowDataBoList)) {
            return idVsEntityNumMap;
        }
        block0: for (RowDataBo rowDataBo : rowDataBoList) {
            for (FieldBo fieldBo : rowDataBo.getFieldBoList()) {
                String fieldName = fieldBo.getFieldName();
                String fieldType = fieldBo.getFieldType();
                if (StringUtils.equals((String)fieldName, (String)itemClassTypeProName)) {
                    idVsEntityNumMap.put(rowDataBo.getPkId(), (String)fieldBo.getFieldValue());
                    continue block0;
                }
                if (!EntityPropertyTypeEnum.ENTRY_PROP.getByType().equals(fieldType) && !EntityPropertyTypeEnum.SUB_ENTRY_PROP.getByType().equals(fieldType)) continue;
                this.getItemClassTypeEntityNumByRowData(ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue()), itemClassTypeProName, idVsEntityNumMap);
            }
        }
        return idVsEntityNumMap;
    }

    public String getParentEntity() {
        return this.parentEntity;
    }

    public void setParentEntity(String parentEntity) {
        this.parentEntity = parentEntity;
    }

    public Boolean getControlMod() {
        return this.isControlMod;
    }

    public void setControlMod(Boolean controlMod) {
        this.isControlMod = controlMod;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String getDbRouteKey() {
        return this.dbRouteKey;
    }

    public void setDbRouteKey(String dbRouteKey) {
        this.dbRouteKey = dbRouteKey;
    }

    public Set<String> getRelF7ProSet() {
        return this.relF7ProSet;
    }

    public void setRelF7ProSet(Set<String> relF7ProSet) {
        this.relF7ProSet = relF7ProSet;
    }

    public Map<String, String> getRelF7ProVsF7EntityNumMap() {
        return this.relF7ProVsF7EntityNumMap;
    }

    public void setRelF7ProVsF7EntityNumMap(Map<String, String> relF7ProVsF7EntityNumMap) {
        this.relF7ProVsF7EntityNumMap = relF7ProVsF7EntityNumMap;
    }

    public Boolean getHisMod() {
        return this.isHisMod;
    }

    public void setHisMod(Boolean hisMod) {
        this.isHisMod = hisMod;
    }

    public List<HisEventBo> getHisEventBoList() {
        return this.hisEventBoList;
    }

    public void setHisEventBoList(List<HisEventBo> hisEventBoList) {
        this.hisEventBoList = hisEventBoList;
    }

    public Boolean getNeedAllHis() {
        return this.isNeedAllHis;
    }

    public void setNeedAllHis(Boolean needAllHis) {
        this.isNeedAllHis = needAllHis;
    }

    public List<CtrlRelTableBo> getCtrlRelTableBoList() {
        return this.ctrlRelTableBoList;
    }

    public void setCtrlRelTableBoList(List<CtrlRelTableBo> ctrlRelTableBoList) {
        this.ctrlRelTableBoList = ctrlRelTableBoList;
    }

    public List<RowDataBo> getRowDataBoList() {
        return this.rowDataBoList;
    }

    public void setRowDataBoList(List<RowDataBo> rowDataBoList) {
        this.rowDataBoList = rowDataBoList;
    }

    public String getMainTableName() {
        return this.mainTableName;
    }

    public void setMainTableName(String mainTableName) {
        this.mainTableName = mainTableName;
    }

    public Boolean getTreeEntity() {
        return this.isTreeEntity;
    }

    public void setTreeEntity(Boolean treeEntity) {
        this.isTreeEntity = treeEntity;
    }

    public Set<String> getParentFieldSet() {
        return this.parentFieldSet;
    }

    public void setParentFieldSet(Set<String> parentFieldSet) {
        this.parentFieldSet = parentFieldSet;
    }
}

