/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.common.model.confitem.entitydata;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.EntityBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.RelEntityBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.RowDataBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.SysConfItemBo;
import kd.hdtc.hrcc.business.domain.transfer.configitem.model.TransferDataParamBo;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;

public class MainEntityBo
extends EntityBo {
    private static final Log LOG = LogFactory.getLog(MainEntityBo.class);
    private static final long serialVersionUID = -3805373480933122450L;
    private List<RelEntityBo> relEntityBoList = new ArrayList<RelEntityBo>(10);
    private List<String> hrConfItemEntityNumList = new ArrayList<String>(10);
    private List<String> sysConfItemEntityNumList = new ArrayList<String>(10);
    private List<SysConfItemBo> sysConfItemBoList = new ArrayList<SysConfItemBo>(10);
    private Set<String> confItemRelF7IsRelEntityNumSet = new HashSet<String>(16);
    private final Map<String, Set<String>> sourceFieldNumVsRelEntityNumMap = new HashMap<String, Set<String>>(16);
    private String confItemMicroserviceParams;

    public MainEntityBo() {
    }

    public MainEntityBo(String entityNumber, String parentEntity, Boolean isNeedAllHis) {
        super(entityNumber, parentEntity, isNeedAllHis);
    }

    @Override
    public void setRowDataIdx(List<TransferDataParamBo> transferDataParamBoList) {
        List<RowDataBo> rowDataBoList = this.getRowDataBoList();
        TransferDataParamBo transferDataParamBo = transferDataParamBoList.get(0);
        List<Object> fieldValueList = transferDataParamBo.getFieldValueList();
        boolean isHisMod = this.getHisMod();
        Map<Object, Integer> mainBoIdVsIdxMap = transferDataParamBo.getMainBoIdVsIdxMap();
        for (int i = 0; i < fieldValueList.size(); ++i) {
            Object idValueObj = fieldValueList.get(i);
            if (ObjectUtils.isEmpty((Object)idValueObj)) continue;
            for (RowDataBo rowDataBo : rowDataBoList) {
                if (isHisMod && idValueObj.toString().equals(rowDataBo.getBoId().toString())) {
                    rowDataBo.setIndex(i + 1);
                } else if (idValueObj.toString().equals(rowDataBo.getPkId().toString())) {
                    rowDataBo.setIndex(i + 1);
                }
                mainBoIdVsIdxMap.put(rowDataBo.getPkId(), rowDataBo.getIndex());
            }
        }
    }

    @Override
    public void analysisOtherBiz(TransferDataParamBo transferDataParamBo) {
        HashSet<String> allRelBaseDataEntityNumSet = new HashSet<String>(16);
        Map<String, String> relF7ProVsF7EntityNumMap = this.getRelF7ProVsF7EntityNumMap();
        if (CollectionUtils.isEmpty(relF7ProVsF7EntityNumMap)) {
            return;
        }
        LOG.info("ConfigItemDomainServiceImpl.getConfItemData,baseEntityFieldMap={}", relF7ProVsF7EntityNumMap);
        Set<String> baseEntityBlackList = transferDataParamBo.getBaseEntityBlackList();
        relF7ProVsF7EntityNumMap.values().forEach(entityNum -> {
            if (!baseEntityBlackList.contains(entityNum)) {
                allRelBaseDataEntityNumSet.add((String)entityNum);
            }
        });
        HashSet<String> sysRelBaseDataEntityNumSet = new HashSet<String>(allRelBaseDataEntityNumSet);
        Set<String> hrAndSysConfItemEntityNumSet = this.getHrAndSysConfItemEntityNumSet(allRelBaseDataEntityNumSet, sysRelBaseDataEntityNumSet);
        this.sysConfItemEntityNumList.addAll(sysRelBaseDataEntityNumSet);
        this.hrConfItemEntityNumList.addAll(hrAndSysConfItemEntityNumSet);
        this.treeEntityAnalysis(transferDataParamBo, relF7ProVsF7EntityNumMap);
    }

    private void treeEntityAnalysis(TransferDataParamBo transferDataParamBo, Map<String, String> relF7ProVsF7EntityNumMap) {
        String entityNumber = transferDataParamBo.getEntityNumber();
        for (Map.Entry<String, String> relF7Entry : relF7ProVsF7EntityNumMap.entrySet()) {
            if (!entityNumber.equals(relF7Entry.getValue())) continue;
            this.getParentFieldSet().add(relF7Entry.getKey());
            this.setTreeEntity(true);
        }
    }

    public Set<String> getHrAndSysConfItemEntityNumSet(Set<String> allRelBaseDataEntityNumSet, Set<String> sysRelBaseDataEntityNumSet) {
        HashSet<String> hrRelBaseDataEntityNumSet = new HashSet<String>(16);
        if (CollectionUtils.isEmpty(allRelBaseDataEntityNumSet) || sysRelBaseDataEntityNumSet == null) {
            return hrRelBaseDataEntityNumSet;
        }
        List<DynamicObject> confItemDynList = this.getEnableConfItemInfoByEntityNumbers("number", allRelBaseDataEntityNumSet, "hrcc_configitems", "number");
        String confItemNumber = this.getEntityNumber();
        if (CollectionUtils.isNotEmpty(confItemDynList)) {
            hrRelBaseDataEntityNumSet.addAll(confItemDynList.stream().filter(dyn -> !confItemNumber.equals(dyn.getString("number"))).map(dyn -> dyn.getString("number")).collect(Collectors.toSet()));
        }
        sysRelBaseDataEntityNumSet.addAll(allRelBaseDataEntityNumSet);
        sysRelBaseDataEntityNumSet.removeAll(hrRelBaseDataEntityNumSet);
        sysRelBaseDataEntityNumSet.remove(confItemNumber);
        IBaseEntityService entityService = CommonEntityServiceFactory.getEntityService((String)"ricc_configitems");
        List sysConfItemDynList = entityService.queryOriginalList("page.number", new QFilter[]{new QFilter("page.number", "in", sysRelBaseDataEntityNumSet), ENABLE_FILTER});
        Set sysConfItemSet = sysConfItemDynList.stream().map(dyn -> dyn.getString("page.number")).collect(Collectors.toSet());
        sysRelBaseDataEntityNumSet.clear();
        sysRelBaseDataEntityNumSet.addAll(sysConfItemSet);
        return hrRelBaseDataEntityNumSet;
    }

    public List<RelEntityBo> getRelEntityBoList() {
        return this.relEntityBoList;
    }

    public void setRelEntityBoList(List<RelEntityBo> relEntityBoList) {
        if (CollectionUtils.isNotEmpty(relEntityBoList)) {
            this.relEntityBoList = relEntityBoList;
        }
    }

    public List<String> getHrConfItemEntityNumList() {
        return this.hrConfItemEntityNumList;
    }

    public void setHrConfItemEntityNumList(List<String> hrConfItemEntityNumList) {
        this.hrConfItemEntityNumList = hrConfItemEntityNumList;
    }

    public List<String> getSysConfItemEntityNumList() {
        return this.sysConfItemEntityNumList;
    }

    public void setSysConfItemEntityNumList(List<String> sysConfItemEntityNumList) {
        this.sysConfItemEntityNumList = sysConfItemEntityNumList;
    }

    public List<SysConfItemBo> getSysConfItemBoList() {
        return this.sysConfItemBoList;
    }

    public void setSysConfItemBoList(List<SysConfItemBo> sysConfItemBoList) {
        this.sysConfItemBoList = sysConfItemBoList;
    }

    public Set<String> getConfItemRelF7IsRelEntityNumSet() {
        return this.confItemRelF7IsRelEntityNumSet;
    }

    public void setConfItemRelF7IsRelEntityNumSet(Set<String> confItemRelF7IsRelEntityNumSet) {
        this.confItemRelF7IsRelEntityNumSet = confItemRelF7IsRelEntityNumSet;
    }

    public Map<String, Set<String>> getSourceFieldNumVsRelEntityNumMap() {
        return this.sourceFieldNumVsRelEntityNumMap;
    }

    public String getConfItemMicroserviceParams() {
        return this.confItemMicroserviceParams;
    }

    public void setConfItemMicroserviceParams(String confItemMicroserviceParams) {
        this.confItemMicroserviceParams = confItemMicroserviceParams;
    }
}

