/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.common.model.confitem.valid;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.common.ServiceFactory;
import kd.hdtc.hrcc.business.common.enums.TransferValidCueEnum;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.EntityBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.FieldBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.HisEventBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.MainEntityBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.RelEntityBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.RowDataBo;
import kd.hdtc.hrcc.business.common.model.confitem.params.EntityItemClassParamBean;
import kd.hdtc.hrcc.business.common.model.confitem.params.EntityRelF7FilterParamBo;
import kd.hdtc.hrcc.business.common.model.confitem.params.F7DataParamBo;
import kd.hdtc.hrcc.business.common.model.confitem.params.RowDataUpParamBo;
import kd.hdtc.hrcc.business.common.model.confitem.valid.F7FieldValidBo;
import kd.hdtc.hrcc.business.common.model.confitem.valid.RowDataValidCueBo;
import kd.hdtc.hrcc.business.common.utils.confItem.ConfItemUtils;
import kd.hdtc.hrcc.business.domain.common.entity.impl.CommonServiceImpl;
import kd.hdtc.hrcc.business.domain.config.entity.IHRCCBaseConfigEntityService;
import kd.hdtc.hrcc.common.enums.EntityPropertyTypeEnum;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class ConfItemValidBo {
    private static final Log LOG = LogFactory.getLog(ConfItemValidBo.class);
    private String confItemEntityNumber;
    private List<RowDataValidCueBo> f7RowDataValidCueBoList = new ArrayList<RowDataValidCueBo>(10);
    private boolean isAllSuccess = true;
    private final Long curUserId = RequestContext.get().getCurrUserId();
    private final Map<Object, Object> relOrgF7OldIdVsNewIdMap = new HashMap<Object, Object>(16);
    private final Map<Object, RowDataBo> confItemRowDataMap = new HashMap<Object, RowDataBo>(16);
    private final Map<String, List<RowDataBo>> entityRowDataBoMap = new HashMap<String, List<RowDataBo>>(16);
    private final EntityBo entityBo = new EntityBo();
    private final IHRCCBaseConfigEntityService ihrccBaseConfigEntityService = ServiceFactory.getService(IHRCCBaseConfigEntityService.class);
    private Set<String> entityRelF7PersonFieldWhiteSet = new HashSet<String>(16);

    public ConfItemValidBo() {
    }

    public ConfItemValidBo(String confItemEntityNumber) {
        this.confItemEntityNumber = confItemEntityNumber;
    }

    public void validConfItemData(MainEntityBo confItemEntityBo) {
        List<RowDataBo> rowDataBoList = confItemEntityBo.getRowDataBoList();
        this.entityRowDataBoMap.put(confItemEntityBo.getEntityNumber(), rowDataBoList);
        confItemEntityBo.getRelEntityBoList().forEach(relEntityBo -> {
            List<RowDataBo> relEntityRowDataBoList = relEntityBo.getRowDataBoList();
            if (CollectionUtils.isNotEmpty(relEntityRowDataBoList)) {
                this.entityRowDataBoMap.put(relEntityBo.getEntityNumber(), relEntityBo.getRowDataBoList());
            }
        });
        this.validMainEntityData(confItemEntityBo);
        this.validRelEntityData(confItemEntityBo);
        List<HisEventBo> hisEventBoList = confItemEntityBo.getHisEventBoList();
        this.updateHisEntityId(hisEventBoList);
    }

    private void validMainEntityData(MainEntityBo confItemEntityBo) {
        Map<String, String> confItemF7ProVsF7EntityNumMap = confItemEntityBo.getRelF7ProVsF7EntityNumMap();
        String confItemEntityNumber = confItemEntityBo.getEntityNumber();
        this.validEntityRelF7Data(confItemEntityBo, confItemEntityNumber, confItemEntityBo.getRowDataBoList(), confItemF7ProVsF7EntityNumMap, true);
    }

    private void validRelEntityData(MainEntityBo confItemEntityBo) {
        List<RelEntityBo> relEntityBoList = confItemEntityBo.getRelEntityBoList();
        for (RelEntityBo relEntityBo : relEntityBoList) {
            String relEntityNumber = relEntityBo.getEntityNumber();
            Map<String, String> relEntityF7ProVsF7EntityNumMap = relEntityBo.getRelF7ProVsF7EntityNumMap();
            List<RowDataBo> relEntityRowDataBoList = relEntityBo.getRowDataBoList();
            this.validEntityRelF7Data(confItemEntityBo, relEntityNumber, relEntityRowDataBoList, relEntityF7ProVsF7EntityNumMap, false);
        }
    }

    public DynamicObject[] loadBaseDataFromDB(String entityType, List<Object> idList, List<String> numberList) {
        if (entityType == null || ObjectUtils.isEmpty(idList)) {
            return null;
        }
        String selectedProperties = "id";
        CommonServiceImpl serviceHelper = new CommonServiceImpl(entityType);
        MainEntityType dataEntityType = MetadataUtils.getMainEntityType((String)entityType);
        QFilter filter = new QFilter("id", "in", idList);
        if (ConfItemUtils.entityContainsNumber(dataEntityType)) {
            selectedProperties = selectedProperties + ",number";
            if (!ObjectUtils.isEmpty(numberList)) {
                filter.or(new QFilter("number", "in", numberList));
            }
        } else if (MetadataUtils.hisEntity((String)entityType)) {
            filter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        }
        LOG.info("ConfItemValidBo.loadBaseDataFromDB,entityType={},filter={}", (Object)entityType, (Object)filter);
        return serviceHelper.query(selectedProperties, new QFilter[]{filter});
    }

    public void validEntityRelF7Data(MainEntityBo confItemEntityBo, String entityNumber, List<RowDataBo> rowDataBoList, Map<String, String> f7ProVsF7EntityNumMap, boolean isMainEntity) {
        boolean ctrEntity = MetadataUtils.checkBaseDataCtrl((String)entityNumber);
        String confItemEntityNum = confItemEntityBo.getEntityNumber();
        MainEntityType entityMainType = MetadataUtils.getMainEntityType((String)entityNumber);
        Map<String, Set<String>> sourceFieldRelationEntityMap = this.getSourceFieldRelationEntityMap(confItemEntityBo);
        Map<String, Set<String>> entityRelF7WhiteMap = this.ihrccBaseConfigEntityService.getEntityRelF7White();
        for (Map.Entry<String, String> f7Entry : f7ProVsF7EntityNumMap.entrySet()) {
            String f7ProName = f7Entry.getKey();
            String baseEntityId = f7Entry.getValue();
            Set<String> relEntityNumSet = sourceFieldRelationEntityMap.get(f7ProName);
            Set<String> entityRelF7WhiteSet = entityRelF7WhiteMap.get(entityNumber);
            if (CollectionUtils.isEmpty(rowDataBoList) || StringUtils.isBlank((CharSequence)f7ProName) || CollectionUtils.isNotEmpty(entityRelF7WhiteSet) && entityRelF7WhiteSet.contains(f7ProName) || CollectionUtils.isNotEmpty(relEntityNumSet) && relEntityNumSet.contains(baseEntityId)) continue;
            if (MetadataUtils.isF7ItemClass((String)entityNumber, (String)f7ProName)) {
                this.compareItemClassRelF7IdDb(confItemEntityBo, rowDataBoList, entityMainType, f7ProName);
                continue;
            }
            EntityRelF7FilterParamBo relF7FilterBo = this.getEntityRelF7FilterBo(rowDataBoList, f7ProName);
            F7DataParamBo f7DataParamBo = new F7DataParamBo(confItemEntityNum, entityNumber, f7ProName);
            f7DataParamBo.setContainNameField(ConfItemUtils.entityContainsProName(entityMainType, "name"));
            f7DataParamBo.setProName(f7ProName).setF7EntityNumber(baseEntityId).setConfItemEntity(isMainEntity).setMainEntity(isMainEntity);
            f7DataParamBo.setFieldType(ConfItemUtils.getRelFieldKeyType(entityNumber, f7ProName));
            if (CollectionUtils.isEmpty(relF7FilterBo.getIdList())) {
                LOG.info("ConfItemValidBo.validEntityRelF7Data,continue,baseEntityId={}", (Object)baseEntityId);
                continue;
            }
            HashSet<Object> dbRelF7IdSet = new HashSet<Object>(16);
            HashSet<String> dbRelF7NumSet = new HashSet<String>(16);
            Map<String, Object> dbF7EntityNumVsIdMap = this.getDbF7EntityNumVsIdMap(baseEntityId, relF7FilterBo, dbRelF7IdSet, dbRelF7NumSet);
            f7DataParamBo.setDbRelF7NumVsIdMap(dbF7EntityNumVsIdMap).setDbRelF7IdSet(dbRelF7IdSet).setCtrEntity(ctrEntity);
            List<RowDataValidCueBo> rowDataValidCueBoList = this.validF7AndUpInDb(rowDataBoList, f7DataParamBo);
            this.validF7AndUpInData(rowDataValidCueBoList, rowDataBoList, f7DataParamBo);
            this.validF7OrgView(rowDataValidCueBoList, entityNumber, f7DataParamBo);
            if (isMainEntity) {
                rowDataBoList.forEach(rowDataBo -> this.confItemRowDataMap.put(rowDataBo.getPkId(), (RowDataBo)rowDataBo));
            }
            this.assemblyValidFailCueBoList(f7DataParamBo, rowDataBoList, rowDataValidCueBoList);
        }
    }

    private void compareItemClassRelF7IdDb(MainEntityBo confItemEntityBo, List<RowDataBo> rowDataBoList, MainEntityType entityMainType, String f7ProName) {
        Map<String, List<Map<String, Object>>> relItemClassF7EntityMap = confItemEntityBo.getRelItemClassF7Entity(entityMainType, rowDataBoList, f7ProName);
        String itemClassTypeProName = MetadataUtils.getItemClassTypeProName((MainEntityType)entityMainType, (String)f7ProName);
        if (StringUtils.isEmpty((String)itemClassTypeProName)) {
            return;
        }
        HashMap<Object, String> idVsEntityNumMap = new HashMap<Object, String>(16);
        confItemEntityBo.getItemClassTypeEntityNumByRowData(rowDataBoList, itemClassTypeProName, idVsEntityNumMap);
        for (Map.Entry<String, List<Map<String, Object>>> relItemClassEntry : relItemClassF7EntityMap.entrySet()) {
            String relItemClassEntityNum = relItemClassEntry.getKey();
            List<Map<String, Object>> idAndNumMapList = relItemClassEntry.getValue();
            EntityRelF7FilterParamBo entityRelF7FilterParamBo = new EntityRelF7FilterParamBo();
            HashSet<Object> dbItemClassIdSet = new HashSet<Object>(16);
            HashSet<String> dbItemClassNumSet = new HashSet<String>(16);
            for (Map<String, Object> idAndNumMap : idAndNumMapList) {
                entityRelF7FilterParamBo.getIdList().add(idAndNumMap.get("id"));
                entityRelF7FilterParamBo.getNumberList().add((String)idAndNumMap.get("number"));
            }
            Map<String, Object> dbF7EntityNumVsIdMap = this.getDbF7EntityNumVsIdMap(relItemClassEntityNum, entityRelF7FilterParamBo, dbItemClassIdSet, dbItemClassNumSet);
            if (ObjectUtils.isEmpty(dbF7EntityNumVsIdMap)) continue;
            EntityItemClassParamBean entityItemClassParamBean = new EntityItemClassParamBean(f7ProName, itemClassTypeProName, relItemClassEntityNum);
            entityItemClassParamBean.setDbF7EntityNumVsIdMap(dbF7EntityNumVsIdMap);
            entityItemClassParamBean.getDbItemClassIdSet().addAll(dbItemClassIdSet);
            entityItemClassParamBean.getDbItemClassNumSet().addAll(dbItemClassNumSet);
            entityItemClassParamBean.setIdVsEntityNumMap(idVsEntityNumMap);
            this.compareRowDataAndUpRelId(rowDataBoList, entityItemClassParamBean);
        }
    }

    private void compareRowDataAndUpRelId(List<RowDataBo> rowDataBoList, EntityItemClassParamBean entityItemClassParamBean) {
        String relItemClassEntityNum = entityItemClassParamBean.getRelItemClassEntityNum();
        Map<Object, String> idVsEntityNumMap = entityItemClassParamBean.getIdVsEntityNumMap();
        for (RowDataBo rowDataBo : rowDataBoList) {
            for (FieldBo fieldBo : rowDataBo.getFieldBoList()) {
                String fieldName = fieldBo.getFieldName();
                String fieldType = fieldBo.getFieldType();
                if (EntityPropertyTypeEnum.SUB_ENTRY_PROP.getByType().equals(fieldType)) {
                    this.compareRowDataAndUpRelId(ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue()), entityItemClassParamBean);
                    continue;
                }
                if (EntityPropertyTypeEnum.ENTRY_PROP.getByType().equals(fieldType)) {
                    this.compareRowDataAndUpRelId(ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue()), entityItemClassParamBean);
                    continue;
                }
                if (!StringUtils.equals((String)fieldName, (String)entityItemClassParamBean.getF7ProName()) || !StringUtils.equals((String)idVsEntityNumMap.get(rowDataBo.getPkId()), (String)relItemClassEntityNum)) continue;
                this.compareValAndUpRelId(entityItemClassParamBean, fieldBo);
            }
        }
    }

    private void compareValAndUpRelId(EntityItemClassParamBean entityItemClassParamBean, FieldBo fieldBo) {
        Map<String, Object> oldItemClassRelF7Map = ConfItemUtils.getSingleF7Map(fieldBo.getFieldValue());
        Object oldRelId = oldItemClassRelF7Map.get("id");
        String oldRelNum = (String)oldItemClassRelF7Map.get("number");
        Set<String> dbItemClassNumSet = entityItemClassParamBean.getDbItemClassNumSet();
        Set<Object> dbItemClassIdSet = entityItemClassParamBean.getDbItemClassIdSet();
        Map<String, Object> dbF7EntityNumVsIdMap = entityItemClassParamBean.getDbF7EntityNumVsIdMap();
        if (dbItemClassIdSet.contains(oldRelId)) {
            return;
        }
        if (dbItemClassNumSet.contains(oldRelNum)) {
            Object newRelId = dbF7EntityNumVsIdMap.get(oldRelNum);
            LOG.info("item class f7 compareValAndUpRelId,oldRelNum={},oldRelId={},newRelId={}", new Object[]{oldRelNum, oldRelId, newRelId});
            List<FieldBo> fieldBoList = ConfItemUtils.getFieldBoList(fieldBo.getFieldValue());
            for (FieldBo bo : fieldBoList) {
                String f7FieldName = bo.getFieldName();
                if (!"id".equals(f7FieldName)) continue;
                bo.setFieldValue(newRelId);
            }
            fieldBo.setRelF7IdVal(newRelId);
            fieldBo.setFieldValue(fieldBoList);
        }
    }

    private Map<String, Set<String>> getSourceFieldRelationEntityMap(MainEntityBo confItemEntityBo) {
        HashMap<String, Set<String>> sourceFieldNumVsRelEntityNumNewMap = new HashMap<String, Set<String>>(16);
        for (Map.Entry<String, Set<String>> relationEntry : confItemEntityBo.getSourceFieldNumVsRelEntityNumMap().entrySet()) {
            String sourceFieldNum = relationEntry.getKey();
            if (sourceFieldNum.contains(".")) {
                sourceFieldNum = sourceFieldNum.split("\\.")[1];
            }
            sourceFieldNumVsRelEntityNumNewMap.put(sourceFieldNum, relationEntry.getValue());
        }
        return sourceFieldNumVsRelEntityNumNewMap;
    }

    public void updateHisEntityId(List<HisEventBo> hisEventBoList) {
        if (CollectionUtils.isEmpty(hisEventBoList)) {
            return;
        }
        Map<String, List<HisEventBo>> hisEventEntityNumBoListMap = hisEventBoList.stream().collect(Collectors.groupingBy(HisEventBo::getHisEventEntityNum));
        for (Map.Entry<String, List<HisEventBo>> hisEventEntityEntry : hisEventEntityNumBoListMap.entrySet()) {
            String hisEventEntityNum = hisEventEntityEntry.getKey();
            List<HisEventBo> eventHisEntityBoList = hisEventEntityEntry.getValue();
            if (CollectionUtils.isEmpty(eventHisEntityBoList)) continue;
            HisEventBo hisEventBo = eventHisEntityBoList.get(0);
            List<RowDataBo> rowDataBoList = hisEventBo.getRowDataBoList();
            Map entityRefF7ProMap = MetadataUtils.getEntityRefF7ProMap((String)hisEventEntityNum);
            for (Map.Entry hisEntityEntry : entityRefF7ProMap.entrySet()) {
                String f7ProName = (String)hisEntityEntry.getKey();
                String baseEntityId = (String)hisEntityEntry.getValue();
                if (CollectionUtils.isEmpty(rowDataBoList) || StringUtils.isBlank((CharSequence)f7ProName)) {
                    return;
                }
                EntityRelF7FilterParamBo relF7FilterBo = this.getEntityRelF7FilterBo(rowDataBoList, f7ProName);
                if (CollectionUtils.isEmpty(relF7FilterBo.getIdList())) {
                    LOG.info("ConfItemValidBo.updateHisEntityId,continue,baseEntityId={}", (Object)baseEntityId);
                    continue;
                }
                HashSet<Object> dbRelF7IdSet = new HashSet<Object>(16);
                HashSet<String> dbRelF7NumSet = new HashSet<String>(16);
                Map<String, Object> dbF7EntityNumVsIdMap = this.getDbF7EntityNumVsIdMap(baseEntityId, relF7FilterBo, dbRelF7IdSet, dbRelF7NumSet);
                this.compareAndUpHisEntityId(rowDataBoList, f7ProName, dbRelF7IdSet, dbRelF7NumSet, dbF7EntityNumVsIdMap);
            }
        }
    }

    private Map<String, Object> getDbF7EntityNumVsIdMap(String baseEntityId, EntityRelF7FilterParamBo relF7FilterBo, Set<Object> dbRelF7IdSet, Set<String> dbRelF7NumSet) {
        HashMap<String, Object> dbF7EntityNumVsIdMap = new HashMap<String, Object>(16);
        DynamicObject[] baseDataDynArr = this.loadBaseDataFromDB(baseEntityId, relF7FilterBo.getIdList(), relF7FilterBo.getNumberList());
        MainEntityType baseEntityType = MetadataUtils.getMainEntityType((String)baseEntityId);
        boolean containerNumber = ConfItemUtils.entityContainsNumber(baseEntityType);
        if (baseDataDynArr != null) {
            Arrays.stream(baseDataDynArr).forEach(dyn -> {
                Object f7Id = dyn.get("id");
                String f7Number = containerNumber ? dyn.getString("number") : f7Id.toString();
                dbRelF7IdSet.add(dyn.get("id"));
                dbRelF7NumSet.add(f7Number);
                dbF7EntityNumVsIdMap.put(f7Number, f7Id);
            });
        }
        return dbF7EntityNumVsIdMap;
    }

    private void compareAndUpHisEntityId(List<RowDataBo> rowDataBoList, String f7ProName, Set<Object> dbRelF7IdSet, Set<String> dbRelF7NumSet, Map<String, Object> dbF7EntityNumVsIdMap) {
        for (RowDataBo rowDataBo : rowDataBoList) {
            List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
            for (FieldBo fieldBo : fieldBoList) {
                String fieldName = fieldBo.getFieldName();
                String fieldType = fieldBo.getFieldType();
                if (StringUtils.isBlank((CharSequence)fieldType) || !f7ProName.equals(fieldName) || !EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(fieldType)) continue;
                Map<String, Object> singleF7Map = ConfItemUtils.getSingleF7Map(fieldBo.getFieldValue());
                if (this.dbRelF7IdSetContainerPkId(dbRelF7IdSet, singleF7Map.get("id"))) {
                    return;
                }
                if (!ObjectUtils.isEmpty((Object)singleF7Map.get("number")) && !CollectionUtils.isEmpty(dbRelF7NumSet) && dbRelF7NumSet.contains(singleF7Map.get("number").toString())) {
                    Object idVal = dbF7EntityNumVsIdMap.get(singleF7Map.get("number").toString());
                    this.setHisEntityRelF7Val(fieldBo, idVal);
                    continue;
                }
                if (!this.isSysPersonPro(new F7DataParamBo(f7ProName))) continue;
                this.setHisEntityRelF7Val(fieldBo, this.curUserId);
            }
        }
    }

    private void setHisEntityRelF7Val(FieldBo fieldBo, Object idVal) {
        List<FieldBo> f7BoList = ConfItemUtils.getFieldBoList(fieldBo.getFieldValue());
        ConfItemUtils.setFieldValByName(f7BoList, "id", idVal);
        fieldBo.setRelF7IdVal(idVal);
        fieldBo.setFieldValue(f7BoList);
    }

    public List<RowDataValidCueBo> validF7AndUpInDb(List<RowDataBo> rowDataBoList, F7DataParamBo f7DataParamBo) {
        Boolean confItemEntity = f7DataParamBo.getConfItemEntity();
        String mainEntityNumber = f7DataParamBo.getMainEntityNumber();
        ArrayList<RowDataValidCueBo> rowDataValidCueBoList = new ArrayList<RowDataValidCueBo>(10);
        block0: for (RowDataBo rowDataBo : rowDataBoList) {
            List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
            RowDataValidCueBo rowDataValidCueBo = new RowDataValidCueBo(mainEntityNumber, confItemEntity);
            rowDataValidCueBo.setEntityDataPkId(rowDataBo.getPkId());
            if (confItemEntity.booleanValue()) {
                rowDataValidCueBo.setConfItemEntityNumber(mainEntityNumber);
            }
            for (FieldBo fieldBo : fieldBoList) {
                List<RowDataBo> entryRowDataBoList;
                F7FieldValidBo f7FieldValidBo = new F7FieldValidBo(f7DataParamBo.getF7EntityNumber(), f7DataParamBo.getProName());
                String fieldName = fieldBo.getFieldName();
                String fieldType = fieldBo.getFieldType();
                if (StringUtils.isBlank((CharSequence)fieldType)) continue;
                f7FieldValidBo.setF7ProDisplayName(ConfItemUtils.getProDisplayName(f7DataParamBo.getMainEntityNumber(), f7DataParamBo.getProName())).setDataPkId(rowDataBo.getPkId());
                this.compareF7InDataPacket(f7DataParamBo, rowDataValidCueBoList, rowDataValidCueBo, fieldBo, f7FieldValidBo);
                if (f7FieldValidBo.isRelF7Exist() && "bos_org".equals(f7DataParamBo.getF7EntityNumber()) && f7DataParamBo.getProName().equals(fieldName)) {
                    rowDataValidCueBo.getF7FieldValidBoList().add(f7FieldValidBo);
                    rowDataValidCueBoList.add(rowDataValidCueBo);
                    continue;
                }
                if (!f7FieldValidBo.isRelF7Exist()) {
                    LOG.info("validF7Data,ENTRY_PROP,fieldName={}", (Object)f7DataParamBo.getProName());
                    rowDataValidCueBo.getF7FieldValidBoList().add(f7FieldValidBo);
                    rowDataValidCueBo.setValidSuccess(Boolean.FALSE);
                    rowDataValidCueBoList.add(rowDataValidCueBo);
                    continue block0;
                }
                if (!fieldType.equals(EntityPropertyTypeEnum.ENTRY_PROP.getByType()) || !ConfItemUtils.isContainProNameInEntryField(entryRowDataBoList = ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue()), f7DataParamBo.getProName())) continue;
                for (RowDataValidCueBo validCueBo : rowDataValidCueBoList) {
                    for (F7FieldValidBo fieldValidBo : validCueBo.getF7FieldValidBoList()) {
                        if (fieldValidBo.isRelF7Exist()) continue;
                        validCueBo.setEntryOrSubEntryPro(true);
                        validCueBo.setEntryOrSubEntryName(ConfItemUtils.getProDisplayName(f7DataParamBo.getMainEntityNumber(), f7DataParamBo.getProName()));
                    }
                }
            }
        }
        return rowDataValidCueBoList;
    }

    private void compareF7InDataPacket(F7DataParamBo f7DataParamBo, List<RowDataValidCueBo> rowDataValidCueBoList, RowDataValidCueBo rowDataValidCueBo, FieldBo fieldBo, F7FieldValidBo f7FieldValidBo) {
        String fieldName = fieldBo.getFieldName();
        String fieldType = fieldBo.getFieldType();
        if (f7DataParamBo.getProName().equals(fieldName) && EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(fieldType)) {
            List<FieldBo> f7BoList = ConfItemUtils.getFieldBoList(fieldBo.getFieldValue());
            Object f7PkIdVal = f7BoList.get(0).getFieldValue();
            String f7NumberVal = f7BoList.size() == 2 ? f7BoList.get(1).getFieldValue().toString() : "";
            f7DataParamBo.setF7PkIdVal(f7PkIdVal).setF7NumberVal(f7NumberVal).setF7FieldBoList(f7BoList);
            this.comparisonF7DataAndUpdate(fieldBo, f7DataParamBo, f7FieldValidBo);
        } else if (f7DataParamBo.getProName().equals(fieldName) && EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(fieldType)) {
            f7DataParamBo.setFieldType(EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType());
            this.comparisonF7DataAndUpdate(fieldBo, f7DataParamBo, f7FieldValidBo);
        } else if (fieldType.equals(EntityPropertyTypeEnum.ENTRY_PROP.getByType())) {
            List<RowDataBo> entryRowDataBoList = ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue());
            List<RowDataValidCueBo> entryRowDataValidCueBoList = this.comparisonEntryF7DataAndUpdate(f7DataParamBo, rowDataValidCueBo, f7FieldValidBo, entryRowDataBoList);
            fieldBo.setFieldValue(entryRowDataBoList);
            rowDataValidCueBoList.addAll(entryRowDataValidCueBoList);
        }
    }

    private boolean isSysPersonPro(F7DataParamBo f7DataParamBo) {
        if (CollectionUtils.isEmpty(this.entityRelF7PersonFieldWhiteSet)) {
            this.entityRelF7PersonFieldWhiteSet = this.ihrccBaseConfigEntityService.getEntityRelF7PersonFieldWhite();
        }
        return this.entityRelF7PersonFieldWhiteSet.contains(f7DataParamBo.getProName());
    }

    public List<RowDataValidCueBo> validF7AndUpInData(List<RowDataValidCueBo> rowDataValidCueBoList, List<RowDataBo> rowDataBoList, F7DataParamBo f7DataParamBo) {
        String f7EntityNumber = f7DataParamBo.getF7EntityNumber();
        if (CollectionUtils.isEmpty(rowDataValidCueBoList) || StringUtils.isBlank((CharSequence)f7EntityNumber)) {
            return rowDataValidCueBoList;
        }
        if (this.isSysPersonPro(f7DataParamBo)) {
            LOG.info("validF7InDataPacket,isSysPersonField");
            return rowDataValidCueBoList;
        }
        List<RowDataBo> f7EntityRowDataBoList = this.entityRowDataBoMap.get(f7EntityNumber);
        if (CollectionUtils.isEmpty(f7EntityRowDataBoList)) {
            return rowDataValidCueBoList;
        }
        Map<Object, List<RowDataValidCueBo>> rowDataValidCueBoGroupMap = rowDataValidCueBoList.stream().collect(Collectors.groupingBy(RowDataValidCueBo::getEntityDataPkId));
        Set<Object> relEntityF7PkIdSet = f7EntityRowDataBoList.stream().map(RowDataBo::getPkId).collect(Collectors.toSet());
        this.compareF7InDbData(rowDataBoList, f7DataParamBo, rowDataValidCueBoGroupMap, relEntityF7PkIdSet);
        for (RowDataValidCueBo rowDataValidCueBo : rowDataValidCueBoList) {
            boolean isAllSuccess = true;
            for (F7FieldValidBo f7FieldValidBo : rowDataValidCueBo.getF7FieldValidBoList()) {
                if (f7FieldValidBo.isRelF7Exist()) continue;
                isAllSuccess = false;
                break;
            }
            if (!isAllSuccess) continue;
            rowDataValidCueBo.setValidSuccess(true);
        }
        return rowDataValidCueBoList;
    }

    private void compareF7InDbData(List<RowDataBo> rowDataBoList, F7DataParamBo f7DataParamBo, Map<Object, List<RowDataValidCueBo>> rowDataValidCueBoGroupMap, Set<Object> relEntityF7PkIdSet) {
        String f7ProName = f7DataParamBo.getProName();
        String f7FieldType = f7DataParamBo.getFieldType();
        for (RowDataBo rowDataBo : rowDataBoList) {
            Object rowPkId = rowDataBo.getPkId();
            List<RowDataValidCueBo> pkIdRowDataValidCueBoList = rowDataValidCueBoGroupMap.get(rowPkId);
            if (CollectionUtils.isEmpty(pkIdRowDataValidCueBoList)) continue;
            for (RowDataValidCueBo dataValidCueBo : pkIdRowDataValidCueBoList) {
                List<F7FieldValidBo> f7FieldValidBoList = dataValidCueBo.getF7FieldValidBoList();
                if (CollectionUtils.isEmpty(f7FieldValidBoList)) continue;
                List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
                Map<Object, F7FieldValidBo> f7FieldValidBoMap = f7FieldValidBoList.stream().filter(bo -> f7ProName.equals(bo.getF7ProName())).collect(Collectors.toMap(F7FieldValidBo::getDataPkId, bo -> bo, (key1, key2) -> key1));
                List<Object> dataF7IdValueList = ConfItemUtils.getFieldIdValueByPropName(fieldBoList, f7ProName);
                F7FieldValidBo f7FieldValidBo = f7FieldValidBoMap.get(rowPkId);
                if (f7FieldType.equals(EntityPropertyTypeEnum.BASE_DATA_PROP.getByType())) {
                    boolean isDataF7AllContains = true;
                    for (Object f7IdValue : dataF7IdValueList) {
                        if (relEntityF7PkIdSet.contains(f7IdValue)) continue;
                        isDataF7AllContains = false;
                        break;
                    }
                    if (!isDataF7AllContains) continue;
                    f7FieldValidBo.setRelF7Exist(true);
                    continue;
                }
                if (!EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(f7FieldType)) continue;
                Map<Object, String> relF7IdVsNumMap = f7FieldValidBo.getRelF7IdVsNumMap();
                Set<Object> dataRelF7IdSet = f7FieldValidBo.getRelF7IdVsNumMap().keySet();
                int existCount = 0;
                for (Object dataRelF7Id : dataRelF7IdSet) {
                    if (!relEntityF7PkIdSet.contains(dataRelF7Id)) continue;
                    ++existCount;
                }
                if (relF7IdVsNumMap.size() != existCount) continue;
                f7FieldValidBo.setRelF7Exist(true);
            }
        }
    }

    private void validF7OrgView(List<RowDataValidCueBo> rowDataValidCueBoList, String mainEntityNumber, F7DataParamBo f7DataParamBo) {
        if (CollectionUtils.isEmpty(rowDataValidCueBoList) || !f7DataParamBo.getCtrEntity().booleanValue()) {
            return;
        }
        Set relF7IdSet = null;
        for (RowDataValidCueBo rowDataValidCueBo : rowDataValidCueBoList) {
            if (rowDataValidCueBo.getValidSuccess().booleanValue()) continue;
            List<F7FieldValidBo> f7FieldValidBoList = rowDataValidCueBo.getF7FieldValidBoList();
            relF7IdSet = f7FieldValidBoList.stream().filter(f7ValidBo -> f7ValidBo.isRelF7Exist() && "bos_org".equals(f7ValidBo.getF7EntityNumber())).map(F7FieldValidBo::getF7RelId).collect(Collectors.toSet());
        }
        if (CollectionUtils.isEmpty(relF7IdSet)) {
            return;
        }
        Map<Object, Boolean> entityOrgCtrInfo = this.entityBo.getEntityOrgCtrInfo(mainEntityNumber, relF7IdSet);
        for (RowDataValidCueBo rowDataValidCueBo : rowDataValidCueBoList) {
            List<F7FieldValidBo> f7FieldValidBoList = rowDataValidCueBo.getF7FieldValidBoList();
            for (F7FieldValidBo f7FieldValidBo : f7FieldValidBoList) {
                if (!f7FieldValidBo.isRelF7Exist() || !"bos_org".equals(f7FieldValidBo.getF7EntityNumber())) continue;
                Object f7RelId = f7FieldValidBo.getF7RelId();
                if (f7RelId instanceof Integer) {
                    f7RelId = Long.parseLong(f7RelId.toString());
                }
                if (entityOrgCtrInfo.get(f7RelId) != null && entityOrgCtrInfo.get(f7RelId).booleanValue()) continue;
                LOG.info("ConfItemValidBo.checkCtrOrgRange,f7RelId={},entityOrgCtrInfo={}", f7RelId, entityOrgCtrInfo);
                f7FieldValidBo.setBuInCtrRangeExist(false);
                rowDataValidCueBo.setValidSuccess(Boolean.FALSE);
            }
        }
    }

    public void assemblyValidFailCueBoList(F7DataParamBo f7DataParamBo, List<RowDataBo> rowDataBoList, List<RowDataValidCueBo> rowDataValidCueBoList) {
        if (CollectionUtils.isEmpty(rowDataValidCueBoList) || CollectionUtils.isEmpty(rowDataBoList)) {
            return;
        }
        Map<Object, RowDataBo> rowDataBoMap = rowDataBoList.stream().collect(Collectors.toMap(RowDataBo::getPkId, rowDataBo -> rowDataBo, (key1, key2) -> key1));
        for (RowDataValidCueBo rowDataValidCueBo : rowDataValidCueBoList) {
            if (rowDataValidCueBo.getValidSuccess().booleanValue()) continue;
            RowDataBo rowDataBo2 = rowDataBoMap.get(rowDataValidCueBo.getEntityDataPkId());
            String entityDataIde = ConfItemUtils.getEntityDataIde(f7DataParamBo.getContainNameField(), f7DataParamBo.getContainNumberField(), rowDataBo2.getFieldBoList());
            LOG.info("ConfItemValidBo.assemblyValidFailCueBoList,rowDataValidCueBo={}", (Object)SerializationUtils.toJsonString((Object)rowDataValidCueBo));
            if (f7DataParamBo.getConfItemEntity().booleanValue()) {
                this.assemblyConfItemValidFailCue(f7DataParamBo, rowDataValidCueBo, rowDataBo2, entityDataIde);
            } else {
                this.assemblyRelEntityValidFailCue(f7DataParamBo, rowDataValidCueBo, rowDataBo2, entityDataIde);
            }
            this.f7RowDataValidCueBoList.add(rowDataValidCueBo);
        }
    }

    private void assemblyRelEntityValidFailCue(F7DataParamBo f7DataParamBo, RowDataValidCueBo rowDataValidCueBo, RowDataBo rowDataBo, String entityDataIde) {
        String relEntityDataPkId;
        List<F7FieldValidBo> f7FieldValidBoList = rowDataValidCueBo.getF7FieldValidBoList();
        List<F7FieldValidBo> f7FieldNotExistList = f7FieldValidBoList.stream().filter(f7FieldValidBo -> !f7FieldValidBo.isRelF7Exist()).collect(Collectors.toList());
        List buInCtrRangeNotExistList = f7FieldValidBoList.stream().filter(f7FieldValidBo -> !f7FieldValidBo.isBuInCtrRangeExist()).collect(Collectors.toList());
        String f7FieldProInfoStr = this.getF7FieldValidFailStr(f7FieldNotExistList);
        String confItemIdStr = rowDataBo.getStructLongId().split("!")[0];
        RowDataBo confItemRowDataBo = this.confItemRowDataMap.get(Long.parseLong(confItemIdStr));
        if (confItemRowDataBo == null) {
            LOG.info("assemblyValidFailCueBoList,confItemIdStr={},ConfItemEntityNum={}", (Object)confItemIdStr, (Object)f7DataParamBo.getConfItemEntityNum());
            return;
        }
        String confItemEntityDataIde = ConfItemUtils.getEntityDataIde(f7DataParamBo.getContainNameField(), f7DataParamBo.getContainNumberField(), confItemRowDataBo.getFieldBoList());
        rowDataValidCueBo.setConfItemEntityNumber(f7DataParamBo.getConfItemEntityNum()).setConfItemDataPkId(confItemIdStr).setConfItemDataIde(confItemEntityDataIde);
        rowDataValidCueBo.setEntityNumber(f7DataParamBo.getMainEntityNumber()).setEntityDataPkId(rowDataBo.getPkId()).setEntityDataIde(entityDataIde);
        String string = relEntityDataPkId = rowDataValidCueBo.getEntityDataPkId() != null ? rowDataValidCueBo.getEntityDataPkId().toString() : "";
        if (rowDataValidCueBo.getEntryOrSubEntryPro().booleanValue() && EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            String entryOrSubEntryId = f7FieldNotExistList.get(0).getParentId().toString();
            rowDataValidCueBo.getMulF7ProNotExistsSb().append(MessageFormat.format(TransferValidCueEnum.REL_ENTITY_ENTRY_MUL_F7.getValidCue(), f7DataParamBo.getConfItemEntityNum(), rowDataBo.getPkId().toString(), entityDataIde, f7DataParamBo.getMainEntityNumber(), relEntityDataPkId, rowDataValidCueBo.getEntryOrSubEntryName(), entryOrSubEntryId, f7FieldProInfoStr, this.getMulF7ValidFailSb(f7FieldNotExistList))).append("\r\n");
        } else if (rowDataValidCueBo.getEntryOrSubEntryPro().booleanValue() && EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            String entryOrSubEntryId = f7FieldNotExistList.get(0).getParentId().toString();
            rowDataValidCueBo.getMulF7ProNotExistsSb().append(MessageFormat.format(TransferValidCueEnum.REL_ENTITY_ENTRY_F7.getValidCue(), f7DataParamBo.getConfItemEntityNum(), rowDataBo.getPkId().toString(), entityDataIde, f7DataParamBo.getMainEntityNumber(), relEntityDataPkId, rowDataValidCueBo.getEntryOrSubEntryName(), entryOrSubEntryId, f7FieldProInfoStr)).append("\r\n");
        } else if (EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            if (CollectionUtils.isNotEmpty(f7FieldNotExistList)) {
                rowDataValidCueBo.getF7ProNotExistsSb().append(MessageFormat.format(TransferValidCueEnum.REL_ENTITY_F7.getValidCue(), f7DataParamBo.getConfItemEntityNum(), confItemRowDataBo.getPkId().toString(), confItemEntityDataIde, f7DataParamBo.getMainEntityNumber(), relEntityDataPkId, f7FieldProInfoStr)).append("\r\n");
            }
            if (CollectionUtils.isNotEmpty(buInCtrRangeNotExistList)) {
                rowDataValidCueBo.getBuInCtrRangeNotExistSb().append(MessageFormat.format(TransferValidCueEnum.REL_ENTITY_F7_CTR.getValidCue(), f7DataParamBo.getConfItemEntityNum(), confItemRowDataBo.getPkId().toString(), confItemEntityDataIde, f7DataParamBo.getMainEntityNumber(), rowDataBo.getPkId())).append("\r\n");
            }
        } else if (EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            rowDataValidCueBo.getBuInCtrRangeNotExistSb().append(MessageFormat.format(TransferValidCueEnum.REL_ENTITY_MUL_F7.getValidCue(), f7DataParamBo.getConfItemEntityNum(), confItemRowDataBo.getPkId().toString(), confItemEntityDataIde, f7DataParamBo.getMainEntityNumber(), relEntityDataPkId, f7FieldProInfoStr, this.getMulF7ValidFailSb(f7FieldNotExistList))).append("\r\n");
        }
    }

    private void assemblyConfItemValidFailCue(F7DataParamBo f7DataParamBo, RowDataValidCueBo rowDataValidCueBo, RowDataBo rowDataBo, String entityDataIde) {
        List<F7FieldValidBo> f7FieldValidBoList = rowDataValidCueBo.getF7FieldValidBoList();
        List<F7FieldValidBo> f7FieldNotExistList = f7FieldValidBoList.stream().filter(f7FieldValidBo -> !f7FieldValidBo.isRelF7Exist()).collect(Collectors.toList());
        List buInCtrRangeNotExistList = f7FieldValidBoList.stream().filter(f7FieldValidBo -> !f7FieldValidBo.isBuInCtrRangeExist()).collect(Collectors.toList());
        String f7FieldNotExistStr = this.getF7FieldValidFailStr(f7FieldNotExistList);
        if (rowDataValidCueBo.getEntryOrSubEntryPro().booleanValue() && EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            Object entryOrSubEntryId = f7FieldNotExistList.get(0).getParentId();
            rowDataValidCueBo.getMulF7ProNotExistsSb().append(MessageFormat.format(TransferValidCueEnum.CONF_ENTRY_MUL_F7.getValidCue(), f7DataParamBo.getConfItemEntityNum(), rowDataBo.getPkId().toString(), entityDataIde, rowDataValidCueBo.getEntryOrSubEntryName(), entryOrSubEntryId.toString(), f7FieldNotExistStr, this.getMulF7ValidFailSb(f7FieldNotExistList))).append("\r\n");
        } else if (rowDataValidCueBo.getEntryOrSubEntryPro().booleanValue() && EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            Object entryOrSubEntryId = f7FieldNotExistList.get(0).getParentId();
            rowDataValidCueBo.getMulF7ProNotExistsSb().append(MessageFormat.format(TransferValidCueEnum.CONF_ENTRY_F7.getValidCue(), f7DataParamBo.getConfItemEntityNum(), rowDataBo.getPkId().toString(), entityDataIde, rowDataValidCueBo.getEntryOrSubEntryName(), entryOrSubEntryId.toString(), f7FieldNotExistStr)).append("\r\n");
        } else if (EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            if (CollectionUtils.isNotEmpty(f7FieldNotExistList)) {
                rowDataValidCueBo.getF7ProNotExistsSb().append(MessageFormat.format(TransferValidCueEnum.CONF_F7.getValidCue(), f7DataParamBo.getConfItemEntityNum(), rowDataBo.getPkId().toString(), entityDataIde, f7FieldNotExistStr)).append("\r\n");
            } else if (CollectionUtils.isNotEmpty(buInCtrRangeNotExistList)) {
                rowDataValidCueBo.getBuInCtrRangeNotExistSb().append(MessageFormat.format(TransferValidCueEnum.CONF_F7_CTR.getValidCue(), f7DataParamBo.getConfItemEntityNum(), rowDataBo.getPkId().toString(), entityDataIde)).append("\r\n");
            }
        } else if (EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            rowDataValidCueBo.getMulF7ProNotExistsSb().append(MessageFormat.format(TransferValidCueEnum.CONF_MUL_F7.getValidCue(), f7DataParamBo.getConfItemEntityNum(), rowDataBo.getPkId().toString(), entityDataIde, f7FieldNotExistStr, this.getMulF7ValidFailSb(f7FieldNotExistList))).append("\r\n");
        }
    }

    private String getMulF7ValidFailSb(List<F7FieldValidBo> f7FieldNotExistList) {
        StringBuilder f7FieldValidSb = new StringBuilder();
        for (F7FieldValidBo f7FieldValidBo : f7FieldNotExistList) {
            f7FieldValidSb.append(String.join((CharSequence)";", f7FieldValidBo.getRelF7IdVsNumMap().values()));
        }
        return f7FieldValidSb.toString();
    }

    public String getF7FieldValidFailStr(List<F7FieldValidBo> f7FieldValidBoList) {
        StringBuilder f7FieldValidSb = new StringBuilder();
        f7FieldValidBoList.forEach(f7FieldValidBo -> f7FieldValidSb.append(f7FieldValidBo.getF7ProName()).append('(').append(f7FieldValidBo.getF7ProDisplayName()).append(')').append(";"));
        return f7FieldValidSb.toString();
    }

    private List<RowDataValidCueBo> comparisonEntryF7DataAndUpdate(F7DataParamBo f7DataParamBo, RowDataValidCueBo rowDataValidCueBo, F7FieldValidBo f7FieldValidBo, List<RowDataBo> entryRowDataBoList) {
        ArrayList<RowDataValidCueBo> entryRowDataValidCueBoList = new ArrayList<RowDataValidCueBo>(10);
        f7FieldValidBo.setF7ProDisplayName(f7FieldValidBo.getF7ProDisplayName()).setDataPkId(f7FieldValidBo.getDataPkId());
        for (RowDataBo entryRowBo : entryRowDataBoList) {
            RowDataValidCueBo entryRowDataValidCueBo = new RowDataValidCueBo(f7DataParamBo.getMainEntityNumber(), f7DataParamBo.getConfItemEntity());
            for (FieldBo entryFbo : entryRowBo.getFieldBoList()) {
                String entryFboType = entryFbo.getFieldType();
                if (StringUtils.isEmpty((String)entryFboType) || !EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(entryFboType) && !EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(entryFboType) & !EntityPropertyTypeEnum.SUB_ENTRY_PROP.getByType().equals(entryFboType)) continue;
                F7FieldValidBo entryF7FieldValidBo = new F7FieldValidBo(f7DataParamBo.getF7EntityNumber(), f7DataParamBo.getProName());
                String fieldName = entryFbo.getFieldName();
                entryRowDataValidCueBo.setEntityDataPkId(rowDataValidCueBo.getEntityDataPkId());
                entryF7FieldValidBo.setF7ProDisplayName(f7FieldValidBo.getF7ProDisplayName()).setDataPkId(f7FieldValidBo.getDataPkId());
                if (f7DataParamBo.getProName().equals(fieldName)) {
                    this.comparisonF7DataAndUpdate(entryFbo, f7DataParamBo, entryF7FieldValidBo);
                } else if (EntityPropertyTypeEnum.SUB_ENTRY_PROP.getByType().equals(entryFboType)) {
                    this.compareSubEntryF7DataAndUpdate(f7DataParamBo, entryF7FieldValidBo, entryFbo);
                }
                if (entryF7FieldValidBo.isRelF7Exist()) continue;
                entryRowDataValidCueBo.getF7FieldValidBoList().add(entryF7FieldValidBo);
                entryRowDataValidCueBo.setValidSuccess(Boolean.FALSE);
            }
            if (entryRowDataValidCueBo.getValidSuccess().booleanValue()) continue;
            entryRowDataValidCueBoList.add(entryRowDataValidCueBo);
        }
        return entryRowDataValidCueBoList;
    }

    private void compareSubEntryF7DataAndUpdate(F7DataParamBo f7DataParamBo, F7FieldValidBo f7FieldValidBo, FieldBo entryFbo) {
        List<RowDataBo> subEntryRowDataBoList = ConfItemUtils.getRowDataBoList(entryFbo.getFieldValue());
        for (RowDataBo subEntryRowDataBo : subEntryRowDataBoList) {
            List<FieldBo> subEntryFieldBoList = subEntryRowDataBo.getFieldBoList();
            for (FieldBo subEntryFieldBo : subEntryFieldBoList) {
                if (!f7DataParamBo.getProName().equals(subEntryFieldBo.getFieldName())) continue;
                f7DataParamBo.setFieldType(subEntryFieldBo.getFieldType());
                this.comparisonF7DataAndUpdate(subEntryFieldBo, f7DataParamBo, f7FieldValidBo);
            }
        }
        entryFbo.setFieldValue(subEntryRowDataBoList);
    }

    private void comparisonF7DataAndUpdate(FieldBo fieldBo, F7DataParamBo f7DataParamBo, F7FieldValidBo f7FieldValidBo) {
        Map<String, Object> dbF7EntityNumVsIdMap = f7DataParamBo.getDbRelF7NumVsIdMap();
        Set<Object> dbRelF7IdSet = f7DataParamBo.getDbRelF7IdSet();
        if (EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            List<FieldBo> f7FieldBoList = ConfItemUtils.getFieldBoList(fieldBo.getFieldValue());
            f7DataParamBo.setF7PkIdVal(f7FieldBoList.get(0).getFieldValue());
            String numberValue = f7FieldBoList.size() == 1 ? "" : f7FieldBoList.get(1).getFieldValue().toString();
            f7DataParamBo.setF7NumberVal(numberValue);
            f7DataParamBo.setF7FieldBoList(f7FieldBoList);
            this.compareF7Data(fieldBo, f7DataParamBo, f7FieldValidBo);
        } else if (EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            this.compareMulF7Data(fieldBo, f7FieldValidBo, dbF7EntityNumVsIdMap, dbRelF7IdSet);
        }
    }

    private void compareMulF7Data(FieldBo fieldBo, F7FieldValidBo f7FieldValidBo, Map<String, Object> dbF7EntityNumVsIdMap, Set<Object> dbRelF7IdSet) {
        List<RowDataBo> mulRowDataBoList = ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue());
        Map<Object, String> failRelF7IdVsNumMap = f7FieldValidBo.getRelF7IdVsNumMap();
        boolean isContainerNumber = ConfItemUtils.entityContainsNumber(MetadataUtils.getMainEntityType((String)f7FieldValidBo.getF7EntityNumber()));
        for (RowDataBo mulRowDataBo : mulRowDataBoList) {
            List<FieldBo> mulFieldBoList = mulRowDataBo.getFieldBoList();
            for (FieldBo mulFieldBo : mulFieldBoList) {
                String numberValue;
                String mulFieldName = mulFieldBo.getFieldName();
                if (!"fbasedataid".equals(mulFieldName)) continue;
                List<FieldBo> mulBaseFieldBoList = ConfItemUtils.getFieldBoList(mulFieldBo.getFieldValue());
                Object pkIdValue = mulBaseFieldBoList.get(0).getFieldValue();
                String string = numberValue = isContainerNumber ? (String)mulBaseFieldBoList.get(1).getFieldValue() : null;
                if (dbRelF7IdSet.contains(pkIdValue) || !isContainerNumber) continue;
                Object dbRelF7PkId = dbF7EntityNumVsIdMap.get(numberValue);
                if (dbRelF7PkId != null) {
                    mulBaseFieldBoList.get(0).setFieldValue(dbRelF7PkId);
                    mulFieldBo.setFieldValue(mulBaseFieldBoList);
                    continue;
                }
                f7FieldValidBo.setRelF7Exist(false);
                failRelF7IdVsNumMap.put(pkIdValue, numberValue);
                f7FieldValidBo.setParentId(fieldBo.getParentId());
            }
        }
        fieldBo.setFieldValue(mulRowDataBoList);
    }

    private void compareF7Data(FieldBo fieldBo, F7DataParamBo f7DataParamBo, F7FieldValidBo f7FieldValidBo) {
        Object f7PkIdVal = f7DataParamBo.getF7PkIdVal();
        Set<Object> dbRelF7IdSet = f7DataParamBo.getDbRelF7IdSet();
        String f7NumberVal = f7DataParamBo.getF7NumberVal();
        Map<String, Object> dbRelF7NumVsIdMap = f7DataParamBo.getDbRelF7NumVsIdMap();
        Set<String> dbRelF7NumSet = dbRelF7NumVsIdMap.keySet();
        String proName = f7DataParamBo.getProName();
        List<FieldBo> f7FieldBoList = f7DataParamBo.getF7FieldBoList();
        if (this.dbRelF7IdSetContainerPkId(dbRelF7IdSet, f7PkIdVal)) {
            f7FieldValidBo.setRelF7Exist(true);
            return;
        }
        if (CollectionUtils.isNotEmpty(dbRelF7NumSet) && dbRelF7NumSet.contains(f7NumberVal)) {
            this.setF7BoValue(fieldBo, f7FieldValidBo, f7DataParamBo);
            return;
        }
        f7FieldValidBo.setRelF7Exist(false);
        f7FieldValidBo.setF7RelId(f7PkIdVal);
        f7FieldValidBo.setParentId(fieldBo.getParentId());
        if (this.isSysPersonPro(f7DataParamBo) && EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            LOG.info("comparisonF7DataAndUpdate isSysPersonField,proName={},f7PkIdVal={},f7NumberVal={},dbRelF7IdSet={},dbRelF7NumSet={}", new Object[]{proName, f7PkIdVal, f7NumberVal, dbRelF7IdSet, dbRelF7NumSet});
            if (!f7FieldValidBo.isRelF7Exist()) {
                this.setSysPersonIdAndNumNoExistF7(fieldBo, f7FieldValidBo, f7FieldBoList);
            }
            f7FieldValidBo.setRelF7Exist(true);
        }
    }

    private boolean dbRelF7IdSetContainerPkId(Set<Object> dbRelF7IdSet, Object f7PkIdVal) {
        if (f7PkIdVal instanceof Integer) {
            f7PkIdVal = Long.parseLong(f7PkIdVal.toString());
        }
        return dbRelF7IdSet.contains(f7PkIdVal);
    }

    private void setF7BoValue(FieldBo fieldBo, F7FieldValidBo f7FieldValidBo, F7DataParamBo f7DataParamBo) {
        Map<String, Object> dbRelF7NumVsIdMap = f7DataParamBo.getDbRelF7NumVsIdMap();
        String f7NumberVal = f7DataParamBo.getF7NumberVal();
        Object dbF7Id = dbRelF7NumVsIdMap.get(f7NumberVal);
        if (MetadataUtils.checkBaseDataCtrl((String)f7DataParamBo.getMainEntityNumber())) {
            this.relOrgF7OldIdVsNewIdMap.put(fieldBo.getRelF7IdVal(), dbF7Id);
        }
        f7DataParamBo.getF7FieldBoList().get(0).setFieldValue(dbF7Id);
        f7DataParamBo.getF7FieldBoList().get(0).setRelF7IdVal(dbF7Id);
        fieldBo.setRelF7IdVal(dbF7Id);
        fieldBo.setFieldValue(f7DataParamBo.getF7FieldBoList());
        f7FieldValidBo.setRelF7Exist(true);
        f7FieldValidBo.setF7RelId(f7DataParamBo.getF7PkIdVal());
    }

    private void setSysPersonIdAndNumNoExistF7(FieldBo fieldBo, F7FieldValidBo f7FieldValidBo, List<FieldBo> f7BoList) {
        f7FieldValidBo.setRelF7Exist(true);
        fieldBo.setRelF7IdVal(this.curUserId);
        f7BoList.get(0).setFieldValue(this.curUserId);
        f7BoList.get(0).setRelF7IdVal(this.curUserId);
        fieldBo.setFieldValue(f7BoList);
    }

    private EntityRelF7FilterParamBo getEntityRelF7FilterBo(List<RowDataBo> rowDataBoList, String proName) {
        EntityRelF7FilterParamBo relF7FilterBo = new EntityRelF7FilterParamBo();
        if (CollectionUtils.isEmpty(rowDataBoList)) {
            return relF7FilterBo;
        }
        List<FieldBo> relF7FieldBoList = ConfItemUtils.getRelF7FieldBoByPropName(rowDataBoList, proName);
        HashSet<Object> idSet = new HashSet<Object>(16);
        HashSet<String> numSet = new HashSet<String>(16);
        for (FieldBo f7FieldBo : relF7FieldBoList) {
            Object relF7IdVal = f7FieldBo.getRelF7IdVal();
            List<FieldBo> f7FieldBoList = ConfItemUtils.getFieldBoList(f7FieldBo.getFieldValue());
            for (FieldBo f7Bo : f7FieldBoList) {
                if ("id".equals(f7Bo.getFieldName()) && f7Bo.getFieldValue() != null) {
                    idSet.add(f7Bo.getFieldValue());
                    continue;
                }
                if (f7Bo.getFieldValue() == null) continue;
                numSet.add(f7Bo.getFieldValue().toString());
            }
            if (!CollectionUtils.isEmpty(f7FieldBoList)) continue;
            relF7FilterBo.getIdList().add(relF7IdVal);
        }
        relF7FilterBo.getIdList().addAll(idSet);
        relF7FilterBo.getNumberList().addAll(numSet);
        return relF7FilterBo;
    }

    public void validNeedAllHisData(RowDataUpParamBo rowDataUpParamBo, List<DynamicObject> dbEntityDynList, List<RowDataBo> entityRowDataBoList) {
        String entityNumber = rowDataUpParamBo.getEntityNumber();
        Set dataPkIdSet = entityRowDataBoList.stream().map(RowDataBo::getPkId).collect(Collectors.toSet());
        List dbVidNotExistInPacketDataList = dbEntityDynList.stream().filter(dyn -> !dyn.getBoolean("iscurrentversion") && !dataPkIdSet.contains(dyn.get("id"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(dbVidNotExistInPacketDataList)) {
            MainEntityType dynEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
            List<Object> notExistPkIdList = dbVidNotExistInPacketDataList.stream().map(dyn -> dyn.get("id")).collect(Collectors.toList());
            Map<Object, Long> packetDataPkIdVsBoIdMap = dbVidNotExistInPacketDataList.stream().collect(Collectors.toMap(dyn -> dyn.get("id"), dyn -> dyn.getLong("boid")));
            HashSet<Object> notExistBoIdSet = new HashSet<Object>(packetDataPkIdVsBoIdMap.values());
            Map<Object, BaseDataCheckRefrenceResult> cheRelResultMap = ConfItemUtils.checkRef((BasedataEntityType)dynEntityType, notExistPkIdList.toArray(new Object[0]));
            if (cheRelResultMap == null || cheRelResultMap.size() == 0) {
                return;
            }
            this.assemblyHisEntityErrMsg(rowDataUpParamBo, entityRowDataBoList, packetDataPkIdVsBoIdMap, notExistBoIdSet, cheRelResultMap);
        }
    }

    private void assemblyHisEntityErrMsg(RowDataUpParamBo rowDataUpParamBo, List<RowDataBo> entityRowDataBoList, Map<Object, Long> packetDataPkIdVsBoIdMap, Set<Object> notExistBoIdSet, Map<Object, BaseDataCheckRefrenceResult> cheRelResultMap) {
        String entityNumber = rowDataUpParamBo.getEntityNumber();
        Map<Long, List<RowDataBo>> notExistIdVsRowDataListMap = entityRowDataBoList.stream().filter(rowDataBo -> notExistBoIdSet.contains(rowDataBo.getBoId()) && !rowDataBo.getBoId().equals(rowDataBo.getPkId())).collect(Collectors.groupingBy(RowDataBo::getBoId));
        String confEntityCueDesc = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u5b9e\u4f53\u4e3a{0}\uff0c\u6570\u636eid\u4e3a{1}\uff0c\u6570\u636e\u6807\u8bc6\u4e3a{2}\uff0c{3}\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConfItemValidBo_0", (String)"hdtc-hrcc-business", (Object[])new Object[0]);
        String relEntityCueDesc = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u5b9e\u4f53\u4e3a{0}\uff0c\u6570\u636eid\u4e3a{1}\uff0c\u6570\u636e\u6807\u8bc6\u4e3a{2}\u7684\u5173\u8054\u7684\u5b9e\u4f53\u4e3a{3}\uff0c\u7684\u6570\u636e\u6807\u8bc6{4}\uff0c{5}\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ConfItemValidBo_1", (String)"hdtc-hrcc-business", (Object[])new Object[0]);
        StringBuilder cheHisErrCueMsgSb = new StringBuilder();
        Set<Object> cheErrAllPkIdSet = rowDataUpParamBo.getCheErrPkIdSet();
        Set<Object> cheErrConfItemPkIdSet = rowDataUpParamBo.getCheErrConfItemPkIdSet();
        HashSet<Long> boIdSet = new HashSet<Long>(16);
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        boolean isContainerNumber = ConfItemUtils.entityContainsNumber(mainEntityType);
        boolean isContainerName = ConfItemUtils.entityContainsProName(mainEntityType, "name");
        for (Map.Entry<Object, BaseDataCheckRefrenceResult> relEntry : cheRelResultMap.entrySet()) {
            if (!relEntry.getValue().isRefence()) continue;
            Long packetDataBoId = packetDataPkIdVsBoIdMap.get(relEntry.getKey());
            List<RowDataBo> rowDataBoList = notExistIdVsRowDataListMap.get(packetDataBoId);
            for (RowDataBo rowDataBo2 : rowDataBoList) {
                String hisRelCheCueErrMsg;
                String notExistRowDataStructId = rowDataBo2.getStructLongId();
                String confItemPkId = notExistRowDataStructId.split("!")[0];
                String entityDataIde = ConfItemUtils.getEntityDataIde(isContainerName, isContainerNumber, rowDataBo2.getFieldBoList());
                if (StringUtils.isEmpty((String)notExistRowDataStructId)) {
                    LOG.info("compareMainEntityAndUpId,his data,ConfItemNumber={},EntityNumber={},pkId={}", new Object[]{rowDataUpParamBo.getConfItemNumber(), rowDataUpParamBo.getEntityNumber(), rowDataBo2.getPkId()});
                }
                String relMsg = ConfItemUtils.buildRefMessage(relEntry.getValue());
                cheErrConfItemPkIdSet.add(confItemPkId);
                cheErrAllPkIdSet.add(rowDataBo2.getPkId());
                if (rowDataUpParamBo.getRelEntity().booleanValue()) {
                    RowDataBo confItemRowDataBo = this.confItemRowDataMap.get(Long.parseLong(confItemPkId));
                    String confItemEntityDataIde = ConfItemUtils.getEntityDataIde(isContainerName, isContainerNumber, confItemRowDataBo.getFieldBoList());
                    hisRelCheCueErrMsg = MessageFormat.format(relEntityCueDesc, rowDataUpParamBo.getConfItemNumber(), confItemRowDataBo.getPkId().toString(), confItemEntityDataIde, entityNumber, rowDataBo2.getPkId(), relMsg);
                } else {
                    hisRelCheCueErrMsg = MessageFormat.format(confEntityCueDesc, rowDataUpParamBo.getConfItemNumber(), rowDataBo2.getPkId().toString(), entityDataIde, relMsg);
                }
                cheHisErrCueMsgSb.append(hisRelCheCueErrMsg).append("\r\n");
                boIdSet.add(rowDataBo2.getBoId());
            }
        }
        LOG.info("assemblyHisEntityErrMsg,before add bo of all vid data,isRefence.vids={},cheErrConfItemPkIdSet={}", cheErrAllPkIdSet, cheErrConfItemPkIdSet);
        cheErrAllPkIdSet.addAll(cheErrConfItemPkIdSet);
        cheErrAllPkIdSet.addAll(entityRowDataBoList.stream().filter(rowDataBo -> boIdSet.contains(rowDataBo.getBoId())).map(RowDataBo::getPkId).collect(Collectors.toSet()));
        rowDataUpParamBo.setCheckErrCueMsg(cheHisErrCueMsgSb.toString());
    }

    public void validPacketPkIdRepeat(RowDataUpParamBo rowDataUpParamBo) {
        List<RowDataBo> entityRowDataBoList = rowDataUpParamBo.getEntityRowDataBoList();
        if (CollectionUtils.isEmpty(entityRowDataBoList)) {
            return;
        }
        Set<Object> cheErrAllPkIdSet = rowDataUpParamBo.getCheErrPkIdSet();
        Map<Object, List<RowDataBo>> pkIdGroupBoListMap = entityRowDataBoList.stream().collect(Collectors.groupingBy(RowDataBo::getPkId));
        String entityCueDesc = ResManager.loadKDString((String)"\u5b9e\u4f53\u4e3a{0}\uff0c\u6570\u636eid\u4e3a{1}\uff0c\u6570\u636e\u6807\u8bc6\u4e3a\u201d{2}\u201c\u53d1\u751f\u4e3b\u952e\u51b2\u7a81\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u6253\u5305\u4f20\u8f93\u540c\u6b65\u3002", (String)"ConfItemValidBo_2", (String)"hdtc-hrcc-business", (Object[])new Object[0]);
        String entityNumber = rowDataUpParamBo.getEntityNumber();
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        boolean isContainerNumber = ConfItemUtils.entityContainsNumber(mainEntityType);
        boolean isContainerName = ConfItemUtils.entityContainsProName(mainEntityType, "name");
        StringBuilder idRepeatCueSb = new StringBuilder();
        for (Map.Entry<Object, List<RowDataBo>> boEntry : pkIdGroupBoListMap.entrySet()) {
            Object pkId = boEntry.getKey();
            List<RowDataBo> rowDataList = boEntry.getValue();
            if (rowDataList.size() <= 1) continue;
            cheErrAllPkIdSet.add(pkId);
            StringBuilder repeatIdDataIdeSb = new StringBuilder();
            for (RowDataBo rowDataBo : rowDataList) {
                repeatIdDataIdeSb.append(ConfItemUtils.getEntityDataIde(isContainerName, isContainerNumber, rowDataBo.getFieldBoList())).append(";");
            }
            String repeatIdDataIde = repeatIdDataIdeSb.substring(0, repeatIdDataIdeSb.lastIndexOf(";"));
            idRepeatCueSb.append(MessageFormat.format(entityCueDesc, entityNumber, pkId.toString(), repeatIdDataIde)).append("\r\n");
        }
        StringBuilder errMsgSb = new StringBuilder();
        if (StringUtils.isNotEmpty((String)rowDataUpParamBo.getCheckErrCueMsg())) {
            errMsgSb.append(rowDataUpParamBo.getCheckErrCueMsg()).append("\r\n").append((CharSequence)idRepeatCueSb);
        } else {
            errMsgSb.append((CharSequence)idRepeatCueSb);
        }
        rowDataUpParamBo.setCheckErrCueMsg(errMsgSb.toString());
    }

    public String getConfItemEntityNumber() {
        return this.confItemEntityNumber;
    }

    public void setConfItemEntityNumber(String confItemEntityNumber) {
        this.confItemEntityNumber = confItemEntityNumber;
    }

    public boolean isAllSuccess() {
        return this.isAllSuccess;
    }

    public void setAllSuccess(boolean allSuccess) {
        this.isAllSuccess = allSuccess;
    }

    public List<RowDataValidCueBo> getF7RowDataValidCueBoList() {
        return this.f7RowDataValidCueBoList;
    }

    public void setF7RowDataValidCueBoList(List<RowDataValidCueBo> f7RowDataValidCueBoList) {
        this.f7RowDataValidCueBoList = f7RowDataValidCueBoList;
    }

    public Map<String, List<RowDataBo>> getEntityRowDataBoMap() {
        return this.entityRowDataBoMap;
    }

    public Map<Object, Object> getRelOrgF7OldIdVsNewIdMap() {
        return this.relOrgF7OldIdVsNewIdMap;
    }
}

