/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.common.utils;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfItemDyObjectUtils {
    public static Map<String, Object> convertDynamicObjectToMap(DynamicObject dy) throws KDBizException {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (dy == null) {
            return map;
        }
        DataEntityPropertyCollection dePros = dy.getDataEntityType().getProperties();
        if (dePros == null || dePros.size() == 0) {
            return map;
        }
        for (IDataEntityProperty pro : dePros) {
            String proName = pro.getName();
            Object value = dy.get(proName);
            if (value instanceof DynamicObject) {
                DynamicObject baseDyn = (DynamicObject)value;
                DataEntityPropertyCollection baseDataPros = baseDyn.getDataEntityType().getProperties();
                HashMap<String, Object> f7Map = new HashMap<String, Object>(2);
                f7Map.put("id", baseDyn.get("id"));
                f7Map.putIfAbsent("number", "");
                Set baseDataFieldNameSet = baseDataPros.stream().map(IMetadata::getName).collect(Collectors.toSet());
                if (baseDataFieldNameSet.contains("number")) {
                    f7Map.put("number", baseDyn.getString("number"));
                }
                map.put(proName, f7Map);
                continue;
            }
            if (value instanceof DynamicObjectCollection && pro instanceof EntryProp) {
                ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>();
                DynamicObjectCollection dyEntryCol = (DynamicObjectCollection)value;
                for (DynamicObject dyEntry : dyEntryCol) {
                    entryList.add(ConfItemDyObjectUtils.convertDynamicObjectToMap(dyEntry));
                }
                map.put(proName, entryList);
                continue;
            }
            if (pro instanceof MuliLangTextProp) {
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)value;
                map.put(proName, ormLocaleValue);
                continue;
            }
            if (pro instanceof DateTimeProp || pro instanceof DateProp) {
                if (value instanceof Date) {
                    map.put(proName, ((Date)value).getTime());
                    continue;
                }
                Timestamp time = (Timestamp)value;
                if (time == null) continue;
                map.put(proName, time.getTime());
                continue;
            }
            if (pro instanceof MulBasedataProp && value instanceof MulBasedataDynamicObjectCollection) {
                MulBasedataDynamicObjectCollection mulBaseDataDynCol = (MulBasedataDynamicObjectCollection)value;
                ArrayList<Map<String, Object>> mulBaseDataMapList = new ArrayList<Map<String, Object>>();
                for (DynamicObject mulBaseDyn : mulBaseDataDynCol) {
                    mulBaseDataMapList.add(ConfItemDyObjectUtils.convertDynamicObjectToMap(mulBaseDyn));
                }
                map.put(proName, mulBaseDataMapList);
                continue;
            }
            if (pro instanceof LongProp && HRStringUtils.isEmpty((String)pro.getAlias())) {
                map.put(proName, value);
                continue;
            }
            if (HRStringUtils.isEmpty((String)pro.getAlias())) continue;
            map.put(proName, value);
        }
        return map;
    }
}

