/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.common.utils.confItem;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.SubEntryProp;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.FieldBo;
import kd.hdtc.hrcc.business.common.model.confitem.entitydata.RowDataBo;
import kd.hdtc.hrcc.common.enums.EntityPropertyTypeEnum;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class ConfItemUtils {
    public static String getRelFieldKeyType(String entityNumber, String propName) {
        IDataEntityProperty type = MetadataUtils.getItemFromProps((IDataEntityType)MetadataUtils.getMainEntityType((String)entityNumber), (String)propName);
        if (type == null) {
            return null;
        }
        if (type instanceof BasedataProp) {
            return EntityPropertyTypeEnum.BASE_DATA_PROP.getByType();
        }
        if (type instanceof MulBasedataProp) {
            return EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType();
        }
        if (type instanceof EntryProp) {
            return EntityPropertyTypeEnum.ENTRY_PROP.getByType();
        }
        if (type instanceof MuliLangTextProp) {
            return EntityPropertyTypeEnum.MUL_I_LANG_TEXT_PROP.getByType();
        }
        return type.getName();
    }

    public static String getProDisplayName(String entityNumber, String propName) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        for (IDataEntityProperty property : mainEntityType.getProperties()) {
            String displayName;
            if (propName.equals(property.getName())) {
                return property.getDisplayName().getLocaleValue();
            }
            if (!(property instanceof EntryProp) || !kd.hdtc.hrdbs.common.util.StringUtils.isNotEmpty((String)(displayName = ConfItemUtils.getProNameInEntry(property, propName)))) continue;
            return displayName;
        }
        return null;
    }

    private static String getProNameInEntry(IDataEntityProperty property, String propName) {
        EntryProp entryProp = (EntryProp)property;
        IDataEntityType entryPropItemType = entryProp.getItemType();
        for (IDataEntityProperty entryPropItemTypeProperty : entryPropItemType.getProperties()) {
            if (propName.equals(entryPropItemTypeProperty.getName())) {
                return entryPropItemTypeProperty.getDisplayName().getLocaleValue();
            }
            if (!(entryPropItemTypeProperty instanceof SubEntryProp)) continue;
            SubEntryProp subEntryProp = (SubEntryProp)entryPropItemTypeProperty;
            IDataEntityType subEntryPropItemType = subEntryProp.getItemType();
            for (IDataEntityProperty subEntryPropItemTypeProperty : subEntryPropItemType.getProperties()) {
                if (!propName.equals(subEntryPropItemTypeProperty.getName())) continue;
                return subEntryPropItemTypeProperty.getDisplayName().getLocaleValue();
            }
        }
        return null;
    }

    public static List<FieldBo> getRelF7FieldBoByPropName(List<RowDataBo> rowDataBoList, String proName) {
        ArrayList<FieldBo> relF7FieldBoList = new ArrayList<FieldBo>(10);
        if (CollectionUtils.isEmpty(rowDataBoList)) {
            return relF7FieldBoList;
        }
        block0: for (RowDataBo rowDataBo : rowDataBoList) {
            List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
            for (FieldBo fieldBo : fieldBoList) {
                String fieldName = fieldBo.getFieldName();
                String fieldType = fieldBo.getFieldType();
                if (kd.hdtc.hrdbs.common.util.StringUtils.isBlank((CharSequence)fieldType)) continue;
                if (proName.equals(fieldName) && EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(fieldType)) {
                    relF7FieldBoList.add(fieldBo);
                    continue block0;
                }
                if (proName.equals(fieldName) && EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(fieldType)) {
                    ConfItemUtils.handleRelMulF7(proName, relF7FieldBoList, fieldBo);
                    continue;
                }
                if (!EntityPropertyTypeEnum.ENTRY_PROP.getByType().equals(fieldType) && !EntityPropertyTypeEnum.SUB_ENTRY_PROP.getByType().equals(fieldType)) continue;
                ConfItemUtils.analysisEntryRelF7FieldBo(proName, fieldBo, relF7FieldBoList);
            }
        }
        return relF7FieldBoList;
    }

    public static Object getFieldValueByPropName(List<FieldBo> fieldBoList, String proName) {
        if (CollectionUtils.isEmpty(fieldBoList)) {
            return null;
        }
        for (FieldBo fieldBo : fieldBoList) {
            String fieldName = fieldBo.getFieldName();
            String fieldType = fieldBo.getFieldType();
            if (proName.equals(fieldName) && EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(fieldType)) {
                List<FieldBo> f7FieldBoList = ConfItemUtils.getFieldBoList(fieldBo.getFieldValue());
                return f7FieldBoList.get(0).getFieldValue();
            }
            if (proName.equals(fieldName) && !EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(fieldType)) {
                return fieldBo.getFieldValue();
            }
            if (!proName.equals(fieldName)) continue;
            return fieldBo.getFieldValue();
        }
        return null;
    }

    public static List<Object> getFieldValueListByPropName(List<FieldBo> fieldBoList, String proName, List<Object> proValList) {
        if (CollectionUtils.isEmpty(fieldBoList) || proValList == null) {
            return proValList;
        }
        for (FieldBo fieldBo : fieldBoList) {
            String fieldName = fieldBo.getFieldName();
            String fieldType = fieldBo.getFieldType();
            if (proName.equals(fieldName) && EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(fieldType)) {
                Map<String, Object> singleF7Map = ConfItemUtils.getSingleF7Map(fieldBo.getFieldValue());
                proValList.add(singleF7Map.get("id"));
                return proValList;
            }
            if (proName.equals(fieldName) && !EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(fieldType)) {
                proValList.add(fieldBo.getFieldValue());
                return proValList;
            }
            if (EntityPropertyTypeEnum.ENTRY_PROP.getByType().equals(fieldType)) {
                List<RowDataBo> entryRowDataBoList = ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue());
                for (RowDataBo entryRowDataBo : entryRowDataBoList) {
                    proValList.addAll(ConfItemUtils.getFieldValueListByPropName(entryRowDataBo.getFieldBoList(), proName, proValList));
                }
                continue;
            }
            if (EntityPropertyTypeEnum.SUB_ENTRY_PROP.getByType().equals(fieldType)) {
                List<RowDataBo> subRowDataBoList = ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue());
                for (RowDataBo subEntryRowDataBo : subRowDataBoList) {
                    ConfItemUtils.getFieldValueListByPropName(subEntryRowDataBo.getFieldBoList(), proName, proValList);
                }
                continue;
            }
            if (!proName.equals(fieldName) || !EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(fieldType)) continue;
            List<RowDataBo> rowDataBoList = ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue());
            for (RowDataBo rowDataBo : rowDataBoList) {
                List mulFieldBoList = rowDataBo.getFieldBoList().stream().filter(fBo -> "fbasedataid".equals(fBo.getFieldName())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(mulFieldBoList)) continue;
                for (FieldBo mulFieldBo : mulFieldBoList) {
                    proValList.addAll(ConfItemUtils.getMulF7ValList(mulFieldBo));
                }
            }
        }
        return proValList;
    }

    public static boolean isContainProNameInEntryField(List<RowDataBo> rowDataBoList, String proName) {
        if (CollectionUtils.isEmpty(rowDataBoList)) {
            return false;
        }
        RowDataBo rowDataBo = rowDataBoList.get(0);
        List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
        Set filedNameSet = fieldBoList.stream().map(bo -> bo.getFieldName()).collect(Collectors.toSet());
        return filedNameSet.contains(proName);
    }

    public static List<Object> getFieldIdValueByPropName(List<FieldBo> fieldBoList, String proName) {
        ArrayList<Object> fieldValueList = new ArrayList<Object>(10);
        if (CollectionUtils.isEmpty(fieldBoList)) {
            return fieldValueList;
        }
        for (FieldBo fieldBo : fieldBoList) {
            String fieldName = fieldBo.getFieldName();
            String fieldType = fieldBo.getFieldType();
            if (proName.equals(fieldName) && EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(fieldType)) {
                Map<String, Object> singleF7Map = ConfItemUtils.getSingleF7Map(fieldBo.getFieldValue());
                fieldValueList.add(singleF7Map.get("id"));
                return fieldValueList;
            }
            if (proName.equals(fieldName) && EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(fieldType)) {
                fieldValueList.addAll(ConfItemUtils.getMulF7ValList(fieldBo));
                return fieldValueList;
            }
            if (EntityPropertyTypeEnum.ENTRY_PROP.getByType().equals(fieldType)) {
                List<RowDataBo> entryRowDataBoList = ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue());
                for (RowDataBo entryRowDataBo : entryRowDataBoList) {
                    fieldValueList.addAll(ConfItemUtils.getFieldIdValueByPropName(entryRowDataBo.getFieldBoList(), proName));
                }
                continue;
            }
            if (!proName.equals(fieldName)) continue;
            fieldValueList.add(fieldBo.getFieldValue());
        }
        return fieldValueList;
    }

    private static List<Object> getMulF7ValList(FieldBo fieldBo) {
        ArrayList<Object> f7ValList = new ArrayList<Object>(10);
        List<RowDataBo> mulF7RowDataBoList = ConfItemUtils.getRowDataBoList(fieldBo.getFieldValue());
        for (RowDataBo rowDataBo : mulF7RowDataBoList) {
            for (FieldBo f7FieldBo : rowDataBo.getFieldBoList()) {
                if (!"fbasedataid".equals(f7FieldBo.getFieldName())) continue;
                Map<String, Object> singleF7Map = ConfItemUtils.getSingleF7Map(f7FieldBo.getFieldValue());
                f7ValList.add(singleF7Map.get("id"));
            }
        }
        return f7ValList;
    }

    public static Map<Object, BaseDataCheckRefrenceResult> checkRef(BasedataEntityType baseEntityType, Object[] objIds) {
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(true);
        return checker.checkRef(baseEntityType, objIds);
    }

    public static String buildRefMessage(BaseDataCheckRefrenceResult baseDataCheckRefrenceResult) {
        if (ObjectUtils.isEmpty((Object)baseDataCheckRefrenceResult)) {
            return null;
        }
        MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)baseDataCheckRefrenceResult.getRefenceKey().getRefEntityKey());
        String billName = refMainType.getDisplayName().toString();
        String tableName = baseDataCheckRefrenceResult.getRefenceKey().getRefTable();
        String fieldName = baseDataCheckRefrenceResult.getRefenceKey().getRefCol();
        for (IDataEntityProperty property : refMainType.getAllFields().values()) {
            if (ConfItemUtils.equalsFieldName(property, tableName, fieldName)) {
                fieldName = property.getDisplayName().toString();
                break;
            }
            if (!ConfItemUtils.equalsMulBaseDataFieldName(property, tableName, fieldName)) continue;
            fieldName = property.getDisplayName().toString();
            break;
        }
        String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u6b64\u6570\u636e", (String)"ConfItemUtils_0", (String)"hdtc-hrcc-business", (Object[])new Object[0]), billName, fieldName);
        return msg;
    }

    private static boolean equalsFieldName(IDataEntityProperty property, String tableName, String fieldName) {
        if (property instanceof IFieldHandle && property.getParent() != null && property.getParent().getAlias() != null) {
            if (!kd.hdtc.hrdbs.common.util.StringUtils.equalsIgnoreCase((String)property.getAlias(), (String)fieldName)) {
                return false;
            }
            String propTableName = property.getParent().getAlias();
            if (StringUtils.isNotBlank((CharSequence)property.getTableGroup())) {
                propTableName = propTableName + "_" + property.getTableGroup();
            }
            return kd.hdtc.hrdbs.common.util.StringUtils.equalsIgnoreCase((String)propTableName, (String)tableName);
        }
        return false;
    }

    private static boolean equalsMulBaseDataFieldName(IDataEntityProperty property, String tableName, String fieldName) {
        if (!(property instanceof MulBasedataProp)) {
            return false;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
        if (mulBasedataProp.getItemType() != null && mulBasedataProp.getItemType().getAlias() != null) {
            return kd.hdtc.hrdbs.common.util.StringUtils.equalsIgnoreCase((String)fieldName, (String)"fbasedataid") && kd.hdtc.hrdbs.common.util.StringUtils.equalsIgnoreCase((String)tableName, (String)mulBasedataProp.getItemType().getAlias());
        }
        return false;
    }

    private static void handleRelMulF7(String proName, List<FieldBo> relF7FieldBoList, FieldBo fieldBo) {
        Object fieldValueObj = fieldBo.getFieldValue();
        List<RowDataBo> mulBaseRowDataBoList = ConfItemUtils.getRowDataBoList(fieldValueObj);
        ArrayList allMulBaseDataFieldBoList = new ArrayList(10);
        for (RowDataBo mulBaseRowDataBo : mulBaseRowDataBoList) {
            allMulBaseDataFieldBoList.addAll(mulBaseRowDataBo.getFieldBoList().stream().filter(bo -> "fbasedataid".equals(bo.getFieldName())).collect(Collectors.toList()));
        }
        for (FieldBo mulBaseFieldBo : allMulBaseDataFieldBoList) {
            Object mulBaseFieldValue = mulBaseFieldBo.getFieldValue();
            List<FieldBo> f7MulBaseBoList = ConfItemUtils.getFieldBoList(mulBaseFieldValue);
            FieldBo f7Bo = new FieldBo();
            for (FieldBo bo2 : f7MulBaseBoList) {
                if (!"id".equals(bo2.getFieldName())) continue;
                f7Bo.setRelF7IdVal(bo2.getFieldValue());
                break;
            }
            f7Bo.setFieldType(mulBaseFieldBo.getFieldType()).setFieldName(proName).setFieldValue(f7MulBaseBoList);
            relF7FieldBoList.add(f7Bo);
        }
    }

    public static List<FieldBo> getFieldBoList(Object fieldValue) {
        if (fieldValue == null) {
            return new ArrayList<FieldBo>(10);
        }
        List retFieldBoList = fieldValue instanceof JSONArray ? JSONArray.parseArray((String)fieldValue.toString(), FieldBo.class) : (List)fieldValue;
        return retFieldBoList;
    }

    public static void setFieldValByName(List<FieldBo> fieldBoList, String proName, Object val) {
        if (CollectionUtils.isEmpty(fieldBoList) || kd.hdtc.hrdbs.common.util.StringUtils.isEmpty((String)proName) || val == null) {
            return;
        }
        for (FieldBo fieldBo : fieldBoList) {
            if (!proName.equals(fieldBo.getFieldName())) continue;
            fieldBo.setFieldValue(val);
        }
    }

    public static Map<String, Object> getSingleF7Map(Object fieldValue) {
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        if (fieldValue == null) {
            return retMap;
        }
        List<FieldBo> fieldBoList = ConfItemUtils.getFieldBoList(fieldValue);
        if (CollectionUtils.isEmpty(fieldBoList)) {
            return retMap;
        }
        return fieldBoList.stream().collect(Collectors.toMap(FieldBo::getFieldName, FieldBo::getFieldValue));
    }

    public static Object getSingleF7IdVal(Object fieldValue) {
        ConfItemUtils.getSingleF7Map(fieldValue).get("id");
        return ConfItemUtils.getSingleF7Map(fieldValue).get("id");
    }

    public static List<RowDataBo> getRowDataBoList(Object fieldValue) {
        if (fieldValue == null) {
            return new ArrayList<RowDataBo>(10);
        }
        List rowDataBoList = fieldValue instanceof JSONArray ? JSONArray.parseArray((String)fieldValue.toString(), RowDataBo.class) : (List)fieldValue;
        return rowDataBoList;
    }

    private static void analysisEntryRelF7FieldBo(String proName, FieldBo fieldBo, List<FieldBo> relF7FieldBoList) {
        Object fieldValue = fieldBo.getFieldValue();
        List<RowDataBo> entryRowDataBoList = ConfItemUtils.getRowDataBoList(fieldValue);
        for (RowDataBo entryRowBo : entryRowDataBoList) {
            for (FieldBo entryFbo : entryRowBo.getFieldBoList()) {
                String entryFboType = entryFbo.getFieldType();
                if (EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(entryFboType) && proName.equals(entryFbo.getFieldName())) {
                    relF7FieldBoList.add(entryFbo);
                    continue;
                }
                if (EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(entryFboType) && proName.equals(entryFbo.getFieldName())) {
                    List<RowDataBo> rowDataBoList = ConfItemUtils.getRowDataBoList(entryFbo.getFieldValue());
                    rowDataBoList.forEach(rowDataBo -> {
                        List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
                        List newFieldBoList = fieldBoList.stream().filter(fBo -> "fbasedataid".equals(fBo.getFieldName())).collect(Collectors.toList());
                        relF7FieldBoList.addAll(newFieldBoList);
                    });
                    continue;
                }
                if (!EntityPropertyTypeEnum.SUB_ENTRY_PROP.getByType().equals(entryFboType)) continue;
                List<RowDataBo> subRowDataBoList = ConfItemUtils.getRowDataBoList(entryFbo.getFieldValue());
                subRowDataBoList.forEach(rowDataBo -> {
                    List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
                    List newFieldBoList = fieldBoList.stream().filter(fBo -> proName.equals(fBo.getFieldName())).collect(Collectors.toList());
                    relF7FieldBoList.addAll(newFieldBoList);
                });
            }
        }
    }

    public static boolean entityContainsNumber(MainEntityType dataEntityType) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        IDataEntityProperty numberProp = (IDataEntityProperty)properties.get((Object)"number");
        return Objects.nonNull(numberProp) && kd.hdtc.hrdbs.common.util.StringUtils.isNotEmpty((String)numberProp.getAlias());
    }

    public static boolean entityContainsProName(MainEntityType dataEntityType, String proName) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        IDataEntityProperty numberProp = (IDataEntityProperty)properties.get((Object)proName);
        return Objects.nonNull(numberProp) && kd.hdtc.hrdbs.common.util.StringUtils.isNotEmpty((String)numberProp.getAlias());
    }

    public static boolean entityContainsAllProName(MainEntityType dataEntityType, List<String> proNameList) {
        if (CollectionUtils.isEmpty(proNameList)) {
            return false;
        }
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        for (String proName : proNameList) {
            IDataEntityProperty numberProp;
            if (kd.hdtc.hrdbs.common.util.StringUtils.isEmpty((String)proName) || !Objects.isNull(numberProp = (IDataEntityProperty)properties.get((Object)proName)) && !kd.hdtc.hrdbs.common.util.StringUtils.isEmpty((String)numberProp.getAlias())) continue;
            return false;
        }
        return true;
    }

    public static String getEntityDataIde(boolean isContainNameField, boolean isContainNumberField, List<FieldBo> fieldBoList) {
        String entityDataIde = "";
        if (CollectionUtils.isEmpty(fieldBoList)) {
            return entityDataIde;
        }
        String langName = RequestContext.get().getLang().name();
        for (FieldBo fieldBo : fieldBoList) {
            List<FieldBo> mulLangFieldBoList;
            Optional<FieldBo> boOptional;
            if (!isContainNameField || !"name".equals(fieldBo.getFieldName()) || !(boOptional = (mulLangFieldBoList = ConfItemUtils.getFieldBoList(fieldBo.getFieldValue())).stream().filter(bo -> langName.equals(bo.getFieldName())).findAny()).isPresent()) continue;
            FieldBo localFieldBo = boOptional.get();
            entityDataIde = (String)localFieldBo.getFieldValue();
        }
        if (kd.hdtc.hrdbs.common.util.StringUtils.isEmpty((String)entityDataIde) && isContainNumberField) {
            for (FieldBo fieldBo : fieldBoList) {
                if (!"number".equals(fieldBo.getFieldName())) continue;
                entityDataIde = (String)fieldBo.getFieldValue();
            }
        } else if (kd.hdtc.hrdbs.common.util.StringUtils.isEmpty((String)entityDataIde)) {
            entityDataIde = ConfItemUtils.getFieldValueByPropName(fieldBoList, "id") + "";
        }
        return entityDataIde;
    }
}

