/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.config.entity.impl;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrcc.business.domain.config.entity.IHRCCBaseConfigEntityService;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRCCBaseConfigEntityServiceImpl
extends AbstractBaseEntityService
implements IHRCCBaseConfigEntityService {
    private static final String SELECT_FIELDS = "id,number,value";

    public HRCCBaseConfigEntityServiceImpl() {
        super("hrcc_baseconfig");
    }

    @Override
    public String queryBaseConfigValueByNumber(String number) {
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        DynamicObject baseConfigDyn = this.queryOne("value", new QFilter[]{numberFilter});
        return baseConfigDyn != null ? baseConfigDyn.getString("value") : "";
    }

    @Override
    public Map<String, String> queryBaseConfigValueByNumberList(List<String> numberList) {
        QFilter numberFilter = new QFilter("number", "in", numberList);
        List dynamicObjectList = this.queryOriginalList(SELECT_FIELDS, new QFilter[]{numberFilter});
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectList)) {
            HashMap numberValueMap = Maps.newHashMapWithExpectedSize((int)dynamicObjectList.size());
            for (DynamicObject dy : dynamicObjectList) {
                numberValueMap.put(dy.getString("number"), dy.getString("value"));
            }
            return numberValueMap;
        }
        return new HashMap<String, String>(16);
    }

    @Override
    public Set<String> getRelBaseEntityBlackList() {
        HashSet<String> retSet = new HashSet<String>(16);
        QFilter blackListNumFilter = new QFilter("number", "=", (Object)"hrcc_configitems");
        Map mapFromCacheDyn = this.getMapFromCache(SELECT_FIELDS, new QFilter[]{blackListNumFilter});
        if (ObjectUtils.isEmpty((Object)mapFromCacheDyn)) {
            return retSet;
        }
        for (DynamicObject blackDyn : mapFromCacheDyn.values()) {
            String confValue = blackDyn.getString("value");
            if (HRStringUtils.isEmpty((String)confValue)) continue;
            Arrays.stream(confValue.split(",")).forEach(be -> retSet.add(be.trim()));
        }
        return retSet;
    }

    @Override
    public Map<String, Set<String>> getEntityRelF7White() {
        HashMap<String, Set<String>> entityRelF7SetMap = new HashMap<String, Set<String>>(16);
        QFilter whiteListNumFilter = new QFilter("number", "like", (Object)"f7whitelist#%");
        Map mapFromCacheDyn = this.getMapFromCache(SELECT_FIELDS, new QFilter[]{whiteListNumFilter});
        if (ObjectUtils.isEmpty((Object)mapFromCacheDyn)) {
            return entityRelF7SetMap;
        }
        for (DynamicObject whiteDyn : mapFromCacheDyn.values()) {
            String[] entityInfoArr;
            String confValue = whiteDyn.getString("value");
            String whiteEntityInfo = whiteDyn.getString("number");
            if (StringUtils.isEmpty((String)confValue) || StringUtils.isEmpty((String)whiteEntityInfo) || (entityInfoArr = whiteEntityInfo.split("#")).length != 2) continue;
            String entityNumber = entityInfoArr[1];
            entityRelF7SetMap.putIfAbsent(entityNumber, new HashSet(16));
            Set entityRelF7Set = (Set)entityRelF7SetMap.get(entityNumber);
            Arrays.stream(confValue.split(",")).forEach(be -> entityRelF7Set.add(be.trim()));
        }
        return entityRelF7SetMap;
    }

    @Override
    public Set<String> getEntityRelF7PersonFieldWhite() {
        HashSet<String> relPersonF7FieldSet = new HashSet<String>(16);
        QFilter whiteListNumFilter = new QFilter("number", "=", (Object)"f7PersonFieldWhilteList");
        Map mapFromCacheDyn = this.getMapFromCache(SELECT_FIELDS, new QFilter[]{whiteListNumFilter});
        if (ObjectUtils.isEmpty((Object)mapFromCacheDyn)) {
            return relPersonF7FieldSet;
        }
        for (DynamicObject whiteDyn : mapFromCacheDyn.values()) {
            String confValue = whiteDyn.getString("value");
            Arrays.stream(confValue.split(",")).forEach(be -> relPersonF7FieldSet.add(be.trim()));
        }
        return relPersonF7FieldSet;
    }
}

