/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.fileimport.file.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.fileservice.FileItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.attachment.AttachmentRemoveSource;
import kd.bos.servicehelper.AttDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.hdtc.hrcc.business.domain.fileimport.file.IFileFieldDealService;
import kd.hdtc.hrcc.business.domain.fileimport.file.impl.FileImportBaseService;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFileFieldInfoBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubTaskResultBean;
import kd.hdtc.hrcc.common.enums.EntityFieldSource;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.ThrowableUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class AttachmentFieldDealServiceImpl
extends FileImportBaseService
implements IFileFieldDealService {
    private static Log LOG = LogFactory.getLog(AttachmentFieldDealServiceImpl.class);

    @Override
    public FileImportSubTaskResultBean uploadFileList(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, DynamicObject subTask, FileImportConfigBo fileImportConfigBo) {
        FileImportSubTaskResultBean fileImportSubTaskResultBean = new FileImportSubTaskResultBean(fileImportFileFieldInfoBo.getEntityNumber());
        if (CollectionUtils.isEmpty(fileImportFileFieldInfoBo.getFileInfoList())) {
            fileImportSubTaskResultBean.fail("AttachmentFieldDealServiceImpl deal data is null");
            return fileImportSubTaskResultBean;
        }
        fileImportSubTaskResultBean.setDataPkId(fileImportFileFieldInfoBo.getDataPkId());
        List<FileImportFileFieldInfoBo.FileInfo> fileInfoList = fileImportFileFieldInfoBo.getFileInfoList();
        try {
            HashMap<FileItem, FileImportFileFieldInfoBo.FileInfo> fileItemMap = new HashMap<FileItem, FileImportFileFieldInfoBo.FileInfo>(fileInfoList.size());
            this.bizHandleFile(fileImportFileFieldInfoBo, subTask, fileImportConfigBo);
            this.deleteFileList(fileImportFileFieldInfoBo);
            List<String> successFileNameList = this.uploadToRemote(fileImportFileFieldInfoBo, fileInfoList, fileItemMap);
            Map<Object, List<FileItem>> dataRowFileItemListMap = this.analysisUploadResult(fileImportFileFieldInfoBo, fileImportSubTaskResultBean, fileItemMap, successFileNameList, false);
            this.doSaveBindingBizEntityData(fileImportFileFieldInfoBo, dataRowFileItemListMap, fileItemMap);
        }
        catch (Exception ex) {
            LOG.error("AttachmentFieldDealServiceImpl \uff1a " + ThrowableUtils.toString((Throwable)ex));
            fileImportSubTaskResultBean.fail(ThrowableUtils.toString((Throwable)ex));
        }
        return fileImportSubTaskResultBean;
    }

    @Override
    public void doSaveBindingBizEntityData(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, Map<Object, List<FileItem>> dataRowFileItemListMap, Map<FileItem, FileImportFileFieldInfoBo.FileInfo> fileItemMap) {
        ArrayList<AttDto> attDtoList = new ArrayList<AttDto>(10);
        for (Map.Entry<Object, List<FileItem>> itemEntry : dataRowFileItemListMap.entrySet()) {
            List<FileItem> rowFileItemList = itemEntry.getValue();
            for (FileItem fileItem : rowFileItemList) {
                FileImportFileFieldInfoBo.FileInfo fieldInfo = fileItemMap.get(fileItem);
                if (fieldInfo == null) continue;
                AttDto attDto = new AttDto();
                attDto.setPath(fileItem.getPath());
                attDto.setAttKey(fileImportFileFieldInfoBo.getFiledNumber());
                attDto.setSize(fieldInfo.getSize());
                attDto.setEntryPkId(fileImportFileFieldInfoBo.getDataPkId() + "");
                attDtoList.add(attDto);
            }
        }
        try {
            Map bindingParam = AttachmentServiceHelper.genBindingParam((String)fileImportFileFieldInfoBo.getEntityNumber(), (String)fileImportFileFieldInfoBo.getDataPkId().toString(), attDtoList);
            AttachmentServiceHelper.bindingAttachment((Map)bindingParam);
        }
        catch (Exception ex) {
            LOG.error("AttachmentFieldDealServiceImpl genBindingParam error  ", (Throwable)ex);
            throw new HDTCBizException(ThrowableUtils.toString((Throwable)ex));
        }
    }

    @Override
    public FileImportSubTaskResultBean deleteFileList(FileImportFileFieldInfoBo fileImportFileFieldInfoBo) {
        FileImportSubTaskResultBean fileImportSubTaskResultBean = new FileImportSubTaskResultBean();
        DynamicObject[] bizDataDynArr = this.getBizDataDynArr(fileImportFileFieldInfoBo);
        BasedataEntityType dataEntityType = null;
        ArrayList<Object> attPkIdList = new ArrayList<Object>(10);
        ArrayList<Long> bizPkIdList = new ArrayList<Long>(10);
        List<FileImportFileFieldInfoBo.FileInfo> fileInfoList = fileImportFileFieldInfoBo.getFileInfoList();
        Set fileNameSet = fileInfoList.stream().map(FileImportFileFieldInfoBo.FileInfo::getFileName).collect(Collectors.toSet());
        for (DynamicObject bizDyn : bizDataDynArr) {
            if (dataEntityType == null) {
                dataEntityType = (BasedataEntityType)bizDyn.getDataEntityType();
            }
            DynamicObjectCollection fieldDynCol = bizDyn.getDynamicObjectCollection(fileImportFileFieldInfoBo.getFiledNumber());
            for (DynamicObject mulBaseDyn : fieldDynCol) {
                DynamicObject attachmentDyn = mulBaseDyn.getDynamicObject("fbasedataid");
                if (attachmentDyn == null) continue;
                if (fileImportFileFieldInfoBo.getSingleDelFile().booleanValue()) {
                    attPkIdList.add(attachmentDyn.get("id"));
                    continue;
                }
                if (!fileNameSet.contains(attachmentDyn.getString("name"))) continue;
                attPkIdList.add(attachmentDyn.get("id"));
            }
            bizPkIdList.add(bizDyn.getLong("id"));
            fieldDynCol.clear();
        }
        if (dataEntityType == null || CollectionUtils.isEmpty(attPkIdList)) {
            return fileImportSubTaskResultBean;
        }
        AttachmentFieldServiceHelper.batchRemoveAtt((String)fileImportFileFieldInfoBo.getEntityNumber(), (String)dataEntityType.getAlias(), (Object[])attPkIdList.toArray(), (Object[])bizPkIdList.toArray(), (AttachmentRemoveSource)AttachmentRemoveSource.getAttachmentRemoveSource((String)this.getFieldSourceType(fileImportFileFieldInfoBo.getEntityNumber(), fileImportFileFieldInfoBo.getFiledNumber())), (boolean)false);
        this.saveBizDataDyn(fileImportFileFieldInfoBo.getEntityNumber(), bizDataDynArr);
        return fileImportSubTaskResultBean;
    }

    public String getFieldSourceType(String entityNumber, String filedNumber) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        DataEntityPropertyCollection properties = mainEntityType.getProperties();
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            if (!StringUtils.equals((String)filedNumber, (String)propertyName) && !(property instanceof EntryProp)) continue;
            if (property instanceof EntryProp) {
                return this.getEntryAndSubEntryFieldSourceType(property, filedNumber);
            }
            if (!StringUtils.equals((String)filedNumber, (String)propertyName)) continue;
            return EntityFieldSource.HEAD.getValue();
        }
        return "";
    }

    private String getEntryAndSubEntryFieldSourceType(IDataEntityProperty property, String filedNumber) {
        EntryProp entryProp = (EntryProp)property;
        IDataEntityType entryPropItemType = entryProp.getItemType();
        for (IDataEntityProperty entryPropItemTypeProperty : entryPropItemType.getProperties()) {
            if (entryPropItemTypeProperty instanceof SubEntryProp) {
                SubEntryProp subEntryProp = (SubEntryProp)entryPropItemTypeProperty;
                IDataEntityType subEntryPropItemType = subEntryProp.getItemType();
                DataEntityPropertyCollection subEntryProperties = subEntryPropItemType.getProperties();
                for (IDataEntityProperty subEntryProperty : subEntryProperties) {
                    if (!StringUtils.equals((String)filedNumber, (String)subEntryProperty.getName())) continue;
                    return EntityFieldSource.SUB_ENTRY.getValue();
                }
                continue;
            }
            if (!StringUtils.equals((String)filedNumber, (String)entryPropItemTypeProperty.getName())) continue;
            return EntityFieldSource.ENTRY.getValue();
        }
        return "";
    }

    @Override
    public Map<Long, List<String>> queryFileList(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, Set<Long> dataPkIdSet) {
        DynamicObject[] bizDataDynArr;
        HashMap<Long, List<String>> idVsFileNameListMap = new HashMap<Long, List<String>>(16);
        if (fileImportFileFieldInfoBo == null) {
            return idVsFileNameListMap;
        }
        for (DynamicObject bizDyn : bizDataDynArr = this.getBizDataDynArr(fileImportFileFieldInfoBo, dataPkIdSet)) {
            long pkId = bizDyn.getLong("id");
            idVsFileNameListMap.putIfAbsent(pkId, new ArrayList(10));
            DynamicObjectCollection fieldDynCol = bizDyn.getDynamicObjectCollection(fileImportFileFieldInfoBo.getFiledNumber());
            for (DynamicObject mulBaseDyn : fieldDynCol) {
                DynamicObject attachmentDyn = mulBaseDyn.getDynamicObject("fbasedataid");
                if (attachmentDyn == null) continue;
                ((List)idVsFileNameListMap.get(pkId)).add(attachmentDyn.getString("name"));
            }
        }
        return idVsFileNameListMap;
    }
}

