/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.fileimport.file.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.fileservice.FileItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hdtc.hrcc.business.domain.fileimport.file.IFileFieldDealService;
import kd.hdtc.hrcc.business.domain.fileimport.file.impl.FileImportBaseService;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFileFieldInfoBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubTaskResultBean;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;

public class AttachmentPanelApDealServiceImpl
extends FileImportBaseService
implements IFileFieldDealService {
    private static Log LOG = LogFactory.getLog(AttachmentPanelApDealServiceImpl.class);

    @Override
    public FileImportSubTaskResultBean uploadFileList(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, DynamicObject subTask, FileImportConfigBo fileImportConfigBo) {
        FileImportSubTaskResultBean fileImportSubTaskResultBean = new FileImportSubTaskResultBean(fileImportFileFieldInfoBo.getEntityNumber());
        fileImportSubTaskResultBean.setDataPkId(fileImportFileFieldInfoBo.getDataPkId());
        if (CollectionUtils.isEmpty(fileImportFileFieldInfoBo.getFileInfoList())) {
            fileImportSubTaskResultBean.fail("AttachmentPanelApDealServiceImpl deal data is null");
            return fileImportSubTaskResultBean;
        }
        List<FileImportFileFieldInfoBo.FileInfo> fileInfoList = fileImportFileFieldInfoBo.getFileInfoList();
        this.bizHandleFile(fileImportFileFieldInfoBo, subTask, fileImportConfigBo);
        this.deleteFileList(fileImportFileFieldInfoBo);
        HashMap fileItemMap = Maps.newHashMapWithExpectedSize((int)fileInfoList.size());
        List<String> successFileNameList = this.uploadToRemote(fileImportFileFieldInfoBo, fileInfoList, fileItemMap);
        Map<Object, List<FileItem>> dataRowFileItemListMap = this.analysisUploadResult(fileImportFileFieldInfoBo, fileImportSubTaskResultBean, fileItemMap, successFileNameList, false);
        this.doSaveBindingBizEntityData(fileImportFileFieldInfoBo, dataRowFileItemListMap, fileItemMap);
        return fileImportSubTaskResultBean;
    }

    @Override
    public void doSaveBindingBizEntityData(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, Map<Object, List<FileItem>> dataRowFileItemListMap, Map<FileItem, FileImportFileFieldInfoBo.FileInfo> fileItemMap) {
        long lastModifiedTime = DateTimeUtils.getNowDateTime().getTime();
        for (Map.Entry<Object, List<FileItem>> itemEntry : dataRowFileItemListMap.entrySet()) {
            Object dataPkId = itemEntry.getKey();
            List<FileItem> rowFileItemList = itemEntry.getValue();
            ArrayList attachments = new ArrayList(10);
            for (FileItem fileItem : rowFileItemList) {
                FileImportFileFieldInfoBo.FileInfo fieldInfo = fileItemMap.get(fileItem);
                if (fieldInfo == null) continue;
                HashMap<String, Object> uploadFileMap = new HashMap<String, Object>(16);
                uploadFileMap.put("entityNum", fileImportFileFieldInfoBo.getEntityNumber());
                uploadFileMap.put("billPkId", fileImportFileFieldInfoBo.getDataPkId());
                uploadFileMap.put("lastModified", lastModifiedTime);
                uploadFileMap.put("name", fileItem.getFileName());
                uploadFileMap.put("url", fileItem.getPath());
                uploadFileMap.put("size", fieldInfo.getSize());
                uploadFileMap.put("status", "success");
                uploadFileMap.put("uid", AttachmentServiceHelper.generateUid());
                attachments.add(uploadFileMap);
            }
            AttachmentServiceHelper.upload((String)fileImportFileFieldInfoBo.getEntityNumber(), (Object)dataPkId, (String)fileImportFileFieldInfoBo.getFiledNumber(), attachments);
        }
    }

    @Override
    public FileImportSubTaskResultBean deleteFileList(FileImportFileFieldInfoBo fileImportFileFieldInfoBo) {
        Set fileNameSet = fileImportFileFieldInfoBo.getFileInfoList().stream().map(FileImportFileFieldInfoBo.FileInfo::getFileName).collect(Collectors.toSet());
        List attachmentMapList = AttachmentServiceHelper.getAttachments((String)fileImportFileFieldInfoBo.getEntityNumber(), (Object)fileImportFileFieldInfoBo.getDataPkId(), (String)fileImportFileFieldInfoBo.getFiledNumber());
        for (Map attachmentMap : attachmentMapList) {
            String oldFileName = (String)attachmentMap.get("name");
            if (!fileImportFileFieldInfoBo.getSingleDelFile().booleanValue() && !fileNameSet.contains(oldFileName)) continue;
            AttachmentServiceHelper.remove((String)fileImportFileFieldInfoBo.getEntityNumber(), (Object)fileImportFileFieldInfoBo.getDataPkId(), attachmentMap.get("uid"));
        }
        return new FileImportSubTaskResultBean();
    }

    @Override
    public Map<Long, List<String>> queryFileList(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, Set<Long> dataPkIdSet) {
        HashMap<Long, List<String>> idVsFileNameListMap = new HashMap<Long, List<String>>(16);
        if (fileImportFileFieldInfoBo == null) {
            return idVsFileNameListMap;
        }
        Map dataAttachmentListMap = AttachmentServiceHelper.getAttachments((String)fileImportFileFieldInfoBo.getEntityNumber(), (Object[])dataPkIdSet.toArray(), (String)fileImportFileFieldInfoBo.getFiledNumber(), (boolean)false);
        List attachmentMapList = AttachmentServiceHelper.getAttachments((String)fileImportFileFieldInfoBo.getEntityNumber(), (Object)fileImportFileFieldInfoBo.getDataPkId(), (String)fileImportFileFieldInfoBo.getFiledNumber());
        for (Map.Entry entry : dataAttachmentListMap.entrySet()) {
            String dataIdStr = (String)entry.getKey();
            List dataAttachmentMapList = (List)entry.getValue();
            long dataPkId = Long.parseLong(dataIdStr);
            idVsFileNameListMap.putIfAbsent(dataPkId, new ArrayList(10));
            List dataAttachmentList = (List)idVsFileNameListMap.get(dataPkId);
            for (Map dataAttachmentMap : dataAttachmentMapList) {
                dataAttachmentList.add((String)dataAttachmentMap.get("name"));
            }
        }
        return idVsFileNameListMap;
    }
}

