/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrcc.business.domain.fileimport.file.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportConfigBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportFileFieldInfoBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubSceneBo;
import kd.hdtc.hrcc.business.domain.fileimport.model.FileImportSubTaskResultBean;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.FileUtils;
import kd.hdtc.hrdbs.common.util.ObjectUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public abstract class FileImportBaseService {
    private static Log LOG = LogFactory.getLog(FileImportBaseService.class);
    static final String ATTACHMENT_PAGE_KEY = "bos_svc_attachment";

    protected List<String> uploadToRemote(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, List<FileImportFileFieldInfoBo.FileInfo> fileInfoList, Map<FileItem, FileImportFileFieldInfoBo.FileInfo> fileItemMap) {
        RequestContext requestContext = RequestContext.get();
        ArrayList fileItemList = Lists.newArrayListWithExpectedSize((int)fileInfoList.size());
        fileInfoList.forEach(data -> {
            TempFileCacheDownloadable.Content content = FileUtils.getCacheContentFromTempUrl((String)data.getTemUrl());
            if (content != null) {
                String fileName = content.getFilename();
                String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)fileImportFileFieldInfoBo.getDataPkId(), (String)fileName);
                FileItem item = new FileItem(fileName, pathParam, content.getInputStream());
                item.setCreateNewFileWhenExists(true);
                fileItemMap.put(item, (FileImportFileFieldInfoBo.FileInfo)data);
                fileItemList.add(item);
            }
        });
        return FileServiceFactory.getAttachmentFileService().upload(fileItemList.toArray(new FileItem[0]));
    }

    protected Map<Object, List<FileItem>> analysisUploadResult(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, FileImportSubTaskResultBean fileImportSubTaskResultBean, Map<FileItem, FileImportFileFieldInfoBo.FileInfo> fileItemMap, List<String> successFileNameList, boolean isPic) {
        Map<Object, List<FileItem>> dataRowFileItemListMap;
        if (ObjectUtils.isEmpty(fileItemMap) || CollectionUtils.isEmpty(successFileNameList)) {
            fileImportSubTaskResultBean.fail("fileItemMap is empty or successFileNameList is empty.");
            return new HashMap<Object, List<FileItem>>();
        }
        if (isPic) {
            HashSet<String> successFileNameSet = new HashSet<String>(successFileNameList);
            dataRowFileItemListMap = this.getFileImportSubTaskResultMap(fileImportFileFieldInfoBo, fileImportSubTaskResultBean, fileItemMap, successFileNameSet);
        } else {
            Set<String> successFileNameSet = this.getAttachmentNameSetByNumberList(successFileNameList);
            dataRowFileItemListMap = this.getFileImportSubTaskResultMap(fileImportFileFieldInfoBo, fileImportSubTaskResultBean, fileItemMap, successFileNameSet);
        }
        return dataRowFileItemListMap;
    }

    private Map<Object, List<FileItem>> getFileImportSubTaskResultMap(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, FileImportSubTaskResultBean fileImportSubTaskResultBean, Map<FileItem, FileImportFileFieldInfoBo.FileInfo> fileItemMap, Set<String> successFileNameSet) {
        HashMap<Object, List<FileItem>> dataRowFileItemListMap = new HashMap<Object, List<FileItem>>(16);
        for (Map.Entry<FileItem, FileImportFileFieldInfoBo.FileInfo> fileItemFileInfoEntry : fileItemMap.entrySet()) {
            FileItem fileItem = fileItemFileInfoEntry.getKey();
            String fileName = fileItem.getFileName();
            if (successFileNameSet.contains(fileName)) {
                dataRowFileItemListMap.putIfAbsent(fileImportFileFieldInfoBo.getDataPkId(), new ArrayList(10));
                ((List)dataRowFileItemListMap.get(fileImportFileFieldInfoBo.getDataPkId())).add(fileItem);
                continue;
            }
            fileImportSubTaskResultBean.getFailFileNameList().add(fileName);
            fileImportSubTaskResultBean.setDataPkId(fileImportFileFieldInfoBo.getDataPkId());
        }
        return dataRowFileItemListMap;
    }

    private Set<String> getAttachmentNameSetByNumberList(List<String> successFileNameList) {
        IBaseEntityService attachmentService = CommonEntityServiceFactory.getEntityService((String)ATTACHMENT_PAGE_KEY);
        QFilter fileNumberFilter = new QFilter("number", "in", successFileNameList);
        List attachmentDynList = attachmentService.queryOriginalList("id,number,name", new QFilter[]{fileNumberFilter});
        if (CollectionUtils.isEmpty((Collection)attachmentDynList)) {
            LOG.info("getAttachmentNameSetByNumberList attachmentDynList is empty,successFileNameList={}", successFileNameList);
            return new HashSet<String>();
        }
        return attachmentDynList.stream().map(attachmentDyn -> attachmentDyn.getString("name")).collect(Collectors.toSet());
    }

    protected void bizHandleFile(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, DynamicObject subTaskDyn, FileImportConfigBo fileImportConfigBo) {
        if (fileImportFileFieldInfoBo == null || subTaskDyn == null) {
            return;
        }
        List<FileImportSubSceneBo> fileImportSubSceneList = fileImportConfigBo.getFileImportSubSceneList();
        DynamicObject subSceneDyn = subTaskDyn.getDynamicObject("scene");
        if (subSceneDyn == null || CollectionUtils.isEmpty(fileImportSubSceneList)) {
            return;
        }
        FileImportSubSceneBo fileImportSubSceneBo = fileImportSubSceneList.stream().filter(subScene -> subSceneDyn.getLong("id") == subScene.getSubSceneId().longValue()).findFirst().get();
        subSceneDyn.getLong("id");
        boolean isSingleUpdate = fileImportSubSceneBo.isSingleUpdate();
        if (fileImportSubSceneBo.getNum() == 1 && isSingleUpdate) {
            fileImportFileFieldInfoBo.setSingleDelFile(Boolean.TRUE);
        }
    }

    protected void doSaveBindingBizEntityData(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, Map<Object, List<FileItem>> dataRowFileItemListMap, Map<FileItem, FileImportFileFieldInfoBo.FileInfo> fileItemMap) {
    }

    protected Set<String> getAttachmentNameSet(FileImportFileFieldInfoBo fileImportFileFieldInfoBo) {
        String attachKey = fileImportFileFieldInfoBo.getFiledNumber();
        List attachmentMapList = AttachmentServiceHelper.getAttachments((String)fileImportFileFieldInfoBo.getEntityNumber(), (Object)fileImportFileFieldInfoBo.getDataPkId(), (String)attachKey);
        HashSet<String> dbAttachmentFileNameSet = new HashSet<String>(16);
        for (Map attachmentMap : attachmentMapList) {
            dbAttachmentFileNameSet.add(attachmentMap.get("name") + "");
        }
        return dbAttachmentFileNameSet;
    }

    protected DynamicObject[] getBizDataDynArr(FileImportFileFieldInfoBo fileImportFileFieldInfoBo) {
        return this.getBizDataDynArr(fileImportFileFieldInfoBo, null);
    }

    protected DynamicObject[] getBizDataDynArr(FileImportFileFieldInfoBo fileImportFileFieldInfoBo, Set<Long> dataPkIdSet) {
        IBaseEntityService entityService = CommonEntityServiceFactory.getEntityService((String)fileImportFileFieldInfoBo.getEntityNumber());
        QFilter qFilter = new QFilter("id", "in", CollectionUtils.isNotEmpty(dataPkIdSet) ? dataPkIdSet : fileImportFileFieldInfoBo.getDataPkId());
        String dealFieldNumber = fileImportFileFieldInfoBo.getFiledNumber();
        return entityService.query("id," + dealFieldNumber, qFilter.toArray());
    }

    protected void saveBizDataDyn(String entityNumber, DynamicObject[] dataArr) {
        if (StringUtils.isEmpty((String)entityNumber) || ObjectUtils.isEmpty((Object[])dataArr)) {
            return;
        }
        IBaseEntityService entityService = CommonEntityServiceFactory.getEntityService((String)entityNumber);
        entityService.save(dataArr);
    }
}

